/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.java.parsing.comment;

import com.github.tadukoo.java.JavaCodeType;
import com.github.tadukoo.java.JavaCodeTypes;
import com.github.tadukoo.java.comment.EditableJavaSingleLineComment;
import com.github.tadukoo.java.comment.JavaSingleLineComment;
import com.github.tadukoo.java.parsing.AbstractJavaParser;
import com.github.tadukoo.java.parsing.JavaParsingException;
import com.github.tadukoo.java.parsing.ParsingPojo;
import com.github.tadukoo.util.StringUtil;
import java.util.List;

public class JavaSingleLineCommentParser
extends AbstractJavaParser {
    private JavaSingleLineCommentParser() {
    }

    public static JavaSingleLineComment parseSingleLineComment(String content) throws JavaParsingException {
        List<String> tokens = JavaSingleLineCommentParser.splitContentIntoTokens(content);
        int startToken = JavaSingleLineCommentParser.skipLeadingWhitespace(tokens);
        ParsingPojo result = JavaSingleLineCommentParser.parseSingleLineComment(tokens, startToken);
        JavaSingleLineCommentParser.verifyEndOfTokens(tokens, result, JavaCodeTypes.SINGLE_LINE_COMMENT);
        return (JavaSingleLineComment)result.parsedType();
    }

    public static ParsingPojo parseSingleLineComment(List<String> tokens, int startToken) throws JavaParsingException {
        int currentToken;
        String firstToken = tokens.get(startToken);
        if (!firstToken.startsWith("//")) {
            throw new JavaParsingException(JavaCodeTypes.SINGLE_LINE_COMMENT, "First token of single-line comment must start with '//'");
        }
        StringBuilder content = new StringBuilder();
        if (StringUtil.notEquals((String)firstToken, (String)"//")) {
            content.append(firstToken, "//".length(), firstToken.length());
        }
        if (content.isEmpty()) {
            for (currentToken = startToken + 1; currentToken < tokens.size() && WHITESPACE_MATCHER.reset(tokens.get(currentToken)).matches(); ++currentToken) {
            }
        }
        while (currentToken < tokens.size()) {
            String token = tokens.get(currentToken);
            ++currentToken;
            if (StringUtil.equals((String)token, (String)"\n")) break;
            content.append(token);
        }
        return new ParsingPojo(currentToken, (JavaCodeType)EditableJavaSingleLineComment.builder().content(StringUtil.trim((String)content.toString())).build());
    }
}

