/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.java;

import com.github.tadukoo.java.JavaCodeType;
import com.github.tadukoo.java.JavaCodeTypes;
import com.github.tadukoo.java.JavaParameter;
import com.github.tadukoo.java.JavaType;
import com.github.tadukoo.java.JavaTypeParameter;
import com.github.tadukoo.java.Visibility;
import com.github.tadukoo.java.annotation.EditableJavaAnnotation;
import com.github.tadukoo.java.annotation.JavaAnnotation;
import com.github.tadukoo.java.annotation.JavaAnnotationBuilder;
import com.github.tadukoo.java.annotation.UneditableJavaAnnotation;
import com.github.tadukoo.java.code.staticcodeblock.EditableJavaStaticCodeBlock;
import com.github.tadukoo.java.code.staticcodeblock.JavaStaticCodeBlock;
import com.github.tadukoo.java.code.staticcodeblock.JavaStaticCodeBlockBuilder;
import com.github.tadukoo.java.code.staticcodeblock.UneditableJavaStaticCodeBlock;
import com.github.tadukoo.java.comment.EditableJavaMultiLineComment;
import com.github.tadukoo.java.comment.EditableJavaSingleLineComment;
import com.github.tadukoo.java.comment.JavaMultiLineComment;
import com.github.tadukoo.java.comment.JavaMultiLineCommentBuilder;
import com.github.tadukoo.java.comment.JavaSingleLineComment;
import com.github.tadukoo.java.comment.JavaSingleLineCommentBuilder;
import com.github.tadukoo.java.comment.UneditableJavaMultiLineComment;
import com.github.tadukoo.java.comment.UneditableJavaSingleLineComment;
import com.github.tadukoo.java.field.EditableJavaField;
import com.github.tadukoo.java.field.JavaField;
import com.github.tadukoo.java.field.JavaFieldBuilder;
import com.github.tadukoo.java.field.UneditableJavaField;
import com.github.tadukoo.java.importstatement.EditableJavaImportStatement;
import com.github.tadukoo.java.importstatement.JavaImportStatement;
import com.github.tadukoo.java.importstatement.JavaImportStatementBuilder;
import com.github.tadukoo.java.importstatement.UneditableJavaImportStatement;
import com.github.tadukoo.java.javaclass.EditableJavaClass;
import com.github.tadukoo.java.javaclass.JavaClass;
import com.github.tadukoo.java.javaclass.JavaClassBuilder;
import com.github.tadukoo.java.javaclass.UneditableJavaClass;
import com.github.tadukoo.java.javadoc.EditableJavadoc;
import com.github.tadukoo.java.javadoc.Javadoc;
import com.github.tadukoo.java.javadoc.JavadocBuilder;
import com.github.tadukoo.java.javadoc.UneditableJavadoc;
import com.github.tadukoo.java.method.EditableJavaMethod;
import com.github.tadukoo.java.method.JavaMethod;
import com.github.tadukoo.java.method.JavaMethodBuilder;
import com.github.tadukoo.java.method.UneditableJavaMethod;
import com.github.tadukoo.java.packagedeclaration.EditableJavaPackageDeclaration;
import com.github.tadukoo.java.packagedeclaration.JavaPackageDeclaration;
import com.github.tadukoo.java.packagedeclaration.JavaPackageDeclarationBuilder;
import com.github.tadukoo.java.packagedeclaration.UneditableJavaPackageDeclaration;
import com.github.tadukoo.util.ListUtil;
import com.github.tadukoo.util.StringUtil;
import com.github.tadukoo.util.functional.function.Function;
import com.github.tadukoo.util.functional.supplier.Supplier;
import com.github.tadukoo.util.tuple.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public abstract class BaseJavaCodeTypeTest<CodeType extends JavaCodeType> {
    protected static final List<Builders> allBuilders = ListUtil.createList((Object[])new Builders[]{new Builders((Supplier<JavaPackageDeclarationBuilder<? extends JavaPackageDeclaration>>)((Supplier)UneditableJavaPackageDeclaration::builder), (Supplier<JavaImportStatementBuilder<? extends JavaImportStatement>>)((Supplier)UneditableJavaImportStatement::builder), (Supplier<JavaSingleLineCommentBuilder<? extends JavaSingleLineComment>>)((Supplier)UneditableJavaSingleLineComment::builder), (Supplier<JavaMultiLineCommentBuilder<? extends JavaMultiLineComment>>)((Supplier)UneditableJavaMultiLineComment::builder), (Supplier<JavadocBuilder<? extends Javadoc>>)((Supplier)UneditableJavadoc::builder), (Supplier<JavaAnnotationBuilder<? extends JavaAnnotation>>)((Supplier)UneditableJavaAnnotation::builder), (Supplier<JavaFieldBuilder<? extends JavaField>>)((Supplier)UneditableJavaField::builder), (Supplier<JavaMethodBuilder<? extends JavaMethod>>)((Supplier)UneditableJavaMethod::builder), (Supplier<JavaClassBuilder<? extends JavaClass>>)((Supplier)UneditableJavaClass::builder), (Supplier<JavaStaticCodeBlockBuilder<? extends JavaStaticCodeBlock>>)((Supplier)UneditableJavaStaticCodeBlock::builder)), new Builders((Supplier<JavaPackageDeclarationBuilder<? extends JavaPackageDeclaration>>)((Supplier)EditableJavaPackageDeclaration::builder), (Supplier<JavaImportStatementBuilder<? extends JavaImportStatement>>)((Supplier)EditableJavaImportStatement::builder), (Supplier<JavaSingleLineCommentBuilder<? extends JavaSingleLineComment>>)((Supplier)EditableJavaSingleLineComment::builder), (Supplier<JavaMultiLineCommentBuilder<? extends JavaMultiLineComment>>)((Supplier)EditableJavaMultiLineComment::builder), (Supplier<JavadocBuilder<? extends Javadoc>>)((Supplier)EditableJavadoc::builder), (Supplier<JavaAnnotationBuilder<? extends JavaAnnotation>>)((Supplier)EditableJavaAnnotation::builder), (Supplier<JavaFieldBuilder<? extends JavaField>>)((Supplier)EditableJavaField::builder), (Supplier<JavaMethodBuilder<? extends JavaMethod>>)((Supplier)EditableJavaMethod::builder), (Supplier<JavaClassBuilder<? extends JavaClass>>)((Supplier)EditableJavaClass::builder), (Supplier<JavaStaticCodeBlockBuilder<? extends JavaStaticCodeBlock>>)((Supplier)EditableJavaStaticCodeBlock::builder)), new Builders((Supplier<JavaPackageDeclarationBuilder<? extends JavaPackageDeclaration>>)((Supplier)TestJavaPackageDeclaration::builder), (Supplier<JavaImportStatementBuilder<? extends JavaImportStatement>>)((Supplier)TestJavaImportStatement::builder), (Supplier<JavaSingleLineCommentBuilder<? extends JavaSingleLineComment>>)((Supplier)TestJavaSingleLineComment::builder), (Supplier<JavaMultiLineCommentBuilder<? extends JavaMultiLineComment>>)((Supplier)TestJavaMultiLineComment::builder), (Supplier<JavadocBuilder<? extends Javadoc>>)((Supplier)TestJavadoc::builder), (Supplier<JavaAnnotationBuilder<? extends JavaAnnotation>>)((Supplier)TestJavaAnnotation::builder), (Supplier<JavaFieldBuilder<? extends JavaField>>)((Supplier)TestJavaField::builder), (Supplier<JavaMethodBuilder<? extends JavaMethod>>)((Supplier)TestJavaMethod::builder), (Supplier<JavaClassBuilder<? extends JavaClass>>)((Supplier)TestJavaClass::builder), (Supplier<JavaStaticCodeBlockBuilder<? extends JavaStaticCodeBlock>>)((Supplier)TestJavaStaticCodeBlock::builder))});
    protected static final List<SimpleClassNames> simpleClassNames = ListUtil.createList((Object[])new SimpleClassNames[]{new SimpleClassNames(UneditableJavaPackageDeclaration.class.getSimpleName(), UneditableJavaImportStatement.class.getSimpleName(), UneditableJavaSingleLineComment.class.getSimpleName(), UneditableJavaMultiLineComment.class.getSimpleName(), UneditableJavadoc.class.getSimpleName(), UneditableJavaAnnotation.class.getSimpleName(), UneditableJavaField.class.getSimpleName(), UneditableJavaMethod.class.getSimpleName(), UneditableJavaClass.class.getSimpleName(), UneditableJavaStaticCodeBlock.class.getSimpleName()), new SimpleClassNames(EditableJavaPackageDeclaration.class.getSimpleName(), EditableJavaImportStatement.class.getSimpleName(), EditableJavaSingleLineComment.class.getSimpleName(), EditableJavaMultiLineComment.class.getSimpleName(), EditableJavadoc.class.getSimpleName(), EditableJavaAnnotation.class.getSimpleName(), EditableJavaField.class.getSimpleName(), EditableJavaMethod.class.getSimpleName(), EditableJavaClass.class.getSimpleName(), EditableJavaStaticCodeBlock.class.getSimpleName()), new SimpleClassNames(TestJavaPackageDeclaration.class.getSimpleName(), TestJavaImportStatement.class.getSimpleName(), TestJavaSingleLineComment.class.getSimpleName(), TestJavaMultiLineComment.class.getSimpleName(), TestJavadoc.class.getSimpleName(), TestJavaAnnotation.class.getSimpleName(), TestJavaField.class.getSimpleName(), TestJavaMethod.class.getSimpleName(), TestJavaClass.class.getSimpleName(), TestJavaStaticCodeBlock.class.getSimpleName())});

    protected abstract Stream<Arguments> getEditableData();

    @ParameterizedTest
    @MethodSource(value={"getEditableData"})
    public void testIsEditable(CodeType type, boolean editable, Function<CodeType, Boolean> editableFunc) {
        Assertions.assertEquals((Object)editable, (Object)editableFunc.apply(type));
    }

    protected abstract Stream<Arguments> getEqualsData();

    @ParameterizedTest
    @MethodSource(value={"getEqualsData"})
    public void testEquals(Object expectedObject, Object actualObject) {
        Assertions.assertEquals((Object)expectedObject, (Object)actualObject);
    }

    protected abstract Stream<Arguments> getNotEqualsData();

    @ParameterizedTest
    @MethodSource(value={"getNotEqualsData"})
    public void testNotEquals(Object expectedObject, Object actualObject) {
        Assertions.assertNotEquals((Object)expectedObject, (Object)actualObject);
    }

    protected abstract Stream<Arguments> getStringData();

    @ParameterizedTest
    @MethodSource(value={"getStringData"})
    public void testToString(CodeType type, String expectedText, String ignored) {
        Assertions.assertEquals((Object)expectedText, (Object)type.toString());
    }

    @ParameterizedTest
    @MethodSource(value={"getStringData"})
    public void testToBuilderCode(CodeType type, String ignored, String builderCode) {
        Assertions.assertEquals((Object)builderCode, (Object)type.toBuilderCode());
    }

    protected Stream<Arguments> getBuilderErrorData() {
        return Stream.of(Arguments.of((Object[])new Object[]{() -> null, null}));
    }

    @ParameterizedTest
    @MethodSource(value={"getBuilderErrorData"})
    public void testBuilderError(Supplier<CodeType> buildFunc, String errorText) {
        if (StringUtil.isBlank((String)errorText)) {
            return;
        }
        try {
            buildFunc.get();
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)errorText, (Object)e.getMessage());
        }
    }

    protected record Builders(Supplier<JavaPackageDeclarationBuilder<? extends JavaPackageDeclaration>> packageDeclarationBuilder, Supplier<JavaImportStatementBuilder<? extends JavaImportStatement>> importStatementBuilder, Supplier<JavaSingleLineCommentBuilder<? extends JavaSingleLineComment>> singleLineCommentBuilder, Supplier<JavaMultiLineCommentBuilder<? extends JavaMultiLineComment>> multiLineCommentBuilder, Supplier<JavadocBuilder<? extends Javadoc>> javadocBuilder, Supplier<JavaAnnotationBuilder<? extends JavaAnnotation>> annotationBuilder, Supplier<JavaFieldBuilder<? extends JavaField>> fieldBuilder, Supplier<JavaMethodBuilder<? extends JavaMethod>> methodBuilder, Supplier<JavaClassBuilder<? extends JavaClass>> classBuilder, Supplier<JavaStaticCodeBlockBuilder<? extends JavaStaticCodeBlock>> staticCodeBlockBuilder) {
    }

    protected record SimpleClassNames(String packageDeclarationSimpleClassName, String importStatementSimpleClassName, String singleLineCommentSimpleClassName, String multiLineCommentSimpleClassName, String javadocSimpleClassName, String annotationSimpleClassName, String fieldSimpleClassName, String methodSimpleClassName, String classSimpleClassName, String staticCodeBlockSimpleClassName) {
    }

    protected static class TestJavaPackageDeclaration
    extends JavaPackageDeclaration {
        private TestJavaPackageDeclaration(boolean editable, String packageName) {
            super(editable, packageName);
        }

        public static TestJavaPackageDeclarationBuilder builder() {
            return new TestJavaPackageDeclarationBuilder(false);
        }
    }

    protected static class TestJavaImportStatement
    extends JavaImportStatement {
        private TestJavaImportStatement(boolean editable, boolean isStatic, String importName) {
            super(editable, isStatic, importName);
        }

        public static TestJavaImportStatementBuilder builder() {
            return new TestJavaImportStatementBuilder(false);
        }
    }

    protected static class TestJavaSingleLineComment
    extends JavaSingleLineComment {
        protected TestJavaSingleLineComment(boolean editable, String content) {
            super(editable, content);
        }

        public static TestJavaSingleLineCommentBuilder builder() {
            return new TestJavaSingleLineCommentBuilder(false);
        }
    }

    protected static class TestJavaMultiLineComment
    extends JavaMultiLineComment {
        protected TestJavaMultiLineComment(boolean editable, List<String> content) {
            super(editable, content);
        }

        public static TestJavaMultiLineCommentBuilder builder() {
            return new TestJavaMultiLineCommentBuilder(false);
        }
    }

    protected static class TestJavadoc
    extends Javadoc {
        protected TestJavadoc(boolean editable, boolean condensed, List<String> content, String author, String version, String since, List<Pair<String, String>> params, String returnVal, List<Pair<String, String>> throwsInfos) {
            super(editable, condensed, content, author, version, since, params, returnVal, throwsInfos);
        }

        public static TestJavadocBuilder builder() {
            return new TestJavadocBuilder(false);
        }
    }

    protected static class TestJavaAnnotation
    extends JavaAnnotation {
        private TestJavaAnnotation(boolean editable, String name, String canonicalName, List<Pair<String, String>> parameters) {
            super(editable, name, canonicalName, parameters);
        }

        public static TestJavaAnnotationBuilder builder() {
            return new TestJavaAnnotationBuilder(false);
        }
    }

    protected static class TestJavaField
    extends JavaField {
        protected TestJavaField(boolean editable, Javadoc javadoc, List<JavaAnnotation> annotations, Visibility visibility, boolean isStatic, boolean isFinal, JavaType type, String name, String value) {
            super(editable, javadoc, annotations, visibility, isStatic, isFinal, type, name, value);
        }

        public static TestJavaFieldBuilder builder() {
            return new TestJavaFieldBuilder(false);
        }
    }

    protected static class TestJavaMethod
    extends JavaMethod {
        private TestJavaMethod(boolean editable, Javadoc javadoc, List<JavaAnnotation> annotations, Visibility visibility, boolean isAbstract, boolean isStatic, boolean isFinal, List<JavaTypeParameter> typeParameters, JavaType returnType, String name, List<JavaParameter> parameters, List<String> throwTypes, List<String> lines) {
            super(editable, javadoc, annotations, visibility, isAbstract, isStatic, isFinal, typeParameters, returnType, name, parameters, throwTypes, lines);
        }

        public static TestJavaMethodBuilder builder() {
            return new TestJavaMethodBuilder(false);
        }
    }

    protected static class TestJavaClass
    extends JavaClass {
        private TestJavaClass(boolean editable, boolean isInnerClass, JavaPackageDeclaration packageDeclaration, List<JavaImportStatement> importStatements, Javadoc javadoc, List<JavaAnnotation> annotations, Visibility visibility, boolean isAbstract, boolean isStatic, boolean isFinal, JavaType className, JavaType superClassName, List<JavaType> implementsInterfaceNames, List<JavaStaticCodeBlock> staticCodeBlocks, List<JavaSingleLineComment> singleLineComments, List<JavaMultiLineComment> multiLineComments, List<JavaClass> innerClasses, List<JavaField> fields, List<JavaMethod> methods, List<Pair<JavaCodeTypes, String>> innerElementsOrder) {
            super(editable, isInnerClass, packageDeclaration, importStatements, javadoc, annotations, visibility, isAbstract, isStatic, isFinal, className, superClassName, implementsInterfaceNames, staticCodeBlocks, singleLineComments, multiLineComments, innerClasses, fields, methods, innerElementsOrder);
        }

        public static TestJavaClassBuilder builder() {
            return new TestJavaClassBuilder(false);
        }
    }

    protected static class TestJavaStaticCodeBlock
    extends JavaStaticCodeBlock {
        private TestJavaStaticCodeBlock(boolean editable, List<String> lines) {
            super(editable, lines);
        }

        public static TestJavaStaticCodeBlockBuilder builder() {
            return new TestJavaStaticCodeBlockBuilder(false);
        }
    }

    protected static class TestJavaStaticCodeBlockBuilder
    extends JavaStaticCodeBlockBuilder<TestJavaStaticCodeBlock> {
        private final boolean editable;

        private TestJavaStaticCodeBlockBuilder(boolean editable) {
            this.editable = editable;
        }

        protected TestJavaStaticCodeBlock constructStaticCodeBlock() {
            return new TestJavaStaticCodeBlock(this.editable, this.lines);
        }
    }

    protected static class TestJavaClassBuilder
    extends JavaClassBuilder<TestJavaClass> {
        private final boolean editable;

        private TestJavaClassBuilder(boolean editable) {
            this.editable = editable;
        }

        protected JavaPackageDeclarationBuilder<?> getPackageDeclarationBuilder() {
            return UneditableJavaPackageDeclaration.builder();
        }

        protected JavaImportStatementBuilder<?> getImportStatementBuilder() {
            return UneditableJavaImportStatement.builder();
        }

        protected JavaStaticCodeBlockBuilder<?> getStaticCodeBlockBuilder() {
            return UneditableJavaStaticCodeBlock.builder();
        }

        protected JavaSingleLineCommentBuilder<?> getSingleLineCommentBuilder() {
            return UneditableJavaSingleLineComment.builder();
        }

        protected JavaMultiLineCommentBuilder<?> getMultiLineCommentBuilder() {
            return UneditableJavaMultiLineComment.builder();
        }

        protected List<String> checkForSpecificErrors() {
            return new ArrayList<String>();
        }

        protected TestJavaClass constructClass() {
            return new TestJavaClass(this.editable, this.isInnerClass, this.packageDeclaration, this.importStatements, this.javadoc, this.annotations, this.visibility, this.isAbstract, this.isStatic, this.isFinal, this.className, this.superClassName, this.implementsInterfaceNames, this.staticCodeBlocks, this.singleLineComments, this.multiLineComments, this.innerClasses, this.fields, this.methods, this.innerElementsOrder);
        }
    }

    protected static class TestJavaMethodBuilder
    extends JavaMethodBuilder<TestJavaMethod> {
        private final boolean editable;

        private TestJavaMethodBuilder(boolean editable) {
            this.editable = editable;
        }

        protected List<String> checkForSpecificErrors() {
            return new ArrayList<String>();
        }

        protected TestJavaMethod constructMethod() {
            return new TestJavaMethod(this.editable, this.javadoc, this.annotations, this.visibility, this.isAbstract, this.isStatic, this.isFinal, this.typeParameters, this.returnType, this.name, this.parameters, this.throwTypes, this.lines);
        }
    }

    protected static class TestJavaFieldBuilder
    extends JavaFieldBuilder<TestJavaField> {
        private final boolean editable;

        public TestJavaFieldBuilder(boolean editable) {
            this.editable = editable;
        }

        protected List<String> checkForSpecificErrors() {
            return new ArrayList<String>();
        }

        protected TestJavaField constructField() {
            return new TestJavaField(this.editable, this.javadoc, this.annotations, this.visibility, this.isStatic, this.isFinal, this.type, this.name, this.value);
        }
    }

    protected static class TestJavaAnnotationBuilder
    extends JavaAnnotationBuilder<TestJavaAnnotation> {
        private final boolean editable;

        private TestJavaAnnotationBuilder(boolean editable) {
            this.editable = editable;
        }

        protected TestJavaAnnotation constructAnnotation() {
            return new TestJavaAnnotation(this.editable, this.name, this.canonicalName, this.parameters);
        }
    }

    protected static class TestJavadocBuilder
    extends JavadocBuilder<TestJavadoc> {
        private final boolean editable;

        public TestJavadocBuilder(boolean editable) {
            this.editable = editable;
        }

        protected TestJavadoc constructJavadoc() {
            return new TestJavadoc(this.editable, this.condensed, this.content, this.author, this.version, this.since, this.params, this.returnVal, this.throwsInfos);
        }
    }

    protected static class TestJavaMultiLineCommentBuilder
    extends JavaMultiLineCommentBuilder<TestJavaMultiLineComment> {
        private final boolean editable;

        private TestJavaMultiLineCommentBuilder(boolean editable) {
            this.editable = editable;
        }

        protected TestJavaMultiLineComment constructComment() {
            return new TestJavaMultiLineComment(this.editable, this.content);
        }
    }

    protected static class TestJavaSingleLineCommentBuilder
    extends JavaSingleLineCommentBuilder<TestJavaSingleLineComment> {
        private final boolean editable;

        private TestJavaSingleLineCommentBuilder(boolean editable) {
            this.editable = editable;
        }

        protected TestJavaSingleLineComment constructSingleLineComment() {
            return new TestJavaSingleLineComment(this.editable, this.content);
        }
    }

    protected static class TestJavaImportStatementBuilder
    extends JavaImportStatementBuilder<TestJavaImportStatement> {
        private final boolean editable;

        private TestJavaImportStatementBuilder(boolean editable) {
            this.editable = editable;
        }

        protected TestJavaImportStatement constructImportStatement() {
            return new TestJavaImportStatement(this.editable, this.isStatic, this.importName);
        }
    }

    protected static class TestJavaPackageDeclarationBuilder
    extends JavaPackageDeclarationBuilder<TestJavaPackageDeclaration> {
        private final boolean editable;

        private TestJavaPackageDeclarationBuilder(boolean editable) {
            this.editable = editable;
        }

        protected TestJavaPackageDeclaration constructPackageDeclaration() {
            return new TestJavaPackageDeclaration(this.editable, this.packageName);
        }
    }
}

