/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.java;

import com.github.tadukoo.java.JavaCodeTypes;
import com.github.tadukoo.java.JavaParameter;
import com.github.tadukoo.java.JavaType;
import com.github.tadukoo.java.JavaTypeParameter;
import com.github.tadukoo.java.annotation.JavaAnnotation;
import com.github.tadukoo.java.comment.JavaMultiLineComment;
import com.github.tadukoo.java.comment.JavaSingleLineComment;
import com.github.tadukoo.java.field.JavaField;
import com.github.tadukoo.java.importstatement.JavaImportStatement;
import com.github.tadukoo.java.javaclass.JavaClass;
import com.github.tadukoo.java.javadoc.Javadoc;
import com.github.tadukoo.java.method.JavaMethod;
import com.github.tadukoo.java.packagedeclaration.JavaPackageDeclaration;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class JavaCodeTypesTest {
    @ParameterizedTest
    @MethodSource(value={"getJavaCodeTypesData"})
    void testToString(JavaCodeTypes type, String expectedToString, Class<?> ignored, String ignored2e) {
        Assertions.assertEquals((Object)expectedToString, (Object)type.toString());
    }

    @ParameterizedTest
    @MethodSource(value={"getJavaCodeTypesData"})
    void testJavaTypeClass(JavaCodeTypes type, String ignored, Class<?> expectedJavaTypeClass, String ignored2) {
        Assertions.assertEquals(expectedJavaTypeClass, (Object)type.getJavaTypeClass());
    }

    @ParameterizedTest
    @MethodSource(value={"getJavaCodeTypesData"})
    public void testStandardName(JavaCodeTypes type, String ignored, Class<?> ignored2, String expectedStandardName) {
        Assertions.assertEquals((Object)expectedStandardName, (Object)type.getStandardName());
    }

    public static Stream<Arguments> getJavaCodeTypesData() {
        return Stream.of(Arguments.of((Object[])new Object[]{JavaCodeTypes.UNKNOWN, "UNKNOWN", null, "unknown"}), Arguments.of((Object[])new Object[]{JavaCodeTypes.TYPE_PARAMETER, "TYPE_PARAMETER", JavaTypeParameter.class, "type parameter"}), Arguments.of((Object[])new Object[]{JavaCodeTypes.TYPE, "TYPE", JavaType.class, "type"}), Arguments.of((Object[])new Object[]{JavaCodeTypes.PARAMETER, "PARAMETER", JavaParameter.class, "parameter"}), Arguments.of((Object[])new Object[]{JavaCodeTypes.PACKAGE_DECLARATION, "PACKAGE_DECLARATION", JavaPackageDeclaration.class, "package declaration"}), Arguments.of((Object[])new Object[]{JavaCodeTypes.IMPORT_STATEMENT, "IMPORT_STATEMENT", JavaImportStatement.class, "import statement"}), Arguments.of((Object[])new Object[]{JavaCodeTypes.JAVADOC, "JAVADOC", Javadoc.class, "Javadoc"}), Arguments.of((Object[])new Object[]{JavaCodeTypes.MULTI_LINE_COMMENT, "MULTI_LINE_COMMENT", JavaMultiLineComment.class, "multi-line comment"}), Arguments.of((Object[])new Object[]{JavaCodeTypes.SINGLE_LINE_COMMENT, "SINGLE_LINE_COMMENT", JavaSingleLineComment.class, "single-line comment"}), Arguments.of((Object[])new Object[]{JavaCodeTypes.ANNOTATION, "ANNOTATION", JavaAnnotation.class, "annotation"}), Arguments.of((Object[])new Object[]{JavaCodeTypes.TYPE_WITH_MODIFIERS, "TYPE_WITH_MODIFIERS", null, "type with modifiers"}), Arguments.of((Object[])new Object[]{JavaCodeTypes.FIELD, "FIELD", JavaField.class, "field"}), Arguments.of((Object[])new Object[]{JavaCodeTypes.METHOD, "METHOD", JavaMethod.class, "method"}), Arguments.of((Object[])new Object[]{JavaCodeTypes.CLASS, "CLASS", JavaClass.class, "class"}));
    }
}

