/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.java;

import com.github.tadukoo.java.JavaCodeTypes;
import com.github.tadukoo.java.JavaParameter;
import com.github.tadukoo.java.JavaType;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class JavaParameterTest {
    @Test
    public void testGetCodeType() {
        Assertions.assertEquals((Object)JavaCodeTypes.PARAMETER, (Object)JavaParameter.builder().type(JavaType.builder().baseType("String").build()).name("text").build().getJavaCodeType());
    }

    @Test
    public void testType() {
        JavaType type = JavaType.builder().baseType("String").build();
        JavaParameter parameter = JavaParameter.builder().type(type).name("text").build();
        Assertions.assertEquals((Object)type, (Object)parameter.getType());
    }

    @Test
    public void testName() {
        JavaType type = JavaType.builder().baseType("String").build();
        JavaParameter parameter = JavaParameter.builder().type(type).name("text").build();
        Assertions.assertEquals((Object)"text", (Object)parameter.getName());
    }

    @Test
    public void testVarargDefault() {
        JavaType type = JavaType.builder().baseType("String").build();
        JavaParameter parameter = JavaParameter.builder().type(type).name("text").build();
        Assertions.assertFalse((boolean)parameter.isVararg());
    }

    @Test
    public void testVarargSet() {
        JavaType type = JavaType.builder().baseType("String").build();
        JavaParameter parameter = JavaParameter.builder().type(type).name("text").vararg().build();
        Assertions.assertTrue((boolean)parameter.isVararg());
    }

    @Test
    public void testVarargSetFalse() {
        JavaType type = JavaType.builder().baseType("String").build();
        JavaParameter parameter = JavaParameter.builder().type(type).name("text").vararg(false).build();
        Assertions.assertFalse((boolean)parameter.isVararg());
    }

    @Test
    public void testTypeEmpty() {
        try {
            JavaParameter.builder().name("text").build();
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"type can't be null!", (Object)e.getMessage());
        }
    }

    @Test
    public void testNameEmpty() {
        try {
            JavaParameter.builder().type(JavaType.builder().baseType("String").build()).build();
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"name can't be empty!", (Object)e.getMessage());
        }
    }

    @Test
    public void testAllErrors() {
        try {
            JavaParameter.builder().build();
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"type can't be null!\nname can't be empty!", (Object)e.getMessage());
        }
    }

    @ParameterizedTest
    @MethodSource(value={"getNotEqualsData"})
    public void testNotEquals(JavaParameter parameter, JavaParameter otherParameter) {
        Assertions.assertNotEquals((Object)parameter, (Object)otherParameter);
    }

    public static Stream<Arguments> getNotEqualsData() {
        return Stream.of(Arguments.of((Object[])new Object[]{JavaParameter.builder().type(JavaType.builder().baseType("String").build()).name("text").build(), JavaParameter.builder().type(JavaType.builder().baseType("Integer").build()).name("text").build()}), Arguments.of((Object[])new Object[]{JavaParameter.builder().type(JavaType.builder().baseType("String").build()).vararg().name("text").build(), JavaParameter.builder().type(JavaType.builder().baseType("String").build()).name("text").build()}), Arguments.of((Object[])new Object[]{JavaParameter.builder().type(JavaType.builder().baseType("String").build()).name("text").build(), JavaParameter.builder().type(JavaType.builder().baseType("String").build()).name("something").build()}));
    }

    @Test
    public void testEqualsDifferentClassType() {
        Assertions.assertNotEquals((Object)JavaParameter.builder().type(JavaType.builder().baseType("String").build()).name("text").build(), (Object)"testing");
    }

    @Test
    public void testEqualsSame() {
        Assertions.assertEquals((Object)JavaParameter.builder().type(JavaType.builder().baseType("String").build()).name("text").build(), (Object)JavaParameter.builder().type(JavaType.builder().baseType("String").build()).name("text").build());
    }

    @ParameterizedTest
    @MethodSource(value={"getStringData"})
    public void testToString(JavaParameter parameter, String text, String ignored) {
        Assertions.assertEquals((Object)text, (Object)parameter.toString());
    }

    @ParameterizedTest
    @MethodSource(value={"getStringData"})
    public void testToBuilderCode(JavaParameter parameter, String ignored, String builderCode) {
        Assertions.assertEquals((Object)builderCode, (Object)parameter.toBuilderCode());
    }

    public static Stream<Arguments> getStringData() {
        return Stream.of(Arguments.of((Object[])new Object[]{JavaParameter.builder().type(JavaType.builder().baseType("String").build()).name("text").build(), "String text", "JavaParameter.builder()\n\t\t.type(JavaType.builder()\n\t\t\t\t.baseType(\"String\")\n\t\t\t\t.build())\n\t\t.name(\"text\")\n\t\t.build()"}), Arguments.of((Object[])new Object[]{JavaParameter.builder().type(JavaType.builder().baseType("String").build()).vararg().name("text").build(), "String ... text", "JavaParameter.builder()\n\t\t.type(JavaType.builder()\n\t\t\t\t.baseType(\"String\")\n\t\t\t\t.build())\n\t\t.vararg()\n\t\t.name(\"text\")\n\t\t.build()"}));
    }
}

