/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.java;

import com.github.tadukoo.java.JavaTokens;
import com.github.tadukoo.util.SetUtil;
import java.util.Set;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class JavaTokensTest {
    @ParameterizedTest
    @MethodSource(value={"getTokenData"})
    public void testToken(String expectedText, String token) {
        Assertions.assertEquals((Object)expectedText, (Object)token);
    }

    public static Stream<Arguments> getTokenData() {
        return Stream.of(Arguments.of((Object[])new Object[]{";", ";"}), Arguments.of((Object[])new Object[]{"package", "package"}), Arguments.of((Object[])new Object[]{"import", "import"}), Arguments.of((Object[])new Object[]{"class", "class"}), Arguments.of((Object[])new Object[]{"throws", "throws"}), Arguments.of((Object[])new Object[]{"extends", "extends"}), Arguments.of((Object[])new Object[]{"implements", "implements"}), Arguments.of((Object[])new Object[]{"/**", "/**"}), Arguments.of((Object[])new Object[]{"*", "*"}), Arguments.of((Object[])new Object[]{"/*", "/*"}), Arguments.of((Object[])new Object[]{"*/", "*/"}), Arguments.of((Object[])new Object[]{"//", "//"}), Arguments.of((Object[])new Object[]{"@", "@"}), Arguments.of((Object[])new Object[]{"(", "("}), Arguments.of((Object[])new Object[]{")", ")"}), Arguments.of((Object[])new Object[]{",", ","}), Arguments.of((Object[])new Object[]{"{", "{"}), Arguments.of((Object[])new Object[]{"}", "}"}), Arguments.of((Object[])new Object[]{"=", "="}), Arguments.of((Object[])new Object[]{"<", "<"}), Arguments.of((Object[])new Object[]{">", ">"}), Arguments.of((Object[])new Object[]{"...", "..."}), Arguments.of((Object[])new Object[]{"author", "author"}), Arguments.of((Object[])new Object[]{"version", "version"}), Arguments.of((Object[])new Object[]{"since", "since"}), Arguments.of((Object[])new Object[]{"param", "param"}), Arguments.of((Object[])new Object[]{"return", "return"}), Arguments.of((Object[])new Object[]{"private", "private"}), Arguments.of((Object[])new Object[]{"protected", "protected"}), Arguments.of((Object[])new Object[]{"public", "public"}), Arguments.of((Object[])new Object[]{"abstract", "abstract"}), Arguments.of((Object[])new Object[]{"static", "static"}), Arguments.of((Object[])new Object[]{"final", "final"}));
    }

    @ParameterizedTest
    @MethodSource(value={"getTokenSetData"})
    public void testTokenSet(Set<String> expectedSet, Set<String> actualSet) {
        Assertions.assertEquals(expectedSet, actualSet);
    }

    public static Stream<Arguments> getTokenSetData() {
        return Stream.of(Arguments.of((Object[])new Object[]{SetUtil.createSet((Object[])new String[]{"private", "protected", "public"}), JavaTokens.VISIBILITY_MODIFIERS}), Arguments.of((Object[])new Object[]{SetUtil.createSet((Object[])new String[]{"private", "protected", "public", "abstract", "static", "final"}), JavaTokens.MODIFIERS}));
    }
}

