/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.java;

import com.github.tadukoo.java.JavaCodeTypes;
import com.github.tadukoo.java.JavaType;
import com.github.tadukoo.java.JavaTypeParameter;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class JavaTypeParameterTest {
    @Test
    public void testGetJavaCodeType() {
        Assertions.assertEquals((Object)JavaCodeTypes.TYPE_PARAMETER, (Object)JavaTypeParameter.builder().baseType(JavaType.builder().baseType("String").build()).build().getJavaCodeType());
    }

    @Test
    public void testBaseType() {
        JavaTypeParameter typeParameter = JavaTypeParameter.builder().baseType(JavaType.builder().baseType("String").build()).build();
        Assertions.assertEquals((Object)JavaType.builder().baseType("String").build(), (Object)typeParameter.getBaseType());
    }

    @Test
    public void testExtendsType() {
        JavaTypeParameter typeParameter = JavaTypeParameter.builder().baseType(JavaType.builder().baseType("?").build()).extendsType(JavaType.builder().baseType("String").build()).build();
        Assertions.assertEquals((Object)JavaType.builder().baseType("String").build(), (Object)typeParameter.getExtendsType());
    }

    @Test
    public void testBaseTypeMissing() {
        try {
            JavaTypeParameter.builder().build();
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"baseType can't be empty!", (Object)e.getMessage());
        }
    }

    @ParameterizedTest
    @MethodSource(value={"notEqualsData"})
    public void testNotEquals(JavaTypeParameter typeParam, JavaTypeParameter otherParam) {
        Assertions.assertNotEquals((Object)typeParam, (Object)otherParam);
    }

    public static Stream<Arguments> notEqualsData() {
        return Stream.of(Arguments.of((Object[])new Object[]{JavaTypeParameter.builder().baseType(JavaType.builder().baseType("String").build()).build(), JavaTypeParameter.builder().baseType(JavaType.builder().baseType("Integer").build()).build()}), Arguments.of((Object[])new Object[]{JavaTypeParameter.builder().baseType(JavaType.builder().baseType("?").build()).extendsType(JavaType.builder().baseType("String").build()).build(), JavaTypeParameter.builder().baseType(JavaType.builder().baseType("?").build()).extendsType(JavaType.builder().baseType("Integer").build()).build()}));
    }

    @Test
    public void testEqualsNotTypeParam() {
        JavaTypeParameter typeParam = JavaTypeParameter.builder().baseType(JavaType.builder().baseType("String").build()).build();
        Assertions.assertNotEquals((Object)typeParam, (Object)"testing");
    }

    @Test
    public void testEqualsSame() {
        Assertions.assertEquals((Object)JavaTypeParameter.builder().baseType(JavaType.builder().baseType("?").build()).extendsType(JavaType.builder().baseType("String").build()).build(), (Object)JavaTypeParameter.builder().baseType(JavaType.builder().baseType("?").build()).extendsType(JavaType.builder().baseType("String").build()).build());
    }

    @ParameterizedTest
    @MethodSource(value={"getStringData"})
    public void testToString(JavaTypeParameter typeParam, String text, String ignored) {
        Assertions.assertEquals((Object)text, (Object)typeParam.toString());
    }

    @ParameterizedTest
    @MethodSource(value={"getStringData"})
    public void testToBuilderCode(JavaTypeParameter typeParam, String ignored, String builderCode) {
        Assertions.assertEquals((Object)builderCode, (Object)typeParam.toBuilderCode());
    }

    public static Stream<Arguments> getStringData() {
        return Stream.of(Arguments.of((Object[])new Object[]{JavaTypeParameter.builder().baseType(JavaType.builder().baseType("String").build()).build(), "String", "JavaTypeParameter.builder()\n\t\t.baseType(JavaType.builder()\n\t\t\t\t.baseType(\"String\")\n\t\t\t\t.build())\n\t\t.build()"}), Arguments.of((Object[])new Object[]{JavaTypeParameter.builder().baseType(JavaType.builder().baseType("?").build()).extendsType(JavaType.builder().baseType("String").build()).build(), "? extends String", "JavaTypeParameter.builder()\n\t\t.baseType(JavaType.builder()\n\t\t\t\t.baseType(\"?\")\n\t\t\t\t.build())\n\t\t.extendsType(JavaType.builder()\n\t\t\t\t.baseType(\"String\")\n\t\t\t\t.build())\n\t\t.build()"}), Arguments.of((Object[])new Object[]{JavaTypeParameter.builder().baseType(JavaType.builder().baseType("T").build()).extendsType(JavaType.builder().baseType("String").build()).build(), "T extends String", "JavaTypeParameter.builder()\n\t\t.baseType(JavaType.builder()\n\t\t\t\t.baseType(\"T\")\n\t\t\t\t.build())\n\t\t.extendsType(JavaType.builder()\n\t\t\t\t.baseType(\"String\")\n\t\t\t\t.build())\n\t\t.build()"}));
    }
}

