/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.java;

import com.github.tadukoo.java.JavaCodeTypes;
import com.github.tadukoo.java.JavaType;
import com.github.tadukoo.java.JavaTypeParameter;
import com.github.tadukoo.util.ListUtil;
import java.util.List;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class JavaTypeTest {
    @Test
    public void testGetJavaCodeType() {
        Assertions.assertEquals((Object)JavaCodeTypes.TYPE, (Object)JavaType.builder().baseType("String").build().getJavaCodeType());
    }

    @Test
    public void testBaseType() {
        JavaType type = JavaType.builder().baseType("String").build();
        Assertions.assertEquals((Object)"String", (Object)type.getBaseType());
    }

    @Test
    public void testTypeParameters() {
        List typeParams = ListUtil.createList((Object[])new JavaTypeParameter[]{JavaTypeParameter.builder().baseType(JavaType.builder().baseType("String").build()).build(), JavaTypeParameter.builder().baseType(JavaType.builder().baseType("Object").build()).build()});
        JavaType type = JavaType.builder().baseType("Map").typeParameters(typeParams).build();
        Assertions.assertEquals((Object)typeParams, (Object)type.getTypeParameters());
    }

    @Test
    public void testTypeParameter() {
        JavaTypeParameter stringTypeParam = JavaTypeParameter.builder().baseType(JavaType.builder().baseType("String").build()).build();
        JavaTypeParameter objectTypeParam = JavaTypeParameter.builder().baseType(JavaType.builder().baseType("Object").build()).build();
        JavaType type = JavaType.builder().baseType("Map").typeParameter(stringTypeParam).typeParameter(objectTypeParam).build();
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new JavaTypeParameter[]{stringTypeParam, objectTypeParam}), (Object)type.getTypeParameters());
    }

    @Test
    public void testCanonicalName() {
        JavaType type = JavaType.builder().baseType("String").canonicalName(String.class.getCanonicalName()).build();
        Assertions.assertEquals((Object)String.class.getCanonicalName(), (Object)type.getCanonicalName());
    }

    @Test
    public void testBaseTypeMissing() {
        try {
            JavaType.builder().build();
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"baseType can't be empty!", (Object)e.getMessage());
        }
    }

    @Test
    public void testSetCanonicalName() {
        JavaType type = JavaType.builder().baseType("String").canonicalName(String.class.getCanonicalName()).build();
        Assertions.assertEquals((Object)String.class.getCanonicalName(), (Object)type.getCanonicalName());
        type.setCanonicalName("com.tadukoo.String");
        Assertions.assertEquals((Object)"com.tadukoo.String", (Object)type.getCanonicalName());
    }

    @ParameterizedTest
    @MethodSource(value={"getEqualsData"})
    public void testNotEquals(JavaType type, JavaType otherType) {
        Assertions.assertNotEquals((Object)type, (Object)otherType);
    }

    public static Stream<Arguments> getEqualsData() {
        return Stream.of(Arguments.of((Object[])new Object[]{JavaType.builder().baseType("String").build(), JavaType.builder().baseType("Integer").build()}), Arguments.of((Object[])new Object[]{JavaType.builder().baseType("List").typeParameter(JavaTypeParameter.builder().baseType(JavaType.builder().baseType("String").build()).build()).build(), JavaType.builder().baseType("List").typeParameter(JavaTypeParameter.builder().baseType(JavaType.builder().baseType("Integer").build()).build()).build()}), Arguments.of((Object[])new Object[]{JavaType.builder().baseType("String").canonicalName(String.class.getCanonicalName()).build(), JavaType.builder().baseType("String").canonicalName("com.tadukoo.String").build()}));
    }

    @Test
    public void testEqualsDifferentThing() {
        Assertions.assertNotEquals((Object)JavaType.builder().baseType("String").build(), (Object)"testing");
    }

    @Test
    public void testEqualsSame() {
        Assertions.assertEquals((Object)JavaType.builder().baseType("List").typeParameter(JavaTypeParameter.builder().baseType(JavaType.builder().baseType("String").build()).build()).canonicalName(String.class.getCanonicalName()).build(), (Object)JavaType.builder().baseType("List").typeParameter(JavaTypeParameter.builder().baseType(JavaType.builder().baseType("String").build()).build()).canonicalName(String.class.getCanonicalName()).build());
    }

    @ParameterizedTest
    @MethodSource(value={"getStringData"})
    public void testToString(JavaType type, String text, String ignored) {
        Assertions.assertEquals((Object)text, (Object)type.toString());
    }

    @ParameterizedTest
    @MethodSource(value={"getStringData"})
    public void testToBuilderCode(JavaType type, String ignored, String builderText) {
        Assertions.assertEquals((Object)builderText, (Object)type.toBuilderCode());
    }

    public static Stream<Arguments> getStringData() {
        return Stream.of(Arguments.of((Object[])new Object[]{JavaType.builder().baseType("String").build(), "String", "JavaType.builder()\n\t\t.baseType(\"String\")\n\t\t.build()"}), Arguments.of((Object[])new Object[]{JavaType.builder().baseType("List").typeParameter(JavaTypeParameter.builder().baseType(JavaType.builder().baseType("String").build()).build()).build(), "List<String>", "JavaType.builder()\n\t\t.baseType(\"List\")\n\t\t.typeParameter(JavaTypeParameter.builder()\n\t\t\t\t.baseType(JavaType.builder()\n\t\t\t\t\t\t.baseType(\"String\")\n\t\t\t\t\t\t.build())\n\t\t\t\t.build())\n\t\t.build()"}), Arguments.of((Object[])new Object[]{JavaType.builder().baseType("Map").typeParameter(JavaTypeParameter.builder().baseType(JavaType.builder().baseType("String").build()).build()).typeParameter(JavaTypeParameter.builder().baseType(JavaType.builder().baseType("Object").build()).build()).build(), "Map<String, Object>", "JavaType.builder()\n\t\t.baseType(\"Map\")\n\t\t.typeParameter(JavaTypeParameter.builder()\n\t\t\t\t.baseType(JavaType.builder()\n\t\t\t\t\t\t.baseType(\"String\")\n\t\t\t\t\t\t.build())\n\t\t\t\t.build())\n\t\t.typeParameter(JavaTypeParameter.builder()\n\t\t\t\t.baseType(JavaType.builder()\n\t\t\t\t\t\t.baseType(\"Object\")\n\t\t\t\t\t\t.build())\n\t\t\t\t.build())\n\t\t.build()"}), Arguments.of((Object[])new Object[]{JavaType.builder().baseType("String").canonicalName("com.tadukoo.String").build(), "String", "JavaType.builder()\n\t\t.baseType(\"String\")\n\t\t.canonicalName(\"com.tadukoo.String\")\n\t\t.build()"}), Arguments.of((Object[])new Object[]{JavaType.builder().baseType("Map").canonicalName("com.tadukoo.Map").typeParameter(JavaTypeParameter.builder().baseType(JavaType.builder().baseType("String").build()).build()).typeParameter(JavaTypeParameter.builder().baseType(JavaType.builder().baseType("Object").build()).build()).build(), "Map<String, Object>", "JavaType.builder()\n\t\t.baseType(\"Map\")\n\t\t.canonicalName(\"com.tadukoo.Map\")\n\t\t.typeParameter(JavaTypeParameter.builder()\n\t\t\t\t.baseType(JavaType.builder()\n\t\t\t\t\t\t.baseType(\"String\")\n\t\t\t\t\t\t.build())\n\t\t\t\t.build())\n\t\t.typeParameter(JavaTypeParameter.builder()\n\t\t\t\t.baseType(JavaType.builder()\n\t\t\t\t\t\t.baseType(\"Object\")\n\t\t\t\t\t\t.build())\n\t\t\t\t.build())\n\t\t.build()"}));
    }
}

