/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.java;

import com.github.tadukoo.java.Visibility;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class VisibilityTest {
    @ParameterizedTest
    @MethodSource(value={"getVisibilityData"})
    public void testVisibilityToken(String token, Visibility visibility, String ignored) {
        Assertions.assertEquals((Object)token, (Object)visibility.getToken());
    }

    @ParameterizedTest
    @MethodSource(value={"getVisibilityData"})
    public void testVisibilityFromTextToken(String token, Visibility visibility, String ignored) {
        Assertions.assertEquals((Object)visibility, (Object)Visibility.fromToken((String)token));
    }

    @ParameterizedTest
    @MethodSource(value={"getVisibilityData"})
    public void testVisibilityFromTextCaseInsensitive(String ignored, Visibility visibility, String testString) {
        Assertions.assertEquals((Object)visibility, (Object)Visibility.fromToken((String)testString));
    }

    public static Stream<Arguments> getVisibilityData() {
        return Stream.of(Arguments.of((Object[])new Object[]{"public", Visibility.PUBLIC, "pUBlIc"}), Arguments.of((Object[])new Object[]{"protected", Visibility.PROTECTED, "PROtecTeD"}), Arguments.of((Object[])new Object[]{"private", Visibility.PRIVATE, "PRiVAtE"}), Arguments.of((Object[])new Object[]{"", Visibility.NONE, ""}));
    }

    @Test
    public void testFromTextGarbage() {
        Assertions.assertNull((Object)Visibility.fromToken((String)"some_garbage_Stuff"));
    }
}

