/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.java.annotation;

import com.github.tadukoo.java.BaseJavaCodeTypeTest;
import com.github.tadukoo.java.JavaCodeTypes;
import com.github.tadukoo.java.annotation.EditableJavaAnnotation;
import com.github.tadukoo.java.annotation.JavaAnnotation;
import com.github.tadukoo.java.annotation.JavaAnnotationBuilder;
import com.github.tadukoo.java.annotation.UneditableJavaAnnotation;
import com.github.tadukoo.util.ListUtil;
import com.github.tadukoo.util.StringUtil;
import com.github.tadukoo.util.functional.function.Function;
import com.github.tadukoo.util.map.MapUtil;
import com.github.tadukoo.util.tuple.Pair;
import com.github.tadukoo.util.tuple.Triple;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.provider.Arguments;

public class JavaAnnotationTest
extends BaseJavaCodeTypeTest<JavaAnnotation> {
    @Override
    protected Stream<Arguments> getEditableData() {
        return Stream.of(Arguments.of((Object[])new Object[]{UneditableJavaAnnotation.builder().name("Test").build(), false, JavaAnnotation::isEditable}), Arguments.of((Object[])new Object[]{EditableJavaAnnotation.builder().name("Test").build(), true, JavaAnnotation::isEditable}));
    }

    @Override
    protected Stream<Arguments> getEqualsData() {
        List comparisons = ListUtil.createList((Object[])new Pair[]{Pair.of(builders -> JavaCodeTypes.ANNOTATION, builders -> ((JavaAnnotationBuilder)builders.annotationBuilder().get()).name("Test").build().getJavaCodeType()), Pair.of(builders -> new ArrayList(), builders -> ((JavaAnnotationBuilder)builders.annotationBuilder().get()).name("Test").build().getParameters()), Pair.of(builders -> ((JavaAnnotationBuilder)builders.annotationBuilder().get()).name("Test").canonicalName("something.Test").parameter("test", "true").parameter("derp", "false").build(), builders -> ((JavaAnnotationBuilder)builders.annotationBuilder().get()).copy(((JavaAnnotationBuilder)builders.annotationBuilder().get()).name("Test").canonicalName("something.Test").parameter("test", "true").parameter("derp", "false").build()).build()), Pair.of(builders -> "Test", builders -> ((JavaAnnotationBuilder)builders.annotationBuilder().get()).name("Test").build().getName()), Pair.of(builders -> "something.Test", builders -> ((JavaAnnotationBuilder)builders.annotationBuilder().get()).name("Test").canonicalName("something.Test").build().getCanonicalName()), Pair.of(builders -> ListUtil.createList((Object[])new Pair[]{Pair.of((Object)"test", (Object)"true"), Pair.of((Object)"derp", (Object)"false")}), builders -> ((JavaAnnotationBuilder)builders.annotationBuilder().get()).name("Test").parameter("test", "true").parameter("derp", "false").build().getParameters()), Pair.of(builders -> ListUtil.createList((Object[])new Pair[]{Pair.of((Object)"test", (Object)"true"), Pair.of((Object)"derp", (Object)"false")}), builders -> ((JavaAnnotationBuilder)builders.annotationBuilder().get()).name("Test").parameter(Pair.of((Object)"test", (Object)"true")).parameter(Pair.of((Object)"derp", (Object)"false")).build().getParameters()), Pair.of(builders -> ListUtil.createList((Object[])new Pair[]{Pair.of((Object)"test", (Object)"true"), Pair.of((Object)"derp", (Object)"false")}), builders -> ((JavaAnnotationBuilder)builders.annotationBuilder().get()).name("Test").parameters(ListUtil.createList((Object[])new Pair[]{Pair.of((Object)"test", (Object)"true"), Pair.of((Object)"derp", (Object)"false")})).build().getParameters()), Pair.of(builders -> true, builders -> ((JavaAnnotationBuilder)builders.annotationBuilder().get()).name("Test").build().getParametersMap().isEmpty()), Pair.of(builders -> MapUtil.createMap((Pair[])new Pair[]{Pair.of((Object)"test", (Object)"something")}), builders -> ((JavaAnnotationBuilder)builders.annotationBuilder().get()).name("Test").parameter("test", "something").build().getParametersMap()), Pair.of(builders -> MapUtil.createMap((Pair[])new Pair[]{Pair.of((Object)"test", (Object)"something"), Pair.of((Object)"derp", (Object)"something else")}), builders -> ((JavaAnnotationBuilder)builders.annotationBuilder().get()).name("Test").parameter("test", "something").parameter("derp", "something else").build().getParametersMap()), Pair.of(builders -> ((JavaAnnotationBuilder)builders.annotationBuilder().get()).name("Test").build(), builders -> ((JavaAnnotationBuilder)builders.annotationBuilder().get()).name("Test").build())});
        return comparisons.stream().flatMap(pair -> Stream.of(0, 1, 2).map(index -> Arguments.of((Object[])new Object[]{((Function)pair.getLeft()).apply((Object)((BaseJavaCodeTypeTest.Builders)allBuilders.get((int)index))), ((Function)pair.getRight()).apply((Object)((BaseJavaCodeTypeTest.Builders)allBuilders.get((int)index)))})));
    }

    @Override
    protected Stream<Arguments> getNotEqualsData() {
        List comparisons = ListUtil.createList((Object[])new Pair[]{Pair.of(builders -> ((JavaAnnotationBuilder)builders.annotationBuilder().get()).name("Test").build(), builders -> ((JavaAnnotationBuilder)builders.annotationBuilder().get()).name("Testing").build()), Pair.of(builders -> ((JavaAnnotationBuilder)builders.annotationBuilder().get()).name("Test").build(), builders -> ((JavaAnnotationBuilder)builders.annotationBuilder().get()).name("Test").canonicalName("something.here").build()), Pair.of(builders -> ((JavaAnnotationBuilder)builders.annotationBuilder().get()).name("Test").build(), builders -> "testing")});
        return comparisons.stream().flatMap(pair -> Stream.of(0, 1, 2).map(index -> Arguments.of((Object[])new Object[]{((Function)pair.getLeft()).apply((Object)((BaseJavaCodeTypeTest.Builders)allBuilders.get((int)index))), ((Function)pair.getRight()).apply((Object)((BaseJavaCodeTypeTest.Builders)allBuilders.get((int)index)))})));
    }

    @Override
    protected Stream<Arguments> getStringData() {
        List annotationMakersAndStrings = ListUtil.createList((Object[])new Triple[]{Triple.of(builders -> ((JavaAnnotationBuilder)builders.annotationBuilder().get()).name("Test").build(), (Object)"@Test", classNames -> classNames.annotationSimpleClassName() + ".builder()\n\t\t.name(\"Test\")\n\t\t.build()"), Triple.of(builders -> ((JavaAnnotationBuilder)builders.annotationBuilder().get()).name("Test").parameter("test", "true").build(), (Object)"@Test(test = true)", classNames -> classNames.annotationSimpleClassName() + ".builder()\n\t\t.name(\"Test\")\n\t\t.parameter(\"test\", \"true\")\n\t\t.build()"), Triple.of(builders -> ((JavaAnnotationBuilder)builders.annotationBuilder().get()).name("Test").parameter("value", "true").build(), (Object)"@Test(true)", classNames -> classNames.annotationSimpleClassName() + ".builder()\n\t\t.name(\"Test\")\n\t\t.parameter(\"value\", \"true\")\n\t\t.build()"), Triple.of(builders -> ((JavaAnnotationBuilder)builders.annotationBuilder().get()).name("Test").parameter("test", "true").parameter("derp", "String.class").build(), (Object)"@Test(test = true, derp = String.class)", classNames -> classNames.annotationSimpleClassName() + ".builder()\n\t\t.name(\"Test\")\n\t\t.parameter(\"test\", \"true\")\n\t\t.parameter(\"derp\", \"String.class\")\n\t\t.build()"), Triple.of(builders -> ((JavaAnnotationBuilder)builders.annotationBuilder().get()).name("Test").parameter("value", "true").parameter("derp", "String.class").build(), (Object)"@Test(value = true, derp = String.class)", classNames -> classNames.annotationSimpleClassName() + ".builder()\n\t\t.name(\"Test\")\n\t\t.parameter(\"value\", \"true\")\n\t\t.parameter(\"derp\", \"String.class\")\n\t\t.build()"), Triple.of(builders -> ((JavaAnnotationBuilder)builders.annotationBuilder().get()).name("Test").canonicalName("some.canon.name").build(), (Object)"@Test", classNames -> classNames.annotationSimpleClassName() + ".builder()\n\t\t.name(\"Test\")\n\t\t.canonicalName(\"some.canon.name\")\n\t\t.build()"), Triple.of(builders -> ((JavaAnnotationBuilder)builders.annotationBuilder().get()).name("Test").canonicalName("some.canon.name").parameter("test", "5").parameter("something", "42").build(), (Object)"@Test(test = 5, something = 42)", classNames -> classNames.annotationSimpleClassName() + ".builder()\n\t\t.name(\"Test\")\n\t\t.canonicalName(\"some.canon.name\")\n\t\t.parameter(\"test\", \"5\")\n\t\t.parameter(\"something\", \"42\")\n\t\t.build()")});
        return annotationMakersAndStrings.stream().flatMap(triple -> Stream.of(0, 1, 2).map(index -> Arguments.of((Object[])new Object[]{((Function)triple.getLeft()).apply((Object)((BaseJavaCodeTypeTest.Builders)allBuilders.get((int)index))), triple.getMiddle(), ((Function)triple.getRight()).apply((Object)((BaseJavaCodeTypeTest.SimpleClassNames)simpleClassNames.get((int)index)))})));
    }

    @Override
    protected Stream<Arguments> getBuilderErrorData() {
        List builderFuncsAndErrorMessages = ListUtil.createList((Object[])new Pair[]{Pair.of(builders -> () -> ((JavaAnnotationBuilder)builders.annotationBuilder().get()).build(), (Object)"Must specify name!")});
        return builderFuncsAndErrorMessages.stream().flatMap(pair -> Stream.of(0, 1, 2).map(index -> Arguments.of((Object[])new Object[]{((Function)pair.getLeft()).apply((Object)((BaseJavaCodeTypeTest.Builders)allBuilders.get((int)index))), pair.getRight()})));
    }

    @Test
    public void testSetName() {
        EditableJavaAnnotation annotation = (EditableJavaAnnotation)EditableJavaAnnotation.builder().name("Test").build();
        Assertions.assertEquals((Object)"Test", (Object)annotation.getName());
        annotation.setName("Derp");
        Assertions.assertEquals((Object)"Derp", (Object)annotation.getName());
    }

    @Test
    public void testSetCanonicalName() {
        EditableJavaAnnotation annotation = (EditableJavaAnnotation)EditableJavaAnnotation.builder().name("Test").build();
        Assertions.assertTrue((boolean)StringUtil.isBlank((String)annotation.getCanonicalName()));
        annotation.setCanonicalName("something.Test");
        Assertions.assertEquals((Object)"something.Test", (Object)annotation.getCanonicalName());
    }

    @Test
    public void testAddParameterPieces() {
        EditableJavaAnnotation annotation = (EditableJavaAnnotation)EditableJavaAnnotation.builder().name("Test").build();
        Assertions.assertEquals(new ArrayList(), (Object)annotation.getParameters());
        annotation.addParameter("test", "true");
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new Pair[]{Pair.of((Object)"test", (Object)"true")}), (Object)annotation.getParameters());
        annotation.addParameter("derp", "String.class");
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new Pair[]{Pair.of((Object)"test", (Object)"true"), Pair.of((Object)"derp", (Object)"String.class")}), (Object)annotation.getParameters());
    }

    @Test
    public void testAddParameterPair() {
        EditableJavaAnnotation annotation = (EditableJavaAnnotation)EditableJavaAnnotation.builder().name("Test").build();
        Assertions.assertEquals(new ArrayList(), (Object)annotation.getParameters());
        annotation.addParameter(Pair.of((Object)"test", (Object)"true"));
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new Pair[]{Pair.of((Object)"test", (Object)"true")}), (Object)annotation.getParameters());
        annotation.addParameter(Pair.of((Object)"derp", (Object)"String.class"));
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new Pair[]{Pair.of((Object)"test", (Object)"true"), Pair.of((Object)"derp", (Object)"String.class")}), (Object)annotation.getParameters());
    }

    @Test
    public void testAddParameters() {
        EditableJavaAnnotation annotation = (EditableJavaAnnotation)EditableJavaAnnotation.builder().name("Test").build();
        Pair param1 = Pair.of((Object)"test", (Object)"true");
        Pair param2 = Pair.of((Object)"derp", (Object)"String.class");
        Pair param3 = Pair.of((Object)"yep", (Object)"false");
        Pair param4 = Pair.of((Object)"nah", (Object)"\"\"");
        Assertions.assertEquals(new ArrayList(), (Object)annotation.getParameters());
        annotation.addParameters(ListUtil.createList((Object[])new Pair[]{param1, param2}));
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new Pair[]{param1, param2}), (Object)annotation.getParameters());
        annotation.addParameters(ListUtil.createList((Object[])new Pair[]{param3, param4}));
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new Pair[]{param1, param2, param3, param4}), (Object)annotation.getParameters());
    }

    @Test
    public void testSetParameters() {
        EditableJavaAnnotation annotation = (EditableJavaAnnotation)EditableJavaAnnotation.builder().name("Test").build();
        Pair param1 = Pair.of((Object)"test", (Object)"true");
        Pair param2 = Pair.of((Object)"derp", (Object)"String.class");
        Pair param3 = Pair.of((Object)"yep", (Object)"false");
        Pair param4 = Pair.of((Object)"nah", (Object)"\"\"");
        Assertions.assertEquals(new ArrayList(), (Object)annotation.getParameters());
        annotation.setParameters(ListUtil.createList((Object[])new Pair[]{param1, param2}));
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new Pair[]{param1, param2}), (Object)annotation.getParameters());
        annotation.setParameters(ListUtil.createList((Object[])new Pair[]{param3, param4}));
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new Pair[]{param3, param4}), (Object)annotation.getParameters());
    }
}

