/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.java.code.staticcodeblock;

import com.github.tadukoo.java.BaseJavaCodeTypeTest;
import com.github.tadukoo.java.JavaCodeTypes;
import com.github.tadukoo.java.code.staticcodeblock.EditableJavaStaticCodeBlock;
import com.github.tadukoo.java.code.staticcodeblock.JavaStaticCodeBlock;
import com.github.tadukoo.java.code.staticcodeblock.JavaStaticCodeBlockBuilder;
import com.github.tadukoo.java.code.staticcodeblock.UneditableJavaStaticCodeBlock;
import com.github.tadukoo.util.ListUtil;
import com.github.tadukoo.util.functional.function.Function;
import com.github.tadukoo.util.tuple.Pair;
import com.github.tadukoo.util.tuple.Triple;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.provider.Arguments;

public class JavaStaticCodeBlockTest
extends BaseJavaCodeTypeTest<JavaStaticCodeBlock> {
    @Override
    protected Stream<Arguments> getEditableData() {
        return Stream.of(Arguments.of((Object[])new Object[]{UneditableJavaStaticCodeBlock.builder().build(), false, JavaStaticCodeBlock::isEditable}), Arguments.of((Object[])new Object[]{EditableJavaStaticCodeBlock.builder().build(), true, JavaStaticCodeBlock::isEditable}));
    }

    @Override
    protected Stream<Arguments> getEqualsData() {
        List comparisons = ListUtil.createList((Object[])new Pair[]{Pair.of(builders -> JavaCodeTypes.STATIC_CODE_BLOCK, builders -> ((JavaStaticCodeBlockBuilder)builders.staticCodeBlockBuilder().get()).build().getJavaCodeType()), Pair.of(builders -> new ArrayList(), builders -> ((JavaStaticCodeBlockBuilder)builders.staticCodeBlockBuilder().get()).build().getLines()), Pair.of(builders -> ((JavaStaticCodeBlockBuilder)builders.staticCodeBlockBuilder().get()).line("doSomething();").line("doSomethingElse();").build(), builders -> ((JavaStaticCodeBlockBuilder)builders.staticCodeBlockBuilder().get()).copy(((JavaStaticCodeBlockBuilder)builders.staticCodeBlockBuilder().get()).line("doSomething();").line("doSomethingElse();").build()).build()), Pair.of(builders -> ListUtil.createList((Object[])new String[]{"doSomething();", "doSomethingElse();"}), builders -> ((JavaStaticCodeBlockBuilder)builders.staticCodeBlockBuilder().get()).lines(ListUtil.createList((Object[])new String[]{"doSomething();", "doSomethingElse();"})).build().getLines()), Pair.of(builders -> ListUtil.createList((Object[])new String[]{"doSomething();"}), builders -> ((JavaStaticCodeBlockBuilder)builders.staticCodeBlockBuilder().get()).line("doSomething();").build().getLines()), Pair.of(builders -> ((JavaStaticCodeBlockBuilder)builders.staticCodeBlockBuilder().get()).line("doSomething();").line("doSomethingElse();").build(), builders -> ((JavaStaticCodeBlockBuilder)builders.staticCodeBlockBuilder().get()).line("doSomething();").line("doSomethingElse();").build())});
        return comparisons.stream().flatMap(pair -> Stream.of(0, 1, 2).map(index -> Arguments.of((Object[])new Object[]{((Function)pair.getLeft()).apply((Object)((BaseJavaCodeTypeTest.Builders)allBuilders.get((int)index))), ((Function)pair.getRight()).apply((Object)((BaseJavaCodeTypeTest.Builders)allBuilders.get((int)index)))})));
    }

    @Override
    protected Stream<Arguments> getNotEqualsData() {
        List comparisons = ListUtil.createList((Object[])new Pair[]{Pair.of(builders -> ((JavaStaticCodeBlockBuilder)builders.staticCodeBlockBuilder().get()).line("doSomething();").line("doSomethingElse();").build(), builders -> ((JavaStaticCodeBlockBuilder)builders.staticCodeBlockBuilder().get()).line("doSomething();").line("doSomething2();").build()), Pair.of(builders -> ((JavaStaticCodeBlockBuilder)builders.staticCodeBlockBuilder().get()).build(), builders -> "testing")});
        return comparisons.stream().flatMap(pair -> Stream.of(0, 1, 2).map(index -> Arguments.of((Object[])new Object[]{((Function)pair.getLeft()).apply((Object)((BaseJavaCodeTypeTest.Builders)allBuilders.get((int)index))), ((Function)pair.getRight()).apply((Object)((BaseJavaCodeTypeTest.Builders)allBuilders.get((int)index)))})));
    }

    @Override
    protected Stream<Arguments> getStringData() {
        List codeBlockMakersAndStrings = ListUtil.createList((Object[])new Triple[]{Triple.of(builders -> ((JavaStaticCodeBlockBuilder)builders.staticCodeBlockBuilder().get()).build(), (Object)"static{ }", classNames -> classNames.staticCodeBlockSimpleClassName() + ".builder()\n\t\t.build()"), Triple.of(builders -> ((JavaStaticCodeBlockBuilder)builders.staticCodeBlockBuilder().get()).line("doSomething();").build(), (Object)"static{\n\tdoSomething();\n}", classNames -> classNames.staticCodeBlockSimpleClassName() + ".builder()\n\t\t.line(\"doSomething();\")\n\t\t.build()"), Triple.of(builders -> ((JavaStaticCodeBlockBuilder)builders.staticCodeBlockBuilder().get()).line("doSomething();").line("doSomethingElse();").build(), (Object)"static{\n\tdoSomething();\n\tdoSomethingElse();\n}", classNames -> classNames.staticCodeBlockSimpleClassName() + ".builder()\n\t\t.line(\"doSomething();\")\n\t\t.line(\"doSomethingElse();\")\n\t\t.build()")});
        return codeBlockMakersAndStrings.stream().flatMap(triple -> Stream.of(0, 1, 2).map(index -> Arguments.of((Object[])new Object[]{((Function)triple.getLeft()).apply((Object)((BaseJavaCodeTypeTest.Builders)allBuilders.get((int)index))), triple.getMiddle(), ((Function)triple.getRight()).apply((Object)((BaseJavaCodeTypeTest.SimpleClassNames)simpleClassNames.get((int)index)))})));
    }

    @Test
    public void testAddLine() {
        EditableJavaStaticCodeBlock codeBlock = (EditableJavaStaticCodeBlock)EditableJavaStaticCodeBlock.builder().build();
        Assertions.assertEquals(new ArrayList(), (Object)codeBlock.getLines());
        codeBlock.addLine("doSomething();");
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"doSomething();"}), (Object)codeBlock.getLines());
        codeBlock.addLine("doSomethingElse();");
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"doSomething();", "doSomethingElse();"}), (Object)codeBlock.getLines());
    }

    @Test
    public void testAddLines() {
        EditableJavaStaticCodeBlock codeBlock = (EditableJavaStaticCodeBlock)EditableJavaStaticCodeBlock.builder().build();
        Assertions.assertEquals(new ArrayList(), (Object)codeBlock.getLines());
        codeBlock.addLines(ListUtil.createList((Object[])new String[]{"doSomething();", "doSomethingElse();"}));
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"doSomething();", "doSomethingElse();"}), (Object)codeBlock.getLines());
        codeBlock.addLines(ListUtil.createList((Object[])new String[]{"doSomething2();", "doSomethingElse2();"}));
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"doSomething();", "doSomethingElse();", "doSomething2();", "doSomethingElse2();"}), (Object)codeBlock.getLines());
    }

    @Test
    public void testSetLines() {
        EditableJavaStaticCodeBlock codeBlock = (EditableJavaStaticCodeBlock)EditableJavaStaticCodeBlock.builder().build();
        Assertions.assertEquals(new ArrayList(), (Object)codeBlock.getLines());
        codeBlock.setLines(ListUtil.createList((Object[])new String[]{"doSomething();", "doSomethingElse();"}));
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"doSomething();", "doSomethingElse();"}), (Object)codeBlock.getLines());
        codeBlock.setLines(ListUtil.createList((Object[])new String[]{"doSomething2();", "doSomethingElse2();"}));
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"doSomething2();", "doSomethingElse2();"}), (Object)codeBlock.getLines());
    }
}

