/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.java.comment;

import com.github.tadukoo.java.BaseJavaCodeTypeTest;
import com.github.tadukoo.java.JavaCodeTypes;
import com.github.tadukoo.java.comment.EditableJavaMultiLineComment;
import com.github.tadukoo.java.comment.JavaMultiLineComment;
import com.github.tadukoo.java.comment.JavaMultiLineCommentBuilder;
import com.github.tadukoo.java.comment.UneditableJavaMultiLineComment;
import com.github.tadukoo.util.ListUtil;
import com.github.tadukoo.util.functional.function.Function;
import com.github.tadukoo.util.tuple.Pair;
import com.github.tadukoo.util.tuple.Triple;
import java.util.List;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.provider.Arguments;

public class JavaMultiLineCommentTest
extends BaseJavaCodeTypeTest<JavaMultiLineComment> {
    @Override
    protected Stream<Arguments> getEditableData() {
        return Stream.of(Arguments.of((Object[])new Object[]{UneditableJavaMultiLineComment.builder().build(), false, JavaMultiLineComment::isEditable}), Arguments.of((Object[])new Object[]{EditableJavaMultiLineComment.builder().build(), true, JavaMultiLineComment::isEditable}));
    }

    @Override
    protected Stream<Arguments> getEqualsData() {
        List comparisons = ListUtil.createList((Object[])new Pair[]{Pair.of(builder -> JavaCodeTypes.MULTI_LINE_COMMENT, builders -> ((JavaMultiLineCommentBuilder)builders.multiLineCommentBuilder().get()).build().getJavaCodeType()), Pair.of(builder -> ListUtil.createList((Object[])new Object[0]), builders -> ((JavaMultiLineCommentBuilder)builders.multiLineCommentBuilder().get()).build().getContent()), Pair.of(builders -> ((JavaMultiLineCommentBuilder)builders.multiLineCommentBuilder().get()).content("something useful").build(), builders -> ((JavaMultiLineCommentBuilder)builders.multiLineCommentBuilder().get()).copy(((JavaMultiLineCommentBuilder)builders.multiLineCommentBuilder().get()).content("something useful").build()).build()), Pair.of(builder -> ListUtil.createList((Object[])new String[]{"something useful"}), builders -> ((JavaMultiLineCommentBuilder)builders.multiLineCommentBuilder().get()).content("something useful").build().getContent()), Pair.of(builder -> ListUtil.createList((Object[])new String[]{"something useful", "something else"}), builders -> ((JavaMultiLineCommentBuilder)builders.multiLineCommentBuilder().get()).content(ListUtil.createList((Object[])new String[]{"something useful", "something else"})).build().getContent()), Pair.of(builder -> ListUtil.createList((Object[])new String[]{"something useful", "something else"}), builders -> ((JavaMultiLineCommentBuilder)builders.multiLineCommentBuilder().get()).content("something useful").content("something else").build().getContent()), Pair.of(builders -> ((JavaMultiLineCommentBuilder)builders.multiLineCommentBuilder().get()).build(), builders -> ((JavaMultiLineCommentBuilder)builders.multiLineCommentBuilder().get()).build())});
        return comparisons.stream().flatMap(pair -> Stream.of(0, 1, 2).map(index -> Arguments.of((Object[])new Object[]{((Function)pair.getLeft()).apply((Object)((BaseJavaCodeTypeTest.Builders)allBuilders.get((int)index))), ((Function)pair.getRight()).apply((Object)((BaseJavaCodeTypeTest.Builders)allBuilders.get((int)index)))})));
    }

    @Override
    protected Stream<Arguments> getNotEqualsData() {
        List comparisons = ListUtil.createList((Object[])new Pair[]{Pair.of(builders -> ((JavaMultiLineCommentBuilder)builders.multiLineCommentBuilder().get()).build(), builders -> ((JavaMultiLineCommentBuilder)builders.multiLineCommentBuilder().get()).content("something useful").build()), Pair.of(builders -> ((JavaMultiLineCommentBuilder)builders.multiLineCommentBuilder().get()).build(), builder -> "testing")});
        return comparisons.stream().flatMap(pair -> Stream.of(0, 1, 2).map(index -> Arguments.of((Object[])new Object[]{((Function)pair.getLeft()).apply((Object)((BaseJavaCodeTypeTest.Builders)allBuilders.get((int)index))), ((Function)pair.getRight()).apply((Object)((BaseJavaCodeTypeTest.Builders)allBuilders.get((int)index)))})));
    }

    @Override
    protected Stream<Arguments> getStringData() {
        List commentMakersAndStrings = ListUtil.createList((Object[])new Triple[]{Triple.of(builders -> ((JavaMultiLineCommentBuilder)builders.multiLineCommentBuilder().get()).build(), (Object)"/*\n */", classNames -> classNames.multiLineCommentSimpleClassName() + ".builder()\n\t\t.build()"), Triple.of(builders -> ((JavaMultiLineCommentBuilder)builders.multiLineCommentBuilder().get()).content("something useful").build(), (Object)"/*\n * something useful\n */", classNames -> classNames.multiLineCommentSimpleClassName() + ".builder()\n\t\t.content(\"something useful\")\n\t\t.build()"), Triple.of(builders -> ((JavaMultiLineCommentBuilder)builders.multiLineCommentBuilder().get()).content("something useful").content("something else").build(), (Object)"/*\n * something useful\n * something else\n */", classNames -> classNames.multiLineCommentSimpleClassName() + ".builder()\n\t\t.content(\"something useful\")\n\t\t.content(\"something else\")\n\t\t.build()")});
        return commentMakersAndStrings.stream().flatMap(triple -> Stream.of(0, 1, 2).map(index -> Arguments.of((Object[])new Object[]{((Function)triple.getLeft()).apply((Object)((BaseJavaCodeTypeTest.Builders)allBuilders.get((int)index))), triple.getMiddle(), ((Function)triple.getRight()).apply((Object)((BaseJavaCodeTypeTest.SimpleClassNames)simpleClassNames.get((int)index)))})));
    }

    @Test
    public void testAddContent() {
        EditableJavaMultiLineComment comment = (EditableJavaMultiLineComment)EditableJavaMultiLineComment.builder().build();
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new Object[0]), (Object)comment.getContent());
        comment.addContent("something");
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"something"}), (Object)comment.getContent());
        comment.addContent("something else");
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"something", "something else"}), (Object)comment.getContent());
    }

    @Test
    public void testAddMultiComments() {
        EditableJavaMultiLineComment comment = (EditableJavaMultiLineComment)EditableJavaMultiLineComment.builder().build();
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new Object[0]), (Object)comment.getContent());
        comment.addContent(ListUtil.createList((Object[])new String[]{"something", "something else"}));
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"something", "something else"}), (Object)comment.getContent());
        comment.addContent(ListUtil.createList((Object[])new String[]{"yep", "nope"}));
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"something", "something else", "yep", "nope"}), (Object)comment.getContent());
    }

    @Test
    public void testSetContent() {
        EditableJavaMultiLineComment comment = (EditableJavaMultiLineComment)EditableJavaMultiLineComment.builder().build();
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new Object[0]), (Object)comment.getContent());
        comment.setContent(ListUtil.createList((Object[])new String[]{"something", "something else"}));
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"something", "something else"}), (Object)comment.getContent());
        comment.setContent(ListUtil.createList((Object[])new String[]{"yep", "nope"}));
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"yep", "nope"}), (Object)comment.getContent());
    }
}

