/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.java.comment;

import com.github.tadukoo.java.BaseJavaCodeTypeTest;
import com.github.tadukoo.java.JavaCodeTypes;
import com.github.tadukoo.java.comment.EditableJavaSingleLineComment;
import com.github.tadukoo.java.comment.JavaSingleLineComment;
import com.github.tadukoo.java.comment.JavaSingleLineCommentBuilder;
import com.github.tadukoo.java.comment.UneditableJavaSingleLineComment;
import com.github.tadukoo.util.ListUtil;
import com.github.tadukoo.util.functional.function.Function;
import com.github.tadukoo.util.tuple.Pair;
import com.github.tadukoo.util.tuple.Triple;
import java.util.List;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.provider.Arguments;

public class JavaSingleLineCommentTest
extends BaseJavaCodeTypeTest<JavaSingleLineComment> {
    @Override
    protected Stream<Arguments> getEditableData() {
        return Stream.of(Arguments.of((Object[])new Object[]{UneditableJavaSingleLineComment.builder().build(), false, JavaSingleLineComment::isEditable}), Arguments.of((Object[])new Object[]{EditableJavaSingleLineComment.builder().build(), true, JavaSingleLineComment::isEditable}));
    }

    @Override
    protected Stream<Arguments> getEqualsData() {
        List comparisons = ListUtil.createList((Object[])new Pair[]{Pair.of(builder -> JavaCodeTypes.SINGLE_LINE_COMMENT, builders -> ((JavaSingleLineCommentBuilder)builders.singleLineCommentBuilder().get()).build().getJavaCodeType()), Pair.of(builder -> "", builders -> ((JavaSingleLineCommentBuilder)builders.singleLineCommentBuilder().get()).build().getContent()), Pair.of(builders -> ((JavaSingleLineCommentBuilder)builders.singleLineCommentBuilder().get()).content("something useful").build(), builders -> ((JavaSingleLineCommentBuilder)builders.singleLineCommentBuilder().get()).copy(((JavaSingleLineCommentBuilder)builders.singleLineCommentBuilder().get()).content("something useful").build()).build()), Pair.of(builder -> "something useful", builders -> ((JavaSingleLineCommentBuilder)builders.singleLineCommentBuilder().get()).content("something useful").build().getContent()), Pair.of(builders -> ((JavaSingleLineCommentBuilder)builders.singleLineCommentBuilder().get()).build(), builders -> ((JavaSingleLineCommentBuilder)builders.singleLineCommentBuilder().get()).build()), Pair.of(builders -> ((JavaSingleLineCommentBuilder)builders.singleLineCommentBuilder().get()).content("something useful").build(), builders -> ((JavaSingleLineCommentBuilder)builders.singleLineCommentBuilder().get()).content("something useful").build())});
        return comparisons.stream().flatMap(pair -> Stream.of(0, 1, 2).map(index -> Arguments.of((Object[])new Object[]{((Function)pair.getLeft()).apply((Object)((BaseJavaCodeTypeTest.Builders)allBuilders.get((int)index))), ((Function)pair.getRight()).apply((Object)((BaseJavaCodeTypeTest.Builders)allBuilders.get((int)index)))})));
    }

    @Override
    protected Stream<Arguments> getNotEqualsData() {
        List comparisons = ListUtil.createList((Object[])new Pair[]{Pair.of(builders -> ((JavaSingleLineCommentBuilder)builders.singleLineCommentBuilder().get()).build(), builders -> ((JavaSingleLineCommentBuilder)builders.singleLineCommentBuilder().get()).content("something useful").build()), Pair.of(builders -> ((JavaSingleLineCommentBuilder)builders.singleLineCommentBuilder().get()).content("something else").build(), builders -> ((JavaSingleLineCommentBuilder)builders.singleLineCommentBuilder().get()).content("something useful").build()), Pair.of(builders -> ((JavaSingleLineCommentBuilder)builders.singleLineCommentBuilder().get()).build(), builder -> "testing")});
        return comparisons.stream().flatMap(pair -> Stream.of(0, 1, 2).map(index -> Arguments.of((Object[])new Object[]{((Function)pair.getLeft()).apply((Object)((BaseJavaCodeTypeTest.Builders)allBuilders.get((int)index))), ((Function)pair.getRight()).apply((Object)((BaseJavaCodeTypeTest.Builders)allBuilders.get((int)index)))})));
    }

    @Override
    protected Stream<Arguments> getStringData() {
        List commentMakersAndStrings = ListUtil.createList((Object[])new Triple[]{Triple.of(builders -> ((JavaSingleLineCommentBuilder)builders.singleLineCommentBuilder().get()).build(), (Object)"// ", classNames -> classNames.singleLineCommentSimpleClassName() + ".builder()\n\t\t.content(\"\")\n\t\t.build()"), Triple.of(builders -> ((JavaSingleLineCommentBuilder)builders.singleLineCommentBuilder().get()).content("something useful").build(), (Object)"// something useful", classNames -> classNames.singleLineCommentSimpleClassName() + ".builder()\n\t\t.content(\"something useful\")\n\t\t.build()")});
        return commentMakersAndStrings.stream().flatMap(triple -> Stream.of(0, 1, 2).map(index -> Arguments.of((Object[])new Object[]{((Function)triple.getLeft()).apply((Object)((BaseJavaCodeTypeTest.Builders)allBuilders.get((int)index))), triple.getMiddle(), ((Function)triple.getRight()).apply((Object)((BaseJavaCodeTypeTest.SimpleClassNames)simpleClassNames.get((int)index)))})));
    }

    @Test
    public void testSetContent() {
        EditableJavaSingleLineComment comment = (EditableJavaSingleLineComment)EditableJavaSingleLineComment.builder().build();
        Assertions.assertEquals((Object)"", (Object)comment.getContent());
        comment.setContent("something dumb");
        Assertions.assertEquals((Object)"something dumb", (Object)comment.getContent());
    }
}

