/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.java.field;

import com.github.tadukoo.java.BaseJavaCodeTypeTest;
import com.github.tadukoo.java.JavaCodeTypes;
import com.github.tadukoo.java.JavaType;
import com.github.tadukoo.java.Visibility;
import com.github.tadukoo.java.annotation.EditableJavaAnnotation;
import com.github.tadukoo.java.annotation.JavaAnnotation;
import com.github.tadukoo.java.annotation.JavaAnnotationBuilder;
import com.github.tadukoo.java.annotation.UneditableJavaAnnotation;
import com.github.tadukoo.java.field.EditableJavaField;
import com.github.tadukoo.java.field.JavaField;
import com.github.tadukoo.java.field.JavaFieldBuilder;
import com.github.tadukoo.java.field.UneditableJavaField;
import com.github.tadukoo.java.javadoc.EditableJavadoc;
import com.github.tadukoo.java.javadoc.Javadoc;
import com.github.tadukoo.java.javadoc.JavadocBuilder;
import com.github.tadukoo.java.javadoc.UneditableJavadoc;
import com.github.tadukoo.util.ListUtil;
import com.github.tadukoo.util.functional.function.Function;
import com.github.tadukoo.util.tuple.Pair;
import com.github.tadukoo.util.tuple.Triple;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.provider.Arguments;

public class JavaFieldTest
extends BaseJavaCodeTypeTest<JavaField> {
    @Override
    protected Stream<Arguments> getEditableData() {
        return Stream.of(Arguments.of((Object[])new Object[]{UneditableJavaField.builder().type("int").name("test").build(), false, JavaField::isEditable}), Arguments.of((Object[])new Object[]{EditableJavaField.builder().type("int").name("test").build(), true, JavaField::isEditable}));
    }

    @Override
    protected Stream<Arguments> getEqualsData() {
        List comparisons = ListUtil.createList((Object[])new Pair[]{Pair.of(builders -> JavaCodeTypes.FIELD, builders -> ((JavaFieldBuilder)builders.fieldBuilder().get()).type("int").name("test").build().getJavaCodeType()), Pair.of(builders -> null, builders -> ((JavaFieldBuilder)builders.fieldBuilder().get()).type("int").name("test").build().getJavadoc()), Pair.of(builders -> new ArrayList(), builders -> ((JavaFieldBuilder)builders.fieldBuilder().get()).type("int").name("test").build().getAnnotations()), Pair.of(builders -> Visibility.NONE, builders -> ((JavaFieldBuilder)builders.fieldBuilder().get()).type("int").name("test").build().getVisibility()), Pair.of(builders -> false, builders -> ((JavaFieldBuilder)builders.fieldBuilder().get()).type("int").name("test").build().isStatic()), Pair.of(builders -> false, builders -> ((JavaFieldBuilder)builders.fieldBuilder().get()).type("int").name("test").build().isFinal()), Pair.of(builders -> null, builders -> ((JavaFieldBuilder)builders.fieldBuilder().get()).type("int").name("test").build().getValue()), Pair.of(builders -> ((JavaFieldBuilder)builders.fieldBuilder().get()).javadoc(((JavadocBuilder)builders.javadocBuilder().get()).build()).annotation(((JavaAnnotationBuilder)builders.annotationBuilder().get()).name("Test").build()).visibility(Visibility.PRIVATE).isStatic().isFinal().type("int").name("test").value("42").build(), builders -> ((JavaFieldBuilder)builders.fieldBuilder().get()).copy(((JavaFieldBuilder)builders.fieldBuilder().get()).javadoc(((JavadocBuilder)builders.javadocBuilder().get()).build()).annotation(((JavaAnnotationBuilder)builders.annotationBuilder().get()).name("Test").build()).visibility(Visibility.PRIVATE).isStatic().isFinal().type("int").name("test").value("42").build()).build()), Pair.of(builders -> JavaType.builder().baseType("int").build(), builders -> ((JavaFieldBuilder)builders.fieldBuilder().get()).type(JavaType.builder().baseType("int").build()).name("test").build().getType()), Pair.of(builders -> JavaType.builder().baseType("int").build(), builders -> ((JavaFieldBuilder)builders.fieldBuilder().get()).type("int").name("test").build().getType()), Pair.of(builders -> "test", builders -> ((JavaFieldBuilder)builders.fieldBuilder().get()).type("int").name("test").build().getName()), Pair.of(builders -> ((JavadocBuilder)builders.javadocBuilder().get()).build(), builders -> ((JavaFieldBuilder)builders.fieldBuilder().get()).javadoc(((JavadocBuilder)builders.javadocBuilder().get()).build()).type("int").name("test").build().getJavadoc()), Pair.of(builders -> ListUtil.createList((Object[])new JavaAnnotation[]{((JavaAnnotationBuilder)builders.annotationBuilder().get()).name("Test").build(), ((JavaAnnotationBuilder)builders.annotationBuilder().get()).name("Derp").build()}), builders -> ((JavaFieldBuilder)builders.fieldBuilder().get()).annotations(ListUtil.createList((Object[])new JavaAnnotation[]{((JavaAnnotationBuilder)builders.annotationBuilder().get()).name("Test").build(), ((JavaAnnotationBuilder)builders.annotationBuilder().get()).name("Derp").build()})).type("int").name("test").build().getAnnotations()), Pair.of(builders -> ListUtil.createList((Object[])new JavaAnnotation[]{((JavaAnnotationBuilder)builders.annotationBuilder().get()).name("Test").build()}), builders -> ((JavaFieldBuilder)builders.fieldBuilder().get()).annotation(((JavaAnnotationBuilder)builders.annotationBuilder().get()).name("Test").build()).type("int").name("test").build().getAnnotations()), Pair.of(builders -> Visibility.PUBLIC, builders -> ((JavaFieldBuilder)builders.fieldBuilder().get()).visibility(Visibility.PUBLIC).type("int").name("test").build().getVisibility()), Pair.of(builders -> false, builders -> ((JavaFieldBuilder)builders.fieldBuilder().get()).isStatic(false).type("int").name("test").build().isStatic()), Pair.of(builders -> true, builders -> ((JavaFieldBuilder)builders.fieldBuilder().get()).isStatic(true).type("int").name("test").build().isStatic()), Pair.of(builders -> true, builders -> ((JavaFieldBuilder)builders.fieldBuilder().get()).isStatic().type("int").name("test").build().isStatic()), Pair.of(builders -> false, builders -> ((JavaFieldBuilder)builders.fieldBuilder().get()).isFinal(false).type("int").name("test").build().isFinal()), Pair.of(builders -> true, builders -> ((JavaFieldBuilder)builders.fieldBuilder().get()).isFinal(true).type("int").name("test").build().isFinal()), Pair.of(builders -> true, builders -> ((JavaFieldBuilder)builders.fieldBuilder().get()).isFinal().type("int").name("test").build().isFinal()), Pair.of(builders -> "42", builders -> ((JavaFieldBuilder)builders.fieldBuilder().get()).type("int").name("test").value("42").build().getValue()), Pair.of(builders -> ((JavaFieldBuilder)builders.fieldBuilder().get()).type("int").name("test").javadoc(((JavadocBuilder)builders.javadocBuilder().get()).build()).annotation(((JavaAnnotationBuilder)builders.annotationBuilder().get()).name("Test").build()).annotation(((JavaAnnotationBuilder)builders.annotationBuilder().get()).name("Derp").build()).visibility(Visibility.PRIVATE).isStatic().isFinal().value("42").build(), builders -> ((JavaFieldBuilder)builders.fieldBuilder().get()).type("int").name("test").javadoc(((JavadocBuilder)builders.javadocBuilder().get()).build()).annotation(((JavaAnnotationBuilder)builders.annotationBuilder().get()).name("Test").build()).annotation(((JavaAnnotationBuilder)builders.annotationBuilder().get()).name("Derp").build()).visibility(Visibility.PRIVATE).isStatic().isFinal().value("42").build())});
        return comparisons.stream().flatMap(pair -> Stream.of(0, 1, 2).map(index -> Arguments.of((Object[])new Object[]{((Function)pair.getLeft()).apply((Object)((BaseJavaCodeTypeTest.Builders)allBuilders.get((int)index))), ((Function)pair.getRight()).apply((Object)((BaseJavaCodeTypeTest.Builders)allBuilders.get((int)index)))})));
    }

    @Override
    protected Stream<Arguments> getNotEqualsData() {
        List comparisons = ListUtil.createList((Object[])new Pair[]{Pair.of(builders -> ((JavaFieldBuilder)builders.fieldBuilder().get()).type("int").name("test").javadoc(((JavadocBuilder)builders.javadocBuilder().get()).build()).annotation(((JavaAnnotationBuilder)builders.annotationBuilder().get()).name("Test").build()).annotation(((JavaAnnotationBuilder)builders.annotationBuilder().get()).name("Derp").build()).visibility(Visibility.PRIVATE).isStatic().isFinal().value("42").build(), builders -> ((JavaFieldBuilder)builders.fieldBuilder().get()).type("int").name("test").javadoc(((JavadocBuilder)builders.javadocBuilder().get()).build()).annotation(((JavaAnnotationBuilder)builders.annotationBuilder().get()).name("Test").build()).annotation(((JavaAnnotationBuilder)builders.annotationBuilder().get()).name("Derp").build()).visibility(Visibility.PRIVATE).isStatic().isFinal().value("41").build()), Pair.of(builders -> ((JavaFieldBuilder)builders.fieldBuilder().get()).type("int").name("test").build(), builders -> "testing")});
        return comparisons.stream().flatMap(pair -> Stream.of(0, 1, 2).map(index -> Arguments.of((Object[])new Object[]{((Function)pair.getLeft()).apply((Object)((BaseJavaCodeTypeTest.Builders)allBuilders.get((int)index))), ((Function)pair.getRight()).apply((Object)((BaseJavaCodeTypeTest.Builders)allBuilders.get((int)index)))})));
    }

    @Override
    protected Stream<Arguments> getStringData() {
        List fieldMakersAndStrings = ListUtil.createList((Object[])new Triple[]{Triple.of(builders -> ((JavaFieldBuilder)builders.fieldBuilder().get()).type("int").name("test").build(), (Object)"int test;", classNames -> classNames.fieldSimpleClassName() + ".builder()\n\t\t.type(\"int\").name(\"test\")\n\t\t.build()"), Triple.of(builders -> ((JavaFieldBuilder)builders.fieldBuilder().get()).type("int").name("test").javadoc(((JavadocBuilder)builders.javadocBuilder().get()).build()).build(), (Object)"/**\n */\nint test;", classNames -> classNames.fieldSimpleClassName() + ".builder()\n\t\t.javadoc(" + classNames.javadocSimpleClassName() + ".builder()\n\t\t\t\t.build())\n\t\t.type(\"int\").name(\"test\")\n\t\t.build()"), Triple.of(builders -> ((JavaFieldBuilder)builders.fieldBuilder().get()).type("int").name("test").annotation(((JavaAnnotationBuilder)builders.annotationBuilder().get()).name("Test").build()).build(), (Object)"@Test\nint test;", classNames -> classNames.fieldSimpleClassName() + ".builder()\n\t\t.annotation(" + classNames.annotationSimpleClassName() + ".builder()\n\t\t\t\t.name(\"Test\")\n\t\t\t\t.build())\n\t\t.type(\"int\").name(\"test\")\n\t\t.build()"), Triple.of(builders -> ((JavaFieldBuilder)builders.fieldBuilder().get()).type("int").name("test").annotation(((JavaAnnotationBuilder)builders.annotationBuilder().get()).name("Test").build()).annotation(((JavaAnnotationBuilder)builders.annotationBuilder().get()).name("Derp").build()).build(), (Object)"@Test\n@Derp\nint test;", classNames -> classNames.fieldSimpleClassName() + ".builder()\n\t\t.annotation(" + classNames.annotationSimpleClassName() + ".builder()\n\t\t\t\t.name(\"Test\")\n\t\t\t\t.build())\n\t\t.annotation(" + classNames.annotationSimpleClassName() + ".builder()\n\t\t\t\t.name(\"Derp\")\n\t\t\t\t.build())\n\t\t.type(\"int\").name(\"test\")\n\t\t.build()"), Triple.of(builders -> ((JavaFieldBuilder)builders.fieldBuilder().get()).visibility(Visibility.PRIVATE).type("int").name("test").build(), (Object)"private int test;", classNames -> classNames.fieldSimpleClassName() + ".builder()\n\t\t.visibility(Visibility.PRIVATE)\n\t\t.type(\"int\").name(\"test\")\n\t\t.build()"), Triple.of(builders -> ((JavaFieldBuilder)builders.fieldBuilder().get()).isStatic().type("int").name("test").build(), (Object)"static int test;", classNames -> classNames.fieldSimpleClassName() + ".builder()\n\t\t.isStatic()\n\t\t.type(\"int\").name(\"test\")\n\t\t.build()"), Triple.of(builders -> ((JavaFieldBuilder)builders.fieldBuilder().get()).isFinal().type("int").name("test").build(), (Object)"final int test;", classNames -> classNames.fieldSimpleClassName() + ".builder()\n\t\t.isFinal()\n\t\t.type(\"int\").name(\"test\")\n\t\t.build()"), Triple.of(builders -> ((JavaFieldBuilder)builders.fieldBuilder().get()).type("int").name("test").value("42").build(), (Object)"int test = 42;", classNames -> classNames.fieldSimpleClassName() + ".builder()\n\t\t.type(\"int\").name(\"test\")\n\t\t.value(\"42\")\n\t\t.build()"), Triple.of(builders -> ((JavaFieldBuilder)builders.fieldBuilder().get()).type("int").name("test").javadoc(((JavadocBuilder)builders.javadocBuilder().get()).build()).annotation(((JavaAnnotationBuilder)builders.annotationBuilder().get()).name("Test").build()).annotation(((JavaAnnotationBuilder)builders.annotationBuilder().get()).name("Derp").build()).visibility(Visibility.PRIVATE).isStatic().isFinal().value("42").build(), (Object)"/**\n */\n@Test\n@Derp\nprivate static final int test = 42;", classNames -> classNames.fieldSimpleClassName() + ".builder()\n\t\t.javadoc(" + classNames.javadocSimpleClassName() + ".builder()\n\t\t\t\t.build())\n\t\t.annotation(" + classNames.annotationSimpleClassName() + ".builder()\n\t\t\t\t.name(\"Test\")\n\t\t\t\t.build())\n\t\t.annotation(" + classNames.annotationSimpleClassName() + ".builder()\n\t\t\t\t.name(\"Derp\")\n\t\t\t\t.build())\n\t\t.visibility(Visibility.PRIVATE)\n\t\t.isStatic()\n\t\t.isFinal()\n\t\t.type(\"int\").name(\"test\")\n\t\t.value(\"42\")\n\t\t.build()")});
        return fieldMakersAndStrings.stream().flatMap(triple -> Stream.of(0, 1, 2).map(index -> Arguments.of((Object[])new Object[]{((Function)triple.getLeft()).apply((Object)((BaseJavaCodeTypeTest.Builders)allBuilders.get((int)index))), triple.getMiddle(), ((Function)triple.getRight()).apply((Object)((BaseJavaCodeTypeTest.SimpleClassNames)simpleClassNames.get((int)index)))})));
    }

    @Override
    protected Stream<Arguments> getBuilderErrorData() {
        List builderFuncsAndErrorMessages = ListUtil.createList((Object[])new Pair[]{Pair.of(builders -> () -> ((JavaFieldBuilder)builders.fieldBuilder().get()).type("int").name("test").visibility(null).build(), (Object)"Visibility is required!"), Pair.of(builders -> () -> ((JavaFieldBuilder)builders.fieldBuilder().get()).name("test").build(), (Object)"Must specify type!"), Pair.of(builders -> () -> ((JavaFieldBuilder)builders.fieldBuilder().get()).type("int").build(), (Object)"Must specify name!"), Pair.of(builders -> () -> ((JavaFieldBuilder)builders.fieldBuilder().get()).visibility(null).build(), (Object)"Visibility is required!\nMust specify type!\nMust specify name!")});
        List editableRelatedErrors = ListUtil.createList((Object[])new Pair[]{Pair.of(() -> UneditableJavaField.builder().type("int").name("test").javadoc(EditableJavadoc.builder().build()).build(), (Object)"javadoc is not uneditable in this uneditable JavaField"), Pair.of(() -> UneditableJavaField.builder().type("int").name("test").annotation(EditableJavaAnnotation.builder().name("Test").build()).build(), (Object)"some annotations are not uneditable in this uneditable JavaField"), Pair.of(() -> UneditableJavaField.builder().type("int").name("test").javadoc(EditableJavadoc.builder().build()).annotation(EditableJavaAnnotation.builder().name("Test").build()).build(), (Object)"javadoc is not uneditable in this uneditable JavaField\nsome annotations are not uneditable in this uneditable JavaField"), Pair.of(() -> EditableJavaField.builder().type("int").name("test").javadoc(UneditableJavadoc.builder().build()).build(), (Object)"javadoc is not editable in this editable JavaField"), Pair.of(() -> EditableJavaField.builder().type("int").name("test").annotation(UneditableJavaAnnotation.builder().name("Test").build()).build(), (Object)"some annotations are not editable in this editable JavaField"), Pair.of(() -> EditableJavaField.builder().type("int").name("test").javadoc(UneditableJavadoc.builder().build()).annotation(UneditableJavaAnnotation.builder().name("Test").build()).build(), (Object)"javadoc is not editable in this editable JavaField\nsome annotations are not editable in this editable JavaField")});
        return Stream.concat(builderFuncsAndErrorMessages.stream().flatMap(pair -> Stream.of(0, 1, 2).map(index -> Arguments.of((Object[])new Object[]{((Function)pair.getLeft()).apply((Object)((BaseJavaCodeTypeTest.Builders)allBuilders.get((int)index))), pair.getRight()}))), editableRelatedErrors.stream().map(pair -> Arguments.of((Object[])new Object[]{pair.getLeft(), pair.getRight()})));
    }

    @Test
    public void testSetJavadoc() {
        EditableJavaField field = (EditableJavaField)EditableJavaField.builder().type("int").name("test").build();
        Javadoc doc1 = EditableJavadoc.builder().build();
        Javadoc doc2 = EditableJavadoc.builder().author("Me").build();
        Assertions.assertNull((Object)field.getJavadoc());
        field.setJavadoc(doc1);
        Assertions.assertEquals((Object)doc1, (Object)field.getJavadoc());
        field.setJavadoc(doc2);
        Assertions.assertEquals((Object)doc2, (Object)field.getJavadoc());
    }

    @Test
    public void testSetJavadocNotEditable() {
        try {
            EditableJavaField field = (EditableJavaField)EditableJavaField.builder().type("int").name("test").build();
            Javadoc doc = UneditableJavadoc.builder().build();
            field.setJavadoc(doc);
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"editable JavaField requires an editable Javadoc", (Object)e.getMessage());
        }
    }

    @Test
    public void testAddAnnotation() {
        EditableJavaField field = (EditableJavaField)EditableJavaField.builder().type("int").name("test").build();
        JavaAnnotation test = EditableJavaAnnotation.builder().name("Test").build();
        JavaAnnotation derp = EditableJavaAnnotation.builder().name("Derp").build();
        Assertions.assertEquals(new ArrayList(), (Object)field.getAnnotations());
        field.addAnnotation(test);
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new JavaAnnotation[]{test}), (Object)field.getAnnotations());
        field.addAnnotation(derp);
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new JavaAnnotation[]{test, derp}), (Object)field.getAnnotations());
    }

    @Test
    public void testAddAnnotationNotEditable() {
        try {
            EditableJavaField field = (EditableJavaField)EditableJavaField.builder().type("int").name("test").build();
            JavaAnnotation test = UneditableJavaAnnotation.builder().name("Test").build();
            field.addAnnotation(test);
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"editable JavaField requires editable Java Annotations", (Object)e.getMessage());
        }
    }

    @Test
    public void testAddAnnotations() {
        EditableJavaField field = (EditableJavaField)EditableJavaField.builder().type("int").name("test").build();
        JavaAnnotation test = EditableJavaAnnotation.builder().name("Test").build();
        JavaAnnotation derp = EditableJavaAnnotation.builder().name("Derp").build();
        JavaAnnotation blah = EditableJavaAnnotation.builder().name("Blah").build();
        JavaAnnotation yep = EditableJavaAnnotation.builder().name("yep").build();
        Assertions.assertEquals(new ArrayList(), (Object)field.getAnnotations());
        field.addAnnotations(ListUtil.createList((Object[])new JavaAnnotation[]{test, derp}));
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new JavaAnnotation[]{test, derp}), (Object)field.getAnnotations());
        field.addAnnotations(ListUtil.createList((Object[])new JavaAnnotation[]{blah, yep}));
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new JavaAnnotation[]{test, derp, blah, yep}), (Object)field.getAnnotations());
    }

    @Test
    public void testAddAnnotationsNotEditable() {
        try {
            EditableJavaField field = (EditableJavaField)EditableJavaField.builder().type("int").name("test").build();
            JavaAnnotation test = EditableJavaAnnotation.builder().name("Test").build();
            JavaAnnotation derp = UneditableJavaAnnotation.builder().name("Derp").build();
            field.addAnnotations(ListUtil.createList((Object[])new JavaAnnotation[]{test, derp}));
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"editable JavaField requires editable Java Annotations", (Object)e.getMessage());
        }
    }

    @Test
    public void testSetAnnotations() {
        EditableJavaField field = (EditableJavaField)EditableJavaField.builder().type("int").name("test").build();
        JavaAnnotation test = EditableJavaAnnotation.builder().name("Test").build();
        JavaAnnotation derp = EditableJavaAnnotation.builder().name("Derp").build();
        JavaAnnotation blah = EditableJavaAnnotation.builder().name("Blah").build();
        JavaAnnotation yep = EditableJavaAnnotation.builder().name("yep").build();
        Assertions.assertEquals(new ArrayList(), (Object)field.getAnnotations());
        field.setAnnotations(ListUtil.createList((Object[])new JavaAnnotation[]{test, derp}));
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new JavaAnnotation[]{test, derp}), (Object)field.getAnnotations());
        field.setAnnotations(ListUtil.createList((Object[])new JavaAnnotation[]{blah, yep}));
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new JavaAnnotation[]{blah, yep}), (Object)field.getAnnotations());
    }

    @Test
    public void testSetAnnotationsNotEditable() {
        try {
            EditableJavaField field = (EditableJavaField)EditableJavaField.builder().type("int").name("test").build();
            JavaAnnotation test = EditableJavaAnnotation.builder().name("Test").build();
            JavaAnnotation derp = UneditableJavaAnnotation.builder().name("Derp").build();
            field.setAnnotations(ListUtil.createList((Object[])new JavaAnnotation[]{test, derp}));
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"editable JavaField requires editable Java Annotations", (Object)e.getMessage());
        }
    }

    @Test
    public void testSetVisibility() {
        EditableJavaField field = (EditableJavaField)EditableJavaField.builder().type("int").name("test").build();
        Assertions.assertEquals((Object)Visibility.NONE, (Object)field.getVisibility());
        field.setVisibility(Visibility.PUBLIC);
        Assertions.assertEquals((Object)Visibility.PUBLIC, (Object)field.getVisibility());
    }

    @Test
    public void testSetStatic() {
        EditableJavaField field = (EditableJavaField)EditableJavaField.builder().type("int").name("test").build();
        Assertions.assertFalse((boolean)field.isStatic());
        field.setStatic(true);
        Assertions.assertTrue((boolean)field.isStatic());
        field.setStatic(true);
        Assertions.assertTrue((boolean)field.isStatic());
    }

    @Test
    public void testSetFinal() {
        EditableJavaField field = (EditableJavaField)EditableJavaField.builder().type("int").name("test").build();
        Assertions.assertFalse((boolean)field.isFinal());
        field.setFinal(true);
        Assertions.assertTrue((boolean)field.isFinal());
        field.setFinal(true);
        Assertions.assertTrue((boolean)field.isFinal());
    }

    @Test
    public void testSetType() {
        EditableJavaField field = (EditableJavaField)EditableJavaField.builder().type("int").name("test").build();
        Assertions.assertEquals((Object)JavaType.builder().baseType("int").build(), (Object)field.getType());
        field.setType(JavaType.builder().baseType("String").build());
        Assertions.assertEquals((Object)JavaType.builder().baseType("String").build(), (Object)field.getType());
        field.setType(JavaType.builder().baseType("double").build());
        Assertions.assertEquals((Object)JavaType.builder().baseType("double").build(), (Object)field.getType());
    }

    @Test
    public void testSetTypeByText() {
        EditableJavaField field = (EditableJavaField)EditableJavaField.builder().type("int").name("test").build();
        Assertions.assertEquals((Object)JavaType.builder().baseType("int").build(), (Object)field.getType());
        field.setType("String");
        Assertions.assertEquals((Object)JavaType.builder().baseType("String").build(), (Object)field.getType());
        field.setType("double");
        Assertions.assertEquals((Object)JavaType.builder().baseType("double").build(), (Object)field.getType());
    }

    @Test
    public void testSetName() {
        EditableJavaField field = (EditableJavaField)EditableJavaField.builder().type("int").name("test").build();
        Assertions.assertEquals((Object)"test", (Object)field.getName());
        field.setName("derp");
        Assertions.assertEquals((Object)"derp", (Object)field.getName());
        field.setName("blah");
        Assertions.assertEquals((Object)"blah", (Object)field.getName());
    }

    @Test
    public void testSetValue() {
        EditableJavaField field = (EditableJavaField)EditableJavaField.builder().type("int").name("test").build();
        Assertions.assertNull((Object)field.getValue());
        field.setValue("42");
        Assertions.assertEquals((Object)"42", (Object)field.getValue());
        field.setValue("27");
        Assertions.assertEquals((Object)"27", (Object)field.getValue());
    }
}

