/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.java.importstatement;

import com.github.tadukoo.java.BaseJavaCodeTypeTest;
import com.github.tadukoo.java.JavaCodeTypes;
import com.github.tadukoo.java.importstatement.EditableJavaImportStatement;
import com.github.tadukoo.java.importstatement.JavaImportStatement;
import com.github.tadukoo.java.importstatement.JavaImportStatementBuilder;
import com.github.tadukoo.java.importstatement.UneditableJavaImportStatement;
import com.github.tadukoo.util.ListUtil;
import com.github.tadukoo.util.functional.function.Function;
import com.github.tadukoo.util.tuple.Pair;
import com.github.tadukoo.util.tuple.Triple;
import java.util.List;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.provider.Arguments;

public class JavaImportStatementTest
extends BaseJavaCodeTypeTest<JavaImportStatement> {
    @Override
    protected Stream<Arguments> getEditableData() {
        return Stream.of(Arguments.of((Object[])new Object[]{UneditableJavaImportStatement.builder().importName("com.example").build(), false, JavaImportStatement::isEditable}), Arguments.of((Object[])new Object[]{EditableJavaImportStatement.builder().importName("com.example").build(), true, JavaImportStatement::isEditable}));
    }

    @Override
    protected Stream<Arguments> getEqualsData() {
        List comparisons = ListUtil.createList((Object[])new Pair[]{Pair.of(builder -> JavaCodeTypes.IMPORT_STATEMENT, builders -> ((JavaImportStatementBuilder)builders.importStatementBuilder().get()).importName("com.example").build().getJavaCodeType()), Pair.of(builders -> ((JavaImportStatementBuilder)builders.importStatementBuilder().get()).isStatic().importName("com.example").build(), builders -> ((JavaImportStatementBuilder)builders.importStatementBuilder().get()).copy(((JavaImportStatementBuilder)builders.importStatementBuilder().get()).isStatic().importName("com.example").build()).build()), Pair.of(builder -> "com.example", builders -> ((JavaImportStatementBuilder)builders.importStatementBuilder().get()).importName("com.example").build().getImportName()), Pair.of(builder -> false, builders -> ((JavaImportStatementBuilder)builders.importStatementBuilder().get()).importName("com.example").build().isStatic()), Pair.of(builder -> true, builders -> ((JavaImportStatementBuilder)builders.importStatementBuilder().get()).importName("com.example").isStatic().build().isStatic()), Pair.of(builder -> true, builders -> ((JavaImportStatementBuilder)builders.importStatementBuilder().get()).importName("com.example").isStatic(true).build().isStatic()), Pair.of(builders -> ((JavaImportStatementBuilder)builders.importStatementBuilder().get()).importName("com.example").isStatic().build(), builders -> ((JavaImportStatementBuilder)builders.importStatementBuilder().get()).importName("com.example").isStatic().build())});
        return comparisons.stream().flatMap(pair -> Stream.of(0, 1, 2).map(index -> Arguments.of((Object[])new Object[]{((Function)pair.getLeft()).apply((Object)((BaseJavaCodeTypeTest.Builders)allBuilders.get((int)index))), ((Function)pair.getRight()).apply((Object)((BaseJavaCodeTypeTest.Builders)allBuilders.get((int)index)))})));
    }

    @Override
    protected Stream<Arguments> getNotEqualsData() {
        List comparisons = ListUtil.createList((Object[])new Pair[]{Pair.of(builders -> ((JavaImportStatementBuilder)builders.importStatementBuilder().get()).importName("com.example").build(), builders -> ((JavaImportStatementBuilder)builders.importStatementBuilder().get()).importName("com.example").isStatic().build()), Pair.of(builders -> ((JavaImportStatementBuilder)builders.importStatementBuilder().get()).importName("com.example").build(), builder -> "testing")});
        return comparisons.stream().flatMap(pair -> Stream.of(0, 1, 2).map(index -> Arguments.of((Object[])new Object[]{((Function)pair.getLeft()).apply((Object)((BaseJavaCodeTypeTest.Builders)allBuilders.get((int)index))), ((Function)pair.getRight()).apply((Object)((BaseJavaCodeTypeTest.Builders)allBuilders.get((int)index)))})));
    }

    @Override
    protected Stream<Arguments> getStringData() {
        List commentMakersAndStrings = ListUtil.createList((Object[])new Triple[]{Triple.of(builders -> ((JavaImportStatementBuilder)builders.importStatementBuilder().get()).importName("com.example").build(), (Object)"import com.example;", classNames -> classNames.importStatementSimpleClassName() + ".builder()\n\t\t.importName(\"com.example\")\n\t\t.build()"), Triple.of(builders -> ((JavaImportStatementBuilder)builders.importStatementBuilder().get()).importName("com.example").isStatic().build(), (Object)"import static com.example;", classNames -> classNames.importStatementSimpleClassName() + ".builder()\n\t\t.isStatic()\n\t\t.importName(\"com.example\")\n\t\t.build()")});
        return commentMakersAndStrings.stream().flatMap(triple -> Stream.of(0, 1, 2).map(index -> Arguments.of((Object[])new Object[]{((Function)triple.getLeft()).apply((Object)((BaseJavaCodeTypeTest.Builders)allBuilders.get((int)index))), triple.getMiddle(), ((Function)triple.getRight()).apply((Object)((BaseJavaCodeTypeTest.SimpleClassNames)simpleClassNames.get((int)index)))})));
    }

    @Override
    protected Stream<Arguments> getBuilderErrorData() {
        List builderFuncsAndErrorMessages = ListUtil.createList((Object[])new Pair[]{Pair.of(builders -> () -> ((JavaImportStatementBuilder)builders.importStatementBuilder().get()).build(), (Object)"importName is required!")});
        return builderFuncsAndErrorMessages.stream().flatMap(pair -> Stream.of(0, 1, 2).map(index -> Arguments.of((Object[])new Object[]{((Function)pair.getLeft()).apply((Object)((BaseJavaCodeTypeTest.Builders)allBuilders.get((int)index))), pair.getRight()})));
    }

    @Test
    public void testSetStatic() {
        EditableJavaImportStatement importStatement = (EditableJavaImportStatement)EditableJavaImportStatement.builder().importName("com.example").build();
        Assertions.assertFalse((boolean)importStatement.isStatic());
        importStatement.setStatic(false);
        Assertions.assertFalse((boolean)importStatement.isStatic());
        importStatement.setStatic(true);
        Assertions.assertTrue((boolean)importStatement.isStatic());
    }

    @Test
    public void testSetImportName() {
        EditableJavaImportStatement importStatement = (EditableJavaImportStatement)EditableJavaImportStatement.builder().importName("com.example").build();
        Assertions.assertEquals((Object)"com.example", (Object)importStatement.getImportName());
        importStatement.setImportName("org.help.me");
        Assertions.assertEquals((Object)"org.help.me", (Object)importStatement.getImportName());
    }
}

