/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.java.javadoc;

import com.github.tadukoo.java.BaseJavaCodeTypeTest;
import com.github.tadukoo.java.JavaCodeTypes;
import com.github.tadukoo.java.javadoc.EditableJavadoc;
import com.github.tadukoo.java.javadoc.Javadoc;
import com.github.tadukoo.java.javadoc.JavadocBuilder;
import com.github.tadukoo.java.javadoc.UneditableJavadoc;
import com.github.tadukoo.util.ListUtil;
import com.github.tadukoo.util.functional.function.Function;
import com.github.tadukoo.util.tuple.Pair;
import com.github.tadukoo.util.tuple.Triple;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.provider.Arguments;

public class JavadocTest
extends BaseJavaCodeTypeTest<Javadoc> {
    @Override
    protected Stream<Arguments> getEditableData() {
        return Stream.of(Arguments.of((Object[])new Object[]{UneditableJavadoc.builder().build(), false, Javadoc::isEditable}), Arguments.of((Object[])new Object[]{EditableJavadoc.builder().build(), true, Javadoc::isEditable}));
    }

    @Override
    protected Stream<Arguments> getEqualsData() {
        List comparisons = ListUtil.createList((Object[])new Pair[]{Pair.of(builder -> JavaCodeTypes.JAVADOC, builders -> ((JavadocBuilder)builders.javadocBuilder().get()).build().getJavaCodeType()), Pair.of(builder -> false, builders -> ((JavadocBuilder)builders.javadocBuilder().get()).build().isCondensed()), Pair.of(builder -> new ArrayList(), builders -> ((JavadocBuilder)builders.javadocBuilder().get()).build().getContent()), Pair.of(builder -> null, builders -> ((JavadocBuilder)builders.javadocBuilder().get()).build().getAuthor()), Pair.of(builder -> null, builders -> ((JavadocBuilder)builders.javadocBuilder().get()).build().getVersion()), Pair.of(builder -> null, builders -> ((JavadocBuilder)builders.javadocBuilder().get()).build().getSince()), Pair.of(builder -> new ArrayList(), builders -> ((JavadocBuilder)builders.javadocBuilder().get()).build().getParams()), Pair.of(builder -> null, builders -> ((JavadocBuilder)builders.javadocBuilder().get()).build().getReturnVal()), Pair.of(builder -> new ArrayList(), builders -> ((JavadocBuilder)builders.javadocBuilder().get()).build().getThrowsInfos()), Pair.of(builders -> ((JavadocBuilder)builders.javadocBuilder().get()).condensed().content("Some information").content("Some more information").author("Logan Ferree (Tadukoo)").version("Beta v.0.5").since("Alpha v.0.1").param("something", "Does something").returnVal("yep").throwsInfo("Exception", "because I can").build(), builders -> ((JavadocBuilder)builders.javadocBuilder().get()).copy(((JavadocBuilder)builders.javadocBuilder().get()).condensed().content("Some information").content("Some more information").author("Logan Ferree (Tadukoo)").version("Beta v.0.5").since("Alpha v.0.1").param("something", "Does something").returnVal("yep").throwsInfo("Exception", "because I can").build()).build()), Pair.of(builder -> true, builders -> ((JavadocBuilder)builders.javadocBuilder().get()).condensed(true).build().isCondensed()), Pair.of(builder -> true, builders -> ((JavadocBuilder)builders.javadocBuilder().get()).condensed().build().isCondensed()), Pair.of(builder -> ListUtil.createList((Object[])new String[]{"test", "derp"}), builders -> ((JavadocBuilder)builders.javadocBuilder().get()).content(ListUtil.createList((Object[])new String[]{"test", "derp"})).build().getContent()), Pair.of(builder -> ListUtil.createList((Object[])new String[]{"test"}), builders -> ((JavadocBuilder)builders.javadocBuilder().get()).content("test").build().getContent()), Pair.of(builder -> "Logan Ferree (Tadukoo)", builders -> ((JavadocBuilder)builders.javadocBuilder().get()).author("Logan Ferree (Tadukoo)").build().getAuthor()), Pair.of(builder -> "Alpha v.0.1", builders -> ((JavadocBuilder)builders.javadocBuilder().get()).version("Alpha v.0.1").build().getVersion()), Pair.of(builder -> "Alpha v.0.0.1", builders -> ((JavadocBuilder)builders.javadocBuilder().get()).since("Alpha v.0.0.1").build().getSince()), Pair.of(builder -> ListUtil.createList((Object[])new Pair[]{Pair.of((Object)"test", (Object)"yes"), Pair.of((Object)"derp", (Object)"no")}), builders -> ((JavadocBuilder)builders.javadocBuilder().get()).params(ListUtil.createList((Object[])new Pair[]{Pair.of((Object)"test", (Object)"yes"), Pair.of((Object)"derp", (Object)"no")})).build().getParams()), Pair.of(builder -> ListUtil.createList((Object[])new Pair[]{Pair.of((Object)"test", (Object)"yes")}), builders -> ((JavadocBuilder)builders.javadocBuilder().get()).param(Pair.of((Object)"test", (Object)"yes")).build().getParams()), Pair.of(builder -> ListUtil.createList((Object[])new Pair[]{Pair.of((Object)"test", (Object)"yes")}), builders -> ((JavadocBuilder)builders.javadocBuilder().get()).param("test", "yes").build().getParams()), Pair.of(builder -> "this, to continue building", builders -> ((JavadocBuilder)builders.javadocBuilder().get()).returnVal("this, to continue building").build().getReturnVal()), Pair.of(builder -> ListUtil.createList((Object[])new Pair[]{Pair.of((Object)"Exception", (Object)"Because I can"), Pair.of((Object)"Throwable", (Object)"Because I want to")}), builders -> ((JavadocBuilder)builders.javadocBuilder().get()).throwsInfos(ListUtil.createList((Object[])new Pair[]{Pair.of((Object)"Exception", (Object)"Because I can"), Pair.of((Object)"Throwable", (Object)"Because I want to")})).build().getThrowsInfos()), Pair.of(builder -> ListUtil.createList((Object[])new Pair[]{Pair.of((Object)"Exception", (Object)"Because I can")}), builders -> ((JavadocBuilder)builders.javadocBuilder().get()).throwsInfo(Pair.of((Object)"Exception", (Object)"Because I can")).build().getThrowsInfos()), Pair.of(builder -> ListUtil.createList((Object[])new Pair[]{Pair.of((Object)"Exception", (Object)"Because I can")}), builders -> ((JavadocBuilder)builders.javadocBuilder().get()).throwsInfo("Exception", "Because I can").build().getThrowsInfos()), Pair.of(builders -> ((JavadocBuilder)builders.javadocBuilder().get()).content("test").content("derp").author("Logan Ferree (Tadukoo)").version("Alpha v.0.1").since("Alpha v.0.0.1").param("test", "yes").param("derp", "no").returnVal("this, to continue building").throwsInfo("Exception", "Because I can").build(), builders -> ((JavadocBuilder)builders.javadocBuilder().get()).content("test").content("derp").author("Logan Ferree (Tadukoo)").version("Alpha v.0.1").since("Alpha v.0.0.1").param("test", "yes").param("derp", "no").returnVal("this, to continue building").throwsInfo("Exception", "Because I can").build())});
        return comparisons.stream().flatMap(pair -> Stream.of(0, 1, 2).map(index -> Arguments.of((Object[])new Object[]{((Function)pair.getLeft()).apply((Object)((BaseJavaCodeTypeTest.Builders)allBuilders.get((int)index))), ((Function)pair.getRight()).apply((Object)((BaseJavaCodeTypeTest.Builders)allBuilders.get((int)index)))})));
    }

    @Override
    protected Stream<Arguments> getNotEqualsData() {
        List comparisons = ListUtil.createList((Object[])new Pair[]{Pair.of(builders -> ((JavadocBuilder)builders.javadocBuilder().get()).content("tes").content("derp").author("Logan Ferree (Tadukoo)").version("Alpha v.0.1").since("Alpha v.0.0.1").param("test", "yes").param("derp", "no").returnVal("this, to continue building").build(), builders -> ((JavadocBuilder)builders.javadocBuilder().get()).content("test").content("derp").author("Logan Ferree (Tadukoo)").version("Alpha v.0.1").since("Alpha v.0.0.1").param("test", "yes").param("derp", "no").returnVal("this, to continue building").build()), Pair.of(builders -> ((JavadocBuilder)builders.javadocBuilder().get()).build(), builder -> "test")});
        return comparisons.stream().flatMap(pair -> Stream.of(0, 1, 2).map(index -> Arguments.of((Object[])new Object[]{((Function)pair.getLeft()).apply((Object)((BaseJavaCodeTypeTest.Builders)allBuilders.get((int)index))), ((Function)pair.getRight()).apply((Object)((BaseJavaCodeTypeTest.Builders)allBuilders.get((int)index)))})));
    }

    @Override
    protected Stream<Arguments> getStringData() {
        List commentMakersAndStrings = ListUtil.createList((Object[])new Triple[]{Triple.of(builders -> ((JavadocBuilder)builders.javadocBuilder().get()).build(), (Object)"/**\n */", classNames -> classNames.javadocSimpleClassName() + ".builder()\n\t\t.build()"), Triple.of(builders -> ((JavadocBuilder)builders.javadocBuilder().get()).content("test").content("derp").build(), (Object)"/**\n * test\n * derp\n */", classNames -> classNames.javadocSimpleClassName() + ".builder()\n\t\t.content(\"test\")\n\t\t.content(\"derp\")\n\t\t.build()"), Triple.of(builders -> ((JavadocBuilder)builders.javadocBuilder().get()).author("Logan Ferree (Tadukoo)").build(), (Object)"/**\n * @author Logan Ferree (Tadukoo)\n */", classNames -> classNames.javadocSimpleClassName() + ".builder()\n\t\t.author(\"Logan Ferree (Tadukoo)\")\n\t\t.build()"), Triple.of(builders -> ((JavadocBuilder)builders.javadocBuilder().get()).version("Alpha v.0.1").build(), (Object)"/**\n * @version Alpha v.0.1\n */", classNames -> classNames.javadocSimpleClassName() + ".builder()\n\t\t.version(\"Alpha v.0.1\")\n\t\t.build()"), Triple.of(builders -> ((JavadocBuilder)builders.javadocBuilder().get()).since("Alpha v.0.0.1").build(), (Object)"/**\n * @since Alpha v.0.0.1\n */", classNames -> classNames.javadocSimpleClassName() + ".builder()\n\t\t.since(\"Alpha v.0.0.1\")\n\t\t.build()"), Triple.of(builders -> ((JavadocBuilder)builders.javadocBuilder().get()).param("test", "yes").build(), (Object)"/**\n * @param test yes\n */", classNames -> classNames.javadocSimpleClassName() + ".builder()\n\t\t.param(\"test\", \"yes\")\n\t\t.build()"), Triple.of(builders -> ((JavadocBuilder)builders.javadocBuilder().get()).param("test", "yes").param("derp", "no").build(), (Object)"/**\n * @param test yes\n * @param derp no\n */", classNames -> classNames.javadocSimpleClassName() + ".builder()\n\t\t.param(\"test\", \"yes\")\n\t\t.param(\"derp\", \"no\")\n\t\t.build()"), Triple.of(builders -> ((JavadocBuilder)builders.javadocBuilder().get()).returnVal("this, to continue building").build(), (Object)"/**\n * @return this, to continue building\n */", classNames -> classNames.javadocSimpleClassName() + ".builder()\n\t\t.returnVal(\"this, to continue building\")\n\t\t.build()"), Triple.of(builders -> ((JavadocBuilder)builders.javadocBuilder().get()).throwsInfo("Exception", "Because I can").build(), (Object)"/**\n * @throws Exception Because I can\n */", classNames -> classNames.javadocSimpleClassName() + ".builder()\n\t\t.throwsInfo(\"Exception\", \"Because I can\")\n\t\t.build()"), Triple.of(builders -> ((JavadocBuilder)builders.javadocBuilder().get()).throwsInfo("Exception", "Because I can").throwsInfo("Throwable", "Because I want to").build(), (Object)"/**\n * @throws Exception Because I can\n * @throws Throwable Because I want to\n */", classNames -> classNames.javadocSimpleClassName() + ".builder()\n\t\t.throwsInfo(\"Exception\", \"Because I can\")\n\t\t.throwsInfo(\"Throwable\", \"Because I want to\")\n\t\t.build()"), Triple.of(builders -> ((JavadocBuilder)builders.javadocBuilder().get()).content("test").content("derp").author("Logan Ferree (Tadukoo)").version("Alpha v.0.1").since("Alpha v.0.0.1").param("test", "yes").param("derp", "no").returnVal("this, to continue building").throwsInfo("Exception", "Because I can").throwsInfo("Throwable", "Because I want to").build(), (Object)"/**\n * test\n * derp\n * \n * @author Logan Ferree (Tadukoo)\n * @version Alpha v.0.1\n * @since Alpha v.0.0.1\n * \n * @param test yes\n * @param derp no\n * @return this, to continue building\n * @throws Exception Because I can\n * @throws Throwable Because I want to\n */", classNames -> classNames.javadocSimpleClassName() + ".builder()\n\t\t.content(\"test\")\n\t\t.content(\"derp\")\n\t\t.author(\"Logan Ferree (Tadukoo)\")\n\t\t.version(\"Alpha v.0.1\")\n\t\t.since(\"Alpha v.0.0.1\")\n\t\t.param(\"test\", \"yes\")\n\t\t.param(\"derp\", \"no\")\n\t\t.returnVal(\"this, to continue building\")\n\t\t.throwsInfo(\"Exception\", \"Because I can\")\n\t\t.throwsInfo(\"Throwable\", \"Because I want to\")\n\t\t.build()"), Triple.of(builders -> ((JavadocBuilder)builders.javadocBuilder().get()).condensed().build(), (Object)"/** */", classNames -> classNames.javadocSimpleClassName() + ".builder()\n\t\t.condensed()\n\t\t.build()"), Triple.of(builders -> ((JavadocBuilder)builders.javadocBuilder().get()).condensed().content("test").content("derp").build(), (Object)"/** test\n * derp */", classNames -> classNames.javadocSimpleClassName() + ".builder()\n\t\t.condensed()\n\t\t.content(\"test\")\n\t\t.content(\"derp\")\n\t\t.build()"), Triple.of(builders -> ((JavadocBuilder)builders.javadocBuilder().get()).condensed().author("Logan Ferree (Tadukoo)").build(), (Object)"/** @author Logan Ferree (Tadukoo) */", classNames -> classNames.javadocSimpleClassName() + ".builder()\n\t\t.condensed()\n\t\t.author(\"Logan Ferree (Tadukoo)\")\n\t\t.build()"), Triple.of(builders -> ((JavadocBuilder)builders.javadocBuilder().get()).condensed().version("Alpha v.0.1").build(), (Object)"/** @version Alpha v.0.1 */", classNames -> classNames.javadocSimpleClassName() + ".builder()\n\t\t.condensed()\n\t\t.version(\"Alpha v.0.1\")\n\t\t.build()"), Triple.of(builders -> ((JavadocBuilder)builders.javadocBuilder().get()).condensed().since("Alpha v.0.0.1").build(), (Object)"/** @since Alpha v.0.0.1 */", classNames -> classNames.javadocSimpleClassName() + ".builder()\n\t\t.condensed()\n\t\t.since(\"Alpha v.0.0.1\")\n\t\t.build()"), Triple.of(builders -> ((JavadocBuilder)builders.javadocBuilder().get()).condensed().param("test", "yes").build(), (Object)"/** @param test yes */", classNames -> classNames.javadocSimpleClassName() + ".builder()\n\t\t.condensed()\n\t\t.param(\"test\", \"yes\")\n\t\t.build()"), Triple.of(builders -> ((JavadocBuilder)builders.javadocBuilder().get()).condensed().param("test", "yes").param("derp", "no").build(), (Object)"/** @param test yes\n * @param derp no */", classNames -> classNames.javadocSimpleClassName() + ".builder()\n\t\t.condensed()\n\t\t.param(\"test\", \"yes\")\n\t\t.param(\"derp\", \"no\")\n\t\t.build()"), Triple.of(builders -> ((JavadocBuilder)builders.javadocBuilder().get()).condensed().returnVal("this, to continue building").build(), (Object)"/** @return this, to continue building */", classNames -> classNames.javadocSimpleClassName() + ".builder()\n\t\t.condensed()\n\t\t.returnVal(\"this, to continue building\")\n\t\t.build()"), Triple.of(builders -> ((JavadocBuilder)builders.javadocBuilder().get()).condensed().throwsInfo("Exception", "Because I can").build(), (Object)"/** @throws Exception Because I can */", classNames -> classNames.javadocSimpleClassName() + ".builder()\n\t\t.condensed()\n\t\t.throwsInfo(\"Exception\", \"Because I can\")\n\t\t.build()"), Triple.of(builders -> ((JavadocBuilder)builders.javadocBuilder().get()).condensed().throwsInfo("Exception", "Because I can").throwsInfo("Throwable", "Because I want to").build(), (Object)"/** @throws Exception Because I can\n * @throws Throwable Because I want to */", classNames -> classNames.javadocSimpleClassName() + ".builder()\n\t\t.condensed()\n\t\t.throwsInfo(\"Exception\", \"Because I can\")\n\t\t.throwsInfo(\"Throwable\", \"Because I want to\")\n\t\t.build()"), Triple.of(builders -> ((JavadocBuilder)builders.javadocBuilder().get()).condensed().content("test").content("derp").author("Logan Ferree (Tadukoo)").version("Alpha v.0.1").since("Alpha v.0.0.1").param("test", "yes").param("derp", "no").returnVal("this, to continue building").throwsInfo("Exception", "Because I can").throwsInfo("Throwable", "Because I want to").build(), (Object)"/** test\n * derp\n * \n * @author Logan Ferree (Tadukoo)\n * @version Alpha v.0.1\n * @since Alpha v.0.0.1\n * \n * @param test yes\n * @param derp no\n * @return this, to continue building\n * @throws Exception Because I can\n * @throws Throwable Because I want to */", classNames -> classNames.javadocSimpleClassName() + ".builder()\n\t\t.condensed()\n\t\t.content(\"test\")\n\t\t.content(\"derp\")\n\t\t.author(\"Logan Ferree (Tadukoo)\")\n\t\t.version(\"Alpha v.0.1\")\n\t\t.since(\"Alpha v.0.0.1\")\n\t\t.param(\"test\", \"yes\")\n\t\t.param(\"derp\", \"no\")\n\t\t.returnVal(\"this, to continue building\")\n\t\t.throwsInfo(\"Exception\", \"Because I can\")\n\t\t.throwsInfo(\"Throwable\", \"Because I want to\")\n\t\t.build()"), Triple.of(builders -> ((JavadocBuilder)builders.javadocBuilder().get()).content("test").author("Me").build(), (Object)"/**\n * test\n * \n * @author Me\n */", classNames -> classNames.javadocSimpleClassName() + ".builder()\n\t\t.content(\"test\")\n\t\t.author(\"Me\")\n\t\t.build()"), Triple.of(builders -> ((JavadocBuilder)builders.javadocBuilder().get()).content("test").returnVal("this").build(), (Object)"/**\n * test\n * \n * @return this\n */", classNames -> classNames.javadocSimpleClassName() + ".builder()\n\t\t.content(\"test\")\n\t\t.returnVal(\"this\")\n\t\t.build()")});
        return commentMakersAndStrings.stream().flatMap(triple -> Stream.of(0, 1, 2).map(index -> Arguments.of((Object[])new Object[]{((Function)triple.getLeft()).apply((Object)((BaseJavaCodeTypeTest.Builders)allBuilders.get((int)index))), triple.getMiddle(), ((Function)triple.getRight()).apply((Object)((BaseJavaCodeTypeTest.SimpleClassNames)simpleClassNames.get((int)index)))})));
    }

    @Test
    public void testSetCondensed() {
        EditableJavadoc doc = (EditableJavadoc)EditableJavadoc.builder().build();
        Assertions.assertFalse((boolean)doc.isCondensed());
        doc.setCondensed(true);
        Assertions.assertTrue((boolean)doc.isCondensed());
    }

    @Test
    public void testAddContentSingleLine() {
        EditableJavadoc doc = (EditableJavadoc)EditableJavadoc.builder().build();
        Assertions.assertEquals(new ArrayList(), (Object)doc.getContent());
        doc.addContent("Test");
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"Test"}), (Object)doc.getContent());
        doc.addContent("Derp");
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"Test", "Derp"}), (Object)doc.getContent());
    }

    @Test
    public void testAddContentMultiline() {
        EditableJavadoc doc = (EditableJavadoc)EditableJavadoc.builder().build();
        Assertions.assertEquals(new ArrayList(), (Object)doc.getContent());
        doc.addContent(ListUtil.createList((Object[])new String[]{"Test", "Derp"}));
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"Test", "Derp"}), (Object)doc.getContent());
        doc.addContent(ListUtil.createList((Object[])new String[]{"blah", "yep"}));
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"Test", "Derp", "blah", "yep"}), (Object)doc.getContent());
    }

    @Test
    public void testSetContent() {
        EditableJavadoc doc = (EditableJavadoc)EditableJavadoc.builder().build();
        Assertions.assertEquals(new ArrayList(), (Object)doc.getContent());
        doc.setContent(ListUtil.createList((Object[])new String[]{"Test", "Derp"}));
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"Test", "Derp"}), (Object)doc.getContent());
        doc.setContent(ListUtil.createList((Object[])new String[]{"blah", "yep"}));
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"blah", "yep"}), (Object)doc.getContent());
    }

    @Test
    public void testSetAuthor() {
        EditableJavadoc doc = (EditableJavadoc)EditableJavadoc.builder().build();
        Assertions.assertNull((Object)doc.getAuthor());
        doc.setAuthor("Me");
        Assertions.assertEquals((Object)"Me", (Object)doc.getAuthor());
        doc.setAuthor("Logan Ferree (Tadukoo)");
        Assertions.assertEquals((Object)"Logan Ferree (Tadukoo)", (Object)doc.getAuthor());
    }

    @Test
    public void testSetVersion() {
        EditableJavadoc doc = (EditableJavadoc)EditableJavadoc.builder().build();
        Assertions.assertNull((Object)doc.getVersion());
        doc.setVersion("Test");
        Assertions.assertEquals((Object)"Test", (Object)doc.getVersion());
        doc.setVersion("Alpha v.0.1");
        Assertions.assertEquals((Object)"Alpha v.0.1", (Object)doc.getVersion());
    }

    @Test
    public void testSetSince() {
        EditableJavadoc doc = (EditableJavadoc)EditableJavadoc.builder().build();
        Assertions.assertNull((Object)doc.getSince());
        doc.setSince("Test");
        Assertions.assertEquals((Object)"Test", (Object)doc.getSince());
        doc.setSince("Alpha v.0.1");
        Assertions.assertEquals((Object)"Alpha v.0.1", (Object)doc.getSince());
    }

    @Test
    public void testAddParamPieces() {
        EditableJavadoc doc = (EditableJavadoc)EditableJavadoc.builder().build();
        Assertions.assertEquals(new ArrayList(), (Object)doc.getParams());
        doc.addParam("Test", "something");
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new Pair[]{Pair.of((Object)"Test", (Object)"something")}), (Object)doc.getParams());
        doc.addParam("Derp", "something else");
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new Pair[]{Pair.of((Object)"Test", (Object)"something"), Pair.of((Object)"Derp", (Object)"something else")}), (Object)doc.getParams());
    }

    @Test
    public void testAddParamPair() {
        EditableJavadoc doc = (EditableJavadoc)EditableJavadoc.builder().build();
        Assertions.assertEquals(new ArrayList(), (Object)doc.getParams());
        doc.addParam(Pair.of((Object)"Test", (Object)"something"));
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new Pair[]{Pair.of((Object)"Test", (Object)"something")}), (Object)doc.getParams());
        doc.addParam(Pair.of((Object)"Derp", (Object)"something else"));
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new Pair[]{Pair.of((Object)"Test", (Object)"something"), Pair.of((Object)"Derp", (Object)"something else")}), (Object)doc.getParams());
    }

    @Test
    public void testAddParams() {
        EditableJavadoc doc = (EditableJavadoc)EditableJavadoc.builder().build();
        Assertions.assertEquals(new ArrayList(), (Object)doc.getParams());
        doc.addParams(ListUtil.createList((Object[])new Pair[]{Pair.of((Object)"Test", (Object)"something"), Pair.of((Object)"Derp", (Object)"something else")}));
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new Pair[]{Pair.of((Object)"Test", (Object)"something"), Pair.of((Object)"Derp", (Object)"something else")}), (Object)doc.getParams());
        doc.addParams(ListUtil.createList((Object[])new Pair[]{Pair.of((Object)"Blah", (Object)"yep"), Pair.of((Object)"Bloop", (Object)"nope")}));
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new Pair[]{Pair.of((Object)"Test", (Object)"something"), Pair.of((Object)"Derp", (Object)"something else"), Pair.of((Object)"Blah", (Object)"yep"), Pair.of((Object)"Bloop", (Object)"nope")}), (Object)doc.getParams());
    }

    @Test
    public void testSetParams() {
        EditableJavadoc doc = (EditableJavadoc)EditableJavadoc.builder().build();
        Assertions.assertEquals(new ArrayList(), (Object)doc.getParams());
        doc.setParams(ListUtil.createList((Object[])new Pair[]{Pair.of((Object)"Test", (Object)"something"), Pair.of((Object)"Derp", (Object)"something else")}));
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new Pair[]{Pair.of((Object)"Test", (Object)"something"), Pair.of((Object)"Derp", (Object)"something else")}), (Object)doc.getParams());
        doc.setParams(ListUtil.createList((Object[])new Pair[]{Pair.of((Object)"Blah", (Object)"yep"), Pair.of((Object)"Bloop", (Object)"nope")}));
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new Pair[]{Pair.of((Object)"Blah", (Object)"yep"), Pair.of((Object)"Bloop", (Object)"nope")}), (Object)doc.getParams());
    }

    @Test
    public void testSetReturnVal() {
        EditableJavadoc doc = (EditableJavadoc)EditableJavadoc.builder().build();
        Assertions.assertNull((Object)doc.getReturnVal());
        doc.setReturnVal("a string");
        Assertions.assertEquals((Object)"a string", (Object)doc.getReturnVal());
        doc.setReturnVal("this");
        Assertions.assertEquals((Object)"this", (Object)doc.getReturnVal());
    }

    @Test
    public void testAddThrowsInfoPieces() {
        EditableJavadoc doc = (EditableJavadoc)EditableJavadoc.builder().build();
        Assertions.assertEquals(new ArrayList(), (Object)doc.getThrowsInfos());
        doc.addThrowsInfo("Exception", "Because I can");
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new Pair[]{Pair.of((Object)"Exception", (Object)"Because I can")}), (Object)doc.getThrowsInfos());
        doc.addThrowsInfo("Throwable", "Because I want to");
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new Pair[]{Pair.of((Object)"Exception", (Object)"Because I can"), Pair.of((Object)"Throwable", (Object)"Because I want to")}), (Object)doc.getThrowsInfos());
    }

    @Test
    public void testAddThrowsInfoPair() {
        EditableJavadoc doc = (EditableJavadoc)EditableJavadoc.builder().build();
        Pair throwsInfo1 = Pair.of((Object)"Exception", (Object)"Because I can");
        Pair throwsInfo2 = Pair.of((Object)"Throwable", (Object)"Because I want to");
        Assertions.assertEquals(new ArrayList(), (Object)doc.getThrowsInfos());
        doc.addThrowsInfo(throwsInfo1);
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new Pair[]{throwsInfo1}), (Object)doc.getThrowsInfos());
        doc.addThrowsInfo(throwsInfo2);
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new Pair[]{throwsInfo1, throwsInfo2}), (Object)doc.getThrowsInfos());
    }

    @Test
    public void testAddThrowsInfos() {
        EditableJavadoc doc = (EditableJavadoc)EditableJavadoc.builder().build();
        Pair throwsInfo1 = Pair.of((Object)"Exception", (Object)"Because I can");
        Pair throwsInfo2 = Pair.of((Object)"Throwable", (Object)"Because I want to");
        Pair throwsInfo3 = Pair.of((Object)"CustomException", (Object)"Because why not?");
        Pair throwsInfo4 = Pair.of((Object)"UnknownException", (Object)"Because reasons");
        Assertions.assertEquals(new ArrayList(), (Object)doc.getThrowsInfos());
        doc.addThrowsInfos(ListUtil.createList((Object[])new Pair[]{throwsInfo1, throwsInfo2}));
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new Pair[]{throwsInfo1, throwsInfo2}), (Object)doc.getThrowsInfos());
        doc.addThrowsInfos(ListUtil.createList((Object[])new Pair[]{throwsInfo3, throwsInfo4}));
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new Pair[]{throwsInfo1, throwsInfo2, throwsInfo3, throwsInfo4}), (Object)doc.getThrowsInfos());
    }

    @Test
    public void testSetThrowsInfos() {
        EditableJavadoc doc = (EditableJavadoc)EditableJavadoc.builder().build();
        Pair throwsInfo1 = Pair.of((Object)"Exception", (Object)"Because I can");
        Pair throwsInfo2 = Pair.of((Object)"Throwable", (Object)"Because I want to");
        Pair throwsInfo3 = Pair.of((Object)"CustomException", (Object)"Because why not?");
        Pair throwsInfo4 = Pair.of((Object)"UnknownException", (Object)"Because reasons");
        Assertions.assertEquals(new ArrayList(), (Object)doc.getThrowsInfos());
        doc.setThrowsInfos(ListUtil.createList((Object[])new Pair[]{throwsInfo1, throwsInfo2}));
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new Pair[]{throwsInfo1, throwsInfo2}), (Object)doc.getThrowsInfos());
        doc.setThrowsInfos(ListUtil.createList((Object[])new Pair[]{throwsInfo3, throwsInfo4}));
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new Pair[]{throwsInfo3, throwsInfo4}), (Object)doc.getThrowsInfos());
    }
}

