/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.java.method;

import com.github.tadukoo.java.BaseJavaCodeTypeTest;
import com.github.tadukoo.java.JavaCodeTypes;
import com.github.tadukoo.java.JavaParameter;
import com.github.tadukoo.java.JavaType;
import com.github.tadukoo.java.JavaTypeParameter;
import com.github.tadukoo.java.Visibility;
import com.github.tadukoo.java.annotation.EditableJavaAnnotation;
import com.github.tadukoo.java.annotation.JavaAnnotation;
import com.github.tadukoo.java.annotation.JavaAnnotationBuilder;
import com.github.tadukoo.java.annotation.UneditableJavaAnnotation;
import com.github.tadukoo.java.javadoc.EditableJavadoc;
import com.github.tadukoo.java.javadoc.JavadocBuilder;
import com.github.tadukoo.java.javadoc.UneditableJavadoc;
import com.github.tadukoo.java.method.EditableJavaMethod;
import com.github.tadukoo.java.method.JavaMethod;
import com.github.tadukoo.java.method.JavaMethodBuilder;
import com.github.tadukoo.java.method.UneditableJavaMethod;
import com.github.tadukoo.util.ListUtil;
import com.github.tadukoo.util.functional.function.Function;
import com.github.tadukoo.util.tuple.Pair;
import com.github.tadukoo.util.tuple.Triple;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class JavaMethodTest
extends BaseJavaCodeTypeTest<JavaMethod> {
    @Override
    protected Stream<Arguments> getEditableData() {
        return Stream.of(Arguments.of((Object[])new Object[]{UneditableJavaMethod.builder().returnType("int").build(), false, JavaMethod::isEditable}), Arguments.of((Object[])new Object[]{EditableJavaMethod.builder().returnType("int").build(), true, JavaMethod::isEditable}));
    }

    @Override
    protected Stream<Arguments> getEqualsData() {
        List comparisons = ListUtil.createList((Object[])new Pair[]{Pair.of(builders -> JavaCodeTypes.METHOD, builders -> ((JavaMethodBuilder)builders.methodBuilder().get()).returnType("int").build().getJavaCodeType()), Pair.of(builders -> null, builders -> ((JavaMethodBuilder)builders.methodBuilder().get()).returnType("int").build().getJavadoc()), Pair.of(builders -> new ArrayList(), builders -> ((JavaMethodBuilder)builders.methodBuilder().get()).returnType("int").build().getAnnotations()), Pair.of(builders -> Visibility.NONE, builders -> ((JavaMethodBuilder)builders.methodBuilder().get()).returnType("int").build().getVisibility()), Pair.of(builders -> false, builders -> ((JavaMethodBuilder)builders.methodBuilder().get()).returnType("int").build().isAbstract()), Pair.of(builders -> false, builders -> ((JavaMethodBuilder)builders.methodBuilder().get()).returnType("int").build().isStatic()), Pair.of(builders -> false, builders -> ((JavaMethodBuilder)builders.methodBuilder().get()).returnType("int").build().isFinal()), Pair.of(builders -> new ArrayList(), builders -> ((JavaMethodBuilder)builders.methodBuilder().get()).returnType("int").build().getTypeParameters()), Pair.of(builders -> null, builders -> ((JavaMethodBuilder)builders.methodBuilder().get()).returnType("int").build().getName()), Pair.of(builders -> new ArrayList(), builders -> ((JavaMethodBuilder)builders.methodBuilder().get()).returnType("int").build().getParameters()), Pair.of(builders -> new ArrayList(), builders -> ((JavaMethodBuilder)builders.methodBuilder().get()).returnType("int").build().getThrowTypes()), Pair.of(builders -> new ArrayList(), builders -> ((JavaMethodBuilder)builders.methodBuilder().get()).returnType("int").build().getLines()), Pair.of(builders -> ((JavaMethodBuilder)builders.methodBuilder().get()).javadoc(((JavadocBuilder)builders.javadocBuilder().get()).build()).annotation(((JavaAnnotationBuilder)builders.annotationBuilder().get()).name("Test").build()).visibility(Visibility.PRIVATE).isStatic().isFinal().typeParameter(JavaTypeParameter.builder().baseType(JavaType.builder().baseType("T").build()).build()).returnType("int").name("test").parameter("String type").parameter("int derp").throwType("Throwable").throwType("Exception").line("doSomething();").line("doSomethingElse();").build(), builders -> ((JavaMethodBuilder)builders.methodBuilder().get()).copy(((JavaMethodBuilder)builders.methodBuilder().get()).javadoc(((JavadocBuilder)builders.javadocBuilder().get()).build()).annotation(((JavaAnnotationBuilder)builders.annotationBuilder().get()).name("Test").build()).visibility(Visibility.PRIVATE).isStatic().isFinal().typeParameter(JavaTypeParameter.builder().baseType(JavaType.builder().baseType("T").build()).build()).returnType("int").name("test").parameter("String type").parameter("int derp").throwType("Throwable").throwType("Exception").line("doSomething();").line("doSomethingElse();").build()).build()), Pair.of(builders -> ((JavadocBuilder)builders.javadocBuilder().get()).build(), builders -> ((JavaMethodBuilder)builders.methodBuilder().get()).returnType("int").javadoc(((JavadocBuilder)builders.javadocBuilder().get()).build()).build().getJavadoc()), Pair.of(builders -> ListUtil.createList((Object[])new JavaAnnotation[]{((JavaAnnotationBuilder)builders.annotationBuilder().get()).name("Test").build(), ((JavaAnnotationBuilder)builders.annotationBuilder().get()).name("Derp").build()}), builders -> ((JavaMethodBuilder)builders.methodBuilder().get()).annotations(ListUtil.createList((Object[])new JavaAnnotation[]{((JavaAnnotationBuilder)builders.annotationBuilder().get()).name("Test").build(), ((JavaAnnotationBuilder)builders.annotationBuilder().get()).name("Derp").build()})).returnType("int").build().getAnnotations()), Pair.of(builders -> ListUtil.createList((Object[])new JavaAnnotation[]{((JavaAnnotationBuilder)builders.annotationBuilder().get()).name("Test").build()}), builders -> ((JavaMethodBuilder)builders.methodBuilder().get()).annotation(((JavaAnnotationBuilder)builders.annotationBuilder().get()).name("Test").build()).returnType("int").build().getAnnotations()), Pair.of(builders -> Visibility.PRIVATE, builders -> ((JavaMethodBuilder)builders.methodBuilder().get()).visibility(Visibility.PRIVATE).returnType("int").build().getVisibility()), Pair.of(builders -> true, builders -> ((JavaMethodBuilder)builders.methodBuilder().get()).isAbstract().returnType("int").build().isAbstract()), Pair.of(builders -> true, builders -> ((JavaMethodBuilder)builders.methodBuilder().get()).isAbstract(true).returnType("int").build().isAbstract()), Pair.of(builders -> true, builders -> ((JavaMethodBuilder)builders.methodBuilder().get()).isStatic().returnType("int").build().isStatic()), Pair.of(builders -> true, builders -> ((JavaMethodBuilder)builders.methodBuilder().get()).isStatic(true).returnType("int").build().isStatic()), Pair.of(builders -> true, builders -> ((JavaMethodBuilder)builders.methodBuilder().get()).isFinal().returnType("int").build().isFinal()), Pair.of(builders -> true, builders -> ((JavaMethodBuilder)builders.methodBuilder().get()).isFinal(true).returnType("int").build().isFinal()), Pair.of(builders -> ListUtil.createList((Object[])new JavaTypeParameter[]{JavaTypeParameter.builder().baseType(JavaType.builder().baseType("T").build()).build()}), builders -> ((JavaMethodBuilder)builders.methodBuilder().get()).typeParameter(JavaTypeParameter.builder().baseType(JavaType.builder().baseType("T").build()).build()).returnType("int").build().getTypeParameters()), Pair.of(builders -> ListUtil.createList((Object[])new JavaTypeParameter[]{JavaTypeParameter.builder().baseType(JavaType.builder().baseType("T").build()).build(), JavaTypeParameter.builder().baseType(JavaType.builder().baseType("U").build()).build()}), builders -> ((JavaMethodBuilder)builders.methodBuilder().get()).typeParameters(ListUtil.createList((Object[])new JavaTypeParameter[]{JavaTypeParameter.builder().baseType(JavaType.builder().baseType("T").build()).build(), JavaTypeParameter.builder().baseType(JavaType.builder().baseType("U").build()).build()})).returnType("int").build().getTypeParameters()), Pair.of(builders -> ListUtil.createList((Object[])new JavaTypeParameter[]{JavaTypeParameter.builder().baseType(JavaType.builder().baseType("T").build()).build()}), builders -> ((JavaMethodBuilder)builders.methodBuilder().get()).addTypeParameters("T").returnType("int").build().getTypeParameters()), Pair.of(builders -> JavaType.builder().baseType("int").build(), builders -> ((JavaMethodBuilder)builders.methodBuilder().get()).returnType(JavaType.builder().baseType("int").build()).build().getReturnType()), Pair.of(builders -> JavaType.builder().baseType("int").build(), builders -> ((JavaMethodBuilder)builders.methodBuilder().get()).returnType("int").build().getReturnType()), Pair.of(builders -> "someName", builders -> ((JavaMethodBuilder)builders.methodBuilder().get()).returnType("int").name("someName").build().getName()), Pair.of(builders -> ListUtil.createList((Object[])new JavaParameter[]{JavaParameter.builder().type(JavaType.builder().baseType("int").build()).name("someInt").build(), JavaParameter.builder().type(JavaType.builder().baseType("String").build()).name("someText").build()}), builders -> ((JavaMethodBuilder)builders.methodBuilder().get()).returnType("int").parameters(ListUtil.createList((Object[])new JavaParameter[]{JavaParameter.builder().type(JavaType.builder().baseType("int").build()).name("someInt").build(), JavaParameter.builder().type(JavaType.builder().baseType("String").build()).name("someText").build()})).build().getParameters()), Pair.of(builders -> ListUtil.createList((Object[])new JavaParameter[]{JavaParameter.builder().type(JavaType.builder().baseType("int").build()).name("someInt").build()}), builders -> ((JavaMethodBuilder)builders.methodBuilder().get()).returnType("int").parameter(JavaParameter.builder().type(JavaType.builder().baseType("int").build()).name("someInt").build()).build().getParameters()), Pair.of(builders -> ListUtil.createList((Object[])new JavaParameter[]{JavaParameter.builder().type(JavaType.builder().baseType("int").build()).name("someInt").build()}), builders -> ((JavaMethodBuilder)builders.methodBuilder().get()).returnType("int").parameter("int someInt").build().getParameters()), Pair.of(builders -> ListUtil.createList((Object[])new String[]{"Throwable", "Exception"}), builders -> ((JavaMethodBuilder)builders.methodBuilder().get()).returnType("int").throwTypes(ListUtil.createList((Object[])new String[]{"Throwable", "Exception"})).build().getThrowTypes()), Pair.of(builders -> ListUtil.createList((Object[])new String[]{"Throwable"}), builders -> ((JavaMethodBuilder)builders.methodBuilder().get()).returnType("int").throwType("Throwable").build().getThrowTypes()), Pair.of(builders -> ListUtil.createList((Object[])new String[]{"doSomething();", "return 42;"}), builders -> ((JavaMethodBuilder)builders.methodBuilder().get()).returnType("int").lines(ListUtil.createList((Object[])new String[]{"doSomething();", "return 42;"})).build().getLines()), Pair.of(builders -> ListUtil.createList((Object[])new String[]{"return 42;"}), builders -> ((JavaMethodBuilder)builders.methodBuilder().get()).returnType("int").line("return 42;").build().getLines()), Pair.of(builders -> ((JavaMethodBuilder)builders.methodBuilder().get()).returnType("int").javadoc(((JavadocBuilder)builders.javadocBuilder().get()).build()).annotation(((JavaAnnotationBuilder)builders.annotationBuilder().get()).name("Test").build()).annotation(((JavaAnnotationBuilder)builders.annotationBuilder().get()).name("Derp").build()).name("someMethod").isStatic().isFinal().parameter("String text").parameter("int something").throwType("Throwable").throwType("Exception").line("doSomething();").line("return 42;").build(), builders -> ((JavaMethodBuilder)builders.methodBuilder().get()).returnType("int").javadoc(((JavadocBuilder)builders.javadocBuilder().get()).build()).annotation(((JavaAnnotationBuilder)builders.annotationBuilder().get()).name("Test").build()).annotation(((JavaAnnotationBuilder)builders.annotationBuilder().get()).name("Derp").build()).name("someMethod").isStatic().isFinal().parameter("String text").parameter("int something").throwType("Throwable").throwType("Exception").line("doSomething();").line("return 42;").build())});
        return comparisons.stream().flatMap(pair -> Stream.of(0, 1, 2).map(index -> Arguments.of((Object[])new Object[]{((Function)pair.getLeft()).apply((Object)((BaseJavaCodeTypeTest.Builders)allBuilders.get((int)index))), ((Function)pair.getRight()).apply((Object)((BaseJavaCodeTypeTest.Builders)allBuilders.get((int)index)))})));
    }

    @Override
    protected Stream<Arguments> getNotEqualsData() {
        List comparisons = ListUtil.createList((Object[])new Pair[]{Pair.of(builders -> ((JavaMethodBuilder)builders.methodBuilder().get()).returnType("int").javadoc(((JavadocBuilder)builders.javadocBuilder().get()).build()).annotation(((JavaAnnotationBuilder)builders.annotationBuilder().get()).name("Test").build()).annotation(((JavaAnnotationBuilder)builders.annotationBuilder().get()).name("Derp").build()).name("someMethod").isStatic().isFinal().parameter("String text").parameter("int something").throwType("Throwable").throwType("Exception").line("doSomething();").line("return 42;").build(), builders -> ((JavaMethodBuilder)builders.methodBuilder().get()).returnType("int").javadoc(((JavadocBuilder)builders.javadocBuilder().get()).build()).annotation(((JavaAnnotationBuilder)builders.annotationBuilder().get()).name("Test").build()).annotation(((JavaAnnotationBuilder)builders.annotationBuilder().get()).name("Derp").build()).name("someMethod").isStatic().isFinal().parameter("String text").parameter("int something").throwType("Throwable").throwType("Exception").line("doSomething();").line("return 41;").build()), Pair.of(builders -> ((JavaMethodBuilder)builders.methodBuilder().get()).returnType("int").build(), builders -> "testing")});
        return comparisons.stream().flatMap(pair -> Stream.of(0, 1, 2).map(index -> Arguments.of((Object[])new Object[]{((Function)pair.getLeft()).apply((Object)((BaseJavaCodeTypeTest.Builders)allBuilders.get((int)index))), ((Function)pair.getRight()).apply((Object)((BaseJavaCodeTypeTest.Builders)allBuilders.get((int)index)))})));
    }

    @Override
    protected Stream<Arguments> getStringData() {
        List commentMakersAndStrings = ListUtil.createList((Object[])new Triple[]{Triple.of(builders -> ((JavaMethodBuilder)builders.methodBuilder().get()).returnType("int").build(), (Object)"int(){ }", classNames -> classNames.methodSimpleClassName() + ".builder()\n\t\t.returnType(\"int\")\n\t\t.build()"), Triple.of(builders -> ((JavaMethodBuilder)builders.methodBuilder().get()).javadoc(((JavadocBuilder)builders.javadocBuilder().get()).build()).returnType("int").build(), (Object)"/**\n */\nint(){ }", classNames -> classNames.methodSimpleClassName() + ".builder()\n\t\t.javadoc(" + classNames.javadocSimpleClassName() + ".builder()\n\t\t\t\t.build())\n\t\t.returnType(\"int\")\n\t\t.build()"), Triple.of(builders -> ((JavaMethodBuilder)builders.methodBuilder().get()).annotation(((JavaAnnotationBuilder)builders.annotationBuilder().get()).name("Test").build()).returnType("int").build(), (Object)"@Test\nint(){ }", classNames -> classNames.methodSimpleClassName() + ".builder()\n\t\t.annotation(" + classNames.annotationSimpleClassName() + ".builder()\n\t\t\t\t.name(\"Test\")\n\t\t\t\t.build())\n\t\t.returnType(\"int\")\n\t\t.build()"), Triple.of(builders -> ((JavaMethodBuilder)builders.methodBuilder().get()).annotation(((JavaAnnotationBuilder)builders.annotationBuilder().get()).name("Test").build()).annotation(((JavaAnnotationBuilder)builders.annotationBuilder().get()).name("Derp").build()).returnType("int").build(), (Object)"@Test\n@Derp\nint(){ }", classNames -> classNames.methodSimpleClassName() + ".builder()\n\t\t.annotation(" + classNames.annotationSimpleClassName() + ".builder()\n\t\t\t\t.name(\"Test\")\n\t\t\t\t.build())\n\t\t.annotation(" + classNames.annotationSimpleClassName() + ".builder()\n\t\t\t\t.name(\"Derp\")\n\t\t\t\t.build())\n\t\t.returnType(\"int\")\n\t\t.build()"), Triple.of(builders -> ((JavaMethodBuilder)builders.methodBuilder().get()).visibility(Visibility.PRIVATE).returnType("int").build(), (Object)"private int(){ }", classNames -> classNames.methodSimpleClassName() + ".builder()\n\t\t.visibility(Visibility.PRIVATE)\n\t\t.returnType(\"int\")\n\t\t.build()"), Triple.of(builders -> ((JavaMethodBuilder)builders.methodBuilder().get()).isAbstract().returnType("int").build(), (Object)"abstract int();", classNames -> classNames.methodSimpleClassName() + ".builder()\n\t\t.isAbstract()\n\t\t.returnType(\"int\")\n\t\t.build()"), Triple.of(builders -> ((JavaMethodBuilder)builders.methodBuilder().get()).isStatic().returnType("int").build(), (Object)"static int(){ }", classNames -> classNames.methodSimpleClassName() + ".builder()\n\t\t.isStatic()\n\t\t.returnType(\"int\")\n\t\t.build()"), Triple.of(builders -> ((JavaMethodBuilder)builders.methodBuilder().get()).isFinal().returnType("int").build(), (Object)"final int(){ }", classNames -> classNames.methodSimpleClassName() + ".builder()\n\t\t.isFinal()\n\t\t.returnType(\"int\")\n\t\t.build()"), Triple.of(builders -> ((JavaMethodBuilder)builders.methodBuilder().get()).addTypeParameters("T").returnType("int").build(), (Object)"<T> int(){ }", classNames -> classNames.methodSimpleClassName() + ".builder()\n\t\t.addTypeParameters(\"T\")\n\t\t.returnType(\"int\")\n\t\t.build()"), Triple.of(builders -> ((JavaMethodBuilder)builders.methodBuilder().get()).addTypeParameters("T").addTypeParameters("U").returnType("int").build(), (Object)"<T, U> int(){ }", classNames -> classNames.methodSimpleClassName() + ".builder()\n\t\t.addTypeParameters(\"T\")\n\t\t.addTypeParameters(\"U\")\n\t\t.returnType(\"int\")\n\t\t.build()"), Triple.of(builders -> ((JavaMethodBuilder)builders.methodBuilder().get()).returnType("int").name("someMethod").build(), (Object)"int someMethod(){ }", classNames -> classNames.methodSimpleClassName() + ".builder()\n\t\t.returnType(\"int\")\n\t\t.name(\"someMethod\")\n\t\t.build()"), Triple.of(builders -> ((JavaMethodBuilder)builders.methodBuilder().get()).returnType("int").parameter("String text").build(), (Object)"int(String text){ }", classNames -> classNames.methodSimpleClassName() + ".builder()\n\t\t.returnType(\"int\")\n\t\t.parameter(\"String text\")\n\t\t.build()"), Triple.of(builders -> ((JavaMethodBuilder)builders.methodBuilder().get()).returnType("int").parameter("String text").parameter("int something").build(), (Object)"int(String text, int something){ }", classNames -> classNames.methodSimpleClassName() + ".builder()\n\t\t.returnType(\"int\")\n\t\t.parameter(\"String text\")\n\t\t.parameter(\"int something\")\n\t\t.build()"), Triple.of(builders -> ((JavaMethodBuilder)builders.methodBuilder().get()).returnType("int").parameter("String text").parameter("Testy testy").parameter("Test test").parameter("Test test2").parameter("Test test3").parameter("Test test4").parameter("Test test5").parameter("Test test6").parameter("Test test7").build(), (Object)"int(\n\t\tString text, Testy testy, Test test, Test test2, Test test3, Test test4, Test test5, Test test6, Test test7){ }", classNames -> classNames.methodSimpleClassName() + ".builder()\n\t\t.returnType(\"int\")\n\t\t.parameter(\"String text\")\n\t\t.parameter(\"Testy testy\")\n\t\t.parameter(\"Test test\")\n\t\t.parameter(\"Test test2\")\n\t\t.parameter(\"Test test3\")\n\t\t.parameter(\"Test test4\")\n\t\t.parameter(\"Test test5\")\n\t\t.parameter(\"Test test6\")\n\t\t.parameter(\"Test test7\")\n\t\t.build()"), Triple.of(builders -> ((JavaMethodBuilder)builders.methodBuilder().get()).returnType("int").parameter("String text").parameter("Testy testy").parameter("Test test").parameter("Test test2").parameter("Test test3").parameter("Test test4").parameter("Test test5").parameter("Test test6").parameter("Test test7").parameter("Test test8").build(), (Object)"int(\n\t\tString text, Testy testy, Test test, Test test2, Test test3, Test test4, Test test5, Test test6, Test test7, \n\t\tTest test8){ }", classNames -> classNames.methodSimpleClassName() + ".builder()\n\t\t.returnType(\"int\")\n\t\t.parameter(\"String text\")\n\t\t.parameter(\"Testy testy\")\n\t\t.parameter(\"Test test\")\n\t\t.parameter(\"Test test2\")\n\t\t.parameter(\"Test test3\")\n\t\t.parameter(\"Test test4\")\n\t\t.parameter(\"Test test5\")\n\t\t.parameter(\"Test test6\")\n\t\t.parameter(\"Test test7\")\n\t\t.parameter(\"Test test8\")\n\t\t.build()"), Triple.of(builders -> ((JavaMethodBuilder)builders.methodBuilder().get()).returnType("int").parameter("String aReallyLongNameForAStringThatReallyShouldNotBeThisWayButItIsForSomeReasonAndNoOneKnowsWhyItWasDoneThisWayAndYeah").build(), (Object)"int(\n\t\tString aReallyLongNameForAStringThatReallyShouldNotBeThisWayButItIsForSomeReasonAndNoOneKnowsWhyItWasDoneThisWayAndYeah){ }", classNames -> classNames.methodSimpleClassName() + ".builder()\n\t\t.returnType(\"int\")\n\t\t.parameter(\"String aReallyLongNameForAStringThatReallyShouldNotBeThisWayButItIsForSomeReasonAndNoOneKnowsWhyItWasDoneThisWayAndYeah\")\n\t\t.build()"), Triple.of(builders -> ((JavaMethodBuilder)builders.methodBuilder().get()).returnType("int").parameter("String aReallyLongNameForAStringThatReallyShouldNotBeThisWayButItIsForSomeReasonAndNoOneKnowsWhyItWasDoneThisWayAndYeah").parameter("String aReallyLongNameForAStringThatReallyShouldNotBeThisWayButItIsForSomeReasonAndNoOneKnowsWhyItWasDoneThisWayAndYeah2").build(), (Object)"int(\n\t\tString aReallyLongNameForAStringThatReallyShouldNotBeThisWayButItIsForSomeReasonAndNoOneKnowsWhyItWasDoneThisWayAndYeah, \n\t\tString aReallyLongNameForAStringThatReallyShouldNotBeThisWayButItIsForSomeReasonAndNoOneKnowsWhyItWasDoneThisWayAndYeah2){ }", classNames -> classNames.methodSimpleClassName() + ".builder()\n\t\t.returnType(\"int\")\n\t\t.parameter(\"String aReallyLongNameForAStringThatReallyShouldNotBeThisWayButItIsForSomeReasonAndNoOneKnowsWhyItWasDoneThisWayAndYeah\")\n\t\t.parameter(\"String aReallyLongNameForAStringThatReallyShouldNotBeThisWayButItIsForSomeReasonAndNoOneKnowsWhyItWasDoneThisWayAndYeah2\")\n\t\t.build()"), Triple.of(builders -> ((JavaMethodBuilder)builders.methodBuilder().get()).returnType("int").throwType("Throwable").build(), (Object)"int() throws Throwable{ }", classNames -> classNames.methodSimpleClassName() + ".builder()\n\t\t.returnType(\"int\")\n\t\t.throwType(\"Throwable\")\n\t\t.build()"), Triple.of(builders -> ((JavaMethodBuilder)builders.methodBuilder().get()).returnType("int").throwType("Throwable").throwType("Exception").build(), (Object)"int() throws Throwable, Exception{ }", classNames -> classNames.methodSimpleClassName() + ".builder()\n\t\t.returnType(\"int\")\n\t\t.throwType(\"Throwable\")\n\t\t.throwType(\"Exception\")\n\t\t.build()"), Triple.of(builders -> ((JavaMethodBuilder)builders.methodBuilder().get()).returnType("int").line("return 42;").build(), (Object)"int(){\n\treturn 42;\n}", classNames -> classNames.methodSimpleClassName() + ".builder()\n\t\t.returnType(\"int\")\n\t\t.line(\"return 42;\")\n\t\t.build()"), Triple.of(builders -> ((JavaMethodBuilder)builders.methodBuilder().get()).returnType("int").line("doSomething();").line("return 42;").build(), (Object)"int(){\n\tdoSomething();\n\treturn 42;\n}", classNames -> classNames.methodSimpleClassName() + ".builder()\n\t\t.returnType(\"int\")\n\t\t.line(\"doSomething();\")\n\t\t.line(\"return 42;\")\n\t\t.build()"), Triple.of(builders -> ((JavaMethodBuilder)builders.methodBuilder().get()).returnType("int").javadoc(((JavadocBuilder)builders.javadocBuilder().get()).build()).annotation(((JavaAnnotationBuilder)builders.annotationBuilder().get()).name("Test").build()).annotation(((JavaAnnotationBuilder)builders.annotationBuilder().get()).name("Derp").build()).name("someMethod").visibility(Visibility.PUBLIC).isStatic().isFinal().parameter("String text").parameter("int something").throwType("Throwable").throwType("Exception").line("doSomething();").line("return 42;").build(), (Object)"/**\n */\n@Test\n@Derp\npublic static final int someMethod(String text, int something) throws Throwable, Exception{\n\tdoSomething();\n\treturn 42;\n}", classNames -> classNames.methodSimpleClassName() + ".builder()\n\t\t.javadoc(" + classNames.javadocSimpleClassName() + ".builder()\n\t\t\t\t.build())\n\t\t.annotation(" + classNames.annotationSimpleClassName() + ".builder()\n\t\t\t\t.name(\"Test\")\n\t\t\t\t.build())\n\t\t.annotation(" + classNames.annotationSimpleClassName() + ".builder()\n\t\t\t\t.name(\"Derp\")\n\t\t\t\t.build())\n\t\t.visibility(Visibility.PUBLIC)\n\t\t.isStatic()\n\t\t.isFinal()\n\t\t.returnType(\"int\")\n\t\t.name(\"someMethod\")\n\t\t.parameter(\"String text\")\n\t\t.parameter(\"int something\")\n\t\t.throwType(\"Throwable\")\n\t\t.throwType(\"Exception\")\n\t\t.line(\"doSomething();\")\n\t\t.line(\"return 42;\")\n\t\t.build()")});
        return commentMakersAndStrings.stream().flatMap(triple -> Stream.of(0, 1, 2).map(index -> Arguments.of((Object[])new Object[]{((Function)triple.getLeft()).apply((Object)((BaseJavaCodeTypeTest.Builders)allBuilders.get((int)index))), triple.getMiddle(), ((Function)triple.getRight()).apply((Object)((BaseJavaCodeTypeTest.SimpleClassNames)simpleClassNames.get((int)index)))})));
    }

    @Override
    protected Stream<Arguments> getBuilderErrorData() {
        List builderFuncsAndErrorMessages = ListUtil.createList((Object[])new Pair[]{Pair.of(builders -> () -> ((JavaMethodBuilder)builders.methodBuilder().get()).returnType("int").visibility(null).build(), (Object)"Visibility is required!"), Pair.of(builders -> () -> ((JavaMethodBuilder)builders.methodBuilder().get()).build(), (Object)"Must specify returnType!"), Pair.of(builders -> () -> ((JavaMethodBuilder)builders.methodBuilder().get()).visibility(null).build(), (Object)"Visibility is required!\nMust specify returnType!"), Pair.of(builders -> () -> ((JavaMethodBuilder)builders.methodBuilder().get()).visibility(Visibility.PRIVATE).isAbstract().returnType("String").build(), (Object)"Can't be abstract and private!"), Pair.of(builders -> () -> ((JavaMethodBuilder)builders.methodBuilder().get()).isAbstract().isStatic().returnType("String").build(), (Object)"Can't be abstract and static!"), Pair.of(builders -> () -> ((JavaMethodBuilder)builders.methodBuilder().get()).isAbstract().isFinal().returnType("String").build(), (Object)"Can't be abstract and final!"), Pair.of(builders -> () -> ((JavaMethodBuilder)builders.methodBuilder().get()).isAbstract().returnType("String").line("return this").build(), (Object)"Can't be abstract and have lines!"), Pair.of(builders -> () -> ((JavaMethodBuilder)builders.methodBuilder().get()).visibility(Visibility.PRIVATE).isAbstract().isStatic().isFinal().returnType("String").line("return this").build(), (Object)"Can't be abstract and private!\nCan't be abstract and static!\nCan't be abstract and final!\nCan't be abstract and have lines!")});
        List editableRelatedErrors = ListUtil.createList((Object[])new Pair[]{Pair.of(() -> UneditableJavaMethod.builder().returnType("int").javadoc(EditableJavadoc.builder().build()).build(), (Object)"javadoc is not uneditable in this uneditable JavaMethod"), Pair.of(() -> UneditableJavaMethod.builder().returnType("int").annotation(EditableJavaAnnotation.builder().name("Test").build()).build(), (Object)"some annotations are not uneditable in this uneditable JavaMethod"), Pair.of(() -> UneditableJavaMethod.builder().returnType("int").javadoc(EditableJavadoc.builder().build()).annotation(EditableJavaAnnotation.builder().name("Test").build()).build(), (Object)"javadoc is not uneditable in this uneditable JavaMethod\nsome annotations are not uneditable in this uneditable JavaMethod"), Pair.of(() -> EditableJavaMethod.builder().returnType("int").javadoc(UneditableJavadoc.builder().build()).build(), (Object)"javadoc is not editable in this editable JavaMethod"), Pair.of(() -> EditableJavaMethod.builder().returnType("int").annotation(UneditableJavaAnnotation.builder().name("Test").build()).build(), (Object)"some annotations are not editable in this editable JavaMethod"), Pair.of(() -> EditableJavaMethod.builder().returnType("int").javadoc(UneditableJavadoc.builder().build()).annotation(UneditableJavaAnnotation.builder().name("Test").build()).build(), (Object)"javadoc is not editable in this editable JavaMethod\nsome annotations are not editable in this editable JavaMethod")});
        return Stream.concat(builderFuncsAndErrorMessages.stream().flatMap(pair -> Stream.of(0, 1, 2).map(index -> Arguments.of((Object[])new Object[]{((Function)pair.getLeft()).apply((Object)((BaseJavaCodeTypeTest.Builders)allBuilders.get((int)index))), pair.getRight()}))), editableRelatedErrors.stream().map(pair -> Arguments.of((Object[])new Object[]{pair.getLeft(), pair.getRight()})));
    }

    private Stream<Arguments> getUniqueNameData() {
        List uniqueNameAndBuilders = ListUtil.createList((Object[])new Pair[]{Pair.of(builders -> ((JavaMethodBuilder)builders.methodBuilder().get()).returnType("int").build(), (Object)"init()"), Pair.of(builders -> ((JavaMethodBuilder)builders.methodBuilder().get()).returnType("int").parameter("String name").build(), (Object)"init(String name)"), Pair.of(builders -> ((JavaMethodBuilder)builders.methodBuilder().get()).returnType("int").parameter("String name").parameter("int version").build(), (Object)"init(String name, int version)"), Pair.of(builders -> ((JavaMethodBuilder)builders.methodBuilder().get()).returnType("int").name("test").build(), (Object)"test()"), Pair.of(builders -> ((JavaMethodBuilder)builders.methodBuilder().get()).returnType("int").name("test").parameter("String name").build(), (Object)"test(String name)"), Pair.of(builders -> ((JavaMethodBuilder)builders.methodBuilder().get()).returnType("int").name("test").parameter("String name").parameter("int version").build(), (Object)"test(String name, int version)")});
        return uniqueNameAndBuilders.stream().flatMap(pair -> Stream.of(0, 1, 2).map(index -> Arguments.of((Object[])new Object[]{((Function)pair.getLeft()).apply((Object)((BaseJavaCodeTypeTest.Builders)allBuilders.get((int)index))), pair.getRight()})));
    }

    @ParameterizedTest
    @MethodSource(value={"getUniqueNameData"})
    public void testGetUniqueName(JavaMethod method, String uniqueName) {
        Assertions.assertEquals((Object)uniqueName, (Object)method.getUniqueName());
    }

    @Test
    public void testSetJavadoc() {
        EditableJavaMethod method = (EditableJavaMethod)EditableJavaMethod.builder().returnType("int").build();
        Assertions.assertNull((Object)method.getJavadoc());
        method.setJavadoc(EditableJavadoc.builder().build());
        Assertions.assertEquals((Object)EditableJavadoc.builder().build(), (Object)method.getJavadoc());
        method.setJavadoc(EditableJavadoc.builder().author("Me").build());
        Assertions.assertEquals((Object)EditableJavadoc.builder().author("Me").build(), (Object)method.getJavadoc());
    }

    @Test
    public void testSetJavadocUneditable() {
        try {
            EditableJavaMethod method = (EditableJavaMethod)EditableJavaMethod.builder().returnType("int").build();
            method.setJavadoc(UneditableJavadoc.builder().build());
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"editable Java Method requires editable Javadoc", (Object)e.getMessage());
        }
    }

    @Test
    public void testAddAnnotation() {
        EditableJavaMethod method = (EditableJavaMethod)EditableJavaMethod.builder().returnType("int").build();
        Assertions.assertEquals(new ArrayList(), (Object)method.getAnnotations());
        method.addAnnotation(EditableJavaAnnotation.builder().name("Test").build());
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new EditableJavaAnnotation[]{(EditableJavaAnnotation)EditableJavaAnnotation.builder().name("Test").build()}), (Object)method.getAnnotations());
        method.addAnnotation(EditableJavaAnnotation.builder().name("Derp").build());
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new EditableJavaAnnotation[]{(EditableJavaAnnotation)EditableJavaAnnotation.builder().name("Test").build(), (EditableJavaAnnotation)EditableJavaAnnotation.builder().name("Derp").build()}), (Object)method.getAnnotations());
    }

    @Test
    public void testAddAnnotationUneditable() {
        try {
            EditableJavaMethod method = (EditableJavaMethod)EditableJavaMethod.builder().returnType("int").build();
            method.addAnnotation(UneditableJavaAnnotation.builder().name("Test").build());
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"editable Java Method requires editable Java Annotations", (Object)e.getMessage());
        }
    }

    @Test
    public void testAddAnnotations() {
        EditableJavaMethod method = (EditableJavaMethod)EditableJavaMethod.builder().returnType("int").build();
        JavaAnnotation test = EditableJavaAnnotation.builder().name("Test").build();
        JavaAnnotation derp = EditableJavaAnnotation.builder().name("Derp").build();
        JavaAnnotation blah = EditableJavaAnnotation.builder().name("Blah").build();
        JavaAnnotation yep = EditableJavaAnnotation.builder().name("Yep").build();
        Assertions.assertEquals(new ArrayList(), (Object)method.getAnnotations());
        method.addAnnotations(ListUtil.createList((Object[])new JavaAnnotation[]{test, derp}));
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new JavaAnnotation[]{test, derp}), (Object)method.getAnnotations());
        method.addAnnotations(ListUtil.createList((Object[])new JavaAnnotation[]{blah, yep}));
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new JavaAnnotation[]{test, derp, blah, yep}), (Object)method.getAnnotations());
    }

    @Test
    public void testAddAnnotationsUneditable() {
        try {
            EditableJavaMethod method = (EditableJavaMethod)EditableJavaMethod.builder().returnType("int").build();
            JavaAnnotation test = EditableJavaAnnotation.builder().name("Test").build();
            JavaAnnotation derp = UneditableJavaAnnotation.builder().name("Derp").build();
            method.addAnnotations(ListUtil.createList((Object[])new JavaAnnotation[]{test, derp}));
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"editable Java Method requires editable Java Annotations", (Object)e.getMessage());
        }
    }

    @Test
    public void testSetAnnotations() {
        EditableJavaMethod method = (EditableJavaMethod)EditableJavaMethod.builder().returnType("int").build();
        JavaAnnotation test = EditableJavaAnnotation.builder().name("Test").build();
        JavaAnnotation derp = EditableJavaAnnotation.builder().name("Derp").build();
        JavaAnnotation blah = EditableJavaAnnotation.builder().name("Blah").build();
        JavaAnnotation yep = EditableJavaAnnotation.builder().name("Yep").build();
        Assertions.assertEquals(new ArrayList(), (Object)method.getAnnotations());
        method.setAnnotations(ListUtil.createList((Object[])new JavaAnnotation[]{test, derp}));
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new JavaAnnotation[]{test, derp}), (Object)method.getAnnotations());
        method.setAnnotations(ListUtil.createList((Object[])new JavaAnnotation[]{blah, yep}));
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new JavaAnnotation[]{blah, yep}), (Object)method.getAnnotations());
    }

    @Test
    public void testSetAnnotationsUneditable() {
        try {
            EditableJavaMethod method = (EditableJavaMethod)EditableJavaMethod.builder().returnType("int").build();
            JavaAnnotation test = EditableJavaAnnotation.builder().name("Test").build();
            JavaAnnotation derp = UneditableJavaAnnotation.builder().name("Derp").build();
            method.setAnnotations(ListUtil.createList((Object[])new JavaAnnotation[]{test, derp}));
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"editable Java Method requires editable Java Annotations", (Object)e.getMessage());
        }
    }

    @Test
    public void testSetVisibility() {
        EditableJavaMethod method = (EditableJavaMethod)EditableJavaMethod.builder().returnType("int").build();
        Assertions.assertEquals((Object)Visibility.NONE, (Object)method.getVisibility());
        method.setVisibility(Visibility.PRIVATE);
        Assertions.assertEquals((Object)Visibility.PRIVATE, (Object)method.getVisibility());
    }

    @Test
    public void testSetAbstract() {
        EditableJavaMethod method = (EditableJavaMethod)EditableJavaMethod.builder().returnType("int").build();
        Assertions.assertFalse((boolean)method.isAbstract());
        method.setAbstract(true);
        Assertions.assertTrue((boolean)method.isAbstract());
        method.setAbstract(true);
        Assertions.assertTrue((boolean)method.isAbstract());
    }

    @Test
    public void testSetStatic() {
        EditableJavaMethod method = (EditableJavaMethod)EditableJavaMethod.builder().returnType("int").build();
        Assertions.assertFalse((boolean)method.isStatic());
        method.setStatic(true);
        Assertions.assertTrue((boolean)method.isStatic());
        method.setStatic(true);
        Assertions.assertTrue((boolean)method.isStatic());
    }

    @Test
    public void testSetFinal() {
        EditableJavaMethod method = (EditableJavaMethod)EditableJavaMethod.builder().returnType("int").build();
        Assertions.assertFalse((boolean)method.isFinal());
        method.setFinal(true);
        Assertions.assertTrue((boolean)method.isFinal());
        method.setFinal(true);
        Assertions.assertTrue((boolean)method.isFinal());
    }

    @Test
    public void testSetTypeParameters() {
        EditableJavaMethod method = (EditableJavaMethod)EditableJavaMethod.builder().returnType("int").build();
        Assertions.assertEquals(new ArrayList(), (Object)method.getTypeParameters());
        method.setTypeParameters(ListUtil.createList((Object[])new JavaTypeParameter[]{JavaTypeParameter.builder().baseType(JavaType.builder().baseType("T").build()).build(), JavaTypeParameter.builder().baseType(JavaType.builder().baseType("U").build()).build()}));
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new JavaTypeParameter[]{JavaTypeParameter.builder().baseType(JavaType.builder().baseType("T").build()).build(), JavaTypeParameter.builder().baseType(JavaType.builder().baseType("U").build()).build()}), (Object)method.getTypeParameters());
        method.setTypeParameters(ListUtil.createList((Object[])new JavaTypeParameter[]{JavaTypeParameter.builder().baseType(JavaType.builder().baseType("R").build()).build(), JavaTypeParameter.builder().baseType(JavaType.builder().baseType("S").build()).build()}));
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new JavaTypeParameter[]{JavaTypeParameter.builder().baseType(JavaType.builder().baseType("R").build()).build(), JavaTypeParameter.builder().baseType(JavaType.builder().baseType("S").build()).build()}), (Object)method.getTypeParameters());
    }

    @Test
    public void testAddTypeParameters() {
        EditableJavaMethod method = (EditableJavaMethod)EditableJavaMethod.builder().returnType("int").build();
        Assertions.assertEquals(new ArrayList(), (Object)method.getTypeParameters());
        method.addTypeParameters(ListUtil.createList((Object[])new JavaTypeParameter[]{JavaTypeParameter.builder().baseType(JavaType.builder().baseType("T").build()).build(), JavaTypeParameter.builder().baseType(JavaType.builder().baseType("U").build()).build()}));
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new JavaTypeParameter[]{JavaTypeParameter.builder().baseType(JavaType.builder().baseType("T").build()).build(), JavaTypeParameter.builder().baseType(JavaType.builder().baseType("U").build()).build()}), (Object)method.getTypeParameters());
        method.addTypeParameters(ListUtil.createList((Object[])new JavaTypeParameter[]{JavaTypeParameter.builder().baseType(JavaType.builder().baseType("R").build()).build(), JavaTypeParameter.builder().baseType(JavaType.builder().baseType("S").build()).build()}));
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new JavaTypeParameter[]{JavaTypeParameter.builder().baseType(JavaType.builder().baseType("T").build()).build(), JavaTypeParameter.builder().baseType(JavaType.builder().baseType("U").build()).build(), JavaTypeParameter.builder().baseType(JavaType.builder().baseType("R").build()).build(), JavaTypeParameter.builder().baseType(JavaType.builder().baseType("S").build()).build()}), (Object)method.getTypeParameters());
    }

    @Test
    public void testSetTypeParametersByString() {
        EditableJavaMethod method = (EditableJavaMethod)EditableJavaMethod.builder().returnType("int").build();
        Assertions.assertEquals(new ArrayList(), (Object)method.getTypeParameters());
        method.setTypeParameters("T, U");
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new JavaTypeParameter[]{JavaTypeParameter.builder().baseType(JavaType.builder().baseType("T").build()).build(), JavaTypeParameter.builder().baseType(JavaType.builder().baseType("U").build()).build()}), (Object)method.getTypeParameters());
        method.setTypeParameters("R, S");
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new JavaTypeParameter[]{JavaTypeParameter.builder().baseType(JavaType.builder().baseType("R").build()).build(), JavaTypeParameter.builder().baseType(JavaType.builder().baseType("S").build()).build()}), (Object)method.getTypeParameters());
    }

    @Test
    public void testAddTypeParametersByString() {
        EditableJavaMethod method = (EditableJavaMethod)EditableJavaMethod.builder().returnType("int").build();
        Assertions.assertEquals(new ArrayList(), (Object)method.getTypeParameters());
        method.addTypeParameters("T, U");
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new JavaTypeParameter[]{JavaTypeParameter.builder().baseType(JavaType.builder().baseType("T").build()).build(), JavaTypeParameter.builder().baseType(JavaType.builder().baseType("U").build()).build()}), (Object)method.getTypeParameters());
        method.addTypeParameters("R, S");
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new JavaTypeParameter[]{JavaTypeParameter.builder().baseType(JavaType.builder().baseType("T").build()).build(), JavaTypeParameter.builder().baseType(JavaType.builder().baseType("U").build()).build(), JavaTypeParameter.builder().baseType(JavaType.builder().baseType("R").build()).build(), JavaTypeParameter.builder().baseType(JavaType.builder().baseType("S").build()).build()}), (Object)method.getTypeParameters());
    }

    @Test
    public void testAddTypeParameter() {
        EditableJavaMethod method = (EditableJavaMethod)EditableJavaMethod.builder().returnType("int").build();
        Assertions.assertEquals(new ArrayList(), (Object)method.getTypeParameters());
        method.addTypeParameter(JavaTypeParameter.builder().baseType(JavaType.builder().baseType("T").build()).build());
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new JavaTypeParameter[]{JavaTypeParameter.builder().baseType(JavaType.builder().baseType("T").build()).build()}), (Object)method.getTypeParameters());
        method.addTypeParameter(JavaTypeParameter.builder().baseType(JavaType.builder().baseType("R").build()).build());
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new JavaTypeParameter[]{JavaTypeParameter.builder().baseType(JavaType.builder().baseType("T").build()).build(), JavaTypeParameter.builder().baseType(JavaType.builder().baseType("R").build()).build()}), (Object)method.getTypeParameters());
    }

    @Test
    public void testSetReturnType() {
        EditableJavaMethod method = (EditableJavaMethod)EditableJavaMethod.builder().returnType("int").build();
        Assertions.assertEquals((Object)JavaType.builder().baseType("int").build(), (Object)method.getReturnType());
        method.setReturnType(JavaType.builder().baseType("String").build());
        Assertions.assertEquals((Object)JavaType.builder().baseType("String").build(), (Object)method.getReturnType());
        method.setReturnType(JavaType.builder().baseType("Derp").build());
        Assertions.assertEquals((Object)JavaType.builder().baseType("Derp").build(), (Object)method.getReturnType());
    }

    @Test
    public void testSetReturnTypeByText() {
        EditableJavaMethod method = (EditableJavaMethod)EditableJavaMethod.builder().returnType("int").build();
        Assertions.assertEquals((Object)JavaType.builder().baseType("int").build(), (Object)method.getReturnType());
        method.setReturnType("String");
        Assertions.assertEquals((Object)JavaType.builder().baseType("String").build(), (Object)method.getReturnType());
        method.setReturnType("Derp");
        Assertions.assertEquals((Object)JavaType.builder().baseType("Derp").build(), (Object)method.getReturnType());
    }

    @Test
    public void testSetName() {
        EditableJavaMethod method = (EditableJavaMethod)EditableJavaMethod.builder().returnType("int").build();
        Assertions.assertNull((Object)method.getName());
        method.setName("something");
        Assertions.assertEquals((Object)"something", (Object)method.getName());
        method.setName("somethingElse");
        Assertions.assertEquals((Object)"somethingElse", (Object)method.getName());
    }

    @Test
    public void testAddParameterText() {
        EditableJavaMethod method = (EditableJavaMethod)EditableJavaMethod.builder().returnType("int").build();
        JavaParameter parameter1 = JavaParameter.builder().type(JavaType.builder().baseType("String").build()).name("test").build();
        JavaParameter parameter2 = JavaParameter.builder().type(JavaType.builder().baseType("int").build()).name("something").build();
        Assertions.assertEquals(new ArrayList(), (Object)method.getParameters());
        method.addParameter("String test");
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new JavaParameter[]{parameter1}), (Object)method.getParameters());
        method.addParameter("int something");
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new JavaParameter[]{parameter1, parameter2}), (Object)method.getParameters());
    }

    @Test
    public void testAddParameter() {
        EditableJavaMethod method = (EditableJavaMethod)EditableJavaMethod.builder().returnType("int").build();
        JavaParameter parameter1 = JavaParameter.builder().type(JavaType.builder().baseType("String").build()).name("test").build();
        JavaParameter parameter2 = JavaParameter.builder().type(JavaType.builder().baseType("int").build()).name("something").build();
        Assertions.assertEquals(new ArrayList(), (Object)method.getParameters());
        method.addParameter(parameter1);
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new JavaParameter[]{parameter1}), (Object)method.getParameters());
        method.addParameter(parameter2);
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new JavaParameter[]{parameter1, parameter2}), (Object)method.getParameters());
    }

    @Test
    public void testAddParameters() {
        EditableJavaMethod method = (EditableJavaMethod)EditableJavaMethod.builder().returnType("int").build();
        JavaParameter parameter1 = JavaParameter.builder().type(JavaType.builder().baseType("String").build()).name("test").build();
        JavaParameter parameter2 = JavaParameter.builder().type(JavaType.builder().baseType("int").build()).name("something").build();
        JavaParameter parameter3 = JavaParameter.builder().type(JavaType.builder().baseType("String").build()).name("derp").build();
        JavaParameter parameter4 = JavaParameter.builder().type(JavaType.builder().baseType("double").build()).name("blah").build();
        Assertions.assertEquals(new ArrayList(), (Object)method.getParameters());
        method.addParameters(ListUtil.createList((Object[])new JavaParameter[]{parameter1, parameter2}));
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new JavaParameter[]{parameter1, parameter2}), (Object)method.getParameters());
        method.addParameters(ListUtil.createList((Object[])new JavaParameter[]{parameter3, parameter4}));
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new JavaParameter[]{parameter1, parameter2, parameter3, parameter4}), (Object)method.getParameters());
    }

    @Test
    public void testSetParameters() {
        EditableJavaMethod method = (EditableJavaMethod)EditableJavaMethod.builder().returnType("int").build();
        JavaParameter parameter1 = JavaParameter.builder().type(JavaType.builder().baseType("String").build()).name("test").build();
        JavaParameter parameter2 = JavaParameter.builder().type(JavaType.builder().baseType("int").build()).name("something").build();
        JavaParameter parameter3 = JavaParameter.builder().type(JavaType.builder().baseType("String").build()).name("derp").build();
        JavaParameter parameter4 = JavaParameter.builder().type(JavaType.builder().baseType("double").build()).name("blah").build();
        Assertions.assertEquals(new ArrayList(), (Object)method.getParameters());
        method.setParameters(ListUtil.createList((Object[])new JavaParameter[]{parameter1, parameter2}));
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new JavaParameter[]{parameter1, parameter2}), (Object)method.getParameters());
        method.setParameters(ListUtil.createList((Object[])new JavaParameter[]{parameter3, parameter4}));
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new JavaParameter[]{parameter3, parameter4}), (Object)method.getParameters());
    }

    @Test
    public void testAddThrowType() {
        EditableJavaMethod method = (EditableJavaMethod)EditableJavaMethod.builder().returnType("int").build();
        Assertions.assertEquals(new ArrayList(), (Object)method.getThrowTypes());
        method.addThrowType("NoException");
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"NoException"}), (Object)method.getThrowTypes());
        method.addThrowType("Throwable");
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"NoException", "Throwable"}), (Object)method.getThrowTypes());
    }

    @Test
    public void testAddThrowTypes() {
        EditableJavaMethod method = (EditableJavaMethod)EditableJavaMethod.builder().returnType("int").build();
        Assertions.assertEquals(new ArrayList(), (Object)method.getThrowTypes());
        method.addThrowTypes(ListUtil.createList((Object[])new String[]{"NoException", "Throwable"}));
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"NoException", "Throwable"}), (Object)method.getThrowTypes());
        method.addThrowTypes(ListUtil.createList((Object[])new String[]{"String", "Exception"}));
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"NoException", "Throwable", "String", "Exception"}), (Object)method.getThrowTypes());
    }

    @Test
    public void testSetThrowTypes() {
        EditableJavaMethod method = (EditableJavaMethod)EditableJavaMethod.builder().returnType("int").build();
        Assertions.assertEquals(new ArrayList(), (Object)method.getThrowTypes());
        method.setThrowTypes(ListUtil.createList((Object[])new String[]{"NoException", "Throwable"}));
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"NoException", "Throwable"}), (Object)method.getThrowTypes());
        method.setThrowTypes(ListUtil.createList((Object[])new String[]{"String", "Exception"}));
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"String", "Exception"}), (Object)method.getThrowTypes());
    }

    @Test
    public void testAddLine() {
        EditableJavaMethod method = (EditableJavaMethod)EditableJavaMethod.builder().returnType("int").build();
        Assertions.assertEquals(new ArrayList(), (Object)method.getLines());
        method.addLine("String test = \"42\";");
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"String test = \"42\";"}), (Object)method.getLines());
        method.addLine("test.toString();");
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{"String test = \"42\";", "test.toString();"}), (Object)method.getLines());
    }

    @Test
    public void testAddLines() {
        EditableJavaMethod method = (EditableJavaMethod)EditableJavaMethod.builder().returnType("int").build();
        String line1 = "String test = \"42\";";
        String line2 = "test.toString();";
        String line3 = "String line1 = \"String test = \"42\";\";";
        String line4 = "// yep";
        Assertions.assertEquals(new ArrayList(), (Object)method.getLines());
        method.addLines(ListUtil.createList((Object[])new String[]{line1, line2}));
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{line1, line2}), (Object)method.getLines());
        method.addLines(ListUtil.createList((Object[])new String[]{line3, line4}));
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{line1, line2, line3, line4}), (Object)method.getLines());
    }

    @Test
    public void testSetLines() {
        EditableJavaMethod method = (EditableJavaMethod)EditableJavaMethod.builder().returnType("int").build();
        String line1 = "String test = \"42\";";
        String line2 = "test.toString();";
        String line3 = "String line1 = \"String test = \"42\";\";";
        String line4 = "// yep";
        Assertions.assertEquals(new ArrayList(), (Object)method.getLines());
        method.setLines(ListUtil.createList((Object[])new String[]{line1, line2}));
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{line1, line2}), (Object)method.getLines());
        method.setLines(ListUtil.createList((Object[])new String[]{line3, line4}));
        Assertions.assertEquals((Object)ListUtil.createList((Object[])new String[]{line3, line4}), (Object)method.getLines());
    }
}

