/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.java.packagedeclaration;

import com.github.tadukoo.java.BaseJavaCodeTypeTest;
import com.github.tadukoo.java.JavaCodeTypes;
import com.github.tadukoo.java.packagedeclaration.EditableJavaPackageDeclaration;
import com.github.tadukoo.java.packagedeclaration.JavaPackageDeclaration;
import com.github.tadukoo.java.packagedeclaration.JavaPackageDeclarationBuilder;
import com.github.tadukoo.java.packagedeclaration.UneditableJavaPackageDeclaration;
import com.github.tadukoo.util.ListUtil;
import com.github.tadukoo.util.functional.function.Function;
import com.github.tadukoo.util.tuple.Pair;
import com.github.tadukoo.util.tuple.Triple;
import java.util.List;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.provider.Arguments;

public class JavaPackageDeclarationTest
extends BaseJavaCodeTypeTest<JavaPackageDeclaration> {
    @Override
    protected Stream<Arguments> getEditableData() {
        return Stream.of(Arguments.of((Object[])new Object[]{UneditableJavaPackageDeclaration.builder().packageName("com.example").build(), false, JavaPackageDeclaration::isEditable}), Arguments.of((Object[])new Object[]{EditableJavaPackageDeclaration.builder().packageName("com.example").build(), true, JavaPackageDeclaration::isEditable}));
    }

    @Override
    protected Stream<Arguments> getEqualsData() {
        List comparisons = ListUtil.createList((Object[])new Pair[]{Pair.of(builder -> JavaCodeTypes.PACKAGE_DECLARATION, builders -> ((JavaPackageDeclarationBuilder)builders.packageDeclarationBuilder().get()).packageName("com.example").build().getJavaCodeType()), Pair.of(builders -> ((JavaPackageDeclarationBuilder)builders.packageDeclarationBuilder().get()).packageName("com.example").build(), builders -> ((JavaPackageDeclarationBuilder)builders.packageDeclarationBuilder().get()).copy(((JavaPackageDeclarationBuilder)builders.packageDeclarationBuilder().get()).packageName("com.example").build()).build()), Pair.of(builder -> "com.example", builders -> ((JavaPackageDeclarationBuilder)builders.packageDeclarationBuilder().get()).packageName("com.example").build().getPackageName()), Pair.of(builders -> ((JavaPackageDeclarationBuilder)builders.packageDeclarationBuilder().get()).packageName("com.example").build(), builders -> ((JavaPackageDeclarationBuilder)builders.packageDeclarationBuilder().get()).packageName("com.example").build())});
        return comparisons.stream().flatMap(pair -> Stream.of(0, 1, 2).map(index -> Arguments.of((Object[])new Object[]{((Function)pair.getLeft()).apply((Object)((BaseJavaCodeTypeTest.Builders)allBuilders.get((int)index))), ((Function)pair.getRight()).apply((Object)((BaseJavaCodeTypeTest.Builders)allBuilders.get((int)index)))})));
    }

    @Override
    protected Stream<Arguments> getNotEqualsData() {
        List comparisons = ListUtil.createList((Object[])new Pair[]{Pair.of(builders -> ((JavaPackageDeclarationBuilder)builders.packageDeclarationBuilder().get()).packageName("com.example").build(), builders -> ((JavaPackageDeclarationBuilder)builders.packageDeclarationBuilder().get()).packageName("com.github.tadukoo").build()), Pair.of(builders -> ((JavaPackageDeclarationBuilder)builders.packageDeclarationBuilder().get()).packageName("com.example").build(), builder -> "testing")});
        return comparisons.stream().flatMap(pair -> Stream.of(0, 1, 2).map(index -> Arguments.of((Object[])new Object[]{((Function)pair.getLeft()).apply((Object)((BaseJavaCodeTypeTest.Builders)allBuilders.get((int)index))), ((Function)pair.getRight()).apply((Object)((BaseJavaCodeTypeTest.Builders)allBuilders.get((int)index)))})));
    }

    @Override
    protected Stream<Arguments> getStringData() {
        List commentMakersAndStrings = ListUtil.createList((Object[])new Triple[]{Triple.of(builders -> ((JavaPackageDeclarationBuilder)builders.packageDeclarationBuilder().get()).packageName("com.example").build(), (Object)"package com.example;", classNames -> classNames.packageDeclarationSimpleClassName() + ".builder()\n\t\t.packageName(\"com.example\")\n\t\t.build()")});
        return commentMakersAndStrings.stream().flatMap(triple -> Stream.of(0, 1, 2).map(index -> Arguments.of((Object[])new Object[]{((Function)triple.getLeft()).apply((Object)((BaseJavaCodeTypeTest.Builders)allBuilders.get((int)index))), triple.getMiddle(), ((Function)triple.getRight()).apply((Object)((BaseJavaCodeTypeTest.SimpleClassNames)simpleClassNames.get((int)index)))})));
    }

    @Override
    protected Stream<Arguments> getBuilderErrorData() {
        List builderFuncsAndErrorMessages = ListUtil.createList((Object[])new Pair[]{Pair.of(builders -> () -> ((JavaPackageDeclarationBuilder)builders.packageDeclarationBuilder().get()).build(), (Object)"packageName is required!")});
        return builderFuncsAndErrorMessages.stream().flatMap(pair -> Stream.of(0, 1, 2).map(index -> Arguments.of((Object[])new Object[]{((Function)pair.getLeft()).apply((Object)((BaseJavaCodeTypeTest.Builders)allBuilders.get((int)index))), pair.getRight()})));
    }

    @Test
    public void testSetPackageName() {
        EditableJavaPackageDeclaration packageDeclaration = (EditableJavaPackageDeclaration)EditableJavaPackageDeclaration.builder().packageName("com.example").build();
        Assertions.assertEquals((Object)"com.example", (Object)packageDeclaration.getPackageName());
        packageDeclaration.setPackageName("org.java.test");
        Assertions.assertEquals((Object)"org.java.test", (Object)packageDeclaration.getPackageName());
    }
}

