/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.java.parsing;

import com.github.tadukoo.java.JavaParameter;
import com.github.tadukoo.java.JavaType;
import com.github.tadukoo.java.JavaTypeParameter;
import com.github.tadukoo.java.parsing.AbstractJavaParser;
import com.github.tadukoo.util.ListUtil;
import com.github.tadukoo.util.functional.function.Function;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class AbstractJavaParserTest {
    private static Stream<Arguments> getTypeParameterData() {
        return Stream.of(Arguments.of((Object[])new Object[]{"", new ArrayList()}), Arguments.of((Object[])new Object[]{"\t\n  \t", new ArrayList()}), Arguments.of((Object[])new Object[]{"String", ListUtil.createList((Object[])new JavaTypeParameter[]{JavaTypeParameter.builder().baseType(JavaType.builder().baseType("String").build()).build()})}), Arguments.of((Object[])new Object[]{"? extends String", ListUtil.createList((Object[])new JavaTypeParameter[]{JavaTypeParameter.builder().baseType(JavaType.builder().baseType("?").build()).extendsType(JavaType.builder().baseType("String").build()).build()})}), Arguments.of((Object[])new Object[]{"? extends String, ? extends Object", ListUtil.createList((Object[])new JavaTypeParameter[]{JavaTypeParameter.builder().baseType(JavaType.builder().baseType("?").build()).extendsType(JavaType.builder().baseType("String").build()).build(), JavaTypeParameter.builder().baseType(JavaType.builder().baseType("?").build()).extendsType(JavaType.builder().baseType("Object").build()).build()})}));
    }

    @ParameterizedTest
    @MethodSource(value={"getTypeParameterData"})
    public void testParseJavaTypeParameters(String text, List<JavaTypeParameter> expectedParameters) {
        Assertions.assertEquals(expectedParameters, (Object)AbstractJavaParser.parseJavaTypeParameters((String)text));
    }

    private static Stream<Arguments> getTypeData() {
        return Stream.of(Arguments.of((Object[])new Object[]{"String", JavaType.builder().baseType("String").build()}), Arguments.of((Object[])new Object[]{"Map<String, Object>", JavaType.builder().baseType("Map").typeParameter(JavaTypeParameter.builder().baseType(JavaType.builder().baseType("String").build()).build()).typeParameter(JavaTypeParameter.builder().baseType(JavaType.builder().baseType("Object").build()).build()).build()}), Arguments.of((Object[])new Object[]{"List<Map<String,Object>>", JavaType.builder().baseType("List").typeParameter(JavaTypeParameter.builder().baseType(JavaType.builder().baseType("Map").typeParameter(JavaTypeParameter.builder().baseType(JavaType.builder().baseType("String").build()).build()).typeParameter(JavaTypeParameter.builder().baseType(JavaType.builder().baseType("Object").build()).build()).build()).build()).build()}), Arguments.of((Object[])new Object[]{"Map<Character, Map<Character, ?>>", JavaType.builder().baseType("Map").typeParameter(JavaTypeParameter.builder().baseType(JavaType.builder().baseType("Character").build()).build()).typeParameter(JavaTypeParameter.builder().baseType(JavaType.builder().baseType("Map").typeParameter(JavaTypeParameter.builder().baseType(JavaType.builder().baseType("Character").build()).build()).typeParameter(JavaTypeParameter.builder().baseType(JavaType.builder().baseType("?").build()).build()).build()).build()).build()}), Arguments.of((Object[])new Object[]{"Map<? extends List<String>, Object>", JavaType.builder().baseType("Map").typeParameter(JavaTypeParameter.builder().baseType(JavaType.builder().baseType("?").build()).extendsType(JavaType.builder().baseType("List").typeParameter(JavaTypeParameter.builder().baseType(JavaType.builder().baseType("String").build()).build()).build()).build()).typeParameter(JavaTypeParameter.builder().baseType(JavaType.builder().baseType("Object").build()).build()).build()}));
    }

    @ParameterizedTest
    @MethodSource(value={"getTypeData"})
    public void testParseJavaType(String text, JavaType expectedType) {
        Assertions.assertEquals((Object)expectedType, (Object)AbstractJavaParser.parseJavaType((String)text));
    }

    private static Stream<Arguments> getParameterData() {
        return Stream.of(Arguments.of((Object[])new Object[]{"String text", JavaParameter.builder().type(JavaType.builder().baseType("String").build()).name("text").build()}), Arguments.of((Object[])new Object[]{"String ... text", JavaParameter.builder().type(JavaType.builder().baseType("String").build()).vararg().name("text").build()}));
    }

    @ParameterizedTest
    @MethodSource(value={"getParameterData"})
    public void testParseJavaParameter(String text, JavaParameter expectedParameter) {
        Assertions.assertEquals((Object)expectedParameter, (Object)AbstractJavaParser.parseJavaParameter((String)text));
    }

    private static Stream<Arguments> getErrorData() {
        return Stream.of(Arguments.of((Object[])new Object[]{"Something extends Something extends Yes", AbstractJavaParser::parseJavaTypeParameters, "'Something extends Something extends Yes' is not a valid type parameter"}), Arguments.of((Object[])new Object[]{"Map<String,Object", AbstractJavaParser::parseJavaTypeParameters, "Failed to parse remaining type parameter content: 'Map<String,Object'"}), Arguments.of((Object[])new Object[]{"Something>Truly Garbage<", AbstractJavaParser::parseJavaType, "'Something>Truly Garbage<' is not a valid type"}), Arguments.of((Object[])new Object[]{"Something>Truly Garbage< text ...", AbstractJavaParser::parseJavaParameter, "'Something>Truly Garbage< text ...' is not a valid parameter"}));
    }

    @ParameterizedTest
    @MethodSource(value={"getErrorData"})
    public void testErrors(String text, Function<String, ?> method, String error) {
        try {
            method.apply((Object)text);
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)error, (Object)e.getMessage());
        }
    }
}

