/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.java.parsing;

import com.github.tadukoo.java.JavaCodeType;
import com.github.tadukoo.java.JavaCodeTypes;
import com.github.tadukoo.java.JavaTokens;
import com.github.tadukoo.java.annotation.JavaAnnotation;
import com.github.tadukoo.java.comment.JavaMultiLineComment;
import com.github.tadukoo.java.comment.JavaSingleLineComment;
import com.github.tadukoo.java.field.JavaField;
import com.github.tadukoo.java.importstatement.JavaImportStatement;
import com.github.tadukoo.java.javaclass.JavaClass;
import com.github.tadukoo.java.javadoc.Javadoc;
import com.github.tadukoo.java.method.JavaMethod;
import com.github.tadukoo.java.packagedeclaration.JavaPackageDeclaration;
import com.github.tadukoo.java.parsing.FullJavaParser;
import com.github.tadukoo.java.parsing.JavaParsingException;
import org.junit.jupiter.api.Assertions;

public abstract class BaseJavaParserTest
implements JavaTokens {
    protected String buildJavaParsingExceptionMessage(JavaCodeTypes type, String message) {
        return "Failed parsing JavaType: '" + type + "': " + message;
    }

    protected static JavaPackageDeclaration runFullParserForPackageDeclaration(String content) throws JavaParsingException {
        JavaCodeType type = FullJavaParser.parseType((String)content);
        Assertions.assertEquals((Object)JavaCodeTypes.PACKAGE_DECLARATION, (Object)type.getJavaCodeType());
        Assertions.assertInstanceOf(JavaPackageDeclaration.class, (Object)type);
        return (JavaPackageDeclaration)type;
    }

    protected static JavaImportStatement runFullParserForImportStatement(String content) throws JavaParsingException {
        JavaCodeType type = FullJavaParser.parseType((String)content);
        Assertions.assertEquals((Object)JavaCodeTypes.IMPORT_STATEMENT, (Object)type.getJavaCodeType());
        Assertions.assertInstanceOf(JavaImportStatement.class, (Object)type);
        return (JavaImportStatement)type;
    }

    protected static Javadoc runFullParserForJavadoc(String content) throws JavaParsingException {
        JavaCodeType type = FullJavaParser.parseType((String)content);
        Assertions.assertEquals((Object)JavaCodeTypes.JAVADOC, (Object)type.getJavaCodeType());
        Assertions.assertInstanceOf(Javadoc.class, (Object)type);
        return (Javadoc)type;
    }

    protected static JavaSingleLineComment runFullParserForSingleLineComment(String content) throws JavaParsingException {
        JavaCodeType type = FullJavaParser.parseType((String)content);
        Assertions.assertEquals((Object)JavaCodeTypes.SINGLE_LINE_COMMENT, (Object)type.getJavaCodeType());
        Assertions.assertInstanceOf(JavaSingleLineComment.class, (Object)type);
        return (JavaSingleLineComment)type;
    }

    protected static JavaMultiLineComment runFullParserForMultiLineComment(String content) throws JavaParsingException {
        JavaCodeType type = FullJavaParser.parseType((String)content);
        Assertions.assertEquals((Object)JavaCodeTypes.MULTI_LINE_COMMENT, (Object)type.getJavaCodeType());
        Assertions.assertInstanceOf(JavaMultiLineComment.class, (Object)type);
        return (JavaMultiLineComment)type;
    }

    protected static JavaAnnotation runFullParserForAnnotation(String content) throws JavaParsingException {
        JavaCodeType type = FullJavaParser.parseType((String)content);
        Assertions.assertEquals((Object)JavaCodeTypes.ANNOTATION, (Object)type.getJavaCodeType());
        Assertions.assertInstanceOf(JavaAnnotation.class, (Object)type);
        return (JavaAnnotation)type;
    }

    protected static JavaField runFullParserForField(String content) throws JavaParsingException {
        JavaCodeType type = FullJavaParser.parseType((String)content);
        Assertions.assertEquals((Object)JavaCodeTypes.FIELD, (Object)type.getJavaCodeType());
        Assertions.assertInstanceOf(JavaField.class, (Object)type);
        return (JavaField)type;
    }

    protected static JavaMethod runFullParserForMethod(String content) throws JavaParsingException {
        JavaCodeType type = FullJavaParser.parseType((String)content);
        Assertions.assertEquals((Object)JavaCodeTypes.METHOD, (Object)type.getJavaCodeType());
        Assertions.assertInstanceOf(JavaMethod.class, (Object)type);
        return (JavaMethod)type;
    }

    protected static JavaClass runFullParserForClass(String content) throws JavaParsingException {
        JavaCodeType type = FullJavaParser.parseType((String)content);
        Assertions.assertEquals((Object)JavaCodeTypes.CLASS, (Object)type.getJavaCodeType());
        Assertions.assertInstanceOf(JavaClass.class, (Object)type);
        return (JavaClass)type;
    }
}

