/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.java.parsing;

import com.github.tadukoo.java.JavaCodeTypes;
import com.github.tadukoo.java.parsing.BaseJavaParserTest;
import com.github.tadukoo.java.parsing.FullJavaParser;
import com.github.tadukoo.java.parsing.JavaParsingException;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class FullJavaParserCombinationErrorsTest
extends BaseJavaParserTest {
    private static Stream<Arguments> getParseData() {
        return Stream.of(Arguments.of((Object[])new Object[]{"package com.example;\npackage com.example.other;", "Encountered two package declarations!"}), Arguments.of((Object[])new Object[]{"class Test{\n}\npackage com.example;", "Encountered package declaration after class!"}), Arguments.of((Object[])new Object[]{"class Test{\n}\nimport com.example;", "Encountered import statement after class!"}), Arguments.of((Object[])new Object[]{"/** {@inheritDoc} */\n/** something */", "Encountered two Javadocs!"}), Arguments.of((Object[])new Object[]{"String type;\n/** {@inheritDoc} */", "Encountered a Javadoc after field!"}), Arguments.of((Object[])new Object[]{"void test(){}\n/** {@inheritDoc} */", "Encountered a Javadoc after method!"}), Arguments.of((Object[])new Object[]{"class Test{}\n/** {@inheritDoc} */", "Encountered a Javadoc after class!"}), Arguments.of((Object[])new Object[]{"class Test{\n}\n@Test", "Encountered annotation after class!"}), Arguments.of((Object[])new Object[]{"String type;\nint derp;", "Encountered two fields!"}), Arguments.of((Object[])new Object[]{"class Test{\n}\nString type;", "Encountered field outside a class!"}), Arguments.of((Object[])new Object[]{"package some.package;\nString type;", "Encountered package declaration before field!"}), Arguments.of((Object[])new Object[]{"import some.classname;\nString type;", "Encountered import statements before field!"}), Arguments.of((Object[])new Object[]{"String something(){}\nint somethingElse(){}", "Encountered two methods!"}), Arguments.of((Object[])new Object[]{"class Test{\n}\nString something(){}", "Encountered method outside a class!"}), Arguments.of((Object[])new Object[]{"package some.package;\nString something(){}", "Encountered package declaration before method!"}), Arguments.of((Object[])new Object[]{"import some.classname;\nString something(){}", "Encountered import statements before method!"}), Arguments.of((Object[])new Object[]{"class Test{\n}\nclass Test2{\n}", "Encountered two outer level classes!"}), Arguments.of((Object[])new Object[]{"String type;\nclass Test{\n}", "Encountered fields outside a class!"}), Arguments.of((Object[])new Object[]{"String something(){}\nclass Test{\n}", "Encountered methods outside a class!"}), Arguments.of((Object[])new Object[]{"String something", "Failed to determine type from token 'String'"}));
    }

    @ParameterizedTest
    @MethodSource(value={"getParseData"})
    public void testErrors(String text, String error) {
        try {
            FullJavaParser.parseType((String)text);
            Assertions.fail();
        }
        catch (JavaParsingException e) {
            Assertions.assertEquals((Object)this.buildJavaParsingExceptionMessage(JavaCodeTypes.UNKNOWN, error), (Object)e.getMessage());
        }
    }
}

