/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.java.parsing.classtypes;

import com.github.tadukoo.java.JavaCodeTypes;
import com.github.tadukoo.java.Visibility;
import com.github.tadukoo.java.annotation.EditableJavaAnnotation;
import com.github.tadukoo.java.comment.EditableJavaMultiLineComment;
import com.github.tadukoo.java.comment.EditableJavaSingleLineComment;
import com.github.tadukoo.java.field.EditableJavaField;
import com.github.tadukoo.java.importstatement.EditableJavaImportStatement;
import com.github.tadukoo.java.javaclass.EditableJavaClass;
import com.github.tadukoo.java.javaclass.JavaClass;
import com.github.tadukoo.java.javadoc.EditableJavadoc;
import com.github.tadukoo.java.method.EditableJavaMethod;
import com.github.tadukoo.java.packagedeclaration.EditableJavaPackageDeclaration;
import com.github.tadukoo.java.parsing.BaseJavaParserTest;
import com.github.tadukoo.java.parsing.JavaParsingException;
import com.github.tadukoo.java.parsing.classtypes.JavaClassParser;
import com.github.tadukoo.util.ListUtil;
import com.github.tadukoo.util.functional.function.ThrowingFunction;
import com.github.tadukoo.util.tuple.Pair;
import com.github.tadukoo.util.tuple.Triple;
import java.util.List;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class JavaClassParserTest
extends BaseJavaParserTest {
    private static final List<ThrowingFunction<String, JavaClass, JavaParsingException>> parseMethods = ListUtil.createList((Object[])new ThrowingFunction[]{x$0 -> BaseJavaParserTest.runFullParserForClass(x$0), JavaClassParser::parseClass});

    public static Stream<Arguments> getParsingData() {
        List parsingData = ListUtil.createList((Object[])new Triple[]{Triple.of((Object)"class Test{\n}\n", (Object)EditableJavaClass.builder().className("Test").build(), (Object)"class Test{\n\t\n}\n"), Triple.of((Object)"package com.example;\n\nclass Test{\n}\n", (Object)EditableJavaClass.builder().packageName("com.example").className("Test").build(), (Object)"package com.example;\n\nclass Test{\n\t\n}\n"), Triple.of((Object)"import com.example;\n\nclass Test{\n}\n", (Object)EditableJavaClass.builder().importName("com.example", false).className("Test").build(), (Object)"import com.example;\n\nclass Test{\n\t\n}\n"), Triple.of((Object)"import com.example.Something;\nimport com.example.SomethingElse;\n\nclass Test{\n}\n", (Object)EditableJavaClass.builder().importName("com.example.Something", false).importName("com.example.SomethingElse", false).className("Test").build(), (Object)"import com.example.Something;\nimport com.example.SomethingElse;\n\nclass Test{\n\t\n}\n"), Triple.of((Object)"import com.example.Something;\n\nimport org.example.SomethingElse;\n\nclass Test{\n}\n", (Object)EditableJavaClass.builder().importName("com.example.Something", false).importName("org.example.SomethingElse", false).className("Test").build(), (Object)"import com.example.Something;\n\nimport org.example.SomethingElse;\n\nclass Test{\n\t\n}\n"), Triple.of((Object)"import static com.example.SomethingStatic;\n\nclass Test{\n}\n", (Object)EditableJavaClass.builder().importName("com.example.SomethingStatic", true).className("Test").build(), (Object)"import static com.example.SomethingStatic;\n\nclass Test{\n\t\n}\n"), Triple.of((Object)"import static com.example.SomethingStatic;\nimport static com.example.SomethingElseStatic;\n\nclass Test{\n}\n", (Object)EditableJavaClass.builder().importName("com.example.SomethingStatic", true).importName("com.example.SomethingElseStatic", true).className("Test").build(), (Object)"import static com.example.SomethingElseStatic;\nimport static com.example.SomethingStatic;\n\nclass Test{\n\t\n}\n"), Triple.of((Object)"import static com.example.SomethingStatic;\n\nimport static org.example.SomethingElseStatic;\n\nclass Test{\n}\n", (Object)EditableJavaClass.builder().importName("com.example.SomethingStatic", true).importName("org.example.SomethingElseStatic", true).className("Test").build(), (Object)"import static com.example.SomethingStatic;\n\nimport static org.example.SomethingElseStatic;\n\nclass Test{\n\t\n}\n"), Triple.of((Object)"/**\n * Something here\n * \n * @author Logan Ferree (Tadukoo)\n * @version Alpha v.0.1\n */\nclass Test{\n}", (Object)EditableJavaClass.builder().javadoc(EditableJavadoc.builder().content("Something here").author("Logan Ferree (Tadukoo)").version("Alpha v.0.1").build()).className("Test").build(), (Object)"/**\n * Something here\n * \n * @author Logan Ferree (Tadukoo)\n * @version Alpha v.0.1\n */\nclass Test{\n\t\n}\n"), Triple.of((Object)"@Test\nclass Test{\n}\n", (Object)EditableJavaClass.builder().annotation(EditableJavaAnnotation.builder().name("Test").build()).className("Test").build(), (Object)"@Test\nclass Test{\n\t\n}\n"), Triple.of((Object)"@Test\n@Derp(type=String.class)\nclass Test{\n}\n", (Object)EditableJavaClass.builder().annotation(EditableJavaAnnotation.builder().name("Test").build()).annotation(EditableJavaAnnotation.builder().name("Derp").parameter("type", "String.class").build()).className("Test").build(), (Object)"@Test\n@Derp(type = String.class)\nclass Test{\n\t\n}\n"), Triple.of((Object)"private class Test{\n}\n", (Object)EditableJavaClass.builder().visibility(Visibility.PRIVATE).className("Test").build(), (Object)"private class Test{\n\t\n}\n"), Triple.of((Object)"protected class Test{\n}\n", (Object)EditableJavaClass.builder().visibility(Visibility.PROTECTED).className("Test").build(), (Object)"protected class Test{\n\t\n}\n"), Triple.of((Object)"public class Test{\n}\n", (Object)EditableJavaClass.builder().visibility(Visibility.PUBLIC).className("Test").build(), (Object)"public class Test{\n\t\n}\n"), Triple.of((Object)"abstract class Test{\n}\n", (Object)EditableJavaClass.builder().isAbstract().className("Test").build(), (Object)"abstract class Test{\n\t\n}\n"), Triple.of((Object)"class Derp{\n\tstatic class Test{\n\t}\n}\n", (Object)EditableJavaClass.builder().innerClass(EditableJavaClass.builder().innerClass().isStatic().className("Test").build()).className("Derp").build(), (Object)"class Derp{\n\t\n\tstatic class Test{\n\t\t\n\t}\n\t\n}\n"), Triple.of((Object)"final class Test{\n}\n", (Object)EditableJavaClass.builder().isFinal().className("Test").build(), (Object)"final class Test{\n\t\n}\n"), Triple.of((Object)"final private class Derp{\n\tfinal static public class Test{\n\t}\n}\n", (Object)EditableJavaClass.builder().visibility(Visibility.PRIVATE).isFinal().innerClass(EditableJavaClass.builder().innerClass().visibility(Visibility.PUBLIC).isStatic().isFinal().className("Test").build()).className("Derp").build(), (Object)"private final class Derp{\n\t\n\tpublic static final class Test{\n\t\t\n\t}\n\t\n}\n"), Triple.of((Object)"class Test<T>{\n}\n", (Object)EditableJavaClass.builder().className("Test<T>").build(), (Object)"class Test<T>{\n\t\n}\n"), Triple.of((Object)"class Test <T>{\n}\n", (Object)EditableJavaClass.builder().className("Test<T>").build(), (Object)"class Test<T>{\n\t\n}\n"), Triple.of((Object)"class Test<T, S>{\n}\n", (Object)EditableJavaClass.builder().className("Test<T, S>").build(), (Object)"class Test<T, S>{\n\t\n}\n"), Triple.of((Object)"class Test<Map<String, Object>>{\n}\n", (Object)EditableJavaClass.builder().className("Test<Map<String, Object>>").build(), (Object)"class Test<Map<String, Object>>{\n\t\n}\n"), Triple.of((Object)"class Test<Character, Map<Character, ?>>{\n}\n", (Object)EditableJavaClass.builder().className("Test<Character, Map<Character, ?>>").build(), (Object)"class Test<Character, Map<Character, ?>>{\n\t\n}\n"), Triple.of((Object)"class Test<? extends List<String>, Object>{\n}\n", (Object)EditableJavaClass.builder().className("Test<? extends List<String>, Object>").build(), (Object)"class Test<? extends List<String>, Object>{\n\t\n}\n"), Triple.of((Object)"class Test extends Derp{\n}\n", (Object)EditableJavaClass.builder().className("Test").superClassName("Derp").build(), (Object)"class Test extends Derp{\n\t\n}\n"), Triple.of((Object)"class Test extends Derp<T>{\n}\n", (Object)EditableJavaClass.builder().className("Test").superClassName("Derp<T>").build(), (Object)"class Test extends Derp<T>{\n\t\n}\n"), Triple.of((Object)"class Test extends Derp<T, S>{\n}\n", (Object)EditableJavaClass.builder().className("Test").superClassName("Derp<T, S>").build(), (Object)"class Test extends Derp<T, S>{\n\t\n}\n"), Triple.of((Object)"class Test extends Derp <T, S>{\n}\n", (Object)EditableJavaClass.builder().className("Test").superClassName("Derp<T, S>").build(), (Object)"class Test extends Derp<T, S>{\n\t\n}\n"), Triple.of((Object)"class Test extends Derp<Map<String, Object>>{\n}\n", (Object)EditableJavaClass.builder().className("Test").superClassName("Derp<Map<String, Object>>").build(), (Object)"class Test extends Derp<Map<String, Object>>{\n\t\n}\n"), Triple.of((Object)"class Test extends Derp<Character, Map<Character, ?>>{\n}\n", (Object)EditableJavaClass.builder().className("Test").superClassName("Derp<Character, Map<Character, ?>>").build(), (Object)"class Test extends Derp<Character, Map<Character, ?>>{\n\t\n}\n"), Triple.of((Object)"class Test extends Derp<? extends List<String>, Object>{\n}\n", (Object)EditableJavaClass.builder().className("Test").superClassName("Derp<? extends List<String>, Object>").build(), (Object)"class Test extends Derp<? extends List<String>, Object>{\n\t\n}\n"), Triple.of((Object)"class Test implements Derp{\n}\n", (Object)EditableJavaClass.builder().className("Test").implementsInterfaceName("Derp").build(), (Object)"class Test implements Derp{\n\t\n}\n"), Triple.of((Object)"class Test implements Derp<String>{\n}\n", (Object)EditableJavaClass.builder().className("Test").implementsInterfaceName("Derp<String>").build(), (Object)"class Test implements Derp<String>{\n\t\n}\n"), Triple.of((Object)"class Test implements Derp<String, Object>{\n}\n", (Object)EditableJavaClass.builder().className("Test").implementsInterfaceName("Derp<String, Object>").build(), (Object)"class Test implements Derp<String, Object>{\n\t\n}\n"), Triple.of((Object)"class Test implements Derp<Map<String, Object>>{\n}\n", (Object)EditableJavaClass.builder().className("Test").implementsInterfaceName("Derp<Map<String, Object>>").build(), (Object)"class Test implements Derp<Map<String, Object>>{\n\t\n}\n"), Triple.of((Object)"class Test implements Derp<Character, Map<Character, ?>>{\n}\n", (Object)EditableJavaClass.builder().className("Test").implementsInterfaceName("Derp<Character, Map<Character, ?>>").build(), (Object)"class Test implements Derp<Character, Map<Character, ?>>{\n\t\n}\n"), Triple.of((Object)"class Test implements Derp<? extends List<String>, Object>{\n}\n", (Object)EditableJavaClass.builder().className("Test").implementsInterfaceName("Derp<? extends List<String>, Object>").build(), (Object)"class Test implements Derp<? extends List<String>, Object>{\n\t\n}\n"), Triple.of((Object)"class Test implements Derp, Blah{\n}\n", (Object)EditableJavaClass.builder().className("Test").implementsInterfaceName("Derp").implementsInterfaceName("Blah").build(), (Object)"class Test implements Derp, Blah{\n\t\n}\n"), Triple.of((Object)"class Test implements Derp<String>, Blah<String>{\n}\n", (Object)EditableJavaClass.builder().className("Test").implementsInterfaceName("Derp<String>").implementsInterfaceName("Blah<String>").build(), (Object)"class Test implements Derp<String>, Blah<String>{\n\t\n}\n"), Triple.of((Object)"class Test implements Derp<String, Object>, Blah<String, Object>{\n}\n", (Object)EditableJavaClass.builder().className("Test").implementsInterfaceName("Derp<String, Object>").implementsInterfaceName("Blah<String, Object>").build(), (Object)"class Test implements Derp<String, Object>, Blah<String, Object>{\n\t\n}\n"), Triple.of((Object)"class Test implements Derp<Map<String, Object>>, Blah<Map<String, Object>>{\n}\n", (Object)EditableJavaClass.builder().className("Test").implementsInterfaceName("Derp<Map<String, Object>>").implementsInterfaceName("Blah<Map<String, Object>>").build(), (Object)"class Test implements Derp<Map<String, Object>>, Blah<Map<String, Object>>{\n\t\n}\n"), Triple.of((Object)"class Test implements Derp<Character, Map<Character, ?>>, Blah<Character, Map<Character, ?>>{\n}\n", (Object)EditableJavaClass.builder().className("Test").implementsInterfaceName("Derp<Character, Map<Character, ?>>").implementsInterfaceName("Blah<Character, Map<Character, ?>>").build(), (Object)"class Test implements Derp<Character, Map<Character, ?>>, Blah<Character, Map<Character, ?>>{\n\t\n}\n"), Triple.of((Object)"class Test implements Derp<? extends List<String>, Object>, Blah<? extends List<String>, Object>{\n}\n", (Object)EditableJavaClass.builder().className("Test").implementsInterfaceName("Derp<? extends List<String>, Object>").implementsInterfaceName("Blah<? extends List<String>, Object>").build(), (Object)"class Test implements Derp<? extends List<String>, Object>, Blah<? extends List<String>, Object>{\n\t\n}\n"), Triple.of((Object)"class Test implements Derp,Blah{\n}\n", (Object)EditableJavaClass.builder().className("Test").implementsInterfaceName("Derp").implementsInterfaceName("Blah").build(), (Object)"class Test implements Derp, Blah{\n\t\n}\n"), Triple.of((Object)"class Test{\n\tstatic{\n\t\tdoSomething();\n\t}\n}\n", (Object)EditableJavaClass.builder().className("Test").staticCodeBlock(ListUtil.createList((Object[])new String[]{"doSomething();"})).build(), (Object)"class Test{\n\t\n\tstatic{\n\t\tdoSomething();\n\t}\n}\n"), Triple.of((Object)"class Test{\n\tstatic{\n\t\tdoSomething();\n\t\tdoSomethingElse();\n\t\tdoSomethingEvenMore();\n\t}\n}\n", (Object)EditableJavaClass.builder().className("Test").staticCodeBlock(ListUtil.createList((Object[])new String[]{"doSomething();", "doSomethingElse();", "doSomethingEvenMore();"})).build(), (Object)"class Test{\n\t\n\tstatic{\n\t\tdoSomething();\n\t\tdoSomethingElse();\n\t\tdoSomethingEvenMore();\n\t}\n}\n"), Triple.of((Object)"class Test{\n\tstatic{\n\t\tdoSomething();\n\t\tfor(int i = 0; i < 5; i++){\n\t\t\tdoSomethingElse();\n\t\t\tdoSomethingEvenMore();\n\t\t}\n\t}\n}\n", (Object)EditableJavaClass.builder().className("Test").staticCodeBlock(ListUtil.createList((Object[])new String[]{"doSomething();", "for(int i = 0; i < 5; i++){", "\tdoSomethingElse();", "\tdoSomethingEvenMore();", "}"})).build(), (Object)"class Test{\n\t\n\tstatic{\n\t\tdoSomething();\n\t\tfor(int i = 0; i < 5; i++){\n\t\t\tdoSomethingElse();\n\t\t\tdoSomethingEvenMore();\n\t\t}\n\t}\n}\n"), Triple.of((Object)"class Test{\n\tstatic{doSomething();}\n}\n", (Object)EditableJavaClass.builder().className("Test").staticCodeBlock(ListUtil.createList((Object[])new String[]{"doSomething();"})).build(), (Object)"class Test{\n\t\n\tstatic{\n\t\tdoSomething();\n\t}\n}\n"), Triple.of((Object)"class Test{\n\t// some comment\n}\n", (Object)EditableJavaClass.builder().className("Test").singleLineComment("some comment").build(), (Object)"class Test{\n\t\n\t// some comment\n}\n"), Triple.of((Object)"class Test{\n\t/*\n\t * some comment\n\t */\n}\n", (Object)EditableJavaClass.builder().className("Test").multiLineComment(new String[]{"some comment"}).build(), (Object)"class Test{\n\t\n\t/*\n\t * some comment\n\t */\n}\n"), Triple.of((Object)"class Test{\n\tclass Derp{\n\t}\n}\n", (Object)EditableJavaClass.builder().className("Test").innerClass(EditableJavaClass.builder().innerClass().className("Derp").build()).build(), (Object)"class Test{\n\t\n\tclass Derp{\n\t\t\n\t}\n\t\n}\n"), Triple.of((Object)"class Test{\n\tclass Derp{\n\t}\n\tclass Yep{\n\t}\n}\n", (Object)EditableJavaClass.builder().className("Test").innerClass(EditableJavaClass.builder().innerClass().className("Derp").build()).innerClass(EditableJavaClass.builder().innerClass().className("Yep").build()).build(), (Object)"class Test{\n\t\n\tclass Derp{\n\t\t\n\t}\n\t\n\tclass Yep{\n\t\t\n\t}\n\t\n}\n"), Triple.of((Object)"class Test{\n\tString name;\n}\n", (Object)EditableJavaClass.builder().className("Test").field(EditableJavaField.builder().type("String").name("name").build()).build(), (Object)"class Test{\n\t\n\tString name;\n}\n"), Triple.of((Object)"class Test{\n\tString name;\n\tint derp;\n}\n", (Object)EditableJavaClass.builder().className("Test").field(EditableJavaField.builder().type("String").name("name").build()).field(EditableJavaField.builder().type("int").name("derp").build()).build(), (Object)"class Test{\n\t\n\tString name;\n\tint derp;\n}\n"), Triple.of((Object)"class Test{\n\tString type(){}\n}\n", (Object)EditableJavaClass.builder().className("Test").method(EditableJavaMethod.builder().returnType("String").name("type").build()).build(), (Object)"class Test{\n\t\n\tString type(){ }\n}\n"), Triple.of((Object)"class Test{\n\tString type(){}\n\tint getVersion(){}\n}\n", (Object)EditableJavaClass.builder().className("Test").method(EditableJavaMethod.builder().returnType("String").name("type").build()).method(EditableJavaMethod.builder().returnType("int").name("getVersion").build()).build(), (Object)"class Test{\n\t\n\tString type(){ }\n\t\n\tint getVersion(){ }\n}\n"), Triple.of((Object)"package com.example;\n\nimport com.example.Something;\n\nimport org.example.SomethingElse;\n\nimport static com.example.SomethingStatic;\n\nimport static org.example.SomethingElseStatic;\n\n/**\n * Something here\n * \n * @author Logan Ferree (Tadukoo)\n * @version Alpha v.0.1\n */\n@Example\n@Test(true)\n@Yep(type=String.class)\npublic final class Test extends Derp implements Blah, Foo{\n\t\n\t// some comment\n\t/*\n\t * some comment\n\t */\n\tclass Derp{\n\t}\n\t\n\tclass Yep{\n\t}\n\t\n\tString name;\n\tint derp;\n\t\n\tString type(){}\n\tint getVersion(){}\n}\n", (Object)EditableJavaClass.builder().packageDeclaration(EditableJavaPackageDeclaration.builder().packageName("com.example").build()).importStatement(EditableJavaImportStatement.builder().importName("com.example.Something").build()).importStatement(EditableJavaImportStatement.builder().importName("org.example.SomethingElse").build()).importStatement(EditableJavaImportStatement.builder().isStatic().importName("com.example.SomethingStatic").build()).importStatement(EditableJavaImportStatement.builder().isStatic().importName("org.example.SomethingElseStatic").build()).javadoc(EditableJavadoc.builder().content("Something here").author("Logan Ferree (Tadukoo)").version("Alpha v.0.1").build()).annotation(EditableJavaAnnotation.builder().name("Example").build()).annotation(EditableJavaAnnotation.builder().name("Test").parameter("value", "true").build()).annotation(EditableJavaAnnotation.builder().name("Yep").parameter("type", "String.class").build()).visibility(Visibility.PUBLIC).isFinal().className("Test").superClassName("Derp").implementsInterfaceName("Blah").implementsInterfaceName("Foo").singleLineComment(EditableJavaSingleLineComment.builder().content("some comment").build()).multiLineComment(EditableJavaMultiLineComment.builder().content("some comment").build()).innerClass(EditableJavaClass.builder().innerClass().className("Derp").build()).innerClass(EditableJavaClass.builder().innerClass().className("Yep").build()).field(EditableJavaField.builder().type("String").name("name").build()).field(EditableJavaField.builder().type("int").name("derp").build()).method(EditableJavaMethod.builder().returnType("String").name("type").build()).method(EditableJavaMethod.builder().returnType("int").name("getVersion").build()).build(), (Object)"package com.example;\n\nimport com.example.Something;\n\nimport org.example.SomethingElse;\n\nimport static com.example.SomethingStatic;\n\nimport static org.example.SomethingElseStatic;\n\n/**\n * Something here\n * \n * @author Logan Ferree (Tadukoo)\n * @version Alpha v.0.1\n */\n@Example\n@Test(true)\n@Yep(type = String.class)\npublic final class Test extends Derp implements Blah, Foo{\n\t\n\t// some comment\n\t/*\n\t * some comment\n\t */\n\t\n\tclass Derp{\n\t\t\n\t}\n\t\n\tclass Yep{\n\t\t\n\t}\n\t\n\tString name;\n\tint derp;\n\t\n\tString type(){ }\n\t\n\tint getVersion(){ }\n}\n"), Triple.of((Object)"package com.example;\n\nimport com.example.Something;\n\nimport org.example.SomethingElse;\n\nimport static com.example.SomethingStatic;\n\nimport static org.example.SomethingElseStatic;\n\n/**\n * Something here\n * \n * @author Logan Ferree (Tadukoo)\n * @version Alpha v.0.1\n */\n@Example\n@Test(true)\n@Yep(type=String.class)\npublic final class Test extends Derp implements Blah, Foo{\n\t\n\t// some comment\n\t/*\n\t * some comment\n\t */\n\t/**\n\t * Something here\n\t * \n\t * @author Logan Ferree (Tadukoo)\n\t * @version Alpha v.0.1\n\t */\n\t@Test\n\t@Yep(true)\n\tprivate static final class Derp extends Blah implements Blah, Foo{\n\t\t// some comment\n\t\t/*\n\t\t * some comment\n\t\t */\n\t\t@Test\n\t\t@Derp(type = String.class)\n\t\tprotected static final String derp = \"Blah\";\n\t\t/** It's something alright */\n\t\t@Blah\n\t\tprotected int something;\n\t\t\n\t\t/**\n\t\t * @return the Version\n\t\t */\n\t\t@Blah\n\t\tprivate int getVersion(){return version;}\n\t\t\n\t\t@Test\n\t\t@Derp(type=String.class)\n\t\tprivate static String test(String type, int derp) throws Exception, Throwable{doSomething();doSomethingElse();}\n\t}\n\t\n\t/**\n\t * Something here\n\t * \n\t * @author Logan Ferree (Tadukoo)\n\t * @version Alpha v.0.1\n\t */\n\t@Derp\n\t@Yep(something=\"no\")\n\tprotected static final class Yep extends Something implements Blah, Foo{\n\t\t// some comment\n\t\t/*\n\t\t * some comment\n\t\t */\n\t\tpublic static final String someName = \"Test\";\n\t\t/** This is something else */\n\t\tprivate int somethingElse;\n\t\t\n\t\t/**\n\t\t * @return the Version\n\t\t */\n\t\t@Blah\n\t\tprivate int getVersion(){return version;}\n\t\t\n\t\t@Test\n\t\t@Derp(type=String.class)\n\t\tprivate static String test(String type, int derp) throws Exception, Throwable{doSomething();doSomethingElse();}\n\t}\n\t\n\t@Test\n\t@Derp(type = String.class)\n\tprivate static final String name = \"Test\";\n\t@Blah\n\tpublic int version;\n\t\n\t@Blah\n\tprivate int getVersion(){return version;}\n\t\n\t@Test\n\t@Derp(type=String.class)\n\tprivate static String test(String type, int derp) throws Exception, Throwable{doSomething();doSomethingElse();}\n}\n", (Object)EditableJavaClass.builder().packageDeclaration(EditableJavaPackageDeclaration.builder().packageName("com.example").build()).importStatement(EditableJavaImportStatement.builder().importName("com.example.Something").build()).importStatement(EditableJavaImportStatement.builder().importName("org.example.SomethingElse").build()).importStatement(EditableJavaImportStatement.builder().isStatic().importName("com.example.SomethingStatic").build()).importStatement(EditableJavaImportStatement.builder().isStatic().importName("org.example.SomethingElseStatic").build()).javadoc(EditableJavadoc.builder().content("Something here").author("Logan Ferree (Tadukoo)").version("Alpha v.0.1").build()).annotation(EditableJavaAnnotation.builder().name("Example").build()).annotation(EditableJavaAnnotation.builder().name("Test").parameter("value", "true").build()).annotation(EditableJavaAnnotation.builder().name("Yep").parameter("type", "String.class").build()).visibility(Visibility.PUBLIC).isFinal().className("Test").superClassName("Derp").implementsInterfaceName("Blah").implementsInterfaceName("Foo").singleLineComment(EditableJavaSingleLineComment.builder().content("some comment").build()).multiLineComment(EditableJavaMultiLineComment.builder().content("some comment").build()).innerClass(EditableJavaClass.builder().innerClass().javadoc(EditableJavadoc.builder().content("Something here").author("Logan Ferree (Tadukoo)").version("Alpha v.0.1").build()).annotation(EditableJavaAnnotation.builder().name("Test").build()).annotation(EditableJavaAnnotation.builder().name("Yep").parameter("value", "true").build()).visibility(Visibility.PRIVATE).isStatic().isFinal().className("Derp").superClassName("Blah").implementsInterfaceName("Blah").implementsInterfaceName("Foo").singleLineComment(EditableJavaSingleLineComment.builder().content("some comment").build()).multiLineComment(EditableJavaMultiLineComment.builder().content("some comment").build()).field(EditableJavaField.builder().annotation(EditableJavaAnnotation.builder().name("Test").build()).annotation(EditableJavaAnnotation.builder().name("Derp").parameter("type", "String.class").build()).visibility(Visibility.PROTECTED).isStatic().isFinal().type("String").name("derp").value("\"Blah\"").build()).field(EditableJavaField.builder().javadoc(EditableJavadoc.builder().condensed().content("It's something alright").build()).annotation(EditableJavaAnnotation.builder().name("Blah").build()).visibility(Visibility.PROTECTED).type("int").name("something").build()).method(EditableJavaMethod.builder().javadoc(EditableJavadoc.builder().returnVal("the Version").build()).annotation(EditableJavaAnnotation.builder().name("Blah").build()).visibility(Visibility.PRIVATE).returnType("int").name("getVersion").line("return version;").build()).method(EditableJavaMethod.builder().annotation(EditableJavaAnnotation.builder().name("Test").build()).annotation(EditableJavaAnnotation.builder().name("Derp").parameter("type", "String.class").build()).visibility(Visibility.PRIVATE).isStatic().returnType("String").name("test").parameter("String type").parameter("int derp").throwType("Exception").throwType("Throwable").line("doSomething();").line("doSomethingElse();").build()).build()).innerClass(EditableJavaClass.builder().innerClass().javadoc(EditableJavadoc.builder().content("Something here").author("Logan Ferree (Tadukoo)").version("Alpha v.0.1").build()).annotation(EditableJavaAnnotation.builder().name("Derp").build()).annotation(EditableJavaAnnotation.builder().name("Yep").parameter("something", "\"no\"").build()).visibility(Visibility.PROTECTED).isStatic().isFinal().className("Yep").superClassName("Something").implementsInterfaceName("Blah").implementsInterfaceName("Foo").singleLineComment(EditableJavaSingleLineComment.builder().content("some comment").build()).multiLineComment(EditableJavaMultiLineComment.builder().content("some comment").build()).field(EditableJavaField.builder().visibility(Visibility.PUBLIC).isStatic().isFinal().type("String").name("someName").value("\"Test\"").build()).field(EditableJavaField.builder().javadoc(EditableJavadoc.builder().condensed().content("This is something else").build()).visibility(Visibility.PRIVATE).type("int").name("somethingElse").build()).method(EditableJavaMethod.builder().javadoc(EditableJavadoc.builder().returnVal("the Version").build()).annotation(EditableJavaAnnotation.builder().name("Blah").build()).visibility(Visibility.PRIVATE).returnType("int").name("getVersion").line("return version;").build()).method(EditableJavaMethod.builder().annotation(EditableJavaAnnotation.builder().name("Test").build()).annotation(EditableJavaAnnotation.builder().name("Derp").parameter("type", "String.class").build()).visibility(Visibility.PRIVATE).isStatic().returnType("String").name("test").parameter("String type").parameter("int derp").throwType("Exception").throwType("Throwable").line("doSomething();").line("doSomethingElse();").build()).build()).field(EditableJavaField.builder().annotation(EditableJavaAnnotation.builder().name("Test").build()).annotation(EditableJavaAnnotation.builder().name("Derp").parameter("type", "String.class").build()).visibility(Visibility.PRIVATE).isStatic().isFinal().type("String").name("name").value("\"Test\"").build()).field(EditableJavaField.builder().annotation(EditableJavaAnnotation.builder().name("Blah").build()).visibility(Visibility.PUBLIC).type("int").name("version").build()).method(EditableJavaMethod.builder().annotation(EditableJavaAnnotation.builder().name("Blah").build()).visibility(Visibility.PRIVATE).returnType("int").name("getVersion").line("return version;").build()).method(EditableJavaMethod.builder().annotation(EditableJavaAnnotation.builder().name("Test").build()).annotation(EditableJavaAnnotation.builder().name("Derp").parameter("type", "String.class").build()).visibility(Visibility.PRIVATE).isStatic().returnType("String").name("test").parameter("String type").parameter("int derp").throwType("Exception").throwType("Throwable").line("doSomething();").line("doSomethingElse();").build()).build(), (Object)"package com.example;\n\nimport com.example.Something;\n\nimport org.example.SomethingElse;\n\nimport static com.example.SomethingStatic;\n\nimport static org.example.SomethingElseStatic;\n\n/**\n * Something here\n * \n * @author Logan Ferree (Tadukoo)\n * @version Alpha v.0.1\n */\n@Example\n@Test(true)\n@Yep(type = String.class)\npublic final class Test extends Derp implements Blah, Foo{\n\t\n\t// some comment\n\t/*\n\t * some comment\n\t */\n\t\n\t/**\n\t * Something here\n\t * \n\t * @author Logan Ferree (Tadukoo)\n\t * @version Alpha v.0.1\n\t */\n\t@Test\n\t@Yep(true)\n\tprivate static final class Derp extends Blah implements Blah, Foo{\n\t\t\n\t\t// some comment\n\t\t/*\n\t\t * some comment\n\t\t */\n\t\t\n\t\t@Test\n\t\t@Derp(type = String.class)\n\t\tprotected static final String derp = \"Blah\";\n\t\t/** It's something alright */\n\t\t@Blah\n\t\tprotected int something;\n\t\t\n\t\t/**\n\t\t * @return the Version\n\t\t */\n\t\t@Blah\n\t\tprivate int getVersion(){\n\t\t\treturn version;\n\t\t}\n\t\t\n\t\t@Test\n\t\t@Derp(type = String.class)\n\t\tprivate static String test(String type, int derp) throws Exception, Throwable{\n\t\t\tdoSomething();\n\t\t\tdoSomethingElse();\n\t\t}\n\t}\n\t\n\t/**\n\t * Something here\n\t * \n\t * @author Logan Ferree (Tadukoo)\n\t * @version Alpha v.0.1\n\t */\n\t@Derp\n\t@Yep(something = \"no\")\n\tprotected static final class Yep extends Something implements Blah, Foo{\n\t\t\n\t\t// some comment\n\t\t/*\n\t\t * some comment\n\t\t */\n\t\t\n\t\tpublic static final String someName = \"Test\";\n\t\t/** This is something else */\n\t\tprivate int somethingElse;\n\t\t\n\t\t/**\n\t\t * @return the Version\n\t\t */\n\t\t@Blah\n\t\tprivate int getVersion(){\n\t\t\treturn version;\n\t\t}\n\t\t\n\t\t@Test\n\t\t@Derp(type = String.class)\n\t\tprivate static String test(String type, int derp) throws Exception, Throwable{\n\t\t\tdoSomething();\n\t\t\tdoSomethingElse();\n\t\t}\n\t}\n\t\n\t@Test\n\t@Derp(type = String.class)\n\tprivate static final String name = \"Test\";\n\t@Blah\n\tpublic int version;\n\t\n\t@Blah\n\tprivate int getVersion(){\n\t\treturn version;\n\t}\n\t\n\t@Test\n\t@Derp(type = String.class)\n\tprivate static String test(String type, int derp) throws Exception, Throwable{\n\t\tdoSomething();\n\t\tdoSomethingElse();\n\t}\n}\n"), Triple.of((Object)"\t  \t\n\t class Test{\n}\n", (Object)EditableJavaClass.builder().className("Test").build(), (Object)"class Test{\n\t\n}\n"), Triple.of((Object)"class \t \t\n  \t \tTest{\n}\n", (Object)EditableJavaClass.builder().className("Test").build(), (Object)"class Test{\n\t\n}\n"), Triple.of((Object)"class Test  \t\n\t  {\n}\n", (Object)EditableJavaClass.builder().className("Test").build(), (Object)"class Test{\n\t\n}\n"), Triple.of((Object)"class Test{\t   \t\n\n\t\n}\n", (Object)EditableJavaClass.builder().className("Test").build(), (Object)"class Test{\n\t\n}\n"), Triple.of((Object)"class Test  \t\n\t  {\n}\t    \t\n\t\n", (Object)EditableJavaClass.builder().className("Test").build(), (Object)"class Test{\n\t\n}\n"), Triple.of((Object)"\t  \t\n\t class \t \t\n  \t \tTest{\t   \t\n\t\t \n\t\n}\t    \t\n\t\n", (Object)EditableJavaClass.builder().className("Test").build(), (Object)"class Test{\n\t\n}\n"), Triple.of((Object)"\t     \t\n\t  package com.example;\n\nclass Test{\n}\n", (Object)EditableJavaClass.builder().packageName("com.example").className("Test").build(), (Object)"package com.example;\n\nclass Test{\n\t\n}\n"), Triple.of((Object)"package \t  \t\n\t  com.example;\n\nclass Test{\n}\n", (Object)EditableJavaClass.builder().packageName("com.example").className("Test").build(), (Object)"package com.example;\n\nclass Test{\n\t\n}\n"), Triple.of((Object)"package com     \t\n\n\t    .\t \t\n\t     example;\n\nclass Test{\n}\n", (Object)EditableJavaClass.builder().packageName("com.example").className("Test").build(), (Object)"package com.example;\n\nclass Test{\n\t\n}\n"), Triple.of((Object)"package com.example\n\t   \t;\n\nclass Test{\n}\n", (Object)EditableJavaClass.builder().packageName("com.example").className("Test").build(), (Object)"package com.example;\n\nclass Test{\n\t\n}\n"), Triple.of((Object)"package com.example;\t  \t\n\nclass Test{\n}\n", (Object)EditableJavaClass.builder().packageName("com.example").className("Test").build(), (Object)"package com.example;\n\nclass Test{\n\t\n}\n"), Triple.of((Object)"\t     \t\n\t  package \t  \t\n\t  com     \t\n\n\t    .\t \t\n\t     example\n\t   \t;\t  \t\n\nclass Test{\n}\n", (Object)EditableJavaClass.builder().packageName("com.example").className("Test").build(), (Object)"package com.example;\n\nclass Test{\n\t\n}\n"), Triple.of((Object)"\t   \t\n\t  import com.example;\n\nclass Test{\n}\n", (Object)EditableJavaClass.builder().importName("com.example", false).className("Test").build(), (Object)"import com.example;\n\nclass Test{\n\t\n}\n"), Triple.of((Object)"import \t \n\t     com.example;\n\nclass Test{\n}\n", (Object)EditableJavaClass.builder().importName("com.example", false).className("Test").build(), (Object)"import com.example;\n\nclass Test{\n\t\n}\n"), Triple.of((Object)"import com     \t\n\n\t    .\t        \n\t      example;\n\nclass Test{\n}\n", (Object)EditableJavaClass.builder().importName("com.example", false).className("Test").build(), (Object)"import com.example;\n\nclass Test{\n\t\n}\n"), Triple.of((Object)"import com.example     \t\n\n\t      ;\n\nclass Test{\n}\n", (Object)EditableJavaClass.builder().importName("com.example", false).className("Test").build(), (Object)"import com.example;\n\nclass Test{\n\t\n}\n"), Triple.of((Object)"import    \t\n \t     static com.example;\n\nclass Test{\n}\n", (Object)EditableJavaClass.builder().importName("com.example", true).className("Test").build(), (Object)"import static com.example;\n\nclass Test{\n\t\n}\n"), Triple.of((Object)"import static   \t\n \t     com.example;\n\nclass Test{\n}\n", (Object)EditableJavaClass.builder().importName("com.example", true).className("Test").build(), (Object)"import static com.example;\n\nclass Test{\n\t\n}\n"), Triple.of((Object)"\t   \t\n\t  import    \t\n \t     static   \t\n \t     com     \t\n\t \n\t    .\t        \n\t      example     \t\n\n\t      ;\n\nclass Test{\n}\n", (Object)EditableJavaClass.builder().importName("com.example", true).className("Test").build(), (Object)"import static com.example;\n\nclass Test{\n\t\n}\n"), Triple.of((Object)"\t  \t @ \t  \tTest\t  (\t \ttype \t = \n  \t  \t  String.class\t  , \t  \t defaultValue \t = \t  \t\"\"  \t )    \t\n\nclass Test{\n}\n", (Object)EditableJavaClass.builder().annotation(EditableJavaAnnotation.builder().name("Test").parameter("type", "String.class").parameter("defaultValue", "\"\"").build()).className("Test").build(), (Object)"@Test(type = String.class, defaultValue = \"\")\nclass Test{\n\t\n}\n"), Triple.of((Object)"class Test implements Test ,Derp{\n}", (Object)EditableJavaClass.builder().className("Test").implementsInterfaceName("Test").implementsInterfaceName("Derp").build(), (Object)"class Test implements Test, Derp{\n\t\n}\n"), Triple.of((Object)"class Test implements Test , Derp{\n}", (Object)EditableJavaClass.builder().className("Test").implementsInterfaceName("Test").implementsInterfaceName("Derp").build(), (Object)"class Test implements Test, Derp{\n\t\n}\n"), Triple.of((Object)"class Test{\n\t\t  \t @ \t  \tTest\t  (\t \ttype \t = \t\n\t  \t  String.class\t  , \t  \t defaultValue \t = \t  \t\"\"  \t )    \t\t     \t\n  \t\n \t    \t@       Derp   \t\n   \t public\t     \t\n   \t static\t     \t\n   \t final\t     \t  \t\n \tString \t  \t\n \t  type    \t   \t\n  \t =    \t   \t\n  \t \"\" \t  \t\n\t;     \t\n \t   \n}\n", (Object)EditableJavaClass.builder().className("Test").field(EditableJavaField.builder().annotation(EditableJavaAnnotation.builder().name("Test").parameter("type", "String.class").parameter("defaultValue", "\"\"").build()).annotation(EditableJavaAnnotation.builder().name("Derp").build()).visibility(Visibility.PUBLIC).isStatic().isFinal().type("String").name("type").value("\"\"").build()).build(), (Object)"class Test{\n\t\n\t@Test(type = String.class, defaultValue = \"\")\n\t@Derp\n\tpublic static final String type = \"\";\n}\n"), Triple.of((Object)"class Test{\n\t\t  \t @ \t  \tTest\t  (\t \ttype \t = \t\n\t\t  \t  String.class\t  , \t  \t defaultValue \t = \t  \t\"\"  \t )    \t\t     \t\n\t\t    \t@       Derp   \t\n\t\t\t   \t\n\t\t\t    private     \t   \t\n\t\t    static     \t   \t\n\t\t    String     \t   \t\n\t\t    test     \t   \t\n\t\t    (     \t   \t\n\t\t    String     \t   \t\n\t\t    type     \t   \t\n\t\t    ,     \t   \t\n\t\t    int     \t   \t\n\t\t    derp     \t   \t\n\t\t    )     \t   \t\n\t\t    throws     \t   \t\n\t\t    Exception     \t   \t\n\t\t    ,     \t   \t\n\t\t    Throwable     \t   \t\n\t\t    {     \t   \t\n\t\t    doSomething()     \t   \t\n\t\t    ;     \t   \t\n\t\t    doSomethingElse()     \t   \t\n\t\t    ;     \t   \t\n\t\t    }     \t   \t\n\t\t     \n}", (Object)EditableJavaClass.builder().className("Test").method(EditableJavaMethod.builder().annotation(EditableJavaAnnotation.builder().name("Test").parameter("type", "String.class").parameter("defaultValue", "\"\"").build()).annotation(EditableJavaAnnotation.builder().name("Derp").build()).visibility(Visibility.PRIVATE).isStatic().returnType("String").name("test").parameter("String type").parameter("int derp").throwType("Exception").throwType("Throwable").line("doSomething();").line("doSomethingElse();").build()).build(), (Object)"class Test{\n\t\n\t@Test(type = String.class, defaultValue = \"\")\n\t@Derp\n\tprivate static String test(String type, int derp) throws Exception, Throwable{\n\t\tdoSomething();\n\t\tdoSomethingElse();\n\t}\n}\n"), Triple.of((Object)"\t     \t\n\t  package \t  \t\n\t  com     \t\n\n\t    .\t \t\n\t     example\n\t   \t;\t  \t\n\n\t   \t\n\t  import    \t\n \t        \t\n \t     com     \t\n\t \n\t    .\t        \n\t      example     \t\n   .Something   \t\n\t      ;\n\t import     com.example.SomethingElse      \t;\t     \t    \t\n\n\t   \t\n\t  import    \t\n \t     static   \t\n \t     com     \t\n\t \n\t    .\t        \n\t      example     \t\n\t\t\t\t.SomethingStatic     \t\n\t      ;\n\t  \t import \t      \t static\t  com.example.SomethingElseStatic\t \t  ;\t     \t\n\n\t  \t @ \t  \tTest\t  (\t \ttype \t = \n  \t  \t  String.class\t  , \t  \t defaultValue \t = \t  \t\"\"  \t )    \t\n\n\npublic\t  \t\n\t final\t  \t\n\t    class \t \t\n  \t \tTest{\t   \t\n\t\t \n\t  \t @ \t  \tTest\t  (\t \ttype \t = \t\n\t  \t  String.class\t  , \t  \t defaultValue \t = \t  \t\"\"  \t )    \t\t     \t\n  \t\n \t    \t@       Derp   \t\n   \t public\t     \t\n   \t static\t     \t\n   \t final\t     \t  \t\n \tString \t  \t\n \t  type    \t   \t\n  \t =    \t   \t\n  \t \"\" \t  \t\n\t;     \t\n \t   \n \t  \t @ \t  \tTest\t  (\t \ttype \t = \t\n\t\t  \t  String.class\t  , \t  \t defaultValue \t = \t  \t\"\"  \t )    \t\t     \t\n\t\t    \t@       Derp   \t\n\t\t\t   \t\n\t\t\t    private     \t   \t\n\t\t    static     \t   \t\n\t\t    String     \t   \t\n\t\t    test     \t   \t\n\t\t    (     \t   \t\n\t\t    String     \t   \t\n\t\t    type     \t   \t\n\t\t    ,     \t   \t\n\t\t    int     \t   \t\n\t\t    derp     \t   \t\n\t\t    )     \t   \t\n\t\t    throws     \t   \t\n\t\t    Exception     \t   \t\n\t\t    ,     \t   \t\n\t\t    Throwable     \t   \t\n\t\t    {     \t   \t\n\t\t    doSomething()     \t   \t\n\t\t    ;     \t   \t\n\t\t    doSomethingElse()     \t   \t\n\t\t    ;     \t   \t\n\t\t    }     \t   \t\n\t\t     \n\t\n}\t    \t\n\t\n", (Object)EditableJavaClass.builder().packageDeclaration(EditableJavaPackageDeclaration.builder().packageName("com.example").build()).importStatement(EditableJavaImportStatement.builder().importName("com.example.Something").build()).importStatement(EditableJavaImportStatement.builder().importName("com.example.SomethingElse").build()).importStatement(EditableJavaImportStatement.builder().isStatic().importName("com.example.SomethingStatic").build()).importStatement(EditableJavaImportStatement.builder().isStatic().importName("com.example.SomethingElseStatic").build()).annotation(EditableJavaAnnotation.builder().name("Test").parameter("type", "String.class").parameter("defaultValue", "\"\"").build()).visibility(Visibility.PUBLIC).isFinal().className("Test").field(EditableJavaField.builder().annotation(EditableJavaAnnotation.builder().name("Test").parameter("type", "String.class").parameter("defaultValue", "\"\"").build()).annotation(EditableJavaAnnotation.builder().name("Derp").build()).visibility(Visibility.PUBLIC).isStatic().isFinal().type("String").name("type").value("\"\"").build()).method(EditableJavaMethod.builder().annotation(EditableJavaAnnotation.builder().name("Test").parameter("type", "String.class").parameter("defaultValue", "\"\"").build()).annotation(EditableJavaAnnotation.builder().name("Derp").build()).visibility(Visibility.PRIVATE).isStatic().returnType("String").name("test").parameter("String type").parameter("int derp").throwType("Exception").throwType("Throwable").line("doSomething();").line("doSomethingElse();").build()).build(), (Object)"package com.example;\n\nimport com.example.Something;\nimport com.example.SomethingElse;\n\nimport static com.example.SomethingElseStatic;\nimport static com.example.SomethingStatic;\n\n@Test(type = String.class, defaultValue = \"\")\npublic final class Test{\n\t\n\t@Test(type = String.class, defaultValue = \"\")\n\t@Derp\n\tpublic static final String type = \"\";\n\t\n\t@Test(type = String.class, defaultValue = \"\")\n\t@Derp\n\tprivate static String test(String type, int derp) throws Exception, Throwable{\n\t\tdoSomething();\n\t\tdoSomethingElse();\n\t}\n}\n"), Triple.of((Object)"package com.github.tadukoo.view.form.field.string;\n\nimport com.github.tadukoo.view.components.TadukooLabel;\nimport com.github.tadukoo.view.form.field.FormField;\nimport com.github.tadukoo.view.form.field.annotation.FormFieldBuilder;\n\nimport javax.swing.JComponent;\nimport javax.swing.JLabel;\n\n/**\r\n * Represents a {@link FormField} for a Label\n * \n * @author Logan Ferree (Tadukoo)\n * @version Alpha v.0.4\n */\n@FormFieldBuilder(type = String.class, defaultDefaultValue = \"\\\"\\\"\")\npublic class BetterLabelFormField extends FormField<String>{\n\t\n\t/** {@inheritDoc} */\n\t@Override\n\tpublic JComponent getJustComponent() throws Throwable{\n\t\treturn TadukooLabel.builder()\n\t\t\t\t.text(getDefaultValue())\n\t\t\t\t.foregroundPaint(getLabelForegroundPaint()).backgroundPaint(getLabelBackgroundPaint())\n\t\t\t\t.font(getLabelFontFamily(), getLabelFontStyle(), getLabelFontSize())\n\t\t\t\t.shapeInfo(getLabelShape()).border(getLabelBorder())\n\t\t\t\t.fontResourceLoader(getFontResourceLoader())\n\t\t\t\t.build();\n\t}\n\t\n\t/** {@inheritDoc} */\n\t@Override\n\tpublic String getValueFromJustComponent(JComponent component){\n\t\tif(component instanceof JLabel label){\n\t\t\treturn label.getText();\n\t\t}\n\t\treturn null;\n\t}\n}\n", (Object)EditableJavaClass.builder().packageName("com.github.tadukoo.view.form.field.string").importNames(ListUtil.createList((Object[])new String[]{"com.github.tadukoo.view.components.TadukooLabel", "com.github.tadukoo.view.form.field.FormField", "com.github.tadukoo.view.form.field.annotation.FormFieldBuilder", "javax.swing.JComponent", "javax.swing.JLabel"}), false).javadoc(EditableJavadoc.builder().content("Represents a {@link FormField} for a Label").author("Logan Ferree (Tadukoo)").version("Alpha v.0.4").build()).annotation(EditableJavaAnnotation.builder().name("FormFieldBuilder").parameter("type", "String.class").parameter("defaultDefaultValue", "\"\\\"\\\"\"").build()).visibility(Visibility.PUBLIC).className("BetterLabelFormField").superClassName("FormField<String>").method(EditableJavaMethod.builder().javadoc(EditableJavadoc.builder().condensed().content("{@inheritDoc}").build()).annotation(EditableJavaAnnotation.builder().name("Override").build()).visibility(Visibility.PUBLIC).returnType("JComponent").name("getJustComponent").throwType("Throwable").line("return TadukooLabel.builder()").line("\t\t.text(getDefaultValue())").line("\t\t.foregroundPaint(getLabelForegroundPaint()).backgroundPaint(getLabelBackgroundPaint())").line("\t\t.font(getLabelFontFamily(), getLabelFontStyle(), getLabelFontSize())").line("\t\t.shapeInfo(getLabelShape()).border(getLabelBorder())").line("\t\t.fontResourceLoader(getFontResourceLoader())").line("\t\t.build();").build()).method(EditableJavaMethod.builder().javadoc(EditableJavadoc.builder().condensed().content("{@inheritDoc}").build()).annotation(EditableJavaAnnotation.builder().name("Override").build()).visibility(Visibility.PUBLIC).returnType("String").name("getValueFromJustComponent").parameter("JComponent component").line("if(component instanceof JLabel label){").line("\treturn label.getText();").line("}").line("return null;").build()).build(), (Object)"package com.github.tadukoo.view.form.field.string;\n\nimport com.github.tadukoo.view.components.TadukooLabel;\nimport com.github.tadukoo.view.form.field.FormField;\nimport com.github.tadukoo.view.form.field.annotation.FormFieldBuilder;\n\nimport javax.swing.JComponent;\nimport javax.swing.JLabel;\n\n/**\n * Represents a {@link FormField} for a Label\n * \n * @author Logan Ferree (Tadukoo)\n * @version Alpha v.0.4\n */\n@FormFieldBuilder(type = String.class, defaultDefaultValue = \"\\\"\\\"\")\npublic class BetterLabelFormField extends FormField<String>{\n\t\n\t/** {@inheritDoc} */\n\t@Override\n\tpublic JComponent getJustComponent() throws Throwable{\n\t\treturn TadukooLabel.builder()\n\t\t\t\t.text(getDefaultValue())\n\t\t\t\t.foregroundPaint(getLabelForegroundPaint()).backgroundPaint(getLabelBackgroundPaint())\n\t\t\t\t.font(getLabelFontFamily(), getLabelFontStyle(), getLabelFontSize())\n\t\t\t\t.shapeInfo(getLabelShape()).border(getLabelBorder())\n\t\t\t\t.fontResourceLoader(getFontResourceLoader())\n\t\t\t\t.build();\n\t}\n\t\n\t/** {@inheritDoc} */\n\t@Override\n\tpublic String getValueFromJustComponent(JComponent component){\n\t\tif(component instanceof JLabel label){\n\t\t\treturn label.getText();\n\t\t}\n\t\treturn null;\n\t}\n}\n")});
        return parsingData.stream().flatMap(triple -> Stream.of(0, 1).map(index -> Arguments.of((Object[])new Object[]{parseMethods.get((int)index), triple.getLeft(), triple.getMiddle(), triple.getRight()})));
    }

    @ParameterizedTest
    @MethodSource(value={"getParsingData"})
    public void testParsing(ThrowingFunction<String, JavaClass, JavaParsingException> parseMethod, String textToParse, JavaClass expectedClass, String expectedText) throws JavaParsingException {
        JavaClass clazz = (JavaClass)parseMethod.apply((Object)textToParse);
        Assertions.assertNotNull((Object)clazz);
        Assertions.assertEquals((Object)expectedClass, (Object)clazz);
        Assertions.assertEquals((Object)expectedText, (Object)clazz.toString());
    }

    public static Stream<Arguments> getErrorData() {
        List parsingData = ListUtil.createList((Object[])new Pair[]{Pair.of((Object)"class", (Object)"Failed to find class name!"), Pair.of((Object)"class Test{ extends\n}", (Object)"found 'extends' after hitting the block open token!"), Pair.of((Object)"class Test extends", (Object)"Failed to find super class name after 'extends'!"), Pair.of((Object)"class Test{ implements\n}", (Object)"found 'implements' after hitting the block open token!"), Pair.of((Object)"class Test implements", (Object)"Failed to find implements interface name after 'implements' or ','!"), Pair.of((Object)"class Test implements , {\n}", (Object)"Encountered ',' before any interface names!"), Pair.of((Object)"class Test implements Test ,", (Object)"Failed to find implements interface name after 'implements' or ','!"), Pair.of((Object)"class Test{{\n}", (Object)"We hit the block open token twice for the same class!"), Pair.of((Object)"class Test{\n\tsomething yep it is\n}", (Object)"Unable to determine token: 'something'"), Pair.of((Object)"class Test{\n\t/** {@inheritDoc} */\n}", (Object)"Found Javadoc at end of class with nothing to attach it to!"), Pair.of((Object)"class Test{\n\t@Test\n}", (Object)"Found annotations at end of class with nothing to attach them to!")});
        return parsingData.stream().flatMap(pair -> Stream.of(0, 1).map(index -> Arguments.of((Object[])new Object[]{parseMethods.get((int)index), pair.getLeft(), pair.getRight()})));
    }

    @ParameterizedTest
    @MethodSource(value={"getErrorData"})
    public void testParsingError(ThrowingFunction<String, JavaClass, JavaParsingException> parseMethod, String parseText, String error) {
        try {
            parseMethod.apply((Object)parseText);
            Assertions.fail();
        }
        catch (JavaParsingException e) {
            Assertions.assertEquals((Object)this.buildJavaParsingExceptionMessage(JavaCodeTypes.CLASS, error), (Object)e.getMessage());
        }
    }

    @Test
    public void testMultiplePackageDeclarations() {
        try {
            JavaClassParser.parseClass((String)"package some.package;\npackage something.else;\nclass Test{\n}");
            Assertions.fail();
        }
        catch (JavaParsingException e) {
            Assertions.assertEquals((Object)this.buildJavaParsingExceptionMessage(JavaCodeTypes.CLASS, "Only one package declaration allowed on a class!"), (Object)e.getMessage());
        }
    }

    @Test
    public void testPackageDeclarationAfterClass() {
        try {
            JavaClassParser.parseClass((String)"class Test{\n}\npackage some.package;");
            Assertions.fail();
        }
        catch (JavaParsingException e) {
            Assertions.assertEquals((Object)this.buildJavaParsingExceptionMessage(JavaCodeTypes.CLASS, "Encountered package declaration after class!"), (Object)e.getMessage());
        }
    }

    @Test
    public void testImportStatementAfterClass() {
        try {
            JavaClassParser.parseClass((String)"class Test{\n}\nimport some.name;");
            Assertions.fail();
        }
        catch (JavaParsingException e) {
            Assertions.assertEquals((Object)this.buildJavaParsingExceptionMessage(JavaCodeTypes.CLASS, "Encountered import statement after class!"), (Object)e.getMessage());
        }
    }

    @Test
    public void testMultipleJavadocs() {
        try {
            JavaClassParser.parseClass((String)"/** {@inheritDoc} */\n/** something */\nclass Test{\n}");
            Assertions.fail();
        }
        catch (JavaParsingException e) {
            Assertions.assertEquals((Object)this.buildJavaParsingExceptionMessage(JavaCodeTypes.CLASS, "Only one Javadoc allowed on a class!"), (Object)e.getMessage());
        }
    }

    @Test
    public void testJavadocAfterClass() {
        try {
            JavaClassParser.parseClass((String)"class Test{\n}\n/** {@inheritDoc} */");
            Assertions.fail();
        }
        catch (JavaParsingException e) {
            Assertions.assertEquals((Object)this.buildJavaParsingExceptionMessage(JavaCodeTypes.CLASS, "Encountered Javadoc after class!"), (Object)e.getMessage());
        }
    }

    @Test
    public void testAnnotationAfterClass() {
        try {
            JavaClassParser.parseClass((String)"class Test{\n}\n@Test");
            Assertions.fail();
        }
        catch (JavaParsingException e) {
            Assertions.assertEquals((Object)this.buildJavaParsingExceptionMessage(JavaCodeTypes.CLASS, "Encountered annotation after class!"), (Object)e.getMessage());
        }
    }

    @Test
    public void testMultipleClasses() {
        try {
            JavaClassParser.parseClass((String)"class Test{\n}\nclass Derp{\n}");
            Assertions.fail();
        }
        catch (JavaParsingException e) {
            Assertions.assertEquals((Object)this.buildJavaParsingExceptionMessage(JavaCodeTypes.CLASS, "Encountered multiple classes!"), (Object)e.getMessage());
        }
    }

    @Test
    public void testParsedNotAClass() {
        try {
            JavaClassParser.parseClass((String)"@Test");
            Assertions.fail();
        }
        catch (JavaParsingException e) {
            Assertions.assertEquals((Object)this.buildJavaParsingExceptionMessage(JavaCodeTypes.CLASS, "Failed to parse an actual class!"), (Object)e.getMessage());
        }
    }

    @Test
    public void testFirstTokenNotClass() {
        try {
            JavaClassParser.parseClass((String)"Test{\n}");
            Assertions.fail();
        }
        catch (JavaParsingException e) {
            Assertions.assertEquals((Object)this.buildJavaParsingExceptionMessage(JavaCodeTypes.CLASS, "The first token of a class must be 'class'"), (Object)e.getMessage());
        }
    }

    @Test
    public void testStaticCodeBlockWithPrivate() {
        try {
            JavaClassParser.parseClass((String)"class Test{\n\tprivate{\n\t\tdoSomething();\n\t}\n}");
            Assertions.fail();
        }
        catch (JavaParsingException e) {
            Assertions.assertEquals((Object)this.buildJavaParsingExceptionMessage(JavaCodeTypes.STATIC_CODE_BLOCK, "Static Code Block can only have 'static' as a modifier"), (Object)e.getMessage());
        }
    }

    @Test
    public void testStaticCodeBlockWithMultipleModifiers() {
        try {
            JavaClassParser.parseClass((String)"class Test{\n\tprivate static{\n\t\tdoSomething();\n\t}\n}");
            Assertions.fail();
        }
        catch (JavaParsingException e) {
            Assertions.assertEquals((Object)this.buildJavaParsingExceptionMessage(JavaCodeTypes.STATIC_CODE_BLOCK, "Static Code Block can only have 'static' as a modifier"), (Object)e.getMessage());
        }
    }
}

