/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.java.parsing.codetypes;

import com.github.tadukoo.java.JavaCodeTypes;
import com.github.tadukoo.java.annotation.EditableJavaAnnotation;
import com.github.tadukoo.java.annotation.JavaAnnotation;
import com.github.tadukoo.java.parsing.BaseJavaParserTest;
import com.github.tadukoo.java.parsing.JavaParsingException;
import com.github.tadukoo.java.parsing.codetypes.JavaAnnotationParser;
import com.github.tadukoo.util.ListUtil;
import com.github.tadukoo.util.functional.function.ThrowingFunction;
import com.github.tadukoo.util.tuple.Triple;
import java.util.List;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class JavaAnnotationParserTest
extends BaseJavaParserTest {
    public static Stream<Arguments> getParsingData() {
        List parsingData = ListUtil.createList((Object[])new Triple[]{Triple.of((Object)"@Test", (Object)EditableJavaAnnotation.builder().name("Test").build(), (Object)"@Test"), Triple.of((Object)"@Test(true)", (Object)EditableJavaAnnotation.builder().name("Test").parameter("value", "true").build(), (Object)"@Test(true)"), Triple.of((Object)"@Test(type = String.class)", (Object)EditableJavaAnnotation.builder().name("Test").parameter("type", "String.class").build(), (Object)"@Test(type = String.class)"), Triple.of((Object)"@Test(type = String.class, defaultValue = \"\")", (Object)EditableJavaAnnotation.builder().name("Test").parameter("type", "String.class").parameter("defaultValue", "\"\"").build(), (Object)"@Test(type = String.class, defaultValue = \"\")"), Triple.of((Object)" \t@Test", (Object)EditableJavaAnnotation.builder().name("Test").build(), (Object)"@Test"), Triple.of((Object)"@\t Test", (Object)EditableJavaAnnotation.builder().name("Test").build(), (Object)"@Test"), Triple.of((Object)"@Test \t", (Object)EditableJavaAnnotation.builder().name("Test").build(), (Object)"@Test"), Triple.of((Object)"@Test \t(type = String.class)", (Object)EditableJavaAnnotation.builder().name("Test").parameter("type", "String.class").build(), (Object)"@Test(type = String.class)"), Triple.of((Object)"@Test( \ttype = String.class)", (Object)EditableJavaAnnotation.builder().name("Test").parameter("type", "String.class").build(), (Object)"@Test(type = String.class)"), Triple.of((Object)"@Test(type \t = String.class)", (Object)EditableJavaAnnotation.builder().name("Test").parameter("type", "String.class").build(), (Object)"@Test(type = String.class)"), Triple.of((Object)"@Test(type =  \tString.class)", (Object)EditableJavaAnnotation.builder().name("Test").parameter("type", "String.class").build(), (Object)"@Test(type = String.class)"), Triple.of((Object)"@Test(type = String.class \t)", (Object)EditableJavaAnnotation.builder().name("Test").parameter("type", "String.class").build(), (Object)"@Test(type = String.class)"), Triple.of((Object)"@Test(type = String.class) \t", (Object)EditableJavaAnnotation.builder().name("Test").parameter("type", "String.class").build(), (Object)"@Test(type = String.class)"), Triple.of((Object)"@Test(type = String.class  \t, defaultValue = \"\")", (Object)EditableJavaAnnotation.builder().name("Test").parameter("type", "String.class").parameter("defaultValue", "\"\"").build(), (Object)"@Test(type = String.class, defaultValue = \"\")"), Triple.of((Object)"@Test(type = String.class, \t  \t defaultValue = \"\")", (Object)EditableJavaAnnotation.builder().name("Test").parameter("type", "String.class").parameter("defaultValue", "\"\"").build(), (Object)"@Test(type = String.class, defaultValue = \"\")"), Triple.of((Object)"  \t  \t @ \t  \tTest\t  (\t \ttype \t = \t  \t  String.class\t  , \t  \t defaultValue \t = \t  \t\"\"  \t )    \t", (Object)EditableJavaAnnotation.builder().name("Test").parameter("type", "String.class").parameter("defaultValue", "\"\"").build(), (Object)"@Test(type = String.class, defaultValue = \"\")")});
        List parseMethods = ListUtil.createList((Object[])new ThrowingFunction[]{x$0 -> BaseJavaParserTest.runFullParserForAnnotation(x$0), JavaAnnotationParser::parseAnnotation});
        return parsingData.stream().flatMap(triple -> Stream.of(0, 1).map(index -> Arguments.of((Object[])new Object[]{parseMethods.get((int)index), triple.getLeft(), triple.getMiddle(), triple.getRight()})));
    }

    @ParameterizedTest
    @MethodSource(value={"getParsingData"})
    public void testParsing(ThrowingFunction<String, JavaAnnotation, JavaParsingException> parseMethod, String textToParse, JavaAnnotation expectedAnnotation, String expectedText) throws JavaParsingException {
        JavaAnnotation annotation = (JavaAnnotation)parseMethod.apply((Object)textToParse);
        Assertions.assertNotNull((Object)annotation);
        Assertions.assertEquals((Object)expectedAnnotation, (Object)annotation);
        Assertions.assertEquals((Object)expectedText, (Object)annotation.toString());
    }

    @Test
    public void testMissingStartToken() {
        try {
            JavaAnnotationParser.parseAnnotation((List)ListUtil.createList((Object[])new String[]{"Test", "(", "type", "=", "String.class", ")"}), (int)0);
            Assertions.fail();
        }
        catch (JavaParsingException e) {
            Assertions.assertEquals((Object)this.buildJavaParsingExceptionMessage(JavaCodeTypes.ANNOTATION, "First token of annotation must start with '@'"), (Object)e.getMessage());
        }
    }

    @Test
    public void testAnnotationDoesNotMatchRegex() {
        try {
            JavaAnnotationParser.parseAnnotation((String)"Test(type = String.class)");
            Assertions.fail();
        }
        catch (JavaParsingException e) {
            Assertions.assertEquals((Object)this.buildJavaParsingExceptionMessage(JavaCodeTypes.ANNOTATION, "Failed to parse annotation"), (Object)e.getMessage());
        }
    }

    @Test
    public void failedToEndParameters() {
        try {
            JavaAnnotationParserTest.runFullParserForAnnotation("@Test(");
            Assertions.fail();
        }
        catch (JavaParsingException e) {
            Assertions.assertEquals((Object)this.buildJavaParsingExceptionMessage(JavaCodeTypes.ANNOTATION, "Didn't find end of parameters"), (Object)e.getMessage());
        }
    }
}

