/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.java.parsing.codetypes;

import com.github.tadukoo.java.JavaCodeTypes;
import com.github.tadukoo.java.Visibility;
import com.github.tadukoo.java.annotation.EditableJavaAnnotation;
import com.github.tadukoo.java.field.EditableJavaField;
import com.github.tadukoo.java.field.JavaField;
import com.github.tadukoo.java.javadoc.EditableJavadoc;
import com.github.tadukoo.java.parsing.BaseJavaParserTest;
import com.github.tadukoo.java.parsing.JavaParsingException;
import com.github.tadukoo.java.parsing.codetypes.JavaFieldParser;
import com.github.tadukoo.util.ListUtil;
import com.github.tadukoo.util.functional.function.ThrowingFunction;
import com.github.tadukoo.util.tuple.Pair;
import com.github.tadukoo.util.tuple.Triple;
import java.util.List;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class JavaFieldParserTest
extends BaseJavaParserTest {
    private static final List<ThrowingFunction<String, JavaField, JavaParsingException>> parseMethods = ListUtil.createList((Object[])new ThrowingFunction[]{x$0 -> BaseJavaParserTest.runFullParserForField(x$0), JavaFieldParser::parseField});

    public static Stream<Arguments> getParsingData() {
        List parsingData = ListUtil.createList((Object[])new Triple[]{Triple.of((Object)"String name;", (Object)EditableJavaField.builder().type("String").name("name").build(), (Object)"String name;"), Triple.of((Object)"private String name;", (Object)EditableJavaField.builder().visibility(Visibility.PRIVATE).type("String").name("name").build(), (Object)"private String name;"), Triple.of((Object)"protected String name;", (Object)EditableJavaField.builder().visibility(Visibility.PROTECTED).type("String").name("name").build(), (Object)"protected String name;"), Triple.of((Object)"public String name;", (Object)EditableJavaField.builder().visibility(Visibility.PUBLIC).type("String").name("name").build(), (Object)"public String name;"), Triple.of((Object)"static String name;", (Object)EditableJavaField.builder().isStatic().type("String").name("name").build(), (Object)"static String name;"), Triple.of((Object)"final String name;", (Object)EditableJavaField.builder().isFinal().type("String").name("name").build(), (Object)"final String name;"), Triple.of((Object)"final static public String name;", (Object)EditableJavaField.builder().visibility(Visibility.PUBLIC).isStatic().isFinal().type("String").name("name").build(), (Object)"public static final String name;"), Triple.of((Object)"String name = \"\";", (Object)EditableJavaField.builder().type("String").name("name").value("\"\"").build(), (Object)"String name = \"\";"), Triple.of((Object)"@Test\nString name;", (Object)EditableJavaField.builder().annotation(EditableJavaAnnotation.builder().name("Test").build()).type("String").name("name").build(), (Object)"@Test\nString name;"), Triple.of((Object)"@Test\n@Derp(type=String.class)\nString name;", (Object)EditableJavaField.builder().annotation(EditableJavaAnnotation.builder().name("Test").build()).annotation(EditableJavaAnnotation.builder().name("Derp").parameter("type", "String.class").build()).type("String").name("name").build(), (Object)"@Test\n@Derp(type = String.class)\nString name;"), Triple.of((Object)"/** {@inheritDoc} */\nString name;", (Object)EditableJavaField.builder().javadoc(EditableJavadoc.builder().condensed().content("{@inheritDoc}").build()).type("String").name("name").build(), (Object)"/** {@inheritDoc} */\nString name;"), Triple.of((Object)"/** {@inheritDoc} */\n@Test\n@Derp(type=String.class)\nprivate static final String name = \"\";", (Object)EditableJavaField.builder().javadoc(EditableJavadoc.builder().condensed().content("{@inheritDoc}").build()).annotation(EditableJavaAnnotation.builder().name("Test").build()).annotation(EditableJavaAnnotation.builder().name("Derp").parameter("type", "String.class").build()).visibility(Visibility.PRIVATE).isStatic().isFinal().type("String").name("name").value("\"\"").build(), (Object)"/** {@inheritDoc} */\n@Test\n@Derp(type = String.class)\nprivate static final String name = \"\";"), Triple.of((Object)"List<String> type;", (Object)EditableJavaField.builder().type("List<String>").name("type").build(), (Object)"List<String> type;"), Triple.of((Object)"Map<String, Object> type;", (Object)EditableJavaField.builder().type("Map<String, Object>").name("type").build(), (Object)"Map<String, Object> type;"), Triple.of((Object)"List<Map<String, Object>> type;", (Object)EditableJavaField.builder().type("List<Map<String, Object>>").name("type").build(), (Object)"List<Map<String, Object>> type;"), Triple.of((Object)"Map<Character, Map<Character, ?>> type;", (Object)EditableJavaField.builder().type("Map<Character, Map<Character, ?>>").name("type").build(), (Object)"Map<Character, Map<Character, ?>> type;"), Triple.of((Object)"Map<? extends List<String>, Object> type;", (Object)EditableJavaField.builder().type("Map<? extends List<String>, Object>").name("type").build(), (Object)"Map<? extends List<String>, Object> type;"), Triple.of((Object)"\t     \t  \t\n  \tString type;", (Object)EditableJavaField.builder().type("String").name("type").build(), (Object)"String type;"), Triple.of((Object)"String \t  \t\n  \t  type;", (Object)EditableJavaField.builder().type("String").name("type").build(), (Object)"String type;"), Triple.of((Object)"String type \t  \t\n \t;", (Object)EditableJavaField.builder().type("String").name("type").build(), (Object)"String type;"), Triple.of((Object)"String type;     \t\n  \t   ", (Object)EditableJavaField.builder().type("String").name("type").build(), (Object)"String type;"), Triple.of((Object)"\t     \t\n    \t private String type;", (Object)EditableJavaField.builder().visibility(Visibility.PRIVATE).type("String").name("type").build(), (Object)"private String type;"), Triple.of((Object)"private\t     \t\n    \t String type;", (Object)EditableJavaField.builder().visibility(Visibility.PRIVATE).type("String").name("type").build(), (Object)"private String type;"), Triple.of((Object)"\t     \t\n    \t protected String type;", (Object)EditableJavaField.builder().visibility(Visibility.PROTECTED).type("String").name("type").build(), (Object)"protected String type;"), Triple.of((Object)"protected\t     \t\n    \t String type;", (Object)EditableJavaField.builder().visibility(Visibility.PROTECTED).type("String").name("type").build(), (Object)"protected String type;"), Triple.of((Object)"\t     \t\n    \t public String type;", (Object)EditableJavaField.builder().visibility(Visibility.PUBLIC).type("String").name("type").build(), (Object)"public String type;"), Triple.of((Object)"public\t     \t\n    \t String type;", (Object)EditableJavaField.builder().visibility(Visibility.PUBLIC).type("String").name("type").build(), (Object)"public String type;"), Triple.of((Object)"\t     \t\n    \t static String type;", (Object)EditableJavaField.builder().isStatic().type("String").name("type").build(), (Object)"static String type;"), Triple.of((Object)"static\t     \t\n    \t String type;", (Object)EditableJavaField.builder().isStatic().type("String").name("type").build(), (Object)"static String type;"), Triple.of((Object)"\t     \t\n    \t final String type;", (Object)EditableJavaField.builder().isFinal().type("String").name("type").build(), (Object)"final String type;"), Triple.of((Object)"final\t     \t\n    \t String type;", (Object)EditableJavaField.builder().isFinal().type("String").name("type").build(), (Object)"final String type;"), Triple.of((Object)"String type    \t   \t\n   \t = \"\";", (Object)EditableJavaField.builder().type("String").name("type").value("\"\"").build(), (Object)"String type = \"\";"), Triple.of((Object)"String type =    \t   \t\n   \t \"\";", (Object)EditableJavaField.builder().type("String").name("type").value("\"\"").build(), (Object)"String type = \"\";"), Triple.of((Object)"String type = \"\"    \t   \t\n   \t ;", (Object)EditableJavaField.builder().type("String").name("type").value("\"\"").build(), (Object)"String type = \"\";"), Triple.of((Object)"/** An array containing 0-9 and then A-F, used for converting to hex */\r\n\t\t\t\t\tpublic static final char[] hexChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9',\r\n\t\t\t\t\t\t\t\t\t\t\t\t\t'A', 'B', 'C', 'D', 'E', 'F'};", (Object)EditableJavaField.builder().javadoc(EditableJavadoc.builder().condensed().content("An array containing 0-9 and then A-F, used for converting to hex").build()).visibility(Visibility.PUBLIC).isStatic().isFinal().type("char[]").name("hexChars").value("new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9',\n\t\t\t\t\t\t\t\t\t\t\t\t'A', 'B', 'C', 'D', 'E', 'F'}").build(), (Object)"/** An array containing 0-9 and then A-F, used for converting to hex */\npublic static final char[] hexChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9',\n\t\t\t\t\t\t\t\t\t\t\t\t'A', 'B', 'C', 'D', 'E', 'F'};"), Triple.of((Object)"\t     \t  \t\n  \tString \t  \t\n  \t  type \t  \t\n \t;     \t\n  \t   ", (Object)EditableJavaField.builder().type("String").name("type").build(), (Object)"String type;"), Triple.of((Object)"\t     \t\n    \t public\t     \t\n    \t static\t     \t\n    \t final\t     \t  \t\n  \tString \t  \t\n  \t  type    \t   \t\n   \t =    \t   \t\n   \t \"\" \t  \t\n \t;     \t\n  \t   ", (Object)EditableJavaField.builder().visibility(Visibility.PUBLIC).isStatic().isFinal().type("String").name("type").value("\"\"").build(), (Object)"public static final String type = \"\";"), Triple.of((Object)"\t  \t @ \t  \tTest\t  (\t \ttype \t = \t\n\t  \t  String.class\t  , \t  \t defaultValue \t = \t  \t\"\"  \t )    \t\t     \t\n  \t\n \t    \t@       Derp   \t\n   \t public\t     \t\n   \t static\t     \t\n   \t final\t     \t  \t\n \tString \t  \t\n \t  type    \t   \t\n  \t =    \t   \t\n  \t \"\" \t  \t\n\t;     \t\n \t   ", (Object)EditableJavaField.builder().annotation(EditableJavaAnnotation.builder().name("Test").parameter("type", "String.class").parameter("defaultValue", "\"\"").build()).annotation(EditableJavaAnnotation.builder().name("Derp").build()).visibility(Visibility.PUBLIC).isStatic().isFinal().type("String").name("type").value("\"\"").build(), (Object)"@Test(type = String.class, defaultValue = \"\")\n@Derp\npublic static final String type = \"\";")});
        return parsingData.stream().flatMap(triple -> Stream.of(0, 1).map(index -> Arguments.of((Object[])new Object[]{parseMethods.get((int)index), triple.getLeft(), triple.getMiddle(), triple.getRight()})));
    }

    @ParameterizedTest
    @MethodSource(value={"getParsingData"})
    public void testParsing(ThrowingFunction<String, JavaField, JavaParsingException> parseMethod, String textToParse, JavaField expectedField, String expectedText) throws JavaParsingException {
        JavaField field = (JavaField)parseMethod.apply((Object)textToParse);
        Assertions.assertNotNull((Object)field);
        Assertions.assertEquals((Object)expectedField, (Object)field);
        Assertions.assertEquals((Object)expectedText, (Object)field.toString());
    }

    public static Stream<Arguments> getErrorData() {
        List parsingData = ListUtil.createList((Object[])new Pair[]{Pair.of((Object)"abstract String name;", (Object)"'abstract' is not a valid modifier on field!"), Pair.of((Object)"String name = \"\"", (Object)"Failed to find semicolon at end of field"), Pair.of((Object)"private static final String name = \"\"", (Object)"Failed to find semicolon at end of field")});
        return parsingData.stream().flatMap(pair -> Stream.of(0, 1).map(index -> Arguments.of((Object[])new Object[]{parseMethods.get((int)index), pair.getLeft(), pair.getRight()})));
    }

    @ParameterizedTest
    @MethodSource(value={"getErrorData"})
    public void testParsingError(ThrowingFunction<String, JavaField, JavaParsingException> parseMethod, String parseText, String error) {
        try {
            parseMethod.apply((Object)parseText);
            Assertions.fail();
        }
        catch (JavaParsingException e) {
            Assertions.assertEquals((Object)this.buildJavaParsingExceptionMessage(JavaCodeTypes.FIELD, error), (Object)e.getMessage());
        }
    }

    @Test
    public void testNoFieldParsed() {
        try {
            JavaFieldParser.parseField((String)"@Test");
            Assertions.fail();
        }
        catch (JavaParsingException e) {
            Assertions.assertEquals((Object)this.buildJavaParsingExceptionMessage(JavaCodeTypes.FIELD, "Failed to parse an actual field!"), (Object)e.getMessage());
        }
    }

    @Test
    public void testMultipleJavadocs() {
        try {
            JavaFieldParser.parseField((String)"/** {@inheritDoc} */\n/** something */\nString name;");
            Assertions.fail();
        }
        catch (JavaParsingException e) {
            Assertions.assertEquals((Object)this.buildJavaParsingExceptionMessage(JavaCodeTypes.FIELD, "Only one Javadoc allowed on a field!"), (Object)e.getMessage());
        }
    }

    @Test
    public void testJavadocAfterField() {
        try {
            JavaFieldParser.parseField((String)"String name;\n/** {@inheritDoc} */");
            Assertions.fail();
        }
        catch (JavaParsingException e) {
            Assertions.assertEquals((Object)this.buildJavaParsingExceptionMessage(JavaCodeTypes.FIELD, "Encountered Javadoc after field!"), (Object)e.getMessage());
        }
    }

    @Test
    public void testAnnotationAfterField() {
        try {
            JavaFieldParser.parseField((String)"String name;\n@Test");
            Assertions.fail();
        }
        catch (JavaParsingException e) {
            Assertions.assertEquals((Object)this.buildJavaParsingExceptionMessage(JavaCodeTypes.FIELD, "Encountered annotation after field!"), (Object)e.getMessage());
        }
    }

    @Test
    public void testMultipleFields() {
        try {
            JavaFieldParser.parseField((String)"String name;\nint version;");
            Assertions.fail();
        }
        catch (JavaParsingException e) {
            Assertions.assertEquals((Object)this.buildJavaParsingExceptionMessage(JavaCodeTypes.FIELD, "Encountered multiple fields!"), (Object)e.getMessage());
        }
    }

    @Test
    public void testSimpleFieldNoSemicolon() {
        try {
            JavaFieldParser.parseField((String)"String name");
            Assertions.fail();
        }
        catch (JavaParsingException e) {
            Assertions.assertEquals((Object)this.buildJavaParsingExceptionMessage(JavaCodeTypes.FIELD, "Failed to find semicolon at end of field"), (Object)e.getMessage());
        }
    }

    @Test
    public void testFieldWithVisibilityNoSemicolon() {
        try {
            JavaFieldParser.parseField((String)"private String name");
            Assertions.fail();
        }
        catch (JavaParsingException e) {
            Assertions.assertEquals((Object)this.buildJavaParsingExceptionMessage(JavaCodeTypes.FIELD, "Failed to find semicolon at end of field"), (Object)e.getMessage());
        }
    }

    @Test
    public void testFieldWithStaticNoSemicolon() {
        try {
            JavaFieldParser.parseField((String)"static String name");
            Assertions.fail();
        }
        catch (JavaParsingException e) {
            Assertions.assertEquals((Object)this.buildJavaParsingExceptionMessage(JavaCodeTypes.FIELD, "Failed to find semicolon at end of field"), (Object)e.getMessage());
        }
    }

    @Test
    public void testFieldWithFinalNoSemicolon() {
        try {
            JavaFieldParser.parseField((String)"final String name");
            Assertions.fail();
        }
        catch (JavaParsingException e) {
            Assertions.assertEquals((Object)this.buildJavaParsingExceptionMessage(JavaCodeTypes.FIELD, "Failed to find semicolon at end of field"), (Object)e.getMessage());
        }
    }

    @Test
    public void testGarbage() {
        try {
            JavaFieldParser.parseField((String)"derp bloop scoop loop;");
            Assertions.fail();
        }
        catch (JavaParsingException e) {
            Assertions.assertEquals((Object)this.buildJavaParsingExceptionMessage(JavaCodeTypes.FIELD, "Failed to parse a field"), (Object)e.getMessage());
        }
    }
}

