/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.java.parsing.codetypes;

import com.github.tadukoo.java.JavaCodeTypes;
import com.github.tadukoo.java.importstatement.EditableJavaImportStatement;
import com.github.tadukoo.java.importstatement.JavaImportStatement;
import com.github.tadukoo.java.parsing.BaseJavaParserTest;
import com.github.tadukoo.java.parsing.JavaParsingException;
import com.github.tadukoo.java.parsing.codetypes.JavaImportStatementParser;
import com.github.tadukoo.util.ListUtil;
import com.github.tadukoo.util.functional.function.ThrowingFunction;
import com.github.tadukoo.util.tuple.Pair;
import com.github.tadukoo.util.tuple.Triple;
import java.util.List;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class JavaImportStatementParserTest
extends BaseJavaParserTest {
    private static final List<ThrowingFunction<String, JavaImportStatement, JavaParsingException>> parseMethods = ListUtil.createList((Object[])new ThrowingFunction[]{x$0 -> BaseJavaParserTest.runFullParserForImportStatement(x$0), JavaImportStatementParser::parseImportStatement});

    public static Stream<Arguments> getParsingData() {
        List parsingData = ListUtil.createList((Object[])new Triple[]{Triple.of((Object)"import com.example;", (Object)EditableJavaImportStatement.builder().importName("com.example").build(), (Object)"import com.example;"), Triple.of((Object)"import static com.example;", (Object)EditableJavaImportStatement.builder().isStatic().importName("com.example").build(), (Object)"import static com.example;"), Triple.of((Object)"\t     \t\n    \n\t import com.example;", (Object)EditableJavaImportStatement.builder().importName("com.example").build(), (Object)"import com.example;"), Triple.of((Object)"import\t     \t\n    \n\t com.example;", (Object)EditableJavaImportStatement.builder().importName("com.example").build(), (Object)"import com.example;"), Triple.of((Object)"import com\t     \n\t     .    \n   \t    example;", (Object)EditableJavaImportStatement.builder().importName("com.example").build(), (Object)"import com.example;"), Triple.of((Object)"import com.example    \n\t\n   ;", (Object)EditableJavaImportStatement.builder().importName("com.example").build(), (Object)"import com.example;"), Triple.of((Object)"import     \n\t      \n    static com.example;", (Object)EditableJavaImportStatement.builder().isStatic().importName("com.example").build(), (Object)"import static com.example;"), Triple.of((Object)"import static        \n\t     \n  com.example;", (Object)EditableJavaImportStatement.builder().isStatic().importName("com.example").build(), (Object)"import static com.example;"), Triple.of((Object)"\t     \t\n    \n\t import\t     \t\n    \n\t static        \n\t     \n  com\t     \n\t     .    \n   \t    example    \n\t\n   ;", (Object)EditableJavaImportStatement.builder().isStatic().importName("com.example").build(), (Object)"import static com.example;")});
        return parsingData.stream().flatMap(triple -> Stream.of(0, 1).map(index -> Arguments.of((Object[])new Object[]{parseMethods.get((int)index), triple.getLeft(), triple.getMiddle(), triple.getRight()})));
    }

    @ParameterizedTest
    @MethodSource(value={"getParsingData"})
    public void testParsing(ThrowingFunction<String, JavaImportStatement, JavaParsingException> parseMethod, String textToParse, JavaImportStatement expectedImportStatement, String expectedText) throws JavaParsingException {
        JavaImportStatement importStatement = (JavaImportStatement)parseMethod.apply((Object)textToParse);
        Assertions.assertNotNull((Object)importStatement);
        Assertions.assertEquals((Object)expectedImportStatement, (Object)importStatement);
        Assertions.assertEquals((Object)expectedText, (Object)importStatement.toString());
    }

    public static Stream<Arguments> getErrorData() {
        List parsingData = ListUtil.createList((Object[])new Pair[]{Pair.of((Object)"import ;", (Object)"Failed to find import name in import statement!"), Pair.of((Object)"import com.example", (Object)"Failed to find semicolon ending import statement!"), Pair.of((Object)"import ", (Object)"Failed to find import name in import statement!\nFailed to find semicolon ending import statement!")});
        return parsingData.stream().flatMap(pair -> Stream.of(0, 1).map(index -> Arguments.of((Object[])new Object[]{parseMethods.get((int)index), pair.getLeft(), pair.getRight()})));
    }

    @ParameterizedTest
    @MethodSource(value={"getErrorData"})
    public void testParsingError(ThrowingFunction<String, JavaImportStatement, JavaParsingException> parseMethod, String parseText, String error) {
        try {
            parseMethod.apply((Object)parseText);
            Assertions.fail();
        }
        catch (JavaParsingException e) {
            Assertions.assertEquals((Object)this.buildJavaParsingExceptionMessage(JavaCodeTypes.IMPORT_STATEMENT, error), (Object)e.getMessage());
        }
    }

    @Test
    public void testMissingImportToken() {
        try {
            JavaImportStatementParser.parseImportStatement((String)"com.example;");
            Assertions.fail();
        }
        catch (JavaParsingException e) {
            Assertions.assertEquals((Object)this.buildJavaParsingExceptionMessage(JavaCodeTypes.IMPORT_STATEMENT, "First token of import statement must be 'import'"), (Object)e.getMessage());
        }
    }
}

