/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.java.parsing.codetypes;

import com.github.tadukoo.java.JavaCodeTypes;
import com.github.tadukoo.java.Visibility;
import com.github.tadukoo.java.annotation.EditableJavaAnnotation;
import com.github.tadukoo.java.javadoc.EditableJavadoc;
import com.github.tadukoo.java.method.EditableJavaMethod;
import com.github.tadukoo.java.method.JavaMethod;
import com.github.tadukoo.java.parsing.BaseJavaParserTest;
import com.github.tadukoo.java.parsing.JavaParsingException;
import com.github.tadukoo.java.parsing.codetypes.JavaMethodParser;
import com.github.tadukoo.util.ListUtil;
import com.github.tadukoo.util.functional.function.ThrowingFunction;
import com.github.tadukoo.util.tuple.Pair;
import com.github.tadukoo.util.tuple.Triple;
import java.util.List;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class JavaMethodParserTest
extends BaseJavaParserTest {
    private static final List<ThrowingFunction<String, JavaMethod, JavaParsingException>> parseMethods = ListUtil.createList((Object[])new ThrowingFunction[]{x$0 -> BaseJavaParserTest.runFullParserForMethod(x$0), JavaMethodParser::parseMethod});

    public static Stream<Arguments> getParsingData() {
        List parsingData = ListUtil.createList((Object[])new Triple[]{Triple.of((Object)"Test(){}", (Object)EditableJavaMethod.builder().returnType("Test").build(), (Object)"Test(){ }"), Triple.of((Object)"String test(){}", (Object)EditableJavaMethod.builder().returnType("String").name("test").build(), (Object)"String test(){ }"), Triple.of((Object)"private Test(){}", (Object)EditableJavaMethod.builder().visibility(Visibility.PRIVATE).returnType("Test").build(), (Object)"private Test(){ }"), Triple.of((Object)"protected Test(){}", (Object)EditableJavaMethod.builder().visibility(Visibility.PROTECTED).returnType("Test").build(), (Object)"protected Test(){ }"), Triple.of((Object)"public Test(){}", (Object)EditableJavaMethod.builder().visibility(Visibility.PUBLIC).returnType("Test").build(), (Object)"public Test(){ }"), Triple.of((Object)"abstract Test();", (Object)EditableJavaMethod.builder().isAbstract().returnType("Test").build(), (Object)"abstract Test();"), Triple.of((Object)"static Test(){}", (Object)EditableJavaMethod.builder().isStatic().returnType("Test").build(), (Object)"static Test(){ }"), Triple.of((Object)"final Test(){}", (Object)EditableJavaMethod.builder().isFinal().returnType("Test").build(), (Object)"final Test(){ }"), Triple.of((Object)"final static protected Test(){}", (Object)EditableJavaMethod.builder().visibility(Visibility.PROTECTED).isStatic().isFinal().returnType("Test").build(), (Object)"protected static final Test(){ }"), Triple.of((Object)"<T> Test(){}", (Object)EditableJavaMethod.builder().addTypeParameters("T").returnType("Test").build(), (Object)"<T> Test(){ }"), Triple.of((Object)"<T, U> Test(){}", (Object)EditableJavaMethod.builder().addTypeParameters("T, U").returnType("Test").build(), (Object)"<T, U> Test(){ }"), Triple.of((Object)"<T, U, V> Test(){}", (Object)EditableJavaMethod.builder().addTypeParameters("T, U, V").returnType("Test").build(), (Object)"<T, U, V> Test(){ }"), Triple.of((Object)"Test(String type){}", (Object)EditableJavaMethod.builder().returnType("Test").parameter("String type").build(), (Object)"Test(String type){ }"), Triple.of((Object)"Test(List<String> types){}", (Object)EditableJavaMethod.builder().returnType("Test").parameter("List<String> types").build(), (Object)"Test(List<String> types){ }"), Triple.of((Object)"Test(Map<String, Object> map){}", (Object)EditableJavaMethod.builder().returnType("Test").parameter("Map<String, Object> map").build(), (Object)"Test(Map<String, Object> map){ }"), Triple.of((Object)"Test(String ... types){}", (Object)EditableJavaMethod.builder().returnType("Test").parameter("String ... types").build(), (Object)"Test(String ... types){ }"), Triple.of((Object)"Test(Map<String, Object> ... maps){}", (Object)EditableJavaMethod.builder().returnType("Test").parameter("Map<String, Object> ... maps").build(), (Object)"Test(Map<String, Object> ... maps){ }"), Triple.of((Object)"Test(String type, int derp){}", (Object)EditableJavaMethod.builder().returnType("Test").parameter("String type").parameter("int derp").build(), (Object)"Test(String type, int derp){ }"), Triple.of((Object)"Test() throws Exception{}", (Object)EditableJavaMethod.builder().returnType("Test").throwType("Exception").build(), (Object)"Test() throws Exception{ }"), Triple.of((Object)"Test() throws Exception, Throwable{}", (Object)EditableJavaMethod.builder().returnType("Test").throwType("Exception").throwType("Throwable").build(), (Object)"Test() throws Exception, Throwable{ }"), Triple.of((Object)"Test(){doSomething();}", (Object)EditableJavaMethod.builder().returnType("Test").line("doSomething();").build(), (Object)"Test(){\n\tdoSomething();\n}"), Triple.of((Object)"Test(){doSomething();doSomethingElse();}", (Object)EditableJavaMethod.builder().returnType("Test").line("doSomething();").line("doSomethingElse();").build(), (Object)"Test(){\n\tdoSomething();\n\tdoSomethingElse();\n}"), Triple.of((Object)"private static final <T, U, V> String test(String type, int derp) throws Exception, Throwable{doSomething();doSomethingElse();}", (Object)EditableJavaMethod.builder().visibility(Visibility.PRIVATE).isStatic().isFinal().addTypeParameters("T, U, V").returnType("String").name("test").parameter("String type").parameter("int derp").throwType("Exception").throwType("Throwable").line("doSomething();").line("doSomethingElse();").build(), (Object)"private static final <T, U, V> String test(String type, int derp) throws Exception, Throwable{\n\tdoSomething();\n\tdoSomethingElse();\n}"), Triple.of((Object)"private static final String test(Map<String, Object> map, int ... derps) throws Exception, Throwable{doSomething();doSomethingElse();}", (Object)EditableJavaMethod.builder().visibility(Visibility.PRIVATE).isStatic().isFinal().returnType("String").name("test").parameter("Map<String, Object> map").parameter("int ... derps").throwType("Exception").throwType("Throwable").line("doSomething();").line("doSomethingElse();").build(), (Object)"private static final String test(Map<String, Object> map, int ... derps) throws Exception, Throwable{\n\tdoSomething();\n\tdoSomethingElse();\n}"), Triple.of((Object)"@Test\nTest(){}", (Object)EditableJavaMethod.builder().annotation(EditableJavaAnnotation.builder().name("Test").build()).returnType("Test").build(), (Object)"@Test\nTest(){ }"), Triple.of((Object)"@Test\n@Derp(type=String.class)\nTest(){}", (Object)EditableJavaMethod.builder().annotation(EditableJavaAnnotation.builder().name("Test").build()).annotation(EditableJavaAnnotation.builder().name("Derp").parameter("type", "String.class").build()).returnType("Test").build(), (Object)"@Test\n@Derp(type = String.class)\nTest(){ }"), Triple.of((Object)"/** {@inheritDoc} */\nTest(){}", (Object)EditableJavaMethod.builder().javadoc(EditableJavadoc.builder().condensed().content("{@inheritDoc}").build()).returnType("Test").build(), (Object)"/** {@inheritDoc} */\nTest(){ }"), Triple.of((Object)"/** {@inheritDoc} */\n@Test\n@Derp(type=String.class)\nprivate static final String test(String type, int derp) throws Exception, Throwable{doSomething();doSomethingElse();}", (Object)EditableJavaMethod.builder().javadoc(EditableJavadoc.builder().condensed().content("{@inheritDoc}").build()).annotation(EditableJavaAnnotation.builder().name("Test").build()).annotation(EditableJavaAnnotation.builder().name("Derp").parameter("type", "String.class").build()).visibility(Visibility.PRIVATE).isStatic().isFinal().returnType("String").name("test").parameter("String type").parameter("int derp").throwType("Exception").throwType("Throwable").line("doSomething();").line("doSomethingElse();").build(), (Object)"/** {@inheritDoc} */\n@Test\n@Derp(type = String.class)\nprivate static final String test(String type, int derp) throws Exception, Throwable{\n\tdoSomething();\n\tdoSomethingElse();\n}"), Triple.of((Object)"List<String> test(){}", (Object)EditableJavaMethod.builder().returnType("List<String>").name("test").build(), (Object)"List<String> test(){ }"), Triple.of((Object)"Map<String, Object> test(){}", (Object)EditableJavaMethod.builder().returnType("Map<String, Object>").name("test").build(), (Object)"Map<String, Object> test(){ }"), Triple.of((Object)"List<Map<String, Object>> test(){}", (Object)EditableJavaMethod.builder().returnType("List<Map<String, Object>>").name("test").build(), (Object)"List<Map<String, Object>> test(){ }"), Triple.of((Object)"Map<Character, Map<Character, ?>> test(){}", (Object)EditableJavaMethod.builder().returnType("Map<Character, Map<Character, ?>>").name("test").build(), (Object)"Map<Character, Map<Character, ?>> test(){ }"), Triple.of((Object)"Map<? extends List<String>, Object> test(){}", (Object)EditableJavaMethod.builder().returnType("Map<? extends List<String>, Object>").name("test").build(), (Object)"Map<? extends List<String>, Object> test(){ }"), Triple.of((Object)"Test(){\n\tsomething.builder()\n\t\t\t.build();\n}", (Object)EditableJavaMethod.builder().returnType("Test").line("something.builder()").line("\t\t.build();").build(), (Object)"Test(){\n\tsomething.builder()\n\t\t\t.build();\n}"), Triple.of((Object)"Test(){\n\tfor(int i = 0;;){\n\t\tdoSomething();\n\t}\n}", (Object)EditableJavaMethod.builder().returnType("Test").line("for(int i = 0;;){").line("\tdoSomething();").line("}").build(), (Object)"Test(){\n\tfor(int i = 0;;){\n\t\tdoSomething();\n\t}\n}"), Triple.of((Object)"public static String toHex(byte[] bytes){\n\tStringBuilder hex = new StringBuilder();\n\tfor(byte bite: bytes){\n\t\thex.append(toHex(bite));\n\t}\n\treturn hex.toString();\n}", (Object)EditableJavaMethod.builder().visibility(Visibility.PUBLIC).isStatic().returnType("String").name("toHex").parameter("byte[] bytes").line("StringBuilder hex = new StringBuilder();").line("for(byte bite: bytes){").line("\thex.append(toHex(bite));").line("}").line("return hex.toString();").build(), (Object)"public static String toHex(byte[] bytes){\n\tStringBuilder hex = new StringBuilder();\n\tfor(byte bite: bytes){\n\t\thex.append(toHex(bite));\n\t}\n\treturn hex.toString();\n}"), Triple.of((Object)"public static byte[] fromHex(String hex){\n\tint size = hex.length();\n\t\n\t// Check that the size is even\n\tif(size % 2 != 0){\n\t\tthrow new IllegalArgumentException(\"hex string must be an even length: \" + hex);\n\t}\n\t\n\t// Create byte array to store the bytes in\n\tbyte[] bites = new byte[size/2];\n\t\n\t// Iterate over the string, 2 characters at a time\n\tfor(int i = 0; i < size; i+=2){\n\t\tint highNibble = hexToInt(hex.charAt(i));\n\t\tint lowNibble = hexToInt(hex.charAt(i+1));\n\t\t// If either nibble came out -1, we have an illegal hex character\n\t\tif(highNibble == -1 || lowNibble == -1){\n\t\t\tthrow new IllegalArgumentException(\"hex string contains an illegal hex character: \" + hex);\n\t\t}\n\t\t\n\t\tbites[i/2] = (byte) (highNibble*16 + lowNibble);\n\t}\n\t\n\treturn bites;\n}", (Object)EditableJavaMethod.builder().visibility(Visibility.PUBLIC).isStatic().returnType("byte[]").name("fromHex").parameter("String hex").line("int size = hex.length();").line("").line("// Check that the size is even").line("if(size % 2 != 0){").line("\tthrow new IllegalArgumentException(\"hex string must be an even length: \" + hex);").line("}").line("").line("// Create byte array to store the bytes in").line("byte[] bites = new byte[size/2];").line("").line("// Iterate over the string, 2 characters at a time").line("for(int i = 0; i < size; i+=2){").line("\tint highNibble = hexToInt(hex.charAt(i));").line("\tint lowNibble = hexToInt(hex.charAt(i+1));").line("\t// If either nibble came out -1, we have an illegal hex character").line("\tif(highNibble == -1 || lowNibble == -1){").line("\t\tthrow new IllegalArgumentException(\"hex string contains an illegal hex character: \" + hex);").line("\t}").line("\t").line("\tbites[i/2] = (byte) (highNibble*16 + lowNibble);").line("}").line("").line("return bites;").build(), (Object)"public static byte[] fromHex(String hex){\n\tint size = hex.length();\n\t\n\t// Check that the size is even\n\tif(size % 2 != 0){\n\t\tthrow new IllegalArgumentException(\"hex string must be an even length: \" + hex);\n\t}\n\t\n\t// Create byte array to store the bytes in\n\tbyte[] bites = new byte[size/2];\n\t\n\t// Iterate over the string, 2 characters at a time\n\tfor(int i = 0; i < size; i+=2){\n\t\tint highNibble = hexToInt(hex.charAt(i));\n\t\tint lowNibble = hexToInt(hex.charAt(i+1));\n\t\t// If either nibble came out -1, we have an illegal hex character\n\t\tif(highNibble == -1 || lowNibble == -1){\n\t\t\tthrow new IllegalArgumentException(\"hex string contains an illegal hex character: \" + hex);\n\t\t}\n\t\t\n\t\tbites[i/2] = (byte) (highNibble*16 + lowNibble);\n\t}\n\t\n\treturn bites;\n}"), Triple.of((Object)"public static int hexToInt(char hexChar){\n\tif('0' <= hexChar && hexChar <= '9'){\n\t\treturn hexChar - '0';\n\t}else if('A' <= hexChar && hexChar <= 'F'){\n\t\treturn hexChar - 'A' + 10;\n\t}else if('a' <= hexChar && hexChar <= 'f'){\n\t\treturn hexChar - 'a' + 10;\n\t}else{\n\t\treturn -1;\n\t}\n}", (Object)EditableJavaMethod.builder().visibility(Visibility.PUBLIC).isStatic().returnType("int").name("hexToInt").parameter("char hexChar").line("if('0' <= hexChar && hexChar <= '9'){").line("\treturn hexChar - '0';").line("}else if('A' <= hexChar && hexChar <= 'F'){").line("\treturn hexChar - 'A' + 10;").line("}else if('a' <= hexChar && hexChar <= 'f'){").line("\treturn hexChar - 'a' + 10;").line("}else{").line("\treturn -1;").line("}").build(), (Object)"public static int hexToInt(char hexChar){\n\tif('0' <= hexChar && hexChar <= '9'){\n\t\treturn hexChar - '0';\n\t}else if('A' <= hexChar && hexChar <= 'F'){\n\t\treturn hexChar - 'A' + 10;\n\t}else if('a' <= hexChar && hexChar <= 'f'){\n\t\treturn hexChar - 'a' + 10;\n\t}else{\n\t\treturn -1;\n\t}\n}"), Triple.of((Object)"public static List<File> listAllFiles(Path directoryPath) throws IOException{\n\ttry(Stream<Path> pathStream = Files.walk(directoryPath)){\n\t\treturn pathStream\n\t\t\t\t.filter(Files::isRegularFile)\n\t\t\t\t.map(Path::toFile)\n\t\t\t\t.collect(Collectors.toList());\n\t}\n}", (Object)EditableJavaMethod.builder().visibility(Visibility.PUBLIC).isStatic().returnType("List<File>").name("listAllFiles").parameter("Path directoryPath").throwType("IOException").line("try(Stream<Path> pathStream = Files.walk(directoryPath)){").line("\treturn pathStream").line("\t\t\t.filter(Files::isRegularFile)").line("\t\t\t.map(Path::toFile)").line("\t\t\t.collect(Collectors.toList());").line("}").build(), (Object)"public static List<File> listAllFiles(Path directoryPath) throws IOException{\n\ttry(Stream<Path> pathStream = Files.walk(directoryPath)){\n\t\treturn pathStream\n\t\t\t\t.filter(Files::isRegularFile)\n\t\t\t\t.map(Path::toFile)\n\t\t\t\t.collect(Collectors.toList());\n\t}\n}"), Triple.of((Object)"Test(){}", (Object)EditableJavaMethod.builder().returnType("Test").build(), (Object)"Test(){ }"), Triple.of((Object)"private static String test(String type, int derp)throws Exception,Throwable{doSomething();doSomethingElse();}", (Object)EditableJavaMethod.builder().visibility(Visibility.PRIVATE).isStatic().returnType("String").name("test").parameter("String type").parameter("int derp").throwType("Exception").throwType("Throwable").line("doSomething();").line("doSomethingElse();").build(), (Object)"private static String test(String type, int derp) throws Exception, Throwable{\n\tdoSomething();\n\tdoSomethingElse();\n}"), Triple.of((Object)"\t    \n  \t    Test(){}", (Object)EditableJavaMethod.builder().returnType("Test").build(), (Object)"Test(){ }"), Triple.of((Object)"Test    \t    \n  \t   (){}", (Object)EditableJavaMethod.builder().returnType("Test").build(), (Object)"Test(){ }"), Triple.of((Object)"Test (    \t\n    \t    ){}", (Object)EditableJavaMethod.builder().returnType("Test").build(), (Object)"Test(){ }"), Triple.of((Object)"Test()      \t\n  \t    \t{}", (Object)EditableJavaMethod.builder().returnType("Test").build(), (Object)"Test(){ }"), Triple.of((Object)"Test(){       \t\n   \t    \t\n    \t }", (Object)EditableJavaMethod.builder().returnType("Test").build(), (Object)"Test(){ }"), Triple.of((Object)"Test(){}     \t\n   \t    \t\n   \t", (Object)EditableJavaMethod.builder().returnType("Test").build(), (Object)"Test(){ }"), Triple.of((Object)"\t     \t  \n  \tprivate Test(){}", (Object)EditableJavaMethod.builder().visibility(Visibility.PRIVATE).returnType("Test").build(), (Object)"private Test(){ }"), Triple.of((Object)"\t     \t  \n  \tprotected Test(){}", (Object)EditableJavaMethod.builder().visibility(Visibility.PROTECTED).returnType("Test").build(), (Object)"protected Test(){ }"), Triple.of((Object)"\t     \t  \n  \tpublic Test(){}", (Object)EditableJavaMethod.builder().visibility(Visibility.PUBLIC).returnType("Test").build(), (Object)"public Test(){ }"), Triple.of((Object)"private\t     \t  \n  \tTest(){}", (Object)EditableJavaMethod.builder().visibility(Visibility.PRIVATE).returnType("Test").build(), (Object)"private Test(){ }"), Triple.of((Object)"protected\t     \t  \n  \tTest(){}", (Object)EditableJavaMethod.builder().visibility(Visibility.PROTECTED).returnType("Test").build(), (Object)"protected Test(){ }"), Triple.of((Object)"public\t     \t  \n  \tTest(){}", (Object)EditableJavaMethod.builder().visibility(Visibility.PUBLIC).returnType("Test").build(), (Object)"public Test(){ }"), Triple.of((Object)"\t    \t     \t   \t\n  \t  \tstatic Test(){}", (Object)EditableJavaMethod.builder().isStatic().returnType("Test").build(), (Object)"static Test(){ }"), Triple.of((Object)"static      \t     \t\n    \t    \t  Test(){}", (Object)EditableJavaMethod.builder().isStatic().returnType("Test").build(), (Object)"static Test(){ }"), Triple.of((Object)"\t    \t     \t   \t\n  \t  \tfinal Test(){}", (Object)EditableJavaMethod.builder().isFinal().returnType("Test").build(), (Object)"final Test(){ }"), Triple.of((Object)"final      \t     \t\n    \t    \t  Test(){}", (Object)EditableJavaMethod.builder().isFinal().returnType("Test").build(), (Object)"final Test(){ }"), Triple.of((Object)"String    \t    \t\n   \t   \ttest(){}", (Object)EditableJavaMethod.builder().returnType("String").name("test").build(), (Object)"String test(){ }"), Triple.of((Object)"Test(    \t     \t\n    \t   \t\n    String type){}", (Object)EditableJavaMethod.builder().returnType("Test").parameter("String type").build(), (Object)"Test(String type){ }"), Triple.of((Object)"Test(String    \t     \t\n    \t   \t\n    type){}", (Object)EditableJavaMethod.builder().returnType("Test").parameter("String type").build(), (Object)"Test(String type){ }"), Triple.of((Object)"Test(String type    \t     \t\n    \t   \t\n    \t ){}", (Object)EditableJavaMethod.builder().returnType("Test").parameter("String type").build(), (Object)"Test(String type){ }"), Triple.of((Object)"Test(String type    \t\n    \t   \t ,int derp){}", (Object)EditableJavaMethod.builder().returnType("Test").parameter("String type").parameter("int derp").build(), (Object)"Test(String type, int derp){ }"), Triple.of((Object)"Test(String type,    \t\n    \t   \t int derp){}", (Object)EditableJavaMethod.builder().returnType("Test").parameter("String type").parameter("int derp").build(), (Object)"Test(String type, int derp){ }"), Triple.of((Object)"Test()     \t   \t\n    \t    throws Exception{}", (Object)EditableJavaMethod.builder().returnType("Test").throwType("Exception").build(), (Object)"Test() throws Exception{ }"), Triple.of((Object)"Test()throws     \t   \t\n    \t    Exception{}", (Object)EditableJavaMethod.builder().returnType("Test").throwType("Exception").build(), (Object)"Test() throws Exception{ }"), Triple.of((Object)"Test()throws Exception     \t   \t\n    \t    {}", (Object)EditableJavaMethod.builder().returnType("Test").throwType("Exception").build(), (Object)"Test() throws Exception{ }"), Triple.of((Object)"Test()throws Exception     \t   \t\n    \t    ,Throwable{}", (Object)EditableJavaMethod.builder().returnType("Test").throwType("Exception").throwType("Throwable").build(), (Object)"Test() throws Exception, Throwable{ }"), Triple.of((Object)"Test()throws Exception,     \t   \t\n    \t    Throwable{}", (Object)EditableJavaMethod.builder().returnType("Test").throwType("Exception").throwType("Throwable").build(), (Object)"Test() throws Exception, Throwable{ }"), Triple.of((Object)" \t   \t\n\t    private     \t   \t\n    \t    static     \t   \t\n    \t    final      \t    \t\n    \t    String     \t   \t\n    \t    test     \t   \t\n    \t    (     \t   \t\n    \t    String     \t   \t\n    \t    type     \t   \t\n    \t    ,     \t   \t\n    \t    int     \t   \t\n    \t    derp     \t   \t\n    \t    )     \t   \t\n    \t    throws     \t   \t\n    \t    Exception     \t   \t\n    \t    ,     \t   \t\n    \t    Throwable     \t   \t\n    \t    {     \t   \t\n    \t    doSomething()     \t   \t\n    \t    ;     \t   \t\n    \t    doSomethingElse()     \t   \t\n    \t    ;     \t   \t\n    \t    }     \t   \t\n    \t     ", (Object)EditableJavaMethod.builder().visibility(Visibility.PRIVATE).isStatic().isFinal().returnType("String").name("test").parameter("String type").parameter("int derp").throwType("Exception").throwType("Throwable").line("doSomething();").line("doSomethingElse();").build(), (Object)"private static final String test(String type, int derp) throws Exception, Throwable{\n\tdoSomething();\n\tdoSomethingElse();\n}"), Triple.of((Object)"\t  \t @ \t  \tTest\t  (\t \ttype \t = \t\n\t  \t  String.class\t  , \t  \t defaultValue \t = \t  \t\"\"  \t )    \t\t     \t\n\t    \t@       Derp   \t\n\t\t   \t\n\t\t    private     \t   \t\n\t    static     \t   \t\n\t    final     \t   \t\n\t    String     \t   \t\n\t    test     \t   \t\n\t    (     \t   \t\n\t    String     \t   \t\n\t    type     \t   \t\n\t    ,     \t   \t\n\t    int     \t   \t\n\t    derp     \t   \t\n\t    )     \t   \t\n\t    throws     \t   \t\n\t    Exception     \t   \t\n\t    ,     \t   \t\n\t    Throwable     \t   \t\n\t    {     \t   \t\n\t    doSomething()     \t   \t\n\t    ;     \t   \t\n\t    doSomethingElse()     \t   \t\n\t    ;     \t   \t\n\t    }     \t   \t\n\t     ", (Object)EditableJavaMethod.builder().annotation(EditableJavaAnnotation.builder().name("Test").parameter("type", "String.class").parameter("defaultValue", "\"\"").build()).annotation(EditableJavaAnnotation.builder().name("Derp").build()).visibility(Visibility.PRIVATE).isStatic().isFinal().returnType("String").name("test").parameter("String type").parameter("int derp").throwType("Exception").throwType("Throwable").line("doSomething();").line("doSomethingElse();").build(), (Object)"@Test(type = String.class, defaultValue = \"\")\n@Derp\nprivate static final String test(String type, int derp) throws Exception, Throwable{\n\tdoSomething();\n\tdoSomethingElse();\n}")});
        return parsingData.stream().flatMap(triple -> Stream.of(0, 1).map(index -> Arguments.of((Object[])new Object[]{parseMethods.get((int)index), triple.getLeft(), triple.getMiddle(), triple.getRight()})));
    }

    @ParameterizedTest
    @MethodSource(value={"getParsingData"})
    public void testParsing(ThrowingFunction<String, JavaMethod, JavaParsingException> parseMethod, String textToParse, JavaMethod expectedMethod, String expectedText) throws JavaParsingException {
        JavaMethod method = (JavaMethod)parseMethod.apply((Object)textToParse);
        Assertions.assertNotNull((Object)method);
        Assertions.assertEquals((Object)expectedMethod, (Object)method);
        Assertions.assertEquals((Object)expectedText, (Object)method.toString());
    }

    public static Stream<Arguments> getErrorData() {
        List parsingData = ListUtil.createList((Object[])new Pair[]{Pair.of((Object)"Test(){", (Object)"Didn't complete the method"), Pair.of((Object)"Test(", (Object)"Didn't complete parameters in method\nDidn't complete the method")});
        return parsingData.stream().flatMap(pair -> Stream.of(0, 1).map(index -> Arguments.of((Object[])new Object[]{parseMethods.get((int)index), pair.getLeft(), pair.getRight()})));
    }

    @ParameterizedTest
    @MethodSource(value={"getErrorData"})
    public void testParsingError(ThrowingFunction<String, JavaMethod, JavaParsingException> parseMethod, String parseText, String error) {
        try {
            parseMethod.apply((Object)parseText);
            Assertions.fail();
        }
        catch (JavaParsingException e) {
            Assertions.assertEquals((Object)this.buildJavaParsingExceptionMessage(JavaCodeTypes.METHOD, error), (Object)e.getMessage());
        }
    }

    @Test
    public void testTooManyJavadocs() {
        try {
            JavaMethodParser.parseMethod((String)"/** {@inheritDoc} */\n/** some other Javadoc */\nTest(){}");
            Assertions.fail();
        }
        catch (JavaParsingException e) {
            Assertions.assertEquals((Object)this.buildJavaParsingExceptionMessage(JavaCodeTypes.METHOD, "Only one Javadoc allowed on a method!"), (Object)e.getMessage());
        }
    }

    @Test
    public void testJavadocAfterMethod() {
        try {
            JavaMethodParser.parseMethod((String)"Test(){}\n/** {@inheritDoc} */");
            Assertions.fail();
        }
        catch (JavaParsingException e) {
            Assertions.assertEquals((Object)this.buildJavaParsingExceptionMessage(JavaCodeTypes.METHOD, "Encountered Javadoc after method!"), (Object)e.getMessage());
        }
    }

    @Test
    public void testAnnotationAfterMethod() {
        try {
            JavaMethodParser.parseMethod((String)"Test(){}\n@Test");
            Assertions.fail();
        }
        catch (JavaParsingException e) {
            Assertions.assertEquals((Object)this.buildJavaParsingExceptionMessage(JavaCodeTypes.METHOD, "Encountered annotation after method!"), (Object)e.getMessage());
        }
    }

    @Test
    public void testMultipleMethods() {
        try {
            JavaMethodParser.parseMethod((String)"Test(){}\nTest(){}");
            Assertions.fail();
        }
        catch (JavaParsingException e) {
            Assertions.assertEquals((Object)this.buildJavaParsingExceptionMessage(JavaCodeTypes.METHOD, "Encountered multiple methods!"), (Object)e.getMessage());
        }
    }

    @Test
    public void testNotAMethod() {
        try {
            JavaMethodParser.parseMethod((String)"@Test");
            Assertions.fail();
        }
        catch (JavaParsingException e) {
            Assertions.assertEquals((Object)this.buildJavaParsingExceptionMessage(JavaCodeTypes.METHOD, "Failed to parse an actual method!"), (Object)e.getMessage());
        }
    }

    @Test
    public void testNotAMethodParseJustMethod() {
        Assertions.assertNull((Object)JavaMethodParser.parseJustMethod((String)"@Test"));
    }
}

