/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.java.parsing.codetypes;

import com.github.tadukoo.java.JavaCodeTypes;
import com.github.tadukoo.java.packagedeclaration.EditableJavaPackageDeclaration;
import com.github.tadukoo.java.packagedeclaration.JavaPackageDeclaration;
import com.github.tadukoo.java.parsing.BaseJavaParserTest;
import com.github.tadukoo.java.parsing.JavaParsingException;
import com.github.tadukoo.java.parsing.codetypes.JavaPackageDeclarationParser;
import com.github.tadukoo.util.ListUtil;
import com.github.tadukoo.util.functional.function.ThrowingFunction;
import com.github.tadukoo.util.tuple.Pair;
import com.github.tadukoo.util.tuple.Triple;
import java.util.List;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class JavaPackageDeclarationParserTest
extends BaseJavaParserTest {
    private static final List<ThrowingFunction<String, JavaPackageDeclaration, JavaParsingException>> parseMethods = ListUtil.createList((Object[])new ThrowingFunction[]{x$0 -> BaseJavaParserTest.runFullParserForPackageDeclaration(x$0), JavaPackageDeclarationParser::parsePackageDeclaration});

    public static Stream<Arguments> getParsingData() {
        List parsingData = ListUtil.createList((Object[])new Triple[]{Triple.of((Object)"package com.example;", (Object)EditableJavaPackageDeclaration.builder().packageName("com.example").build(), (Object)"package com.example;"), Triple.of((Object)"\t    \t\npackage com.example;", (Object)EditableJavaPackageDeclaration.builder().packageName("com.example").build(), (Object)"package com.example;"), Triple.of((Object)"package\t  \t\n\tcom.example;", (Object)EditableJavaPackageDeclaration.builder().packageName("com.example").build(), (Object)"package com.example;"), Triple.of((Object)"package com\t \t\n\t.\n\t  example;", (Object)EditableJavaPackageDeclaration.builder().packageName("com.example").build(), (Object)"package com.example;"), Triple.of((Object)"package com.example  \t\n;", (Object)EditableJavaPackageDeclaration.builder().packageName("com.example").build(), (Object)"package com.example;"), Triple.of((Object)"package com.example;\t\n  \t", (Object)EditableJavaPackageDeclaration.builder().packageName("com.example").build(), (Object)"package com.example;"), Triple.of((Object)"\t    \tpackage\t  \t\n\tcom\t \t\n\t.\n\t  example  \t\n;\t\n  \t", (Object)EditableJavaPackageDeclaration.builder().packageName("com.example").build(), (Object)"package com.example;")});
        return parsingData.stream().flatMap(triple -> Stream.of(0, 1).map(index -> Arguments.of((Object[])new Object[]{parseMethods.get((int)index), triple.getLeft(), triple.getMiddle(), triple.getRight()})));
    }

    @ParameterizedTest
    @MethodSource(value={"getParsingData"})
    public void testParsing(ThrowingFunction<String, JavaPackageDeclaration, JavaParsingException> parseMethod, String textToParse, JavaPackageDeclaration expectedPackageDeclaration, String expectedText) throws JavaParsingException {
        JavaPackageDeclaration packageDeclaration = (JavaPackageDeclaration)parseMethod.apply((Object)textToParse);
        Assertions.assertNotNull((Object)packageDeclaration);
        Assertions.assertEquals((Object)expectedPackageDeclaration, (Object)packageDeclaration);
        Assertions.assertEquals((Object)expectedText, (Object)packageDeclaration.toString());
    }

    public static Stream<Arguments> getErrorData() {
        List parsingData = ListUtil.createList((Object[])new Pair[]{Pair.of((Object)"package ;", (Object)"Failed to find package name in package declaration!"), Pair.of((Object)"package com.example", (Object)"Failed to find semicolon ending package declaration!"), Pair.of((Object)"package", (Object)"Failed to find package name in package declaration!\nFailed to find semicolon ending package declaration!")});
        return parsingData.stream().flatMap(pair -> Stream.of(0, 1).map(index -> Arguments.of((Object[])new Object[]{parseMethods.get((int)index), pair.getLeft(), pair.getRight()})));
    }

    @ParameterizedTest
    @MethodSource(value={"getErrorData"})
    public void testParsingError(ThrowingFunction<String, JavaPackageDeclaration, JavaParsingException> parseMethod, String parseText, String error) {
        try {
            parseMethod.apply((Object)parseText);
            Assertions.fail();
        }
        catch (JavaParsingException e) {
            Assertions.assertEquals((Object)this.buildJavaParsingExceptionMessage(JavaCodeTypes.PACKAGE_DECLARATION, error), (Object)e.getMessage());
        }
    }

    @Test
    public void testPackageTokenMissing() {
        try {
            JavaPackageDeclarationParser.parsePackageDeclaration((String)"com.example;\n");
            Assertions.fail();
        }
        catch (JavaParsingException e) {
            Assertions.assertEquals((Object)this.buildJavaParsingExceptionMessage(JavaCodeTypes.PACKAGE_DECLARATION, "First token of package declaration must be 'package'"), (Object)e.getMessage());
        }
    }
}

