/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.java.parsing.codetypes;

import com.github.tadukoo.java.JavaCodeTypes;
import com.github.tadukoo.java.parsing.BaseJavaParserTest;
import com.github.tadukoo.java.parsing.FullJavaParser;
import com.github.tadukoo.java.parsing.JavaParsingException;
import com.github.tadukoo.java.parsing.codetypes.JavaTypeWithModifiersParser;
import com.github.tadukoo.util.ListUtil;
import java.util.List;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class JavaTypeWithModifiersParserErrorsTest
extends BaseJavaParserTest {
    public static Stream<Arguments> getParseTypeWithModifiersData() {
        return Stream.of(Arguments.of((Object[])new Object[]{ListUtil.createList((Object[])new String[]{"String", " ", "type;"}), JavaCodeTypes.FIELD, "First token of type with modifiers must be a modifier"}), Arguments.of((Object[])new Object[]{ListUtil.createList((Object[])new String[]{"static", " ", "yep"}), JavaCodeTypes.UNKNOWN, "Failed to determine type\nFailed to determine result type"}));
    }

    @ParameterizedTest
    @MethodSource(value={"getParseTypeWithModifiersData"})
    public void testParseTypeWithModifiers(List<String> tokens, JavaCodeTypes codeType, String error) {
        try {
            JavaTypeWithModifiersParser.parseTypeWithModifiers(tokens, (int)0);
            Assertions.fail();
        }
        catch (JavaParsingException e) {
            Assertions.assertEquals((Object)this.buildJavaParsingExceptionMessage(codeType, error), (Object)e.getMessage());
        }
    }

    public static Stream<Arguments> getParseTypeData() {
        return Stream.of(Arguments.of((Object[])new Object[]{"static static class Test{\n}\n", JavaCodeTypes.CLASS, "Found duplicate modifier: 'static'"}), Arguments.of((Object[])new Object[]{"static static final final class Test{\n}\n", JavaCodeTypes.CLASS, "Found duplicate modifier: 'static'\nFound duplicate modifier: 'final'"}), Arguments.of((Object[])new Object[]{"private public class Test{\n}\n", JavaCodeTypes.CLASS, "Found multiple visibility modifiers"}), Arguments.of((Object[])new Object[]{"private\n", JavaCodeTypes.TYPE_WITH_MODIFIERS, "Failed to determine result type"}), Arguments.of((Object[])new Object[]{"private public static static final final\n", JavaCodeTypes.TYPE_WITH_MODIFIERS, "Found duplicate modifier: 'static'\nFound duplicate modifier: 'final'\nFound multiple visibility modifiers\nFailed to determine result type"}));
    }

    @ParameterizedTest
    @MethodSource(value={"getParseTypeData"})
    public void testParseTypeError(String parseText, JavaCodeTypes codeType, String error) {
        try {
            FullJavaParser.parseType((String)parseText);
            Assertions.fail();
        }
        catch (JavaParsingException e) {
            Assertions.assertEquals((Object)this.buildJavaParsingExceptionMessage(codeType, error), (Object)e.getMessage());
        }
    }
}

