/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.java.parsing.comment;

import com.github.tadukoo.java.JavaCodeTypes;
import com.github.tadukoo.java.comment.EditableJavaMultiLineComment;
import com.github.tadukoo.java.comment.JavaMultiLineComment;
import com.github.tadukoo.java.parsing.BaseJavaParserTest;
import com.github.tadukoo.java.parsing.JavaParsingException;
import com.github.tadukoo.java.parsing.comment.JavaMultiLineCommentParser;
import com.github.tadukoo.util.ListUtil;
import com.github.tadukoo.util.functional.function.ThrowingFunction;
import com.github.tadukoo.util.tuple.Pair;
import com.github.tadukoo.util.tuple.Triple;
import java.util.List;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class JavaMultiLineCommentParserTest
extends BaseJavaParserTest {
    private static final List<ThrowingFunction<String, JavaMultiLineComment, JavaParsingException>> parseMethods = ListUtil.createList((Object[])new ThrowingFunction[]{x$0 -> BaseJavaParserTest.runFullParserForMultiLineComment(x$0), JavaMultiLineCommentParser::parseMultiLineComment});

    public static Stream<Arguments> getParsingData() {
        List parsingData = ListUtil.createList((Object[])new Triple[]{Triple.of((Object)"/*\n */", (Object)EditableJavaMultiLineComment.builder().build(), (Object)"/*\n */"), Triple.of((Object)"/*\n * something useful\n */", (Object)EditableJavaMultiLineComment.builder().content("something useful").build(), (Object)"/*\n * something useful\n */"), Triple.of((Object)"/*\n * something useful\n * something else\n */", (Object)EditableJavaMultiLineComment.builder().content("something useful").content("something else").build(), (Object)"/*\n * something useful\n * something else\n */"), Triple.of((Object)"/*\n * something useful\n * \n * something else\n */", (Object)EditableJavaMultiLineComment.builder().content("something useful").content("").content("something else").build(), (Object)"/*\n * something useful\n * \n * something else\n */"), Triple.of((Object)"/*\n * something * useful\n */", (Object)EditableJavaMultiLineComment.builder().content("something * useful").build(), (Object)"/*\n * something * useful\n */"), Triple.of((Object)"/* something useful\n */", (Object)EditableJavaMultiLineComment.builder().content("something useful").build(), (Object)"/*\n * something useful\n */"), Triple.of((Object)"/*something useful\n */", (Object)EditableJavaMultiLineComment.builder().content("something useful").build(), (Object)"/*\n * something useful\n */"), Triple.of((Object)"/*\n * something useful */", (Object)EditableJavaMultiLineComment.builder().content("something useful").build(), (Object)"/*\n * something useful\n */"), Triple.of((Object)"/*\n * something useful*/", (Object)EditableJavaMultiLineComment.builder().content("something useful").build(), (Object)"/*\n * something useful\n */"), Triple.of((Object)"\t     \t  \t\n\t    \t\n\t     \t    /*\n * something\n */", (Object)EditableJavaMultiLineComment.builder().content("something").build(), (Object)"/*\n * something\n */"), Triple.of((Object)"/*\n * something\n */    \t\n \t     \t  \t\n\t    \t\n\t     \t    \t", (Object)EditableJavaMultiLineComment.builder().content("something").build(), (Object)"/*\n * something\n */"), Triple.of((Object)"\t     \t  \t\n\t    \t\n\t     \t    /*\n * something\n */    \t\n \t     \t  \t\n\t    \t\n\t     \t    \t", (Object)EditableJavaMultiLineComment.builder().content("something").build(), (Object)"/*\n * something\n */")});
        return parsingData.stream().flatMap(triple -> Stream.of(0, 1).map(index -> Arguments.of((Object[])new Object[]{parseMethods.get((int)index), triple.getLeft(), triple.getMiddle(), triple.getRight()})));
    }

    @ParameterizedTest
    @MethodSource(value={"getParsingData"})
    public void testParsing(ThrowingFunction<String, JavaMultiLineComment, JavaParsingException> parseMethod, String textToParse, JavaMultiLineComment expectedMultiLineComment, String expectedText) throws JavaParsingException {
        JavaMultiLineComment multiLineComment = (JavaMultiLineComment)parseMethod.apply((Object)textToParse);
        Assertions.assertNotNull((Object)multiLineComment);
        Assertions.assertEquals((Object)expectedMultiLineComment, (Object)multiLineComment);
        Assertions.assertEquals((Object)expectedText, (Object)multiLineComment.toString());
    }

    public static Stream<Arguments> getErrorData() {
        List parsingData = ListUtil.createList((Object[])new Pair[]{Pair.of((Object)"/*", (Object)"Failed to find closing multi-line comment token!")});
        return parsingData.stream().flatMap(pair -> Stream.of(0, 1).map(index -> Arguments.of((Object[])new Object[]{parseMethods.get((int)index), pair.getLeft(), pair.getRight()})));
    }

    @ParameterizedTest
    @MethodSource(value={"getErrorData"})
    public void testParsingError(ThrowingFunction<String, JavaMultiLineComment, JavaParsingException> parseMethod, String parseText, String error) {
        try {
            parseMethod.apply((Object)parseText);
            Assertions.fail();
        }
        catch (JavaParsingException e) {
            Assertions.assertEquals((Object)this.buildJavaParsingExceptionMessage(JavaCodeTypes.MULTI_LINE_COMMENT, error), (Object)e.getMessage());
        }
    }

    @Test
    public void testMissingStartToken() {
        try {
            JavaMultiLineCommentParser.parseMultiLineComment((String)"*/");
            Assertions.fail();
        }
        catch (JavaParsingException e) {
            Assertions.assertEquals((Object)this.buildJavaParsingExceptionMessage(JavaCodeTypes.MULTI_LINE_COMMENT, "First token of multi-line comment must start with '/*'"), (Object)e.getMessage());
        }
    }
}

