/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.java.parsing.comment;

import com.github.tadukoo.java.JavaCodeTypes;
import com.github.tadukoo.java.comment.EditableJavaSingleLineComment;
import com.github.tadukoo.java.comment.JavaSingleLineComment;
import com.github.tadukoo.java.parsing.BaseJavaParserTest;
import com.github.tadukoo.java.parsing.JavaParsingException;
import com.github.tadukoo.java.parsing.comment.JavaSingleLineCommentParser;
import com.github.tadukoo.util.ListUtil;
import com.github.tadukoo.util.functional.function.ThrowingFunction;
import com.github.tadukoo.util.tuple.Triple;
import java.util.List;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class JavaSingleLineCommentParserTest
extends BaseJavaParserTest {
    private static final List<ThrowingFunction<String, JavaSingleLineComment, JavaParsingException>> parseMethods = ListUtil.createList((Object[])new ThrowingFunction[]{x$0 -> BaseJavaParserTest.runFullParserForSingleLineComment(x$0), JavaSingleLineCommentParser::parseSingleLineComment});

    public static Stream<Arguments> getParsingData() {
        List parsingData = ListUtil.createList((Object[])new Triple[]{Triple.of((Object)"//", (Object)EditableJavaSingleLineComment.builder().build(), (Object)"// "), Triple.of((Object)"// something useful here", (Object)EditableJavaSingleLineComment.builder().content("something useful here").build(), (Object)"// something useful here"), Triple.of((Object)"//something useful here", (Object)EditableJavaSingleLineComment.builder().content("something useful here").build(), (Object)"// something useful here"), Triple.of((Object)"\t     \t  \t\n\t    // something useful", (Object)EditableJavaSingleLineComment.builder().content("something useful").build(), (Object)"// something useful"), Triple.of((Object)"// something useful \t    \t \t\n\t     \t", (Object)EditableJavaSingleLineComment.builder().content("something useful").build(), (Object)"// something useful"), Triple.of((Object)"// something useful \t      \t \t\n\t     \t\n\t  \t\n\t  \t", (Object)EditableJavaSingleLineComment.builder().content("something useful").build(), (Object)"// something useful"), Triple.of((Object)"// something \t     \t   useful", (Object)EditableJavaSingleLineComment.builder().content("something \t     \t   useful").build(), (Object)"// something \t     \t   useful"), Triple.of((Object)"// \t     \t   something useful", (Object)EditableJavaSingleLineComment.builder().content("something useful").build(), (Object)"// something useful"), Triple.of((Object)"\t     \t  \t\n\t    // \t     \t   something \t     \t   useful \t     \t  \t\n\t     \t", (Object)EditableJavaSingleLineComment.builder().content("something \t     \t   useful").build(), (Object)"// something \t     \t   useful")});
        return parsingData.stream().flatMap(triple -> Stream.of(0, 1).map(index -> Arguments.of((Object[])new Object[]{parseMethods.get((int)index), triple.getLeft(), triple.getMiddle(), triple.getRight()})));
    }

    @ParameterizedTest
    @MethodSource(value={"getParsingData"})
    public void testParsing(ThrowingFunction<String, JavaSingleLineComment, JavaParsingException> parseMethod, String textToParse, JavaSingleLineComment expectedSingleLineComment, String expectedText) throws JavaParsingException {
        JavaSingleLineComment SingleLineComment = (JavaSingleLineComment)parseMethod.apply((Object)textToParse);
        Assertions.assertNotNull((Object)SingleLineComment);
        Assertions.assertEquals((Object)expectedSingleLineComment, (Object)SingleLineComment);
        Assertions.assertEquals((Object)expectedText, (Object)SingleLineComment.toString());
    }

    @Test
    public void testExtraContentFoundError() {
        try {
            JavaSingleLineCommentParser.parseSingleLineComment((String)"// some comment\n// some other comment");
            Assertions.fail();
        }
        catch (JavaParsingException e) {
            Assertions.assertEquals((Object)this.buildJavaParsingExceptionMessage(JavaCodeTypes.SINGLE_LINE_COMMENT, "Found extra content after the single-line comment!"), (Object)e.getMessage());
        }
    }

    @Test
    public void testCommentDoesNotStartWithTokenError() {
        try {
            JavaSingleLineCommentParser.parseSingleLineComment((String)"/* some comment */");
            Assertions.fail();
        }
        catch (JavaParsingException e) {
            Assertions.assertEquals((Object)this.buildJavaParsingExceptionMessage(JavaCodeTypes.SINGLE_LINE_COMMENT, "First token of single-line comment must start with '//'"), (Object)e.getMessage());
        }
    }
}

