/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.java.parsing.comment;

import com.github.tadukoo.java.JavaCodeTypes;
import com.github.tadukoo.java.javadoc.EditableJavadoc;
import com.github.tadukoo.java.javadoc.Javadoc;
import com.github.tadukoo.java.parsing.BaseJavaParserTest;
import com.github.tadukoo.java.parsing.JavaParsingException;
import com.github.tadukoo.java.parsing.comment.JavadocParser;
import com.github.tadukoo.util.ListUtil;
import com.github.tadukoo.util.functional.function.ThrowingFunction;
import com.github.tadukoo.util.tuple.Pair;
import com.github.tadukoo.util.tuple.Triple;
import java.util.List;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class JavadocParserTest
extends BaseJavaParserTest {
    private static final List<ThrowingFunction<String, Javadoc, JavaParsingException>> parseMethods = ListUtil.createList((Object[])new ThrowingFunction[]{x$0 -> BaseJavaParserTest.runFullParserForJavadoc(x$0), JavadocParser::parseJavadoc});

    public static Stream<Arguments> getParsingData() {
        List parsingData = ListUtil.createList((Object[])new Triple[]{Triple.of((Object)"/** */", (Object)EditableJavadoc.builder().condensed().build(), (Object)"/** */"), Triple.of((Object)"/**\n */", (Object)EditableJavadoc.builder().build(), (Object)"/**\n */"), Triple.of((Object)"/** some content */", (Object)EditableJavadoc.builder().condensed().content("some content").build(), (Object)"/** some content */"), Triple.of((Object)"/**\n * some content\n */", (Object)EditableJavadoc.builder().content("some content").build(), (Object)"/**\n * some content\n */"), Triple.of((Object)"/** @author Logan Ferree (Tadukoo) */", (Object)EditableJavadoc.builder().condensed().author("Logan Ferree (Tadukoo)").build(), (Object)"/** @author Logan Ferree (Tadukoo) */"), Triple.of((Object)"/**\n * @author Logan Ferree (Tadukoo)\n */", (Object)EditableJavadoc.builder().author("Logan Ferree (Tadukoo)").build(), (Object)"/**\n * @author Logan Ferree (Tadukoo)\n */"), Triple.of((Object)"/** @version Beta v.0.5 */", (Object)EditableJavadoc.builder().condensed().version("Beta v.0.5").build(), (Object)"/** @version Beta v.0.5 */"), Triple.of((Object)"/**\n * @version Beta v.0.5\n */", (Object)EditableJavadoc.builder().version("Beta v.0.5").build(), (Object)"/**\n * @version Beta v.0.5\n */"), Triple.of((Object)"/** @since Alpha v.0.1 */", (Object)EditableJavadoc.builder().condensed().since("Alpha v.0.1").build(), (Object)"/** @since Alpha v.0.1 */"), Triple.of((Object)"/**\n * @since Alpha v.0.1\n */", (Object)EditableJavadoc.builder().since("Alpha v.0.1").build(), (Object)"/**\n * @since Alpha v.0.1\n */"), Triple.of((Object)"/** @param type The type */", (Object)EditableJavadoc.builder().condensed().param("type", "The type").build(), (Object)"/** @param type The type */"), Triple.of((Object)"/**\n * @param type The type\n */", (Object)EditableJavadoc.builder().param("type", "The type").build(), (Object)"/**\n * @param type The type\n */"), Triple.of((Object)"/** @return this, to continue building */", (Object)EditableJavadoc.builder().condensed().returnVal("this, to continue building").build(), (Object)"/** @return this, to continue building */"), Triple.of((Object)"/**\n * @return this, to continue building\n */", (Object)EditableJavadoc.builder().returnVal("this, to continue building").build(), (Object)"/**\n * @return this, to continue building\n */"), Triple.of((Object)"/** @throws Exception Because I can */", (Object)EditableJavadoc.builder().condensed().throwsInfo("Exception", "Because I can").build(), (Object)"/** @throws Exception Because I can */"), Triple.of((Object)"/**\n * @throws Exception Because I can\n */", (Object)EditableJavadoc.builder().throwsInfo("Exception", "Because I can").build(), (Object)"/**\n * @throws Exception Because I can\n */"), Triple.of((Object)"/** some content\n * @author Logan Ferree (Tadukoo)\n * @version Beta v.0.5\n * @since Alpha v.0.1\n * @param type The type\n * @param derp The int\n * @return this, to continue building\n * @throws Exception Because I can */", (Object)EditableJavadoc.builder().condensed().content("some content").author("Logan Ferree (Tadukoo)").version("Beta v.0.5").since("Alpha v.0.1").param("type", "The type").param("derp", "The int").returnVal("this, to continue building").throwsInfo("Exception", "Because I can").build(), (Object)"/** some content\n * \n * @author Logan Ferree (Tadukoo)\n * @version Beta v.0.5\n * @since Alpha v.0.1\n * \n * @param type The type\n * @param derp The int\n * @return this, to continue building\n * @throws Exception Because I can */"), Triple.of((Object)"/**\n * some content\n * @author Logan Ferree (Tadukoo)\n * @version Beta v.0.5\n * @since Alpha v.0.1\n * @param type The type\n * @param derp The int\n * @return this, to continue building\n * @throws Exception Because I can\n */", (Object)EditableJavadoc.builder().content("some content").author("Logan Ferree (Tadukoo)").version("Beta v.0.5").since("Alpha v.0.1").param("type", "The type").param("derp", "The int").returnVal("this, to continue building").throwsInfo("Exception", "Because I can").build(), (Object)"/**\n * some content\n * \n * @author Logan Ferree (Tadukoo)\n * @version Beta v.0.5\n * @since Alpha v.0.1\n * \n * @param type The type\n * @param derp The int\n * @return this, to continue building\n * @throws Exception Because I can\n */"), Triple.of((Object)"/** @garbage something */", (Object)EditableJavadoc.builder().condensed().content("@garbage something").build(), (Object)"/** @garbage something */"), Triple.of((Object)"/**\n * @garbage something\n */", (Object)EditableJavadoc.builder().content("@garbage something").build(), (Object)"/**\n * @garbage something\n */"), Triple.of((Object)"/**\n * something\n * \n * something else\n */", (Object)EditableJavadoc.builder().content("something").content("something else").build(), (Object)"/**\n * something\n * something else\n */"), Triple.of((Object)"/**\n * /**\n */", (Object)EditableJavadoc.builder().content("/**").build(), (Object)"/**\n * /**\n */"), Triple.of((Object)"/** {@inheritDoc} */", (Object)EditableJavadoc.builder().condensed().content("{@inheritDoc}").build(), (Object)"/** {@inheritDoc} */"), Triple.of((Object)"/** {content} */", (Object)EditableJavadoc.builder().condensed().content("{content}").build(), (Object)"/** {content} */"), Triple.of((Object)"/**some content */", (Object)EditableJavadoc.builder().condensed().content("some content").build(), (Object)"/** some content */"), Triple.of((Object)"/**@author Logan Ferree (Tadukoo) */", (Object)EditableJavadoc.builder().condensed().author("Logan Ferree (Tadukoo)").build(), (Object)"/** @author Logan Ferree (Tadukoo) */"), Triple.of((Object)"\t     \t   \t\n\t    \t  \t\n\t   /**\n * some content\n */", (Object)EditableJavadoc.builder().content("some content").build(), (Object)"/**\n * some content\n */"), Triple.of((Object)"/**\n * some content\n */   \t\n \t     \t   \t\n\t    \t  \t\n\t    ", (Object)EditableJavadoc.builder().content("some content").build(), (Object)"/**\n * some content\n */"), Triple.of((Object)"/**\r\n * Represents a {@link FormField} for a Label\n * \n * @author Logan Ferree (Tadukoo)\n * @version Alpha v.0.4\n */\n", (Object)EditableJavadoc.builder().content("Represents a {@link FormField} for a Label").author("Logan Ferree (Tadukoo)").version("Alpha v.0.4").build(), (Object)"/**\n * Represents a {@link FormField} for a Label\n * \n * @author Logan Ferree (Tadukoo)\n * @version Alpha v.0.4\n */")});
        return parsingData.stream().flatMap(triple -> Stream.of(0, 1).map(index -> Arguments.of((Object[])new Object[]{parseMethods.get((int)index), triple.getLeft(), triple.getMiddle(), triple.getRight()})));
    }

    @ParameterizedTest
    @MethodSource(value={"getParsingData"})
    public void testParsing(ThrowingFunction<String, Javadoc, JavaParsingException> parseMethod, String textToParse, Javadoc expectedDoc, String expectedText) throws JavaParsingException {
        Javadoc doc = (Javadoc)parseMethod.apply((Object)textToParse);
        Assertions.assertNotNull((Object)doc);
        Assertions.assertEquals((Object)expectedDoc, (Object)doc);
        Assertions.assertEquals((Object)expectedText, (Object)doc.toString());
    }

    public static Stream<Arguments> getErrorData() {
        List parsingData = ListUtil.createList((Object[])new Pair[]{Pair.of((Object)"/** @author Logan Ferree (Tadukoo)\n * @author Shea */", (Object)"Found multiple author strings"), Pair.of((Object)"/** @author Logan Ferree (Tadukoo)\n * @author Shea\n * @author Zack */", (Object)"Found multiple author strings"), Pair.of((Object)"/** @version Beta v.0.5\n * @version Beta v.0.4 */", (Object)"Found multiple version strings"), Pair.of((Object)"/** @version Beta v.0.5\n * @version Beta v.0.4\n * @version Alpha v.0.1 */", (Object)"Found multiple version strings"), Pair.of((Object)"/** @since Beta v.0.5\n * @since Beta v.0.4 */", (Object)"Found multiple since strings"), Pair.of((Object)"/** @since Beta v.0.5\n * @since Beta v.0.4\n * @since Alpha v.0.1 */", (Object)"Found multiple since strings"), Pair.of((Object)"/** @return this, to continue building\n * @return The type */", (Object)"Found multiple return strings"), Pair.of((Object)"/** @return this, to continue building\n * @return The type\n * @return I don't even know */", (Object)"Found multiple return strings")});
        return parsingData.stream().flatMap(pair -> Stream.of(0, 1).map(index -> Arguments.of((Object[])new Object[]{parseMethods.get((int)index), pair.getLeft(), pair.getRight()})));
    }

    @ParameterizedTest
    @MethodSource(value={"getErrorData"})
    public void testParsingError(ThrowingFunction<String, Javadoc, JavaParsingException> parseMethod, String parseText, String error) {
        try {
            parseMethod.apply((Object)parseText);
            Assertions.fail();
        }
        catch (JavaParsingException e) {
            Assertions.assertEquals((Object)this.buildJavaParsingExceptionMessage(JavaCodeTypes.JAVADOC, error), (Object)e.getMessage());
        }
    }

    @Test
    public void testNoJavadocStartToken() {
        try {
            JavadocParser.parseJavadoc((String)"* some content\n*/");
            Assertions.fail();
        }
        catch (JavaParsingException e) {
            Assertions.assertEquals((Object)this.buildJavaParsingExceptionMessage(JavaCodeTypes.JAVADOC, "First token of Javadoc must start with '/**'"), (Object)e.getMessage());
        }
    }
}

