/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.java.validation;

import com.github.tadukoo.java.annotation.EditableJavaAnnotation;
import com.github.tadukoo.java.annotation.JavaAnnotation;
import com.github.tadukoo.java.javaclass.EditableJavaClass;
import com.github.tadukoo.java.javaclass.UneditableJavaClass;
import com.github.tadukoo.java.validation.JavaValidator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class JavaValidatorTest {
    private JavaValidator validator;

    @BeforeEach
    public void setup() {
        this.validator = new JavaValidator();
    }

    @Test
    public void testDetermineCanonicalNamesNotEditableJavaClass() {
        try {
            this.validator.determineCanonicalNames(UneditableJavaClass.builder().className("Test").build());
            Assertions.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"Need EditableJavaClass to modify canonical names", (Object)e.getMessage());
        }
    }

    @Test
    public void testDetermineCanonicalNamesSuccess() {
        JavaAnnotation annotation = EditableJavaAnnotation.builder().name("Something").build();
        String canonicalName = "com.example.Something";
        this.validator.determineCanonicalNames(EditableJavaClass.builder().importName(canonicalName, false).className("Test").annotation(annotation).build());
        Assertions.assertEquals((Object)canonicalName, (Object)annotation.getCanonicalName());
    }
}

