/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.java;

import com.github.tadukoo.java.JavaCodeType;
import com.github.tadukoo.java.JavaCodeTypes;
import com.github.tadukoo.java.JavaType;
import com.github.tadukoo.util.StringUtil;
import java.util.ArrayList;

public class JavaParameter
implements JavaCodeType {
    private final JavaType type;
    private final String name;
    private final boolean vararg;

    private JavaParameter(JavaType type, String name, boolean vararg) {
        this.type = type;
        this.name = name;
        this.vararg = vararg;
    }

    public static JavaParameterBuilder builder() {
        return new JavaParameterBuilder();
    }

    @Override
    public JavaCodeTypes getJavaCodeType() {
        return JavaCodeTypes.PARAMETER;
    }

    public JavaType getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public boolean isVararg() {
        return this.vararg;
    }

    public boolean equals(Object otherParameter) {
        if (otherParameter instanceof JavaParameter) {
            JavaParameter parameter = (JavaParameter)otherParameter;
            return StringUtil.equals((String)this.toString(), (String)parameter.toString());
        }
        return false;
    }

    public String toString() {
        StringBuilder parameterText = new StringBuilder(this.type.toString());
        if (this.vararg) {
            parameterText.append(" ").append("...");
        }
        parameterText.append(" ").append(this.name);
        return parameterText.toString();
    }

    @Override
    public String toBuilderCode() {
        StringBuilder codeString = new StringBuilder(this.getClass().getSimpleName()).append(".builder()");
        codeString.append("\n\t\t").append(".type(").append(this.type.toBuilderCode().replace("\n\t\t", "\n\t\t\t\t")).append(')');
        if (this.vararg) {
            codeString.append("\n\t\t").append(".vararg()");
        }
        codeString.append("\n\t\t").append(".name(\"").append(this.name).append("\")");
        codeString.append("\n\t\t").append(".build()");
        return codeString.toString();
    }

    public static class JavaParameterBuilder {
        private JavaType type = null;
        private String name = null;
        private boolean vararg = false;

        private JavaParameterBuilder() {
        }

        public JavaParameterBuilder type(JavaType type) {
            this.type = type;
            return this;
        }

        public JavaParameterBuilder name(String name) {
            this.name = name;
            return this;
        }

        public JavaParameterBuilder vararg() {
            this.vararg = true;
            return this;
        }

        public JavaParameterBuilder vararg(boolean vararg) {
            this.vararg = vararg;
            return this;
        }

        public JavaParameter build() {
            ArrayList<String> errors = new ArrayList<String>();
            if (this.type == null) {
                errors.add("type can't be null!");
            }
            if (StringUtil.isBlank((String)this.name)) {
                errors.add("name can't be empty!");
            }
            if (!errors.isEmpty()) {
                throw new IllegalArgumentException(StringUtil.buildStringWithNewLines(errors));
            }
            return new JavaParameter(this.type, this.name, this.vararg);
        }
    }
}

