/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.java;

import com.github.tadukoo.java.JavaCodeType;
import com.github.tadukoo.java.JavaCodeTypes;
import com.github.tadukoo.java.JavaTypeParameter;
import com.github.tadukoo.util.ListUtil;
import com.github.tadukoo.util.StringUtil;
import java.util.ArrayList;
import java.util.List;

public class JavaType
implements JavaCodeType {
    private final String baseType;
    private String canonicalName;
    private final List<JavaTypeParameter> typeParameters;

    private JavaType(String baseType, String canonicalName, List<JavaTypeParameter> typeParameters) {
        this.baseType = baseType;
        this.canonicalName = canonicalName;
        this.typeParameters = typeParameters;
    }

    public static JavaTypeBuilder builder() {
        return new JavaTypeBuilder();
    }

    @Override
    public JavaCodeTypes getJavaCodeType() {
        return JavaCodeTypes.TYPE;
    }

    public String getBaseType() {
        return this.baseType;
    }

    public String getCanonicalName() {
        return this.canonicalName;
    }

    public void setCanonicalName(String canonicalName) {
        this.canonicalName = canonicalName;
    }

    public List<JavaTypeParameter> getTypeParameters() {
        return this.typeParameters;
    }

    public boolean equals(Object otherType) {
        if (otherType instanceof JavaType) {
            JavaType type = (JavaType)otherType;
            return StringUtil.equals((String)this.toString(), (String)type.toString()) && StringUtil.equals((String)this.getCanonicalName(), (String)type.getCanonicalName());
        }
        return false;
    }

    public String toString() {
        StringBuilder typeText = new StringBuilder(this.baseType);
        if (ListUtil.isNotBlank(this.typeParameters)) {
            typeText.append("<");
            for (JavaTypeParameter typeParam : this.typeParameters) {
                typeText.append(typeParam).append(",").append(" ");
            }
            typeText.delete(typeText.length() - 2, typeText.length());
            typeText.append(">");
        }
        return typeText.toString();
    }

    @Override
    public String toBuilderCode() {
        StringBuilder codeString = new StringBuilder(this.getClass().getSimpleName()).append(".builder()");
        codeString.append("\n\t\t").append(".baseType(\"").append(this.baseType).append("\")");
        if (StringUtil.isNotBlank((String)this.canonicalName)) {
            codeString.append("\n\t\t").append(".canonicalName(\"").append(this.canonicalName).append("\")");
        }
        if (ListUtil.isNotBlank(this.typeParameters)) {
            for (JavaTypeParameter typeParameter : this.typeParameters) {
                codeString.append("\n\t\t").append(".typeParameter(").append(typeParameter.toBuilderCode().replace("\n\t\t", "\n\t\t\t\t")).append(')');
            }
        }
        codeString.append("\n\t\t").append(".build()");
        return codeString.toString();
    }

    public static class JavaTypeBuilder {
        private String baseType = null;
        private String canonicalName = null;
        private List<JavaTypeParameter> typeParameters = new ArrayList<JavaTypeParameter>();

        private JavaTypeBuilder() {
        }

        public JavaTypeBuilder baseType(String baseType) {
            this.baseType = baseType;
            return this;
        }

        public JavaTypeBuilder canonicalName(String canonicalName) {
            this.canonicalName = canonicalName;
            return this;
        }

        public JavaTypeBuilder typeParameter(JavaTypeParameter typeParameter) {
            this.typeParameters.add(typeParameter);
            return this;
        }

        public JavaTypeBuilder typeParameters(List<JavaTypeParameter> typeParameters) {
            this.typeParameters = typeParameters;
            return this;
        }

        public JavaType build() {
            if (StringUtil.isBlank((String)this.baseType)) {
                throw new IllegalArgumentException("baseType can't be empty!");
            }
            return new JavaType(this.baseType, this.canonicalName, this.typeParameters);
        }
    }
}

