/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.java;

import com.github.tadukoo.java.JavaCodeType;
import com.github.tadukoo.java.JavaCodeTypes;
import com.github.tadukoo.java.JavaType;
import com.github.tadukoo.util.StringUtil;

public class JavaTypeParameter
implements JavaCodeType {
    private final JavaType baseType;
    private final JavaType extendsType;

    private JavaTypeParameter(JavaType baseType, JavaType extendsType) {
        this.baseType = baseType;
        this.extendsType = extendsType;
    }

    public static JavaTypeParameterBuilder builder() {
        return new JavaTypeParameterBuilder();
    }

    @Override
    public JavaCodeTypes getJavaCodeType() {
        return JavaCodeTypes.TYPE_PARAMETER;
    }

    public JavaType getBaseType() {
        return this.baseType;
    }

    public JavaType getExtendsType() {
        return this.extendsType;
    }

    public boolean equals(Object otherTypeParam) {
        if (otherTypeParam instanceof JavaTypeParameter) {
            JavaTypeParameter typeParam = (JavaTypeParameter)otherTypeParam;
            return StringUtil.equals((String)this.toString(), (String)typeParam.toString());
        }
        return false;
    }

    public String toString() {
        StringBuilder text = new StringBuilder(this.baseType.toString());
        if (this.extendsType != null) {
            text.append(" extends ").append(this.extendsType);
        }
        return text.toString();
    }

    @Override
    public String toBuilderCode() {
        StringBuilder codeString = new StringBuilder(this.getClass().getSimpleName()).append(".builder()");
        codeString.append("\n\t\t").append(".baseType(").append(this.baseType.toBuilderCode().replace("\n\t\t", "\n\t\t\t\t")).append(')');
        if (this.extendsType != null) {
            codeString.append("\n\t\t").append(".extendsType(").append(this.extendsType.toBuilderCode().replace("\n\t\t", "\n\t\t\t\t")).append(')');
        }
        codeString.append("\n\t\t").append(".build()");
        return codeString.toString();
    }

    public static class JavaTypeParameterBuilder {
        private JavaType baseType = null;
        private JavaType extendsType = null;

        private JavaTypeParameterBuilder() {
        }

        public JavaTypeParameterBuilder baseType(JavaType baseType) {
            this.baseType = baseType;
            return this;
        }

        public JavaTypeParameterBuilder extendsType(JavaType extendsType) {
            this.extendsType = extendsType;
            return this;
        }

        public JavaTypeParameter build() {
            if (this.baseType == null) {
                throw new IllegalArgumentException("baseType can't be empty!");
            }
            return new JavaTypeParameter(this.baseType, this.extendsType);
        }
    }
}

