/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.java.code.staticcodeblock;

import com.github.tadukoo.java.JavaCodeType;
import com.github.tadukoo.java.JavaCodeTypes;
import com.github.tadukoo.util.ListUtil;
import com.github.tadukoo.util.StringUtil;
import java.util.List;

public abstract class JavaStaticCodeBlock
implements JavaCodeType {
    private final boolean editable;
    protected List<String> lines;

    protected JavaStaticCodeBlock(boolean editable, List<String> lines) {
        this.editable = editable;
        this.lines = lines;
    }

    @Override
    public JavaCodeTypes getJavaCodeType() {
        return JavaCodeTypes.STATIC_CODE_BLOCK;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public List<String> getLines() {
        return this.lines;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("static").append("{");
        if (ListUtil.isNotBlank(this.lines)) {
            for (String line : this.lines) {
                builder.append("\n\t").append(line);
            }
            builder.append("\n");
        } else {
            builder.append(" ");
        }
        builder.append("}");
        return builder.toString();
    }

    public boolean equals(Object otherStaticCodeBlock) {
        if (otherStaticCodeBlock instanceof JavaStaticCodeBlock) {
            JavaStaticCodeBlock staticCodeBlock = (JavaStaticCodeBlock)otherStaticCodeBlock;
            return StringUtil.equals((String)this.toString(), (String)staticCodeBlock.toString());
        }
        return false;
    }

    @Override
    public String toBuilderCode() {
        StringBuilder builder = new StringBuilder(this.getClass().getSimpleName()).append(".builder()");
        if (ListUtil.isNotBlank(this.lines)) {
            for (String line : this.lines) {
                builder.append("\n\t\t").append(".line(\"").append(line).append("\")");
            }
        }
        builder.append("\n\t\t").append(".build()");
        return builder.toString();
    }
}

