/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.java.field;

import com.github.tadukoo.java.JavaCodeType;
import com.github.tadukoo.java.JavaCodeTypes;
import com.github.tadukoo.java.JavaType;
import com.github.tadukoo.java.Visibility;
import com.github.tadukoo.java.annotation.JavaAnnotation;
import com.github.tadukoo.java.javadoc.Javadoc;
import com.github.tadukoo.util.ListUtil;
import com.github.tadukoo.util.StringUtil;
import java.util.ArrayList;
import java.util.List;

public abstract class JavaField
implements JavaCodeType {
    private final boolean editable;
    protected Javadoc javadoc;
    protected List<JavaAnnotation> annotations;
    protected Visibility visibility;
    protected boolean isStatic;
    protected boolean isFinal;
    protected JavaType type;
    protected String name;
    protected String value;

    protected JavaField(boolean editable, Javadoc javadoc, List<JavaAnnotation> annotations, Visibility visibility, boolean isStatic, boolean isFinal, JavaType type, String name, String value) {
        this.editable = editable;
        this.javadoc = javadoc;
        this.annotations = annotations;
        this.visibility = visibility;
        this.isStatic = isStatic;
        this.isFinal = isFinal;
        this.type = type;
        this.name = name;
        this.value = value;
    }

    @Override
    public JavaCodeTypes getJavaCodeType() {
        return JavaCodeTypes.FIELD;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public Javadoc getJavadoc() {
        return this.javadoc;
    }

    public List<JavaAnnotation> getAnnotations() {
        return this.annotations;
    }

    public Visibility getVisibility() {
        return this.visibility;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public boolean isFinal() {
        return this.isFinal;
    }

    public JavaType getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        StringBuilder declaration;
        ArrayList<String> content = new ArrayList<String>();
        if (this.javadoc != null) {
            content.add(this.javadoc.toString());
        }
        if (ListUtil.isNotBlank(this.annotations)) {
            for (JavaAnnotation annotation : this.annotations) {
                content.add(annotation.toString());
            }
        }
        if (!(declaration = new StringBuilder(this.visibility.getToken())).isEmpty()) {
            declaration.append(' ');
        }
        if (this.isStatic) {
            declaration.append("static").append(' ');
        }
        if (this.isFinal) {
            declaration.append("final").append(' ');
        }
        declaration.append(this.type).append(' ').append(this.name);
        if (StringUtil.isNotBlank((String)this.value)) {
            declaration.append(' ').append("=").append(' ').append(this.value);
        }
        declaration.append(";");
        content.add(declaration.toString());
        return StringUtil.buildStringWithNewLines(content);
    }

    public boolean equals(Object otherField) {
        if (otherField instanceof JavaField) {
            JavaField field = (JavaField)otherField;
            return StringUtil.equals((String)this.toString(), (String)field.toString());
        }
        return false;
    }

    @Override
    public String toBuilderCode() {
        StringBuilder codeString = new StringBuilder(this.getClass().getSimpleName()).append(".builder()");
        if (this.javadoc != null) {
            codeString.append("\n\t\t").append(".javadoc(").append(this.javadoc.toBuilderCode().replace("\n\t\t", "\n\t\t\t\t")).append(')');
        }
        if (ListUtil.isNotBlank(this.annotations)) {
            for (JavaAnnotation annotation : this.annotations) {
                codeString.append("\n\t\t").append(".annotation(").append(annotation.toBuilderCode().replace("\n\t\t", "\n\t\t\t\t")).append(')');
            }
        }
        if (this.visibility != Visibility.NONE) {
            codeString.append("\n\t\t").append(".visibility(Visibility.").append(this.visibility).append(')');
        }
        if (this.isStatic) {
            codeString.append("\n\t\t").append(".isStatic()");
        }
        if (this.isFinal) {
            codeString.append("\n\t\t").append(".isFinal()");
        }
        codeString.append("\n\t\t").append(".type(\"").append(this.type).append("\").name(\"").append(this.name).append("\")");
        if (StringUtil.isNotBlank((String)this.value)) {
            codeString.append("\n\t\t").append(".value(\"").append(StringUtil.escapeString((String)this.value)).append("\")");
        }
        codeString.append("\n\t\t").append(".build()");
        return codeString.toString();
    }
}

