/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.java.javaclass;

import com.github.tadukoo.java.JavaCodeTypes;
import com.github.tadukoo.java.JavaType;
import com.github.tadukoo.java.Visibility;
import com.github.tadukoo.java.annotation.JavaAnnotation;
import com.github.tadukoo.java.code.staticcodeblock.EditableJavaStaticCodeBlock;
import com.github.tadukoo.java.code.staticcodeblock.JavaStaticCodeBlock;
import com.github.tadukoo.java.code.staticcodeblock.JavaStaticCodeBlockBuilder;
import com.github.tadukoo.java.comment.EditableJavaMultiLineComment;
import com.github.tadukoo.java.comment.EditableJavaSingleLineComment;
import com.github.tadukoo.java.comment.JavaMultiLineComment;
import com.github.tadukoo.java.comment.JavaMultiLineCommentBuilder;
import com.github.tadukoo.java.comment.JavaSingleLineComment;
import com.github.tadukoo.java.comment.JavaSingleLineCommentBuilder;
import com.github.tadukoo.java.field.JavaField;
import com.github.tadukoo.java.importstatement.EditableJavaImportStatement;
import com.github.tadukoo.java.importstatement.JavaImportStatement;
import com.github.tadukoo.java.importstatement.JavaImportStatementBuilder;
import com.github.tadukoo.java.javaclass.JavaClass;
import com.github.tadukoo.java.javaclass.JavaClassBuilder;
import com.github.tadukoo.java.javadoc.Javadoc;
import com.github.tadukoo.java.method.JavaMethod;
import com.github.tadukoo.java.packagedeclaration.EditableJavaPackageDeclaration;
import com.github.tadukoo.java.packagedeclaration.JavaPackageDeclaration;
import com.github.tadukoo.java.packagedeclaration.JavaPackageDeclarationBuilder;
import com.github.tadukoo.java.parsing.AbstractJavaParser;
import com.github.tadukoo.java.parsing.FullJavaParser;
import com.github.tadukoo.util.tuple.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class EditableJavaClass
extends JavaClass {
    private EditableJavaClass(boolean isInnerClass, JavaPackageDeclaration packageDeclaration, List<JavaImportStatement> importStatements, Javadoc javadoc, List<JavaAnnotation> annotations, Visibility visibility, boolean isAbstract, boolean isStatic, boolean isFinal, JavaType className, JavaType superClassName, List<JavaType> implementsInterfaceNames, List<JavaStaticCodeBlock> staticCodeBlocks, List<JavaSingleLineComment> singleLineComments, List<JavaMultiLineComment> multiLineComments, List<JavaClass> innerClasses, List<JavaField> fields, List<JavaMethod> methods, List<Pair<JavaCodeTypes, String>> innerElementsOrder) {
        super(true, isInnerClass, packageDeclaration, importStatements, javadoc, annotations, visibility, isAbstract, isStatic, isFinal, className, superClassName, implementsInterfaceNames, staticCodeBlocks, singleLineComments, multiLineComments, innerClasses, fields, methods, innerElementsOrder);
    }

    public static EditableJavaClassBuilder builder() {
        return new EditableJavaClassBuilder();
    }

    public void setInnerClass(boolean isInnerClass) {
        this.isInnerClass = isInnerClass;
    }

    public void setPackageDeclaration(JavaPackageDeclaration packageDeclaration) {
        if (!packageDeclaration.isEditable()) {
            throw new IllegalArgumentException("editable Java Class requires editable package declaration");
        }
        this.packageDeclaration = packageDeclaration;
    }

    public void setPackageName(String packageName) {
        this.packageDeclaration = EditableJavaPackageDeclaration.builder().packageName(packageName).build();
    }

    public void addImportStatement(JavaImportStatement importStatement) {
        if (!importStatement.isEditable()) {
            throw new IllegalArgumentException("editable Java Class requires editable import statements");
        }
        this.importStatements.add(importStatement);
    }

    public void addImportStatements(List<JavaImportStatement> importStatements) {
        for (JavaImportStatement importStatement : importStatements) {
            if (importStatement.isEditable()) continue;
            throw new IllegalArgumentException("editable Java Class requires editable import statements");
        }
        this.importStatements.addAll(importStatements);
    }

    public void setImportStatements(List<JavaImportStatement> importStatements) {
        for (JavaImportStatement importStatement : importStatements) {
            if (importStatement.isEditable()) continue;
            throw new IllegalArgumentException("editable Java Class requires editable import statements");
        }
        this.importStatements = importStatements;
    }

    public void addImportName(String importName, boolean isStatic) {
        this.importStatements.add(EditableJavaImportStatement.builder().isStatic(isStatic).importName(importName).build());
    }

    public void addImportNames(List<String> importNames, boolean isStatic) {
        for (String importName : importNames) {
            this.importStatements.add(EditableJavaImportStatement.builder().isStatic(isStatic).importName(importName).build());
        }
    }

    public void setImportNames(List<String> importNames, boolean isStatic) {
        this.importStatements = new ArrayList();
        this.addImportNames(importNames, isStatic);
    }

    public void setJavadoc(Javadoc javadoc) {
        if (!javadoc.isEditable()) {
            throw new IllegalArgumentException("editable Java Class requires editable Javadoc");
        }
        this.javadoc = javadoc;
    }

    public void addAnnotation(JavaAnnotation annotation) {
        if (!annotation.isEditable()) {
            throw new IllegalArgumentException("editable Java Class requires editable Java Annotations");
        }
        this.annotations.add(annotation);
    }

    public void addAnnotations(List<JavaAnnotation> annotations) {
        for (JavaAnnotation annotation : annotations) {
            if (annotation.isEditable()) continue;
            throw new IllegalArgumentException("editable Java Class requires editable Java Annotations");
        }
        this.annotations.addAll(annotations);
    }

    public void setAnnotations(List<JavaAnnotation> annotations) {
        for (JavaAnnotation annotation : annotations) {
            if (annotation.isEditable()) continue;
            throw new IllegalArgumentException("editable Java Class requires editable Java Annotations");
        }
        this.annotations = annotations;
    }

    public void setVisibility(Visibility visibility) {
        this.visibility = visibility;
    }

    public void setAbstract(boolean isAbstract) {
        this.isAbstract = isAbstract;
    }

    public void setStatic(boolean isStatic) {
        this.isStatic = isStatic;
    }

    public void setFinal(boolean isFinal) {
        this.isFinal = isFinal;
    }

    public void setClassName(JavaType className) {
        this.className = className;
    }

    public void setClassName(String classNameText) {
        this.className = FullJavaParser.parseJavaType(classNameText);
    }

    public void setSuperClassName(JavaType superClassName) {
        this.superClassName = superClassName;
    }

    public void setSuperClassName(String superClassNameText) {
        this.superClassName = FullJavaParser.parseJavaType(superClassNameText);
    }

    public void addImplementsInterfaceName(JavaType implementsInterfaceName) {
        this.implementsInterfaceNames.add(implementsInterfaceName);
    }

    public void addImplementsInterfaceName(String implementsInterfaceNameText) {
        this.implementsInterfaceNames.add(FullJavaParser.parseJavaType(implementsInterfaceNameText));
    }

    public void addImplementsInterfaceNames(List<JavaType> implementsInterfaceNames) {
        this.implementsInterfaceNames.addAll(implementsInterfaceNames);
    }

    public void addImplementsInterfaceNameTexts(List<String> implementsInterfaceNameTexts) {
        this.implementsInterfaceNames.addAll(implementsInterfaceNameTexts.stream().map(AbstractJavaParser::parseJavaType).toList());
    }

    public void setImplementsInterfaceNames(List<JavaType> implementsInterfaceNames) {
        this.implementsInterfaceNames = implementsInterfaceNames;
    }

    public void setImplementsInterfaceNameTexts(List<String> implementsInterfaceNameTexts) {
        this.implementsInterfaceNames = implementsInterfaceNameTexts.stream().map(AbstractJavaParser::parseJavaType).collect(Collectors.toList());
    }

    public void addStaticCodeBlock(JavaStaticCodeBlock staticCodeBlock) {
        if (!staticCodeBlock.isEditable()) {
            throw new IllegalArgumentException("editable Java Class requires editable static code blocks");
        }
        this.staticCodeBlocks.add(staticCodeBlock);
    }

    public void addStaticCodeBlocks(List<JavaStaticCodeBlock> staticCodeBlocks) {
        for (JavaStaticCodeBlock staticCodeBlock : staticCodeBlocks) {
            if (staticCodeBlock.isEditable()) continue;
            throw new IllegalArgumentException("editable Java Class requires editable static code blocks");
        }
        this.staticCodeBlocks.addAll(staticCodeBlocks);
    }

    public void setStaticCodeBlocks(List<JavaStaticCodeBlock> staticCodeBlocks) {
        for (JavaStaticCodeBlock staticCodeBlock : staticCodeBlocks) {
            if (staticCodeBlock.isEditable()) continue;
            throw new IllegalArgumentException("editable Java Class requires editable static code blocks");
        }
        this.staticCodeBlocks = staticCodeBlocks;
    }

    public void addSingleLineComment(JavaSingleLineComment singleLineComment) {
        if (!singleLineComment.isEditable()) {
            throw new IllegalArgumentException("editable Java Class requires editable single-line comments");
        }
        this.singleLineComments.add(singleLineComment);
    }

    public void addSingleLineComments(List<JavaSingleLineComment> singleLineComments) {
        for (JavaSingleLineComment singleLineComment : singleLineComments) {
            if (singleLineComment.isEditable()) continue;
            throw new IllegalArgumentException("editable Java Class requires editable single-line comments");
        }
        this.singleLineComments.addAll(singleLineComments);
    }

    public void setSingleLineComments(List<JavaSingleLineComment> singleLineComments) {
        for (JavaSingleLineComment singleLineComment : singleLineComments) {
            if (singleLineComment.isEditable()) continue;
            throw new IllegalArgumentException("editable Java Class requires editable single-line comments");
        }
        this.singleLineComments = singleLineComments;
    }

    public void addMultiLineComment(JavaMultiLineComment multiLineComment) {
        if (!multiLineComment.isEditable()) {
            throw new IllegalArgumentException("editable Java Class requires editable multi-line comments");
        }
        this.multiLineComments.add(multiLineComment);
    }

    public void addMultiLineComments(List<JavaMultiLineComment> multiLineComments) {
        for (JavaMultiLineComment multiLineComment : multiLineComments) {
            if (multiLineComment.isEditable()) continue;
            throw new IllegalArgumentException("editable Java Class requires editable multi-line comments");
        }
        this.multiLineComments.addAll(multiLineComments);
    }

    public void setMultiLineComments(List<JavaMultiLineComment> multiLineComments) {
        for (JavaMultiLineComment multiLineComment : multiLineComments) {
            if (multiLineComment.isEditable()) continue;
            throw new IllegalArgumentException("editable Java Class requires editable multi-line comments");
        }
        this.multiLineComments = multiLineComments;
    }

    public void addInnerClass(JavaClass innerClass) {
        if (!innerClass.isEditable()) {
            throw new IllegalArgumentException("editable Java Class requires editable inner classes");
        }
        this.innerClasses.add(innerClass);
    }

    public void addInnerClasses(List<JavaClass> innerClasses) {
        for (JavaClass innerClass : innerClasses) {
            if (innerClass.isEditable()) continue;
            throw new IllegalArgumentException("editable Java Class requires editable inner classes");
        }
        this.innerClasses.addAll(innerClasses);
    }

    public void setInnerClasses(List<JavaClass> innerClasses) {
        for (JavaClass innerClass : innerClasses) {
            if (innerClass.isEditable()) continue;
            throw new IllegalArgumentException("editable Java Class requires editable inner classes");
        }
        this.innerClasses = innerClasses;
    }

    public void addField(JavaField field) {
        if (!field.isEditable()) {
            throw new IllegalArgumentException("editable Java Class requires editable Java Fields");
        }
        this.fields.add(field);
    }

    public void addFields(List<JavaField> fields) {
        for (JavaField field : fields) {
            if (field.isEditable()) continue;
            throw new IllegalArgumentException("editable Java Class requires editable Java Fields");
        }
        this.fields.addAll(fields);
    }

    public void setFields(List<JavaField> fields) {
        for (JavaField field : fields) {
            if (field.isEditable()) continue;
            throw new IllegalArgumentException("editable Java Class requires editable Java Fields");
        }
        this.fields = fields;
    }

    public void addMethod(JavaMethod method) {
        if (!method.isEditable()) {
            throw new IllegalArgumentException("editable Java Class requires editable Java Methods");
        }
        this.methods.add(method);
    }

    public void addMethods(List<JavaMethod> methods) {
        for (JavaMethod method : methods) {
            if (method.isEditable()) continue;
            throw new IllegalArgumentException("editable Java Class requires editable Java Methods");
        }
        this.methods.addAll(methods);
    }

    public void setMethods(List<JavaMethod> methods) {
        for (JavaMethod method : methods) {
            if (method.isEditable()) continue;
            throw new IllegalArgumentException("editable Java Class requires editable Java Methods");
        }
        this.methods = methods;
    }

    public void setInnerElementsOrder(List<Pair<JavaCodeTypes, String>> innerElementsOrder) {
        this.innerElementsOrder = innerElementsOrder;
    }

    public static class EditableJavaClassBuilder
    extends JavaClassBuilder<EditableJavaClass> {
        private EditableJavaClassBuilder() {
        }

        @Override
        protected JavaPackageDeclarationBuilder<?> getPackageDeclarationBuilder() {
            return EditableJavaPackageDeclaration.builder();
        }

        @Override
        protected JavaImportStatementBuilder<?> getImportStatementBuilder() {
            return EditableJavaImportStatement.builder();
        }

        @Override
        protected JavaStaticCodeBlockBuilder<?> getStaticCodeBlockBuilder() {
            return EditableJavaStaticCodeBlock.builder();
        }

        @Override
        protected JavaSingleLineCommentBuilder<?> getSingleLineCommentBuilder() {
            return EditableJavaSingleLineComment.builder();
        }

        @Override
        protected JavaMultiLineCommentBuilder<?> getMultiLineCommentBuilder() {
            return EditableJavaMultiLineComment.builder();
        }

        @Override
        protected List<String> checkForSpecificErrors() {
            ArrayList<String> errors = new ArrayList<String>();
            if (this.packageDeclaration != null && !this.packageDeclaration.isEditable()) {
                errors.add("package declaration is not editable in this editable JavaClass");
            }
            for (JavaImportStatement importStatement : this.importStatements) {
                if (importStatement.isEditable()) continue;
                errors.add("some import statements are not editable in this editable JavaClass");
                break;
            }
            if (this.javadoc != null && !this.javadoc.isEditable()) {
                errors.add("javadoc is not editable in this editable JavaClass");
            }
            for (JavaAnnotation annotation : this.annotations) {
                if (annotation.isEditable()) continue;
                errors.add("some annotations are not editable in this editable JavaClass");
                break;
            }
            for (JavaStaticCodeBlock staticCodeBlock : this.staticCodeBlocks) {
                if (staticCodeBlock.isEditable()) continue;
                errors.add("some static code blocks are not editable in this editable JavaClass");
                break;
            }
            for (JavaSingleLineComment singleLineComment : this.singleLineComments) {
                if (singleLineComment.isEditable()) continue;
                errors.add("some single-line comments are not editable in this editable JavaClass");
                break;
            }
            for (JavaMultiLineComment multiLineComment : this.multiLineComments) {
                if (multiLineComment.isEditable()) continue;
                errors.add("some multi-line comments are not editable in this editable JavaClass");
                break;
            }
            for (JavaClass clazz : this.innerClasses) {
                if (clazz.isEditable()) continue;
                errors.add("some inner classes are not editable in this editable JavaClass");
                break;
            }
            for (JavaField field : this.fields) {
                if (field.isEditable()) continue;
                errors.add("some fields are not editable in this editable JavaClass");
                break;
            }
            for (JavaMethod method : this.methods) {
                if (method.isEditable()) continue;
                errors.add("some methods are not editable in this editable JavaClass");
            }
            return errors;
        }

        @Override
        protected EditableJavaClass constructClass() {
            return new EditableJavaClass(this.isInnerClass, this.packageDeclaration, this.importStatements, this.javadoc, this.annotations, this.visibility, this.isAbstract, this.isStatic, this.isFinal, this.className, this.superClassName, this.implementsInterfaceNames, this.staticCodeBlocks, this.singleLineComments, this.multiLineComments, this.innerClasses, this.fields, this.methods, this.innerElementsOrder);
        }
    }
}

