/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.java.javaclass;

import com.github.tadukoo.java.JavaCodeTypes;
import com.github.tadukoo.java.JavaType;
import com.github.tadukoo.java.Visibility;
import com.github.tadukoo.java.annotation.JavaAnnotation;
import com.github.tadukoo.java.code.staticcodeblock.JavaStaticCodeBlock;
import com.github.tadukoo.java.code.staticcodeblock.JavaStaticCodeBlockBuilder;
import com.github.tadukoo.java.comment.JavaMultiLineComment;
import com.github.tadukoo.java.comment.JavaMultiLineCommentBuilder;
import com.github.tadukoo.java.comment.JavaSingleLineComment;
import com.github.tadukoo.java.comment.JavaSingleLineCommentBuilder;
import com.github.tadukoo.java.field.JavaField;
import com.github.tadukoo.java.importstatement.JavaImportStatement;
import com.github.tadukoo.java.importstatement.JavaImportStatementBuilder;
import com.github.tadukoo.java.javaclass.JavaClass;
import com.github.tadukoo.java.javadoc.Javadoc;
import com.github.tadukoo.java.method.JavaMethod;
import com.github.tadukoo.java.packagedeclaration.JavaPackageDeclaration;
import com.github.tadukoo.java.packagedeclaration.JavaPackageDeclarationBuilder;
import com.github.tadukoo.java.parsing.AbstractJavaParser;
import com.github.tadukoo.java.parsing.FullJavaParser;
import com.github.tadukoo.util.ListUtil;
import com.github.tadukoo.util.SetUtil;
import com.github.tadukoo.util.StringUtil;
import com.github.tadukoo.util.tuple.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public abstract class JavaClassBuilder<ClassType extends JavaClass> {
    protected boolean isInnerClass = false;
    protected JavaPackageDeclaration packageDeclaration = null;
    protected List<JavaImportStatement> importStatements = new ArrayList<JavaImportStatement>();
    protected Javadoc javadoc = null;
    protected List<JavaAnnotation> annotations = new ArrayList<JavaAnnotation>();
    protected Visibility visibility = Visibility.NONE;
    protected boolean isAbstract = false;
    protected boolean isStatic = false;
    protected boolean isFinal = false;
    protected JavaType className = null;
    protected JavaType superClassName = null;
    protected List<JavaType> implementsInterfaceNames = new ArrayList<JavaType>();
    protected List<JavaStaticCodeBlock> staticCodeBlocks = new ArrayList<JavaStaticCodeBlock>();
    protected List<JavaSingleLineComment> singleLineComments = new ArrayList<JavaSingleLineComment>();
    protected List<JavaMultiLineComment> multiLineComments = new ArrayList<JavaMultiLineComment>();
    protected List<JavaClass> innerClasses = new ArrayList<JavaClass>();
    protected List<JavaField> fields = new ArrayList<JavaField>();
    protected List<JavaMethod> methods = new ArrayList<JavaMethod>();
    protected List<Pair<JavaCodeTypes, String>> innerElementsOrder = new ArrayList<Pair<JavaCodeTypes, String>>();

    protected JavaClassBuilder() {
    }

    public JavaClassBuilder<ClassType> copy(JavaClass clazz) {
        this.isInnerClass = clazz.isInnerClass();
        this.packageDeclaration = clazz.getPackageDeclaration();
        this.importStatements = clazz.getImportStatements();
        this.javadoc = clazz.getJavadoc();
        this.annotations = clazz.getAnnotations();
        this.visibility = clazz.getVisibility();
        this.isAbstract = clazz.isAbstract();
        this.isStatic = clazz.isStatic();
        this.isFinal = clazz.isFinal();
        this.className = clazz.getClassName();
        this.superClassName = clazz.getSuperClassName();
        this.implementsInterfaceNames = clazz.getImplementsInterfaceNames();
        this.staticCodeBlocks = clazz.getStaticCodeBlocks();
        this.singleLineComments = clazz.getSingleLineComments();
        this.multiLineComments = clazz.getMultiLineComments();
        this.innerClasses = clazz.getInnerClasses();
        this.fields = clazz.getFields();
        this.methods = clazz.getMethods();
        this.innerElementsOrder = clazz.getInnerElementsOrder();
        return this;
    }

    public JavaClassBuilder<ClassType> isInnerClass(boolean isInnerClass) {
        this.isInnerClass = isInnerClass;
        return this;
    }

    public JavaClassBuilder<ClassType> innerClass() {
        this.isInnerClass = true;
        return this;
    }

    public JavaClassBuilder<ClassType> packageDeclaration(JavaPackageDeclaration packageDeclaration) {
        this.packageDeclaration = packageDeclaration;
        return this;
    }

    protected abstract JavaPackageDeclarationBuilder<?> getPackageDeclarationBuilder();

    public JavaClassBuilder<ClassType> packageName(String packageName) {
        return this.packageDeclaration((JavaPackageDeclaration)this.getPackageDeclarationBuilder().packageName(packageName).build());
    }

    public JavaClassBuilder<ClassType> importStatement(JavaImportStatement importStatement) {
        this.importStatements.add(importStatement);
        return this;
    }

    public JavaClassBuilder<ClassType> importStatements(List<JavaImportStatement> importStatements) {
        this.importStatements = importStatements;
        return this;
    }

    protected abstract JavaImportStatementBuilder<?> getImportStatementBuilder();

    public JavaClassBuilder<ClassType> importName(String importName, boolean isStatic) {
        return this.importStatement((JavaImportStatement)this.getImportStatementBuilder().isStatic(isStatic).importName(importName).build());
    }

    public JavaClassBuilder<ClassType> importNames(List<String> importNames, boolean isStatic) {
        return this.importStatements(importNames.stream().map(importName -> this.getImportStatementBuilder().isStatic(isStatic).importName((String)importName).build()).toList());
    }

    public JavaClassBuilder<ClassType> javadoc(Javadoc javadoc) {
        this.javadoc = javadoc;
        return this;
    }

    public JavaClassBuilder<ClassType> annotations(List<JavaAnnotation> annotations) {
        this.annotations = annotations;
        return this;
    }

    public JavaClassBuilder<ClassType> annotation(JavaAnnotation annotation) {
        this.annotations.add(annotation);
        return this;
    }

    public JavaClassBuilder<ClassType> visibility(Visibility visibility) {
        this.visibility = visibility;
        return this;
    }

    public JavaClassBuilder<ClassType> isAbstract() {
        this.isAbstract = true;
        return this;
    }

    public JavaClassBuilder<ClassType> isAbstract(boolean isAbstract) {
        this.isAbstract = isAbstract;
        return this;
    }

    public JavaClassBuilder<ClassType> isStatic() {
        this.isStatic = true;
        return this;
    }

    public JavaClassBuilder<ClassType> isStatic(boolean isStatic) {
        this.isStatic = isStatic;
        return this;
    }

    public JavaClassBuilder<ClassType> isFinal() {
        this.isFinal = true;
        return this;
    }

    public JavaClassBuilder<ClassType> isFinal(boolean isFinal) {
        this.isFinal = isFinal;
        return this;
    }

    public JavaClassBuilder<ClassType> className(JavaType className) {
        this.className = className;
        return this;
    }

    public JavaClassBuilder<ClassType> className(String classNameText) {
        this.className = FullJavaParser.parseJavaType(classNameText);
        return this;
    }

    public JavaClassBuilder<ClassType> superClassName(JavaType superClassName) {
        this.superClassName = superClassName;
        return this;
    }

    public JavaClassBuilder<ClassType> superClassName(String superClassNameText) {
        this.superClassName = FullJavaParser.parseJavaType(superClassNameText);
        return this;
    }

    public JavaClassBuilder<ClassType> implementsInterfaceName(JavaType implementsInterfaceName) {
        this.implementsInterfaceNames.add(implementsInterfaceName);
        return this;
    }

    public JavaClassBuilder<ClassType> implementsInterfaceName(String implementsInterfaceNameText) {
        this.implementsInterfaceNames.add(FullJavaParser.parseJavaType(implementsInterfaceNameText));
        return this;
    }

    public JavaClassBuilder<ClassType> implementsInterfaceNames(List<JavaType> implementsInterfaceNames) {
        this.implementsInterfaceNames = implementsInterfaceNames;
        return this;
    }

    public JavaClassBuilder<ClassType> implementsInterfaceNameTexts(List<String> implementsInterfaceNameTexts) {
        this.implementsInterfaceNames = implementsInterfaceNameTexts.stream().map(AbstractJavaParser::parseJavaType).collect(Collectors.toList());
        return this;
    }

    public JavaClassBuilder<ClassType> staticCodeBlocks(List<JavaStaticCodeBlock> staticCodeBlocks) {
        this.staticCodeBlocks = staticCodeBlocks;
        for (int i = 0; i < staticCodeBlocks.size(); ++i) {
            this.innerElementsOrder.add((Pair<JavaCodeTypes, String>)Pair.of((Object)((Object)JavaCodeTypes.STATIC_CODE_BLOCK), null));
        }
        return this;
    }

    public JavaClassBuilder<ClassType> staticCodeBlock(JavaStaticCodeBlock staticCodeBlock) {
        this.staticCodeBlocks.add(staticCodeBlock);
        this.innerElementsOrder.add((Pair<JavaCodeTypes, String>)Pair.of((Object)((Object)JavaCodeTypes.STATIC_CODE_BLOCK), null));
        return this;
    }

    protected abstract JavaStaticCodeBlockBuilder<?> getStaticCodeBlockBuilder();

    public JavaClassBuilder<ClassType> staticCodeBlock(List<String> lines) {
        this.staticCodeBlocks.add((JavaStaticCodeBlock)this.getStaticCodeBlockBuilder().lines(lines).build());
        this.innerElementsOrder.add((Pair<JavaCodeTypes, String>)Pair.of((Object)((Object)JavaCodeTypes.STATIC_CODE_BLOCK), null));
        return this;
    }

    public JavaClassBuilder<ClassType> singleLineComments(List<JavaSingleLineComment> singleLineComments) {
        this.singleLineComments = singleLineComments;
        for (int i = 0; i < singleLineComments.size(); ++i) {
            this.innerElementsOrder.add((Pair<JavaCodeTypes, String>)Pair.of((Object)((Object)JavaCodeTypes.SINGLE_LINE_COMMENT), null));
        }
        return this;
    }

    public JavaClassBuilder<ClassType> singleLineComment(JavaSingleLineComment singleLineComment) {
        this.singleLineComments.add(singleLineComment);
        this.innerElementsOrder.add((Pair<JavaCodeTypes, String>)Pair.of((Object)((Object)JavaCodeTypes.SINGLE_LINE_COMMENT), null));
        return this;
    }

    protected abstract JavaSingleLineCommentBuilder<?> getSingleLineCommentBuilder();

    public JavaClassBuilder<ClassType> singleLineComment(String singleLineComment) {
        this.singleLineComments.add((JavaSingleLineComment)this.getSingleLineCommentBuilder().content(singleLineComment).build());
        this.innerElementsOrder.add((Pair<JavaCodeTypes, String>)Pair.of((Object)((Object)JavaCodeTypes.SINGLE_LINE_COMMENT), null));
        return this;
    }

    public JavaClassBuilder<ClassType> multiLineComments(List<JavaMultiLineComment> multiLineComments) {
        this.multiLineComments = multiLineComments;
        for (int i = 0; i < multiLineComments.size(); ++i) {
            this.innerElementsOrder.add((Pair<JavaCodeTypes, String>)Pair.of((Object)((Object)JavaCodeTypes.MULTI_LINE_COMMENT), null));
        }
        return this;
    }

    public JavaClassBuilder<ClassType> multiLineComment(JavaMultiLineComment multiLineComment) {
        this.multiLineComments.add(multiLineComment);
        this.innerElementsOrder.add((Pair<JavaCodeTypes, String>)Pair.of((Object)((Object)JavaCodeTypes.MULTI_LINE_COMMENT), null));
        return this;
    }

    protected abstract JavaMultiLineCommentBuilder<?> getMultiLineCommentBuilder();

    public JavaClassBuilder<ClassType> multiLineComment(String ... multiLineComment) {
        this.multiLineComments.add((JavaMultiLineComment)this.getMultiLineCommentBuilder().content(ListUtil.createList((Object[])multiLineComment)).build());
        this.innerElementsOrder.add((Pair<JavaCodeTypes, String>)Pair.of((Object)((Object)JavaCodeTypes.MULTI_LINE_COMMENT), null));
        return this;
    }

    public JavaClassBuilder<ClassType> innerClasses(List<JavaClass> innerClasses) {
        this.innerClasses = innerClasses;
        for (JavaClass innerClass : innerClasses) {
            this.innerElementsOrder.add((Pair<JavaCodeTypes, String>)Pair.of((Object)((Object)JavaCodeTypes.CLASS), (Object)innerClass.getSimpleClassName()));
        }
        return this;
    }

    public JavaClassBuilder<ClassType> innerClass(JavaClass innerClass) {
        this.innerClasses.add(innerClass);
        this.innerElementsOrder.add((Pair<JavaCodeTypes, String>)Pair.of((Object)((Object)JavaCodeTypes.CLASS), (Object)innerClass.getSimpleClassName()));
        return this;
    }

    public JavaClassBuilder<ClassType> fields(List<JavaField> fields) {
        this.fields = fields;
        for (JavaField field : fields) {
            this.innerElementsOrder.add((Pair<JavaCodeTypes, String>)Pair.of((Object)((Object)JavaCodeTypes.FIELD), (Object)field.getName()));
        }
        return this;
    }

    public JavaClassBuilder<ClassType> field(JavaField field) {
        this.fields.add(field);
        this.innerElementsOrder.add((Pair<JavaCodeTypes, String>)Pair.of((Object)((Object)JavaCodeTypes.FIELD), (Object)field.getName()));
        return this;
    }

    public JavaClassBuilder<ClassType> methods(List<JavaMethod> methods) {
        this.methods = methods;
        for (JavaMethod method : methods) {
            this.innerElementsOrder.add((Pair<JavaCodeTypes, String>)Pair.of((Object)((Object)JavaCodeTypes.METHOD), (Object)method.getUniqueName()));
        }
        return this;
    }

    public JavaClassBuilder<ClassType> method(JavaMethod method) {
        this.methods.add(method);
        this.innerElementsOrder.add((Pair<JavaCodeTypes, String>)Pair.of((Object)((Object)JavaCodeTypes.METHOD), (Object)method.getUniqueName()));
        return this;
    }

    public JavaClassBuilder<ClassType> innerElementsOrder(List<Pair<JavaCodeTypes, String>> innerElementsOrder) {
        this.innerElementsOrder = innerElementsOrder;
        return this;
    }

    private void checkForErrors() {
        ArrayList<Object> errors = new ArrayList<Object>();
        if (this.visibility == null) {
            errors.add("Visibility is required!");
        }
        if (this.className == null) {
            errors.add("Must specify className!");
        }
        if (this.isAbstract) {
            if (this.isStatic) {
                errors.add("Can't be abstract and static!");
            }
            if (this.isFinal) {
                errors.add("Can't be abstract and final!");
            }
        }
        if (ListUtil.isBlank(this.innerElementsOrder) && (ListUtil.isNotBlank(this.staticCodeBlocks) || ListUtil.isNotBlank(this.singleLineComments) || ListUtil.isNotBlank(this.multiLineComments))) {
            errors.add("innerElementsOrder is required when static code blocks or comments are present!");
        }
        if (ListUtil.isNotBlank(this.innerElementsOrder)) {
            int numStaticCodeBlocks = this.staticCodeBlocks.size();
            int numSingleLineComments = this.singleLineComments.size();
            int numMultiLineComments = this.multiLineComments.size();
            Set innerClassNames = SetUtil.createOrderedSet((Object[])this.innerClasses.stream().map(JavaClass::getSimpleClassName).toList().toArray(new String[0]));
            Set fieldNames = SetUtil.createOrderedSet((Object[])this.fields.stream().map(JavaField::getName).toList().toArray(new String[0]));
            Set methodNames = SetUtil.createOrderedSet((Object[])this.methods.stream().map(JavaMethod::getUniqueName).toList().toArray(new String[0]));
            HashSet<String> usedInnerClassNames = new HashSet<String>();
            HashSet<String> usedFieldNames = new HashSet<String>();
            HashSet<String> usedMethodNames = new HashSet<String>();
            block8: for (Pair<JavaCodeTypes, String> elementInfo : this.innerElementsOrder) {
                switch ((JavaCodeTypes)((Object)elementInfo.getLeft())) {
                    case STATIC_CODE_BLOCK: {
                        if (--numStaticCodeBlocks != -1) continue block8;
                        errors.add("Specified more static code blocks in innerElementsOrder than we have!");
                        continue block8;
                    }
                    case SINGLE_LINE_COMMENT: {
                        if (--numSingleLineComments != -1) continue block8;
                        errors.add("Specified more single-line comments in innerElementsOrder than we have!");
                        continue block8;
                    }
                    case MULTI_LINE_COMMENT: {
                        if (--numMultiLineComments != -1) continue block8;
                        errors.add("Specified more multi-line comments in innerElementsOrder than we have!");
                        continue block8;
                    }
                    case CLASS: {
                        String innerClassName = (String)elementInfo.getRight();
                        if (!innerClassNames.remove(innerClassName)) {
                            if (usedInnerClassNames.contains(innerClassName)) {
                                errors.add("Already used inner class named: " + innerClassName);
                            } else {
                                errors.add("Unknown inner class name: " + innerClassName);
                            }
                        }
                        usedInnerClassNames.add(innerClassName);
                        continue block8;
                    }
                    case FIELD: {
                        String fieldName = (String)elementInfo.getRight();
                        if (!fieldNames.remove(fieldName)) {
                            if (usedFieldNames.contains(fieldName)) {
                                errors.add("Already used field named: " + fieldName);
                            } else {
                                errors.add("Unknown field name: " + fieldName);
                            }
                        }
                        usedFieldNames.add(fieldName);
                        continue block8;
                    }
                    case METHOD: {
                        String methodName = (String)elementInfo.getRight();
                        if (!methodNames.remove(methodName)) {
                            if (usedMethodNames.contains(methodName)) {
                                errors.add("Already used method named: " + methodName);
                            } else {
                                errors.add("Unknown method name: " + methodName);
                            }
                        }
                        usedMethodNames.add(methodName);
                        continue block8;
                    }
                }
                errors.add("Unknown inner element type: " + ((JavaCodeTypes)((Object)elementInfo.getLeft())).getStandardName());
            }
            if (numStaticCodeBlocks > 0) {
                errors.add("Missed " + numStaticCodeBlocks + " static code blocks in innerElementsOrder!");
            }
            if (numSingleLineComments > 0) {
                errors.add("Missed " + numSingleLineComments + " single-line comments in innerElementsOrder!");
            }
            if (numMultiLineComments > 0) {
                errors.add("Missed " + numMultiLineComments + " multi-line comments in innerElementsOrder!");
            }
            if (!innerClassNames.isEmpty()) {
                errors.add("The following inner classes were not specified in innerElementsOrder: " + StringUtil.buildCommaSeparatedString((Collection)innerClassNames));
            }
            if (!fieldNames.isEmpty()) {
                errors.add("The following fields were not specified in innerElementsOrder: " + StringUtil.buildCommaSeparatedString((Collection)fieldNames));
            }
            if (!methodNames.isEmpty()) {
                errors.add("The following methods were not specified in innerElementsOrder: " + StringUtil.buildCommaSeparatedString((Collection)methodNames));
            }
        }
        if (ListUtil.isNotBlank(this.innerClasses)) {
            for (JavaClass innerClass : this.innerClasses) {
                if (innerClass.isInnerClass()) continue;
                errors.add("Inner class '" + innerClass.getClassName() + "' is not an inner class!");
            }
        }
        if (this.isInnerClass) {
            if (this.packageDeclaration != null) {
                errors.add("Not allowed to have package declaration for an inner class!");
            }
            if (ListUtil.isNotBlank(this.importStatements)) {
                errors.add("Not allowed to have import statements for an inner class!");
            }
        } else if (this.isStatic) {
            errors.add("Only inner classes can be static!");
        }
        errors.addAll(this.checkForSpecificErrors());
        if (!errors.isEmpty()) {
            throw new IllegalArgumentException(StringUtil.buildStringWithNewLines(errors));
        }
    }

    protected abstract List<String> checkForSpecificErrors();

    public ClassType build() {
        this.checkForErrors();
        return this.constructClass();
    }

    protected abstract ClassType constructClass();
}

