/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.java.method;

import com.github.tadukoo.java.JavaParameter;
import com.github.tadukoo.java.JavaType;
import com.github.tadukoo.java.JavaTypeParameter;
import com.github.tadukoo.java.Visibility;
import com.github.tadukoo.java.annotation.JavaAnnotation;
import com.github.tadukoo.java.javadoc.Javadoc;
import com.github.tadukoo.java.method.JavaMethod;
import com.github.tadukoo.java.parsing.FullJavaParser;
import com.github.tadukoo.util.ListUtil;
import com.github.tadukoo.util.StringUtil;
import java.util.ArrayList;
import java.util.List;

public abstract class JavaMethodBuilder<MethodType extends JavaMethod> {
    protected Javadoc javadoc = null;
    protected List<JavaAnnotation> annotations = new ArrayList<JavaAnnotation>();
    protected Visibility visibility = Visibility.NONE;
    protected boolean isAbstract = false;
    protected boolean isStatic = false;
    protected boolean isFinal = false;
    protected List<JavaTypeParameter> typeParameters = new ArrayList<JavaTypeParameter>();
    protected JavaType returnType = null;
    protected String name = null;
    protected List<JavaParameter> parameters = new ArrayList<JavaParameter>();
    protected List<String> throwTypes = new ArrayList<String>();
    protected List<String> lines = new ArrayList<String>();

    protected JavaMethodBuilder() {
    }

    public JavaMethodBuilder<MethodType> copy(JavaMethod method) {
        this.javadoc = method.getJavadoc();
        this.annotations = method.getAnnotations();
        this.visibility = method.getVisibility();
        this.isAbstract = method.isAbstract();
        this.isStatic = method.isStatic();
        this.isFinal = method.isFinal();
        this.typeParameters = method.getTypeParameters();
        this.returnType = method.getReturnType();
        this.name = method.getName();
        this.parameters = method.getParameters();
        this.throwTypes = method.getThrowTypes();
        this.lines = method.getLines();
        return this;
    }

    public JavaMethodBuilder<MethodType> javadoc(Javadoc javadoc) {
        this.javadoc = javadoc;
        return this;
    }

    public JavaMethodBuilder<MethodType> annotations(List<JavaAnnotation> annotations) {
        this.annotations = annotations;
        return this;
    }

    public JavaMethodBuilder<MethodType> annotation(JavaAnnotation annotation) {
        this.annotations.add(annotation);
        return this;
    }

    public JavaMethodBuilder<MethodType> visibility(Visibility visibility) {
        this.visibility = visibility;
        return this;
    }

    public JavaMethodBuilder<MethodType> isAbstract() {
        this.isAbstract = true;
        return this;
    }

    public JavaMethodBuilder<MethodType> isAbstract(boolean isAbstract) {
        this.isAbstract = isAbstract;
        return this;
    }

    public JavaMethodBuilder<MethodType> isStatic() {
        this.isStatic = true;
        return this;
    }

    public JavaMethodBuilder<MethodType> isStatic(boolean isStatic) {
        this.isStatic = isStatic;
        return this;
    }

    public JavaMethodBuilder<MethodType> isFinal() {
        this.isFinal = true;
        return this;
    }

    public JavaMethodBuilder<MethodType> isFinal(boolean isFinal) {
        this.isFinal = isFinal;
        return this;
    }

    public JavaMethodBuilder<MethodType> typeParameters(List<JavaTypeParameter> typeParameters) {
        this.typeParameters = typeParameters;
        return this;
    }

    public JavaMethodBuilder<MethodType> typeParameter(JavaTypeParameter typeParameter) {
        this.typeParameters.add(typeParameter);
        return this;
    }

    public JavaMethodBuilder<MethodType> addTypeParameters(String typeParameter) {
        this.typeParameters.addAll(FullJavaParser.parseJavaTypeParameters(typeParameter));
        return this;
    }

    public JavaMethodBuilder<MethodType> returnType(JavaType returnType) {
        this.returnType = returnType;
        return this;
    }

    public JavaMethodBuilder<MethodType> returnType(String returnTypeText) {
        this.returnType = FullJavaParser.parseJavaType(returnTypeText);
        return this;
    }

    public JavaMethodBuilder<MethodType> name(String name) {
        this.name = name;
        return this;
    }

    public JavaMethodBuilder<MethodType> parameters(List<JavaParameter> parameters) {
        this.parameters = parameters;
        return this;
    }

    public JavaMethodBuilder<MethodType> parameter(JavaParameter parameter) {
        this.parameters.add(parameter);
        return this;
    }

    public JavaMethodBuilder<MethodType> parameter(String parameterText) {
        this.parameters.add(FullJavaParser.parseJavaParameter(parameterText));
        return this;
    }

    public JavaMethodBuilder<MethodType> throwTypes(List<String> throwTypes) {
        this.throwTypes = throwTypes;
        return this;
    }

    public JavaMethodBuilder<MethodType> throwType(String throwType) {
        this.throwTypes.add(throwType);
        return this;
    }

    public JavaMethodBuilder<MethodType> lines(List<String> lines) {
        this.lines = lines;
        return this;
    }

    public JavaMethodBuilder<MethodType> line(String line) {
        this.lines.add(line);
        return this;
    }

    private void checkForErrors() {
        ArrayList<String> errors = new ArrayList<String>();
        if (this.visibility == null) {
            errors.add("Visibility is required!");
        }
        if (this.isAbstract) {
            if (this.visibility == Visibility.PRIVATE) {
                errors.add("Can't be abstract and private!");
            }
            if (this.isStatic) {
                errors.add("Can't be abstract and static!");
            }
            if (this.isFinal) {
                errors.add("Can't be abstract and final!");
            }
            if (ListUtil.isNotBlank(this.lines)) {
                errors.add("Can't be abstract and have lines!");
            }
        }
        if (this.returnType == null) {
            errors.add("Must specify returnType!");
        }
        errors.addAll(this.checkForSpecificErrors());
        if (!errors.isEmpty()) {
            throw new IllegalArgumentException(StringUtil.buildStringWithNewLines(errors));
        }
    }

    protected abstract List<String> checkForSpecificErrors();

    public MethodType build() {
        this.checkForErrors();
        return this.constructMethod();
    }

    protected abstract MethodType constructMethod();
}

