/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.java.parsing;

import com.github.tadukoo.java.JavaCodeTypes;
import com.github.tadukoo.java.JavaParameter;
import com.github.tadukoo.java.JavaTokens;
import com.github.tadukoo.java.JavaType;
import com.github.tadukoo.java.JavaTypeParameter;
import com.github.tadukoo.java.parsing.JavaParsingException;
import com.github.tadukoo.java.parsing.ParsingPojo;
import com.github.tadukoo.util.StringUtil;
import com.github.tadukoo.util.tuple.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class AbstractJavaParser
implements JavaTokens {
    private static final String SINGLE_MODIFIER_REGEX = "(?:(public|protected|private|static|final|abstract)\\s*)?";
    protected static final String MODIFIERS_REGEX = "(?:(public|protected|private|static|final|abstract)\\s*)?(?:(public|protected|private|static|final|abstract)\\s*)?(?:(public|protected|private|static|final|abstract)\\s*)?";
    protected static final String TOKEN_REGEX = "\n|\\(|\\)|\\{|}|<|>|=|,|[^\\S\n]+|[^\\s(){}=,]+";
    protected static final Matcher WHITESPACE_MATCHER = Pattern.compile("\\s+").matcher("");
    protected static final String TYPE_PARAMETER_REGEX = "\\s*([^\\s)]+)(?:\\s*extends\\s*([^\\s)]*))?\\s*";
    protected static final Pattern TYPE_PARAMETER_PATTERN = Pattern.compile("\\s*([^\\s)]+)(?:\\s*extends\\s*([^\\s)]*))?\\s*");
    protected static final String TYPE_REGEX = "\\s*([^<.\\s)]+)(?:\\s*<((?:\\s*([^\\s)]+)(?:\\s*extends\\s*([^\\s)]*))?\\s*,)*" + TYPE_PARAMETER_PATTERN + ")>)?\\s*";
    protected static final Pattern TYPE_PATTERN = Pattern.compile(TYPE_REGEX);
    protected static final String PARAMETER_REGEX = "(" + TYPE_REGEX + ")(?:\\s+|\\s*(\\.\\.\\.)\\s*)([^\\s)]*)\\s*";
    protected static final Pattern PARAMETER_PATTERN = Pattern.compile(PARAMETER_REGEX);

    protected AbstractJavaParser() {
    }

    protected static List<String> splitContentIntoTokens(String content) {
        return StringUtil.parseListFromStringWithPattern((String)content, (String)TOKEN_REGEX, (boolean)false).stream().filter(StringUtil::isNotBlank).toList();
    }

    protected static int skipLeadingWhitespace(List<String> tokens) {
        int startToken = 0;
        while (WHITESPACE_MATCHER.reset(tokens.get(startToken)).matches()) {
            ++startToken;
        }
        return startToken;
    }

    protected static void verifyEndOfTokens(List<String> tokens, ParsingPojo result, JavaCodeTypes type) throws JavaParsingException {
        if (result.nextTokenIndex() != tokens.size()) {
            int lastTokenIndex;
            for (lastTokenIndex = result.nextTokenIndex(); lastTokenIndex < tokens.size() && WHITESPACE_MATCHER.reset(tokens.get(lastTokenIndex)).matches(); ++lastTokenIndex) {
            }
            if (lastTokenIndex != tokens.size()) {
                throw new JavaParsingException(type, "Found extra content after the " + type.getStandardName() + "!");
            }
        }
    }

    protected static Pair<String, Integer> parseOutType(List<String> tokens, int currentToken) {
        String nextToken;
        int thisToken;
        if (currentToken >= tokens.size()) {
            return null;
        }
        Object type = tokens.get(currentToken);
        for (thisToken = currentToken + 1; thisToken < tokens.size() && WHITESPACE_MATCHER.reset(tokens.get(thisToken)).matches(); ++thisToken) {
        }
        if (thisToken >= tokens.size()) {
            return null;
        }
        if (!((String)type).contains("<") && (nextToken = tokens.get(thisToken)).startsWith("<")) {
            type = (String)type + nextToken;
            ++thisToken;
        }
        if (((String)type).contains("<")) {
            int openTokens = StringUtil.countSubstringInstances((String)type, (String)"<");
            int closeTokens = StringUtil.countSubstringInstances((String)type, (String)">");
            while (openTokens != closeTokens) {
                if (thisToken >= tokens.size()) {
                    return null;
                }
                String nextToken2 = tokens.get(thisToken);
                type = (String)type + nextToken2;
                ++thisToken;
                openTokens = StringUtil.countSubstringInstances((String)type, (String)"<");
                closeTokens = StringUtil.countSubstringInstances((String)type, (String)">");
            }
        }
        return Pair.of((Object)type, (Object)thisToken);
    }

    protected static JavaCodeTypes determineFieldOrMethod(List<String> tokens, int currentToken) {
        int thisToken;
        if (StringUtil.equals((String)tokens.get(currentToken), (String)"<")) {
            return JavaCodeTypes.METHOD;
        }
        Pair<String, Integer> typeStringAndNextToken = AbstractJavaParser.parseOutType(tokens, currentToken);
        if (typeStringAndNextToken == null) {
            return JavaCodeTypes.UNKNOWN;
        }
        for (thisToken = ((Integer)typeStringAndNextToken.getRight()).intValue(); thisToken < tokens.size() && WHITESPACE_MATCHER.reset(tokens.get(thisToken)).matches(); ++thisToken) {
        }
        if (thisToken >= tokens.size()) {
            return JavaCodeTypes.UNKNOWN;
        }
        String token = tokens.get(thisToken);
        if (StringUtil.equals((String)token, (String)"(")) {
            return JavaCodeTypes.METHOD;
        }
        if (token.endsWith(";")) {
            return JavaCodeTypes.FIELD;
        }
        while (++thisToken < tokens.size() && WHITESPACE_MATCHER.reset(tokens.get(thisToken)).matches()) {
        }
        if (thisToken >= tokens.size()) {
            return JavaCodeTypes.UNKNOWN;
        }
        token = tokens.get(thisToken);
        if (StringUtil.equals((String)token, (String)"(")) {
            return JavaCodeTypes.METHOD;
        }
        if (StringUtil.equalsAny((String)token, (String[])new String[]{"=", ";"})) {
            return JavaCodeTypes.FIELD;
        }
        return JavaCodeTypes.UNKNOWN;
    }

    public static JavaParameter parseJavaParameter(String parameterContent) {
        Matcher paramMatch = PARAMETER_PATTERN.matcher(parameterContent);
        if (paramMatch.matches()) {
            String typeContent = paramMatch.group(1);
            JavaType type = AbstractJavaParser.parseJavaType(typeContent);
            boolean vararg = StringUtil.isNotBlank((String)StringUtil.trim((String)paramMatch.group(8)));
            String name = paramMatch.group(9);
            return JavaParameter.builder().type(type).name(name).vararg(vararg).build();
        }
        throw new IllegalArgumentException("'" + parameterContent + "' is not a valid parameter");
    }

    public static JavaType parseJavaType(String typeContent) {
        Matcher typeMatch = TYPE_PATTERN.matcher(typeContent);
        if (typeMatch.matches()) {
            String baseType = typeMatch.group(1);
            String typeParamsContent = typeMatch.group(2);
            List<JavaTypeParameter> typeParams = AbstractJavaParser.parseJavaTypeParameters(typeParamsContent);
            return JavaType.builder().baseType(baseType).typeParameters(typeParams).build();
        }
        throw new IllegalArgumentException("'" + typeContent + "' is not a valid type");
    }

    public static List<JavaTypeParameter> parseJavaTypeParameters(String typeParametersContent) {
        ArrayList<JavaTypeParameter> typeParams = new ArrayList<JavaTypeParameter>();
        if (StringUtil.isBlank((String)StringUtil.trim((String)typeParametersContent))) {
            return typeParams;
        }
        String[] paramSplit = typeParametersContent.split(",");
        Object paramContent = "";
        for (String paramPiece : paramSplit) {
            JavaType extendsType;
            JavaType baseType;
            int endTokenCount;
            int startTokenCount;
            if (StringUtil.isNotBlank((String)paramContent)) {
                paramContent = (String)paramContent + ",";
            }
            if ((startTokenCount = StringUtil.countSubstringInstances((String)(paramContent = (String)paramContent + StringUtil.trim((String)paramPiece)), (String)"<")) != (endTokenCount = StringUtil.countSubstringInstances((String)paramContent, (String)">"))) continue;
            Matcher typeParamMatch = TYPE_PARAMETER_PATTERN.matcher((CharSequence)paramContent);
            if (typeParamMatch.matches()) {
                String extendsTypeStr;
                baseType = null;
                extendsType = null;
                String baseTypeStr = typeParamMatch.group(1);
                if (StringUtil.isNotBlank((String)baseTypeStr)) {
                    baseType = AbstractJavaParser.parseJavaType(baseTypeStr);
                }
                if (StringUtil.isNotBlank((String)(extendsTypeStr = typeParamMatch.group(2)))) {
                    extendsType = AbstractJavaParser.parseJavaType(extendsTypeStr);
                }
            } else {
                throw new IllegalArgumentException("'" + (String)paramContent + "' is not a valid type parameter");
            }
            typeParams.add(JavaTypeParameter.builder().baseType(baseType).extendsType(extendsType).build());
            paramContent = "";
        }
        if (StringUtil.isNotBlank((String)paramContent)) {
            throw new IllegalArgumentException("Failed to parse remaining type parameter content: '" + (String)paramContent + "'");
        }
        return typeParams;
    }
}

