/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.java.parsing.classtypes;

import com.github.tadukoo.java.JavaCodeType;
import com.github.tadukoo.java.JavaCodeTypes;
import com.github.tadukoo.java.annotation.JavaAnnotation;
import com.github.tadukoo.java.code.staticcodeblock.JavaStaticCodeBlock;
import com.github.tadukoo.java.comment.JavaMultiLineComment;
import com.github.tadukoo.java.comment.JavaSingleLineComment;
import com.github.tadukoo.java.field.EditableJavaField;
import com.github.tadukoo.java.importstatement.JavaImportStatement;
import com.github.tadukoo.java.javaclass.EditableJavaClass;
import com.github.tadukoo.java.javaclass.JavaClass;
import com.github.tadukoo.java.javaclass.JavaClassBuilder;
import com.github.tadukoo.java.javadoc.Javadoc;
import com.github.tadukoo.java.method.EditableJavaMethod;
import com.github.tadukoo.java.packagedeclaration.JavaPackageDeclaration;
import com.github.tadukoo.java.parsing.AbstractJavaParser;
import com.github.tadukoo.java.parsing.JavaParsingException;
import com.github.tadukoo.java.parsing.ParsingPojo;
import com.github.tadukoo.java.parsing.codetypes.JavaAnnotationParser;
import com.github.tadukoo.java.parsing.codetypes.JavaFieldParser;
import com.github.tadukoo.java.parsing.codetypes.JavaImportStatementParser;
import com.github.tadukoo.java.parsing.codetypes.JavaMethodParser;
import com.github.tadukoo.java.parsing.codetypes.JavaPackageDeclarationParser;
import com.github.tadukoo.java.parsing.codetypes.JavaTypeWithModifiersParser;
import com.github.tadukoo.java.parsing.comment.JavaMultiLineCommentParser;
import com.github.tadukoo.java.parsing.comment.JavaSingleLineCommentParser;
import com.github.tadukoo.java.parsing.comment.JavadocParser;
import com.github.tadukoo.util.ListUtil;
import com.github.tadukoo.util.StringUtil;
import com.github.tadukoo.util.functional.function.ThrowingFunction2;
import com.github.tadukoo.util.tuple.Pair;
import java.util.ArrayList;
import java.util.List;

public class JavaClassParser
extends AbstractJavaParser {
    private JavaClassParser() {
    }

    public static JavaClass parseClass(String content) throws JavaParsingException {
        List<String> tokens = JavaClassParser.splitContentIntoTokens(content);
        int currentToken = 0;
        ArrayList<JavaCodeType> types = new ArrayList<JavaCodeType>();
        while (currentToken < tokens.size()) {
            String token = tokens.get(currentToken);
            if (WHITESPACE_MATCHER.reset(token).matches()) {
                ++currentToken;
                continue;
            }
            ThrowingFunction2 parseMethod = token.startsWith("package") ? JavaPackageDeclarationParser::parsePackageDeclaration : (token.startsWith("import") ? JavaImportStatementParser::parseImportStatement : (token.startsWith("/**") ? JavadocParser::parseJavadoc : (token.startsWith("@") ? JavaAnnotationParser::parseAnnotation : (MODIFIERS.contains(token) ? JavaTypeWithModifiersParser::parseTypeWithModifiers : JavaClassParser::parseClass))));
            ParsingPojo pojo = (ParsingPojo)parseMethod.apply(tokens, (Object)currentToken);
            types.add(pojo.parsedType());
            currentToken = pojo.nextTokenIndex();
        }
        JavaPackageDeclaration packageDeclaration = null;
        ArrayList<JavaImportStatement> importStatements = new ArrayList<JavaImportStatement>();
        Javadoc doc = null;
        ArrayList<JavaAnnotation> annotations = new ArrayList<JavaAnnotation>();
        EditableJavaClass clazz = null;
        for (JavaCodeType type : types) {
            if (type instanceof JavaPackageDeclaration) {
                JavaPackageDeclaration javaPackageDeclaration = (JavaPackageDeclaration)type;
                if (packageDeclaration != null) {
                    throw new JavaParsingException(JavaCodeTypes.CLASS, "Only one package declaration allowed on a class!");
                }
                if (clazz != null) {
                    throw new JavaParsingException(JavaCodeTypes.CLASS, "Encountered package declaration after class!");
                }
                packageDeclaration = javaPackageDeclaration;
                continue;
            }
            if (type instanceof JavaImportStatement) {
                JavaImportStatement importStatement = (JavaImportStatement)type;
                if (clazz != null) {
                    throw new JavaParsingException(JavaCodeTypes.CLASS, "Encountered import statement after class!");
                }
                importStatements.add(importStatement);
                continue;
            }
            if (type instanceof Javadoc) {
                Javadoc javadoc = (Javadoc)type;
                if (doc != null) {
                    throw new JavaParsingException(JavaCodeTypes.CLASS, "Only one Javadoc allowed on a class!");
                }
                if (clazz != null) {
                    throw new JavaParsingException(JavaCodeTypes.CLASS, "Encountered Javadoc after class!");
                }
                doc = javadoc;
                continue;
            }
            if (type instanceof JavaAnnotation) {
                JavaAnnotation annotation = (JavaAnnotation)type;
                if (clazz != null) {
                    throw new JavaParsingException(JavaCodeTypes.CLASS, "Encountered annotation after class!");
                }
                annotations.add(annotation);
                continue;
            }
            if (!(type instanceof EditableJavaClass)) continue;
            EditableJavaClass javaClass = (EditableJavaClass)type;
            if (clazz != null) {
                throw new JavaParsingException(JavaCodeTypes.CLASS, "Encountered multiple classes!");
            }
            if (packageDeclaration != null) {
                javaClass.setPackageDeclaration(packageDeclaration);
            }
            if (ListUtil.isNotBlank(importStatements)) {
                javaClass.setImportStatements(importStatements);
            }
            if (doc != null) {
                javaClass.setJavadoc(doc);
            }
            if (ListUtil.isNotBlank(annotations)) {
                javaClass.setAnnotations(annotations);
            }
            clazz = javaClass;
        }
        if (clazz == null) {
            throw new JavaParsingException(JavaCodeTypes.CLASS, "Failed to parse an actual class!");
        }
        return clazz;
    }

    public static ParsingPojo parseClass(List<String> tokens, int startToken) throws JavaParsingException {
        int currentToken;
        ArrayList<Object> errors = new ArrayList<Object>();
        if (StringUtil.notEquals((String)tokens.get(startToken), (String)"class")) {
            errors.add("The first token of a class must be 'class'");
        }
        for (currentToken = startToken + 1; currentToken < tokens.size() && WHITESPACE_MATCHER.reset(tokens.get(currentToken)).matches(); ++currentToken) {
        }
        Pair<String, Integer> typeAndNextToken = JavaClassParser.parseOutType(tokens, currentToken);
        if (currentToken >= tokens.size() || typeAndNextToken == null) {
            throw new JavaParsingException(JavaCodeTypes.CLASS, "Failed to find class name!");
        }
        String className = (String)typeAndNextToken.getLeft();
        currentToken = (Integer)typeAndNextToken.getRight();
        boolean hitBlockOpenToken = false;
        boolean endReached = false;
        String superClassName = null;
        ArrayList<String> implementsInterfaces = new ArrayList<String>();
        ArrayList<JavaCodeType> itemsInClass = new ArrayList<JavaCodeType>();
        while (currentToken < tokens.size() && !endReached) {
            ThrowingFunction2 parseMethod;
            String token = tokens.get(currentToken);
            if (StringUtil.equals((String)token, (String)"extends")) {
                if (hitBlockOpenToken) {
                    throw new JavaParsingException(JavaCodeTypes.CLASS, "found 'extends' after hitting the block open token!");
                }
                ++currentToken;
                while (currentToken < tokens.size() && WHITESPACE_MATCHER.reset(tokens.get(currentToken)).matches()) {
                    ++currentToken;
                }
                Pair<String, Integer> extendsTypeAndNextToken = JavaClassParser.parseOutType(tokens, currentToken);
                if (currentToken >= tokens.size() || extendsTypeAndNextToken == null) {
                    throw new JavaParsingException(JavaCodeTypes.CLASS, "Failed to find super class name after 'extends'!");
                }
                superClassName = (String)extendsTypeAndNextToken.getLeft();
                currentToken = (Integer)extendsTypeAndNextToken.getRight();
                continue;
            }
            if (StringUtil.equals((String)token, (String)"implements")) {
                if (hitBlockOpenToken) {
                    throw new JavaParsingException(JavaCodeTypes.CLASS, "found 'implements' after hitting the block open token!");
                }
                ++currentToken;
                while (currentToken < tokens.size() && WHITESPACE_MATCHER.reset(tokens.get(currentToken)).matches()) {
                    ++currentToken;
                }
                boolean continueInterfaces = true;
                while (continueInterfaces) {
                    Pair<String, Integer> interfaceTypeAndNextToken = JavaClassParser.parseOutType(tokens, currentToken);
                    if (currentToken >= tokens.size() || interfaceTypeAndNextToken == null) {
                        throw new JavaParsingException(JavaCodeTypes.CLASS, "Failed to find implements interface name after 'implements' or ','!");
                    }
                    String interfaceName = (String)interfaceTypeAndNextToken.getLeft();
                    currentToken = (Integer)interfaceTypeAndNextToken.getRight();
                    if (interfaceName.startsWith(",")) {
                        if (implementsInterfaces.isEmpty()) {
                            throw new JavaParsingException(JavaCodeTypes.CLASS, "Encountered ',' before any interface names!");
                        }
                        interfaceName = interfaceName.substring(",".length());
                    }
                    continueInterfaces = false;
                    if (interfaceName.endsWith(",")) {
                        continueInterfaces = true;
                        interfaceName = interfaceName.substring(0, interfaceName.length() - ",".length());
                    }
                    implementsInterfaces.add(interfaceName);
                    while (currentToken < tokens.size() && WHITESPACE_MATCHER.reset(tokens.get(currentToken)).matches()) {
                        ++currentToken;
                    }
                    if (currentToken >= tokens.size()) continue;
                    if (StringUtil.equals((String)tokens.get(currentToken), (String)",")) {
                        continueInterfaces = true;
                        ++currentToken;
                        while (currentToken < tokens.size() && WHITESPACE_MATCHER.reset(tokens.get(currentToken)).matches()) {
                            ++currentToken;
                        }
                        continue;
                    }
                    if (!tokens.get(currentToken).startsWith(",")) continue;
                    continueInterfaces = true;
                }
                continue;
            }
            if (StringUtil.equals((String)token, (String)"{")) {
                if (hitBlockOpenToken) {
                    errors.add("We hit the block open token twice for the same class!");
                }
                hitBlockOpenToken = true;
                ++currentToken;
                continue;
            }
            if (StringUtil.equals((String)token, (String)"}")) {
                endReached = true;
                ++currentToken;
                continue;
            }
            if (StringUtil.equals((String)token, (String)"class")) {
                parseMethod = JavaClassParser::parseClass;
            } else if (token.startsWith("/**")) {
                parseMethod = JavadocParser::parseJavadoc;
            } else if (token.startsWith("/*")) {
                parseMethod = JavaMultiLineCommentParser::parseMultiLineComment;
            } else if (token.startsWith("//")) {
                parseMethod = JavaSingleLineCommentParser::parseSingleLineComment;
            } else if (token.startsWith("@")) {
                parseMethod = JavaAnnotationParser::parseAnnotation;
            } else if (MODIFIERS.contains(token)) {
                parseMethod = JavaTypeWithModifiersParser::parseTypeWithModifiers;
            } else {
                if (WHITESPACE_MATCHER.reset(token).matches()) {
                    ++currentToken;
                    continue;
                }
                JavaCodeTypes type = JavaClassParser.determineFieldOrMethod(tokens, currentToken);
                if (type == JavaCodeTypes.FIELD) {
                    parseMethod = JavaFieldParser::parseField;
                } else if (type == JavaCodeTypes.METHOD) {
                    parseMethod = JavaMethodParser::parseMethod;
                } else {
                    throw new JavaParsingException(JavaCodeTypes.CLASS, "Unable to determine token: '" + token + "'");
                }
            }
            ParsingPojo result = (ParsingPojo)parseMethod.apply(tokens, (Object)currentToken);
            itemsInClass.add(result.parsedType());
            currentToken = result.nextTokenIndex();
        }
        JavaClassBuilder builder = EditableJavaClass.builder().className(className);
        if (StringUtil.isNotBlank(superClassName)) {
            builder.superClassName(superClassName);
        }
        if (ListUtil.isNotBlank(implementsInterfaces)) {
            builder.implementsInterfaceNameTexts(implementsInterfaces);
        }
        Javadoc doc = null;
        ArrayList<JavaAnnotation> annotations = new ArrayList<JavaAnnotation>();
        for (JavaCodeType type : itemsInClass) {
            if (type instanceof JavaStaticCodeBlock) {
                JavaStaticCodeBlock staticCodeBlock = (JavaStaticCodeBlock)type;
                builder.staticCodeBlock(staticCodeBlock);
                continue;
            }
            if (type instanceof JavaSingleLineComment) {
                JavaSingleLineComment singleLineComment = (JavaSingleLineComment)type;
                builder.singleLineComment(singleLineComment);
                continue;
            }
            if (type instanceof JavaMultiLineComment) {
                JavaMultiLineComment multiLineComment = (JavaMultiLineComment)type;
                builder.multiLineComment(multiLineComment);
                continue;
            }
            if (type instanceof Javadoc) {
                Javadoc javadoc;
                doc = javadoc = (Javadoc)type;
                continue;
            }
            if (type instanceof JavaAnnotation) {
                JavaAnnotation annotation = (JavaAnnotation)type;
                annotations.add(annotation);
                continue;
            }
            if (type instanceof EditableJavaField) {
                EditableJavaField field = (EditableJavaField)type;
                if (doc != null) {
                    field.setJavadoc(doc);
                    doc = null;
                }
                if (!annotations.isEmpty()) {
                    field.setAnnotations(annotations);
                    annotations = new ArrayList();
                }
                builder.field(field);
                continue;
            }
            if (type instanceof EditableJavaMethod) {
                EditableJavaMethod method = (EditableJavaMethod)type;
                if (doc != null) {
                    method.setJavadoc(doc);
                    doc = null;
                }
                if (!annotations.isEmpty()) {
                    method.setAnnotations(annotations);
                    annotations = new ArrayList();
                }
                builder.method(method);
                continue;
            }
            if (type instanceof EditableJavaClass) {
                EditableJavaClass clazz = (EditableJavaClass)type;
                if (doc != null) {
                    clazz.setJavadoc(doc);
                    doc = null;
                }
                if (!annotations.isEmpty()) {
                    clazz.setAnnotations(annotations);
                    annotations = new ArrayList();
                }
                clazz.setInnerClass(true);
                builder.innerClass(clazz);
                continue;
            }
            errors.add("Don't know how to add '" + type.getJavaCodeType() + "' to a class");
        }
        if (doc != null) {
            errors.add("Found Javadoc at end of class with nothing to attach it to!");
        }
        if (!annotations.isEmpty()) {
            errors.add("Found annotations at end of class with nothing to attach them to!");
        }
        if (!errors.isEmpty()) {
            throw new JavaParsingException(JavaCodeTypes.CLASS, StringUtil.buildStringWithNewLines(errors));
        }
        return new ParsingPojo(currentToken, (JavaCodeType)builder.build());
    }
}

