/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.java.parsing.codetypes;

import com.github.tadukoo.java.JavaCodeType;
import com.github.tadukoo.java.JavaCodeTypes;
import com.github.tadukoo.java.Visibility;
import com.github.tadukoo.java.annotation.JavaAnnotation;
import com.github.tadukoo.java.field.EditableJavaField;
import com.github.tadukoo.java.field.JavaField;
import com.github.tadukoo.java.javadoc.Javadoc;
import com.github.tadukoo.java.parsing.AbstractJavaParser;
import com.github.tadukoo.java.parsing.JavaParsingException;
import com.github.tadukoo.java.parsing.ParsingPojo;
import com.github.tadukoo.java.parsing.codetypes.JavaAnnotationParser;
import com.github.tadukoo.java.parsing.comment.JavadocParser;
import com.github.tadukoo.util.ListUtil;
import com.github.tadukoo.util.StringUtil;
import com.github.tadukoo.util.functional.function.ThrowingFunction2;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaFieldParser
extends AbstractJavaParser {
    private static final Pattern FIELD_START_PATTERN = Pattern.compile("\\s*(?:(public|protected|private|static|final|abstract)\\s*)?(?:(public|protected|private|static|final|abstract)\\s*)?(?:(public|protected|private|static|final|abstract)\\s*)?(" + TYPE_REGEX + ")\\s*([^\\s;]+)?\\s*;?\\s*");

    private JavaFieldParser() {
    }

    public static JavaField parseField(String content) throws JavaParsingException {
        List<String> tokens = JavaFieldParser.splitContentIntoTokens(content);
        int currentToken = 0;
        ArrayList<JavaCodeType> types = new ArrayList<JavaCodeType>();
        while (currentToken < tokens.size()) {
            String token = tokens.get(currentToken);
            if (WHITESPACE_MATCHER.reset(token).matches()) {
                ++currentToken;
                continue;
            }
            ThrowingFunction2 parseMethod = token.startsWith("/**") ? JavadocParser::parseJavadoc : (token.startsWith("@") ? JavaAnnotationParser::parseAnnotation : JavaFieldParser::parseField);
            ParsingPojo pojo = (ParsingPojo)parseMethod.apply(tokens, (Object)currentToken);
            types.add(pojo.parsedType());
            currentToken = pojo.nextTokenIndex();
        }
        Javadoc doc = null;
        ArrayList<JavaAnnotation> annotations = new ArrayList<JavaAnnotation>();
        EditableJavaField field = null;
        for (JavaCodeType type : types) {
            if (type instanceof Javadoc) {
                Javadoc javadoc = (Javadoc)type;
                if (doc != null) {
                    throw new JavaParsingException(JavaCodeTypes.FIELD, "Only one Javadoc allowed on a field!");
                }
                if (field != null) {
                    throw new JavaParsingException(JavaCodeTypes.FIELD, "Encountered Javadoc after field!");
                }
                doc = javadoc;
                continue;
            }
            if (type instanceof JavaAnnotation) {
                JavaAnnotation annotation = (JavaAnnotation)type;
                if (field != null) {
                    throw new JavaParsingException(JavaCodeTypes.FIELD, "Encountered annotation after field!");
                }
                annotations.add(annotation);
                continue;
            }
            if (!(type instanceof EditableJavaField)) continue;
            EditableJavaField javaField = (EditableJavaField)type;
            if (field != null) {
                throw new JavaParsingException(JavaCodeTypes.FIELD, "Encountered multiple fields!");
            }
            if (doc != null) {
                javaField.setJavadoc(doc);
            }
            if (ListUtil.isNotBlank(annotations)) {
                javaField.setAnnotations(annotations);
            }
            field = javaField;
        }
        if (field == null) {
            throw new JavaParsingException(JavaCodeTypes.FIELD, "Failed to parse an actual field!");
        }
        return field;
    }

    public static ParsingPojo parseField(List<String> tokens, int startToken) throws JavaParsingException {
        int currentToken;
        StringBuilder field = new StringBuilder();
        boolean foundSemicolon = false;
        for (currentToken = startToken; currentToken < tokens.size() && !foundSemicolon; ++currentToken) {
            String token = tokens.get(currentToken);
            field.append(token);
            if (!token.endsWith(";")) continue;
            foundSemicolon = true;
        }
        if (!foundSemicolon) {
            throw new JavaParsingException(JavaCodeTypes.FIELD, "Failed to find semicolon at end of field");
        }
        JavaField javaField = JavaFieldParser.parseJustField(field.toString());
        return new ParsingPojo(currentToken, javaField);
    }

    private static JavaField parseJustField(String content) throws JavaParsingException {
        Matcher matcher;
        int equalsIndex = content.indexOf("=");
        String value = null;
        String firstPart = content;
        if (equalsIndex != -1) {
            value = StringUtil.trim((String)content.substring(equalsIndex + 1, content.length() - 1));
            firstPart = content.substring(0, equalsIndex);
        }
        if ((matcher = FIELD_START_PATTERN.matcher(firstPart)).matches()) {
            Visibility visibility = Visibility.NONE;
            boolean isStatic = false;
            boolean isFinal = false;
            block16: for (int i = 1; i <= 3; ++i) {
                String token = matcher.group(i);
                if (!StringUtil.isNotBlank((String)token)) continue;
                switch (token) {
                    case "public": {
                        visibility = Visibility.PUBLIC;
                        continue block16;
                    }
                    case "protected": {
                        visibility = Visibility.PROTECTED;
                        continue block16;
                    }
                    case "private": {
                        visibility = Visibility.PRIVATE;
                        continue block16;
                    }
                    case "abstract": {
                        throw new JavaParsingException(JavaCodeTypes.FIELD, "'abstract' is not a valid modifier on field!");
                    }
                    case "static": {
                        isStatic = true;
                        continue block16;
                    }
                    case "final": {
                        isFinal = true;
                    }
                }
            }
            String type = StringUtil.trim((String)matcher.group(4));
            String name = StringUtil.trim((String)matcher.group(11));
            if (value != null) {
                value = value.replaceAll("\n\t", "\n").replaceAll(System.lineSeparator(), "\n");
            }
            return EditableJavaField.builder().visibility(visibility).isStatic(isStatic).isFinal(isFinal).type(type).name(name).value(value).build();
        }
        throw new JavaParsingException(JavaCodeTypes.FIELD, "Failed to parse a field");
    }
}

