/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.java.parsing.codetypes;

import com.github.tadukoo.java.JavaCodeType;
import com.github.tadukoo.java.JavaCodeTypes;
import com.github.tadukoo.java.JavaParameter;
import com.github.tadukoo.java.JavaTypeParameter;
import com.github.tadukoo.java.Visibility;
import com.github.tadukoo.java.annotation.JavaAnnotation;
import com.github.tadukoo.java.javadoc.Javadoc;
import com.github.tadukoo.java.method.EditableJavaMethod;
import com.github.tadukoo.java.method.JavaMethod;
import com.github.tadukoo.java.parsing.AbstractJavaParser;
import com.github.tadukoo.java.parsing.JavaParsingException;
import com.github.tadukoo.java.parsing.ParsingPojo;
import com.github.tadukoo.java.parsing.codetypes.JavaAnnotationParser;
import com.github.tadukoo.java.parsing.comment.JavadocParser;
import com.github.tadukoo.util.ListUtil;
import com.github.tadukoo.util.StringUtil;
import com.github.tadukoo.util.functional.function.ThrowingFunction2;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaMethodParser
extends AbstractJavaParser {
    private static final Pattern METHOD_PATTERN = Pattern.compile("\\s*(?:(public|protected|private|static|final|abstract)\\s*)?(?:(public|protected|private|static|final|abstract)\\s*)?(?:(public|protected|private|static|final|abstract)\\s*)?(?:<((?:\\s*([^\\s)]+)(?:\\s*extends\\s*([^\\s)]*))?\\s*,)*\\s*([^\\s)]+)(?:\\s*extends\\s*([^\\s)]*))?\\s*)>)?\\s*(" + TYPE_REGEX + ")(\\s*[^\\s(]*)?\\s*\\(\\s*((" + PARAMETER_REGEX + ",?)*)\\s*\\)(?:\\s*throws ([^{]*))?\\s*(?:\\{\\s*(.*)\\s*}|;\\s*)", 32);

    private JavaMethodParser() {
    }

    public static JavaMethod parseMethod(String content) throws JavaParsingException {
        List<String> tokens = JavaMethodParser.splitContentIntoTokens(content);
        int currentToken = 0;
        ArrayList<JavaCodeType> types = new ArrayList<JavaCodeType>();
        while (currentToken < tokens.size()) {
            String token = tokens.get(currentToken);
            if (WHITESPACE_MATCHER.reset(token).matches()) {
                ++currentToken;
                continue;
            }
            ThrowingFunction2 parseMethod = token.startsWith("/**") ? JavadocParser::parseJavadoc : (token.startsWith("@") ? JavaAnnotationParser::parseAnnotation : JavaMethodParser::parseMethod);
            ParsingPojo pojo = (ParsingPojo)parseMethod.apply(tokens, (Object)currentToken);
            types.add(pojo.parsedType());
            currentToken = pojo.nextTokenIndex();
        }
        Javadoc doc = null;
        ArrayList<JavaAnnotation> annotations = new ArrayList<JavaAnnotation>();
        EditableJavaMethod method = null;
        for (JavaCodeType type : types) {
            if (type instanceof Javadoc) {
                Javadoc javadoc = (Javadoc)type;
                if (doc != null) {
                    throw new JavaParsingException(JavaCodeTypes.METHOD, "Only one Javadoc allowed on a method!");
                }
                if (method != null) {
                    throw new JavaParsingException(JavaCodeTypes.METHOD, "Encountered Javadoc after method!");
                }
                doc = javadoc;
                continue;
            }
            if (type instanceof JavaAnnotation) {
                JavaAnnotation annotation = (JavaAnnotation)type;
                if (method != null) {
                    throw new JavaParsingException(JavaCodeTypes.METHOD, "Encountered annotation after method!");
                }
                annotations.add(annotation);
                continue;
            }
            if (!(type instanceof EditableJavaMethod)) continue;
            EditableJavaMethod javaMethod = (EditableJavaMethod)type;
            if (method != null) {
                throw new JavaParsingException(JavaCodeTypes.METHOD, "Encountered multiple methods!");
            }
            if (doc != null) {
                javaMethod.setJavadoc(doc);
            }
            if (ListUtil.isNotBlank(annotations)) {
                javaMethod.setAnnotations(annotations);
            }
            method = javaMethod;
        }
        if (method == null) {
            throw new JavaParsingException(JavaCodeTypes.METHOD, "Failed to parse an actual method!");
        }
        return method;
    }

    public static ParsingPojo parseMethod(List<String> tokens, int startToken) throws JavaParsingException {
        int currentToken;
        ArrayList<String> errors = new ArrayList<String>();
        StringBuilder methodString = new StringBuilder();
        boolean inParameters = false;
        boolean parametersDone = false;
        boolean insideMethod = false;
        int openBlocks = 0;
        boolean methodDone = false;
        for (currentToken = startToken; currentToken < tokens.size() && !methodDone; ++currentToken) {
            String token = tokens.get(currentToken);
            methodString.append(token);
            if (!parametersDone && !inParameters && token.contains("(")) {
                inParameters = true;
            }
            if (!parametersDone && inParameters && token.contains(")")) {
                inParameters = false;
                parametersDone = true;
            }
            if (parametersDone && token.contains("{")) {
                insideMethod = true;
            } else if (parametersDone && !insideMethod && token.endsWith(";")) {
                methodDone = true;
            }
            if (!insideMethod) continue;
            if (StringUtil.equals((String)token, (String)"{")) {
                ++openBlocks;
            }
            if (StringUtil.equals((String)token, (String)"}")) {
                --openBlocks;
            }
            if (openBlocks != 0) continue;
            methodDone = true;
        }
        if (!parametersDone) {
            errors.add("Didn't complete parameters in method");
        }
        if (!methodDone) {
            errors.add("Didn't complete the method");
        }
        if (!errors.isEmpty()) {
            throw new JavaParsingException(JavaCodeTypes.METHOD, StringUtil.buildStringWithNewLines(errors));
        }
        return new ParsingPojo(currentToken, JavaMethodParser.parseJustMethod(methodString.toString()));
    }

    /*
     * WARNING - void declaration
     */
    public static JavaMethod parseJustMethod(String content) {
        String methodString = StringUtil.trim((String)content);
        Matcher matcher = METHOD_PATTERN.matcher(methodString);
        if (matcher.matches()) {
            Visibility visibility = Visibility.NONE;
            boolean isAbstract = false;
            boolean isStatic = false;
            boolean isFinal = false;
            block16: for (int i = 1; i <= 3; ++i) {
                String token = matcher.group(i);
                if (!StringUtil.isNotBlank((String)token)) continue;
                switch (token) {
                    case "public": {
                        visibility = Visibility.PUBLIC;
                        continue block16;
                    }
                    case "protected": {
                        visibility = Visibility.PROTECTED;
                        continue block16;
                    }
                    case "private": {
                        visibility = Visibility.PRIVATE;
                        continue block16;
                    }
                    case "abstract": {
                        isAbstract = true;
                        continue block16;
                    }
                    case "static": {
                        isStatic = true;
                        continue block16;
                    }
                    case "final": {
                        isFinal = true;
                    }
                }
            }
            String typeParametersString = StringUtil.trim((String)matcher.group(4));
            String returnType = StringUtil.trim((String)matcher.group(9));
            String name = StringUtil.trim((String)matcher.group(16));
            String parameterString = StringUtil.trim((String)matcher.group(17));
            String throwsString = StringUtil.trim((String)matcher.group(28));
            String contentString = StringUtil.trim((String)matcher.group(29));
            List<JavaTypeParameter> typeParameters = JavaMethodParser.parseJavaTypeParameters(typeParametersString);
            ArrayList<JavaParameter> parameters = new ArrayList<JavaParameter>();
            if (StringUtil.isNotBlank((String)parameterString)) {
                if (parameterString.contains(",")) {
                    String[] parameterList = parameterString.split(",");
                    Object var16_18 = null;
                    String[] stringArray = parameterList;
                    int n = stringArray.length;
                    for (int i = 0; i < n; ++i) {
                        void var16_22;
                        void var16_19;
                        String parameterPiece = stringArray[i];
                        if (StringUtil.isBlank((String)var16_19)) {
                            String string = parameterPiece;
                        } else {
                            String string = (String)var16_19 + "," + parameterPiece;
                        }
                        if (!PARAMETER_PATTERN.matcher((CharSequence)var16_22).matches()) continue;
                        parameters.add(JavaMethodParser.parseJavaParameter((String)var16_22));
                        Object var16_23 = null;
                    }
                } else {
                    parameters.add(JavaMethodParser.parseJavaParameter(parameterString));
                }
            }
            ArrayList<String> throwTypes = new ArrayList<String>();
            if (StringUtil.isNotBlank((String)throwsString)) {
                if (throwsString.contains(",")) {
                    for (String throwType : throwsString.split(",")) {
                        throwTypes.add(StringUtil.trim((String)throwType));
                    }
                } else {
                    throwTypes.add(throwsString);
                }
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            int insideBlocks = 0;
            if (StringUtil.isNotBlank((String)contentString)) {
                if (contentString.contains("\n")) {
                    for (String line : contentString.split("\n")) {
                        if (StringUtil.equals((String)(line = StringUtil.trim((String)line)), (String)";")) {
                            String lastLine = (String)arrayList.remove(arrayList.size() - 1);
                            arrayList.add(lastLine + ";");
                        }
                        if (line.contains(";") && !line.endsWith("{")) {
                            for (String string : line.split(";")) {
                                void var25_44;
                                String string2 = StringUtil.trim((String)string);
                                if (!StringUtil.isNotBlank((String)string2)) continue;
                                if (string2.startsWith(".")) {
                                    String string3 = "\t\t" + string2;
                                }
                                arrayList.add("\t".repeat(insideBlocks) + (String)var25_44 + ";");
                            }
                            continue;
                        }
                        if (line.startsWith("}") || line.endsWith("}")) {
                            --insideBlocks;
                        }
                        arrayList.add("\t".repeat(insideBlocks) + (line.startsWith(".") ? "\t\t" : "") + StringUtil.trim((String)line));
                        if (!line.endsWith("{")) continue;
                        ++insideBlocks;
                    }
                } else {
                    for (String line : contentString.split(";")) {
                        arrayList.add("\t".repeat(insideBlocks) + (line.startsWith(".") ? "\t\t" : "") + StringUtil.trim((String)line) + ";");
                    }
                }
            }
            return EditableJavaMethod.builder().visibility(visibility).isAbstract(isAbstract).isStatic(isStatic).isFinal(isFinal).typeParameters(typeParameters).returnType(returnType).name(name).parameters(parameters).throwTypes(throwTypes).lines(arrayList).build();
        }
        return null;
    }
}

