/*
 * Decompiled with CFR 0.152.
 */
package com.github.tadukoo.java.parsing.codetypes;

import com.github.tadukoo.java.JavaCodeType;
import com.github.tadukoo.java.JavaCodeTypes;
import com.github.tadukoo.java.Visibility;
import com.github.tadukoo.java.code.staticcodeblock.EditableJavaStaticCodeBlock;
import com.github.tadukoo.java.field.EditableJavaField;
import com.github.tadukoo.java.javaclass.EditableJavaClass;
import com.github.tadukoo.java.method.EditableJavaMethod;
import com.github.tadukoo.java.parsing.AbstractJavaParser;
import com.github.tadukoo.java.parsing.JavaParsingException;
import com.github.tadukoo.java.parsing.ParsingPojo;
import com.github.tadukoo.java.parsing.classtypes.JavaClassParser;
import com.github.tadukoo.java.parsing.codetypes.JavaFieldParser;
import com.github.tadukoo.java.parsing.codetypes.JavaMethodParser;
import com.github.tadukoo.util.StringUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class JavaTypeWithModifiersParser
extends AbstractJavaParser {
    private JavaTypeWithModifiersParser() {
    }

    public static ParsingPojo parseTypeWithModifiers(List<String> tokens, int startToken) throws JavaParsingException {
        int currentToken;
        ArrayList<Object> errors = new ArrayList<Object>();
        if (!MODIFIERS.contains(tokens.get(startToken))) {
            errors.add("First token of type with modifiers must be a modifier");
        }
        JavaCodeTypes type = JavaCodeTypes.TYPE_WITH_MODIFIERS;
        JavaCodeType resultType = null;
        ArrayList<String> modifiers = new ArrayList<String>();
        for (currentToken = startToken; currentToken < tokens.size(); ++currentToken) {
            Object endContent;
            String modifier;
            String token = tokens.get(currentToken);
            if (MODIFIERS.contains(token)) {
                modifiers.add(token);
                continue;
            }
            if (StringUtil.equals((String)token, (String)"class")) {
                ParsingPojo result = JavaClassParser.parseClass(tokens, currentToken);
                type = JavaCodeTypes.CLASS;
                resultType = result.parsedType();
                EditableJavaClass clazz = (EditableJavaClass)resultType;
                currentToken = result.nextTokenIndex();
                Iterator iterator = modifiers.iterator();
                while (iterator.hasNext()) {
                    switch (modifier = (String)iterator.next()) {
                        case "private": {
                            clazz.setVisibility(Visibility.PRIVATE);
                            break;
                        }
                        case "protected": {
                            clazz.setVisibility(Visibility.PROTECTED);
                            break;
                        }
                        case "public": {
                            clazz.setVisibility(Visibility.PUBLIC);
                            break;
                        }
                        case "abstract": {
                            clazz.setAbstract(true);
                            break;
                        }
                        case "static": {
                            clazz.setStatic(true);
                            break;
                        }
                        case "final": {
                            clazz.setFinal(true);
                        }
                    }
                }
                break;
            }
            if (StringUtil.equals((String)token, (String)"{")) {
                if (modifiers.size() != 1 || StringUtil.notEquals((String)((String)modifiers.get(0)), (String)"static")) {
                    errors.add("Static Code Block can only have 'static' as a modifier");
                }
                int openBlocks = 1;
                StringBuilder content = new StringBuilder();
                ++currentToken;
                while (currentToken < tokens.size() && WHITESPACE_MATCHER.reset(tokens.get(currentToken)).matches()) {
                    ++currentToken;
                }
                while (openBlocks > 0) {
                    String currentTokenContent = tokens.get(currentToken);
                    if (StringUtil.equals((String)currentTokenContent, (String)"{")) {
                        ++openBlocks;
                    } else if (StringUtil.equals((String)currentTokenContent, (String)"}")) {
                        --openBlocks;
                    }
                    ++currentToken;
                    if (openBlocks == 0) continue;
                    content.append(currentTokenContent);
                }
                endContent = content.toString().replaceAll("\n\t\t", "\n").replaceAll("\\s+$", "");
                EditableJavaStaticCodeBlock staticCodeBlock = (EditableJavaStaticCodeBlock)EditableJavaStaticCodeBlock.builder().lines(StringUtil.parseListFromStringWithSeparator((String)endContent, (String)"\n", (boolean)false)).build();
                type = JavaCodeTypes.STATIC_CODE_BLOCK;
                resultType = staticCodeBlock;
                break;
            }
            if (WHITESPACE_MATCHER.reset(token).matches()) continue;
            type = JavaTypeWithModifiersParser.determineFieldOrMethod(tokens, currentToken);
            if (type == JavaCodeTypes.METHOD) {
                ParsingPojo result = JavaMethodParser.parseMethod(tokens, currentToken);
                EditableJavaMethod method = (EditableJavaMethod)result.parsedType();
                endContent = modifiers.iterator();
                while (endContent.hasNext()) {
                    switch (modifier = (String)endContent.next()) {
                        case "private": {
                            method.setVisibility(Visibility.PRIVATE);
                            break;
                        }
                        case "protected": {
                            method.setVisibility(Visibility.PROTECTED);
                            break;
                        }
                        case "public": {
                            method.setVisibility(Visibility.PUBLIC);
                            break;
                        }
                        case "abstract": {
                            method.setAbstract(true);
                            break;
                        }
                        case "static": {
                            method.setStatic(true);
                            break;
                        }
                        case "final": {
                            method.setFinal(true);
                        }
                    }
                }
                resultType = method;
                currentToken = result.nextTokenIndex();
                break;
            }
            if (type == JavaCodeTypes.FIELD) {
                ParsingPojo result = JavaFieldParser.parseField(tokens, currentToken);
                EditableJavaField field = (EditableJavaField)result.parsedType();
                endContent = modifiers.iterator();
                while (endContent.hasNext()) {
                    switch (modifier = (String)endContent.next()) {
                        case "private": {
                            field.setVisibility(Visibility.PRIVATE);
                            break;
                        }
                        case "protected": {
                            field.setVisibility(Visibility.PROTECTED);
                            break;
                        }
                        case "public": {
                            field.setVisibility(Visibility.PUBLIC);
                            break;
                        }
                        case "abstract": {
                            throw new JavaParsingException(JavaCodeTypes.FIELD, "'abstract' is not a valid modifier on field!");
                        }
                        case "static": {
                            field.setStatic(true);
                            break;
                        }
                        case "final": {
                            field.setFinal(true);
                        }
                    }
                }
                resultType = field;
                currentToken = result.nextTokenIndex();
                break;
            }
            errors.add("Failed to determine type");
        }
        HashSet<String> foundModifiers = new HashSet<String>();
        int visibilityModifiers = 0;
        for (String modifier : modifiers) {
            if (!foundModifiers.add(modifier)) {
                errors.add("Found duplicate modifier: '" + modifier + "'");
            }
            if (!VISIBILITY_MODIFIERS.contains(modifier)) continue;
            ++visibilityModifiers;
        }
        if (visibilityModifiers > 1) {
            errors.add("Found multiple visibility modifiers");
        }
        if (resultType == null) {
            errors.add("Failed to determine result type");
        }
        if (!errors.isEmpty()) {
            throw new JavaParsingException(type, StringUtil.buildStringWithNewLines(errors));
        }
        return new ParsingPojo(currentToken, resultType);
    }
}

