/*
 * Decompiled with CFR 0.152.
 */
package com.skype;

import com.skype.Application;
import com.skype.Call;
import com.skype.CallListener;
import com.skype.Chat;
import com.skype.ChatMessage;
import com.skype.ChatMessageListener;
import com.skype.ContactList;
import com.skype.Profile;
import com.skype.SMS;
import com.skype.SkypeException;
import com.skype.SkypeExceptionHandler;
import com.skype.User;
import com.skype.Utils;
import com.skype.VoiceMail;
import com.skype.VoiceMailListener;
import com.skype.connector.AbstractConnectorListener;
import com.skype.connector.Connector;
import com.skype.connector.ConnectorException;
import com.skype.connector.ConnectorListener;
import com.skype.connector.ConnectorMessageEvent;
import java.io.File;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public final class Skype {
    public static final String LIBRARY_VERSION = "1.0.0.0";
    private static ContactList contactList;
    private static Profile profile;
    private static Object chatMessageListenerMutex;
    private static ConnectorListener chatMessageListener;
    private static List<ChatMessageListener> chatMessageListeners;
    private static Object callListenerMutex;
    private static ConnectorListener callListener;
    private static List<CallListener> callListeners;
    private static Object voiceMailListenerMutex;
    private static ConnectorListener voiceMailListener;
    private static List<VoiceMailListener> voiceMailListeners;
    private static Object userThreadFieldMutex;
    private static Thread userThread;
    private static SkypeExceptionHandler defaultExceptionHandler;
    private static SkypeExceptionHandler exceptionHandler;

    @Deprecated
    public static void setDeamon(boolean on) {
        Skype.setDaemon(on);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDaemon(boolean on) {
        Object object = userThreadFieldMutex;
        synchronized (object) {
            if (!on && userThread == null) {
                userThread = new Thread("SkypeUserThread"){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Object wait;
                        Object object = wait = new Object();
                        synchronized (object) {
                            try {
                                wait.wait();
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                    }
                };
                userThread.start();
            } else if (on && userThread != null) {
                userThread.interrupt();
                userThread = null;
            }
        }
    }

    public static void setDebug(boolean on) throws SkypeException {
        try {
            Connector.getInstance().setDebug(on);
        }
        catch (ConnectorException e) {
            Utils.convertToSkypeException(e);
        }
    }

    public static String getVersion() throws SkypeException {
        return Utils.getProperty("SKYPEVERSION");
    }

    public static boolean isInstalled() {
        String path = Skype.getInstalledPath();
        if (path == null) {
            return false;
        }
        return new File(path).exists();
    }

    public static String getInstalledPath() {
        return Connector.getInstance().getInstalledPath();
    }

    public static boolean isRunning() throws SkypeException {
        try {
            return Connector.getInstance().isRunning();
        }
        catch (ConnectorException e) {
            Utils.convertToSkypeException(e);
            return false;
        }
    }

    public static User[] searchUsers(String keyword) throws SkypeException {
        String response;
        String command = "SEARCH USERS " + keyword;
        String responseHeader = "USERS ";
        try {
            response = Connector.getInstance().executeWithId(command, responseHeader);
        }
        catch (ConnectorException ex) {
            Utils.convertToSkypeException(ex);
            return null;
        }
        Utils.checkError(response);
        String data = response.substring(responseHeader.length());
        String[] ids = Utils.convertToArray(data);
        User[] users = new User[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            users[i] = User.getInstance(ids[i]);
        }
        return users;
    }

    public static ContactList getContactList() throws SkypeException {
        if (contactList == null) {
            contactList = new ContactList();
        }
        return contactList;
    }

    public static Call call(String ... skypeIds) throws SkypeException {
        Utils.checkNotNull("skypeIds", skypeIds);
        return Skype.call(Utils.convertToCommaSeparatedString(skypeIds));
    }

    public static Call call(String skypeId) throws SkypeException {
        Utils.checkNotNull("skypeIds", skypeId);
        try {
            String responseHeader = "CALL ";
            String response = Connector.getInstance().executeWithId("CALL " + skypeId, responseHeader);
            Utils.checkError(response);
            String id = response.substring(responseHeader.length(), response.indexOf(" STATUS "));
            return Call.getInstance(id);
        }
        catch (ConnectorException e) {
            Utils.convertToSkypeException(e);
            return null;
        }
    }

    public static Chat chat(String[] skypeIds) throws SkypeException {
        Utils.checkNotNull("skypeIds", skypeIds);
        return Skype.chat(Utils.convertToCommaSeparatedString(skypeIds));
    }

    public static Chat chat(String skypeId) throws SkypeException {
        try {
            String responseHeader = "CHAT ";
            String response = Connector.getInstance().executeWithId("CHAT CREATE " + skypeId, responseHeader);
            Utils.checkError(response);
            String id = response.substring(responseHeader.length(), response.indexOf(" STATUS "));
            return Chat.getInstance(id);
        }
        catch (ConnectorException e) {
            Utils.convertToSkypeException(e);
            return null;
        }
    }

    public static SMS submitConfirmationCode(String[] numbers) throws SkypeException {
        Utils.checkNotNull("numbers", numbers);
        return Skype.submitConfirmationCode(Utils.convertToCommaSeparatedString(numbers));
    }

    public static SMS submitConfirmationCode(String number) throws SkypeException {
        SMS message = Skype.createSMS(number, SMS.Type.CONFIRMATION_CODE_REQUEST);
        message.send();
        return message;
    }

    public static SMS submitConfirmationCode(String[] numbers, String code) throws SkypeException {
        Utils.checkNotNull("numbers", numbers);
        Utils.checkNotNull("code", code);
        return Skype.submitConfirmationCode(Utils.convertToCommaSeparatedString(numbers), code);
    }

    public static SMS submitConfirmationCode(String number, String code) throws SkypeException {
        Utils.checkNotNull("number", number);
        Utils.checkNotNull("code", code);
        SMS message = Skype.createSMS(number, SMS.Type.CONFIRMATION_CODE_REQUEST);
        message.setContent(code);
        message.send();
        return message;
    }

    public static SMS sendSMS(String[] numbers, String content) throws SkypeException {
        Utils.checkNotNull("numbers", numbers);
        return Skype.sendSMS(Utils.convertToCommaSeparatedString(numbers), content);
    }

    public static SMS sendSMS(String number, String content) throws SkypeException {
        Utils.checkNotNull("number", number);
        Utils.checkNotNull("content", content);
        SMS message = Skype.createSMS(number, SMS.Type.OUTGOING);
        message.setContent(content);
        message.send();
        return message;
    }

    private static SMS createSMS(String number, SMS.Type type) throws SkypeException {
        try {
            String responseHeader = "SMS ";
            String response = Connector.getInstance().executeWithId("CREATE SMS " + (Object)((Object)type) + " " + number, responseHeader);
            Utils.checkError(response);
            String id = response.substring(responseHeader.length(), response.indexOf(" STATUS "));
            return SMS.getInstance(id);
        }
        catch (ConnectorException e) {
            Utils.convertToSkypeException(e);
            return null;
        }
    }

    public SMS[] getAllSMSs() throws SkypeException {
        return this.getAllSMSs("SMSS");
    }

    public SMS[] getAllMissedSMSs() throws SkypeException {
        return this.getAllSMSs("MISSEDSMSS");
    }

    private SMS[] getAllSMSs(String type) throws SkypeException {
        try {
            String command = "SEARCH " + type;
            String responseHeader = "SMSS ";
            String response = Connector.getInstance().execute(command, responseHeader);
            String data = response.substring(responseHeader.length());
            String[] ids = Utils.convertToArray(data);
            SMS[] smss = new SMS[ids.length];
            for (int i = 0; i < ids.length; ++i) {
                smss[i] = SMS.getInstance(ids[i]);
            }
            return smss;
        }
        catch (ConnectorException e) {
            Utils.convertToSkypeException(e);
            return null;
        }
    }

    public static VoiceMail voiceMail(String skypeId) throws SkypeException {
        try {
            String responseHeader = "VOICEMAIL ";
            String response = Connector.getInstance().executeWithId("VOICEMAIL " + skypeId, responseHeader);
            Utils.checkError(response);
            String id = response.substring(responseHeader.length(), response.indexOf(32, responseHeader.length()));
            return VoiceMail.getInstance(id);
        }
        catch (ConnectorException e) {
            Utils.convertToSkypeException(e);
            return null;
        }
    }

    public static VoiceMail[] getAllVoiceMails() throws SkypeException {
        try {
            String command = "SEARCH VOICEMAILS";
            String responseHeader = "VOICEMAILS ";
            String response = Connector.getInstance().execute(command, responseHeader);
            String data = response.substring(responseHeader.length());
            String[] ids = Utils.convertToArray(data);
            VoiceMail[] voiceMails = new VoiceMail[ids.length];
            for (int i = 0; i < ids.length; ++i) {
                voiceMails[i] = VoiceMail.getInstance(ids[i]);
            }
            return voiceMails;
        }
        catch (ConnectorException ex) {
            Utils.convertToSkypeException(ex);
            return null;
        }
    }

    public static Application addApplication(String name) throws SkypeException {
        Utils.checkNotNull("name", name);
        return Application.getInstance(name);
    }

    public static String getAudioInputDevice() throws SkypeException {
        return Skype.convertDefaultDeviceToNull(Utils.getProperty("AUDIO_IN"));
    }

    public static String getAudioOutputDevice() throws SkypeException {
        return Skype.convertDefaultDeviceToNull(Utils.getProperty("AUDIO_OUT"));
    }

    public static String getVideoDevice() throws SkypeException {
        return Skype.convertDefaultDeviceToNull(Utils.getProperty("VIDEO_IN"));
    }

    private static String convertDefaultDeviceToNull(String deviceName) {
        if (Skype.isDefaultDevice(deviceName)) {
            return null;
        }
        return deviceName;
    }

    private static boolean isDefaultDevice(String deviceName) {
        return "".equals(deviceName);
    }

    public static void setAudioInputDevice(String deviceName) throws SkypeException {
        Utils.setProperty("AUDIO_IN", Skype.convertNullToDefaultDevice(deviceName));
    }

    public static void setAudioOutputDevice(String deviceName) throws SkypeException {
        Utils.setProperty("AUDIO_OUT", Skype.convertNullToDefaultDevice(deviceName));
    }

    public static void setVideoDevice(String deviceName) throws SkypeException {
        Utils.setProperty("VIDEO_IN", Skype.convertNullToDefaultDevice(deviceName));
    }

    private static String convertNullToDefaultDevice(String deviceName) {
        if (deviceName == null) {
            return "";
        }
        return deviceName;
    }

    public static synchronized Profile getProfile() {
        if (profile == null) {
            profile = new Profile();
        }
        return profile;
    }

    public static Call[] getAllActiveCalls() throws SkypeException {
        try {
            String command = "SEARCH ACTIVECALLS";
            String responseHeader = "CALLS ";
            String response = Connector.getInstance().execute(command, responseHeader);
            String data = response.substring(responseHeader.length());
            String[] ids = Utils.convertToArray(data);
            Call[] calls = new Call[ids.length];
            for (int i = 0; i < ids.length; ++i) {
                calls[i] = Call.getInstance(ids[i]);
            }
            return calls;
        }
        catch (ConnectorException ex) {
            Utils.convertToSkypeException(ex);
            return null;
        }
    }

    public static Chat[] getAllChats() throws SkypeException {
        return Skype.getAllChats("CHATS");
    }

    public static Chat[] getAllActiveChats() throws SkypeException {
        return Skype.getAllChats("ACTIVECHATS");
    }

    public static Chat[] getAllMissedChats() throws SkypeException {
        return Skype.getAllChats("MISSEDCHATS");
    }

    public static Chat[] getAllRecentChats() throws SkypeException {
        return Skype.getAllChats("RECENTCHATS");
    }

    public static Chat[] getAllBookmarkedChats() throws SkypeException {
        return Skype.getAllChats("BOOKMARKEDCHATS");
    }

    private static Chat[] getAllChats(String type) throws SkypeException {
        try {
            String command = "SEARCH " + type;
            String responseHeader = "CHATS ";
            String response = Connector.getInstance().execute(command, responseHeader);
            String data = response.substring(responseHeader.length());
            String[] ids = Utils.convertToArray(data);
            Chat[] chats = new Chat[ids.length];
            for (int i = 0; i < ids.length; ++i) {
                chats[i] = Chat.getInstance(ids[i]);
            }
            return chats;
        }
        catch (ConnectorException ex) {
            Utils.convertToSkypeException(ex);
            return null;
        }
    }

    public static void clearCallHistory() throws SkypeException {
        Utils.executeWithErrorCheck("CLEAR CALLHISTORY ALL");
    }

    public static void clearChatHistory() throws SkypeException {
        Utils.executeWithErrorCheck("CLEAR CHATHISTORY");
    }

    public static void clearVoiceMailHistory() throws SkypeException {
        Utils.executeWithErrorCheck("CLEAR VOICEMAILHISTORY");
    }

    public static User getUser(String id) {
        return User.getInstance(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addChatMessageListener(ChatMessageListener listener) throws SkypeException {
        Utils.checkNotNull("listener", listener);
        Object object = chatMessageListenerMutex;
        synchronized (object) {
            chatMessageListeners.add(listener);
            if (chatMessageListener == null) {
                chatMessageListener = new AbstractConnectorListener(){

                    @Override
                    public void messageReceived(ConnectorMessageEvent event) {
                        block10: {
                            String message = event.getMessage();
                            if (!message.startsWith("CHATMESSAGE ")) break block10;
                            String data = message.substring("CHATMESSAGE ".length());
                            String id = data.substring(0, data.indexOf(32));
                            String propertyNameAndValue = data.substring(data.indexOf(32) + 1);
                            String propertyName = propertyNameAndValue.substring(0, propertyNameAndValue.indexOf(32));
                            if ("STATUS".equals(propertyName)) {
                                String propertyValue = propertyNameAndValue.substring(propertyNameAndValue.indexOf(32) + 1);
                                ChatMessageListener[] listeners = chatMessageListeners.toArray(new ChatMessageListener[0]);
                                ChatMessage chatMessage = ChatMessage.getInstance(id);
                                if ("SENT".equals(propertyValue)) {
                                    for (ChatMessageListener listener : listeners) {
                                        try {
                                            listener.chatMessageSent(chatMessage);
                                        }
                                        catch (Throwable e) {
                                            Skype.handleUncaughtException(e);
                                        }
                                    }
                                } else if ("RECEIVED".equals(propertyValue)) {
                                    for (ChatMessageListener listener : listeners) {
                                        try {
                                            listener.chatMessageReceived(chatMessage);
                                        }
                                        catch (Throwable e) {
                                            Skype.handleUncaughtException(e);
                                        }
                                    }
                                }
                            }
                        }
                    }
                };
                try {
                    Connector.getInstance().addConnectorListener(chatMessageListener);
                }
                catch (ConnectorException e) {
                    Utils.convertToSkypeException(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeChatMessageListener(ChatMessageListener listener) {
        Utils.checkNotNull("listener", listener);
        Object object = chatMessageListenerMutex;
        synchronized (object) {
            chatMessageListeners.remove(listener);
            if (chatMessageListeners.isEmpty()) {
                Connector.getInstance().removeConnectorListener(chatMessageListener);
                chatMessageListener = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addCallListener(CallListener listener) throws SkypeException {
        Utils.checkNotNull("listener", listener);
        Object object = callListenerMutex;
        synchronized (object) {
            callListeners.add(listener);
            if (callListener == null) {
                callListener = new AbstractConnectorListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void messageReceived(ConnectorMessageEvent event) {
                        String message = event.getMessage();
                        if (message.startsWith("CALL ")) {
                            String data = message.substring("CALL ".length());
                            String id = data.substring(0, data.indexOf(32));
                            String propertyNameAndValue = data.substring(data.indexOf(32) + 1);
                            String propertyName = propertyNameAndValue.substring(0, propertyNameAndValue.indexOf(32));
                            if ("STATUS".equals(propertyName)) {
                                Call call;
                                Call.Status status;
                                block19: {
                                    String propertyValue = propertyNameAndValue.substring(propertyNameAndValue.indexOf(32) + 1);
                                    status = Call.Status.valueOf(propertyValue);
                                    call = Call.getInstance(id);
                                    if (status == Call.Status.ROUTING || status == Call.Status.RINGING) {
                                        Call call2 = call;
                                        synchronized (call2) {
                                            if (call.isCallListenerEventFired()) {
                                                break block19;
                                            }
                                            call.setCallListenerEventFired(true);
                                            CallListener[] listeners = callListeners.toArray(new CallListener[0]);
                                            try {
                                                switch (call.getType()) {
                                                    case OUTGOING_P2P: 
                                                    case OUTGOING_PSTN: {
                                                        for (CallListener listener : listeners) {
                                                            try {
                                                                listener.callMaked(call);
                                                            }
                                                            catch (Throwable e) {
                                                                Skype.handleUncaughtException(e);
                                                            }
                                                        }
                                                        break;
                                                    }
                                                    case INCOMING_P2P: 
                                                    case INCOMING_PSTN: {
                                                        for (CallListener listener : listeners) {
                                                            try {
                                                                listener.callReceived(call);
                                                            }
                                                            catch (Throwable e) {
                                                                Skype.handleUncaughtException(e);
                                                            }
                                                        }
                                                        break;
                                                    }
                                                }
                                            }
                                            catch (Throwable e) {
                                                Skype.handleUncaughtException(e);
                                            }
                                        }
                                    }
                                }
                                call.fireStatusChanged(status);
                            }
                        }
                    }
                };
                try {
                    Connector.getInstance().addConnectorListener(callListener);
                }
                catch (ConnectorException e) {
                    Utils.convertToSkypeException(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeCallListener(CallListener listener) {
        Utils.checkNotNull("listener", listener);
        Object object = callListenerMutex;
        synchronized (object) {
            callListeners.remove(listener);
            if (callListeners.isEmpty()) {
                Connector.getInstance().removeConnectorListener(callListener);
                callListener = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addVoiceMailListener(VoiceMailListener listener) throws SkypeException {
        Utils.checkNotNull("listener", listener);
        Object object = voiceMailListenerMutex;
        synchronized (object) {
            voiceMailListeners.add(listener);
            if (voiceMailListener == null) {
                voiceMailListener = new AbstractConnectorListener(){

                    @Override
                    public void messageReceived(ConnectorMessageEvent event) {
                        String message = event.getMessage();
                        if (message.startsWith("VOICEMAIL ")) {
                            String data = message.substring("VOICEMAIL ".length());
                            String id = data.substring(0, data.indexOf(32));
                            String propertyNameAndValue = data.substring(data.indexOf(32) + 1);
                            String propertyName = propertyNameAndValue.substring(0, propertyNameAndValue.indexOf(32));
                            if ("TYPE".equals(propertyName)) {
                                String propertyValue = propertyNameAndValue.substring(propertyNameAndValue.indexOf(32) + 1);
                                VoiceMail.Type type = VoiceMail.Type.valueOf(propertyValue);
                                VoiceMail voiceMail = VoiceMail.getInstance(id);
                                VoiceMailListener[] listeners = voiceMailListeners.toArray(new VoiceMailListener[0]);
                                switch (type) {
                                    case OUTGOING: {
                                        for (VoiceMailListener listener : listeners) {
                                            try {
                                                listener.voiceMailMade(voiceMail);
                                            }
                                            catch (Throwable e) {
                                                Skype.handleUncaughtException(e);
                                            }
                                        }
                                        break;
                                    }
                                    case INCOMING: {
                                        for (VoiceMailListener listener : listeners) {
                                            try {
                                                listener.voiceMailReceived(voiceMail);
                                            }
                                            catch (Throwable e) {
                                                Skype.handleUncaughtException(e);
                                            }
                                        }
                                        break;
                                    }
                                }
                            }
                        }
                    }
                };
                try {
                    Connector.getInstance().addConnectorListener(voiceMailListener);
                }
                catch (ConnectorException e) {
                    Utils.convertToSkypeException(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeVoiceMailListener(VoiceMailListener listener) {
        Utils.checkNotNull("listener", listener);
        Object object = voiceMailListenerMutex;
        synchronized (object) {
            voiceMailListeners.remove(listener);
            if (voiceMailListeners.isEmpty()) {
                Connector.getInstance().removeConnectorListener(voiceMailListener);
                voiceMailListener = null;
            }
        }
    }

    public static void setSkypeExceptionHandler(SkypeExceptionHandler handler) {
        if (handler == null) {
            handler = defaultExceptionHandler;
        }
        exceptionHandler = handler;
    }

    static void handleUncaughtException(Throwable e) {
        exceptionHandler.uncaughtExceptionHappened(e);
    }

    private Skype() {
    }

    static {
        chatMessageListenerMutex = new Object();
        chatMessageListeners = new CopyOnWriteArrayList<ChatMessageListener>();
        callListenerMutex = new Object();
        callListeners = new CopyOnWriteArrayList<CallListener>();
        voiceMailListenerMutex = new Object();
        voiceMailListeners = new CopyOnWriteArrayList<VoiceMailListener>();
        userThreadFieldMutex = new Object();
        exceptionHandler = defaultExceptionHandler = new SkypeExceptionHandler(){

            @Override
            public void uncaughtExceptionHappened(Throwable e) {
                e.printStackTrace();
            }
        };
    }
}

