/*
 * Decompiled with CFR 0.152.
 */
package com.skype;

import com.skype.SkypeException;
import com.skype.SkypeExceptionHandler;
import com.skype.SkypeObject;
import com.skype.User;
import com.skype.Utils;
import com.skype.VoiceMailStatusChangedListener;
import com.skype.connector.AbstractConnectorListener;
import com.skype.connector.Connector;
import com.skype.connector.ConnectorException;
import com.skype.connector.ConnectorListener;
import com.skype.connector.ConnectorMessageEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class VoiceMail
extends SkypeObject {
    private static final Map<String, VoiceMail> voiceMails = new HashMap<String, VoiceMail>();
    private static final Object voiceMailStatusChangedListenerFieldMutex = new Object();
    private static ConnectorListener voiceMailStatusChangedListener;
    private final String id;
    private final List<VoiceMailStatusChangedListener> listeners = Collections.synchronizedList(new ArrayList());
    private Status oldStatus;
    private SkypeExceptionHandler exceptionHandler;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static VoiceMail getInstance(String id) {
        Map<String, VoiceMail> map = voiceMails;
        synchronized (map) {
            if (!voiceMails.containsKey(id)) {
                voiceMails.put(id, new VoiceMail(id));
            }
            return voiceMails.get(id);
        }
    }

    private VoiceMail(String newId) {
        this.id = newId;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object compared) {
        if (compared instanceof VoiceMail) {
            return this.id.equals(((VoiceMail)compared).id);
        }
        return false;
    }

    public String getId() {
        return this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addVoiceMailStatusChangedListener(VoiceMailStatusChangedListener listener) throws SkypeException {
        Utils.checkNotNull("listener", listener);
        Object object = voiceMailStatusChangedListenerFieldMutex;
        synchronized (object) {
            this.listeners.add(listener);
            if (voiceMailStatusChangedListener == null) {
                voiceMailStatusChangedListener = new AbstractConnectorListener(){

                    @Override
                    public void messageReceived(ConnectorMessageEvent event) {
                        String message = event.getMessage();
                        if (message.startsWith("VOICEMAIL ")) {
                            String data = message.substring("VOICEMAIL ".length());
                            String id = data.substring(0, data.indexOf(32));
                            String propertyNameAndValue = data.substring(data.indexOf(32) + 1);
                            String propertyName = propertyNameAndValue.substring(0, propertyNameAndValue.indexOf(32));
                            if ("STATUS".equals(propertyName)) {
                                VoiceMail voiceMail = VoiceMail.getInstance(id);
                                String propertyValue = propertyNameAndValue.substring(propertyNameAndValue.indexOf(32) + 1);
                                Status status = Status.valueOf(propertyValue);
                                voiceMail.fireStatusChanged(status);
                            }
                        }
                    }
                };
                try {
                    Connector.getInstance().addConnectorListener(voiceMailStatusChangedListener);
                }
                catch (ConnectorException e) {
                    Utils.convertToSkypeException(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeVoiceMailStatusChangedListener(VoiceMailStatusChangedListener listener) {
        Utils.checkNotNull("listener", listener);
        Object object = voiceMailStatusChangedListenerFieldMutex;
        synchronized (object) {
            this.listeners.remove(listener);
            if (this.listeners.isEmpty()) {
                Connector.getInstance().removeConnectorListener(voiceMailStatusChangedListener);
                voiceMailStatusChangedListener = null;
            }
        }
    }

    private void fireStatusChanged(Status status) {
        VoiceMailStatusChangedListener[] listeners = this.listeners.toArray(new VoiceMailStatusChangedListener[0]);
        if (status == this.oldStatus) {
            return;
        }
        this.oldStatus = status;
        for (VoiceMailStatusChangedListener listener : listeners) {
            try {
                listener.statusChanged(status);
            }
            catch (Throwable e) {
                Utils.handleUncaughtException(e, this.exceptionHandler);
            }
        }
    }

    public Type getType() throws SkypeException {
        return Type.valueOf(Utils.getPropertyWithCommandId("VOICEMAIL", this.getId(), "TYPE"));
    }

    public User getPartner() throws SkypeException {
        return User.getInstance(this.getPartnerId());
    }

    public String getPartnerId() throws SkypeException {
        return this.getProperty("PARTNER_HANDLE");
    }

    public String getPartnerDisplayName() throws SkypeException {
        return this.getProperty("PARTNER_DISPNAME");
    }

    public Status getStatus() throws SkypeException {
        return Status.valueOf(Utils.getPropertyWithCommandId("VOICEMAIL", this.getId(), "STATUS"));
    }

    public FailureReason getFailureReason() throws SkypeException {
        return FailureReason.valueOf(this.getProperty("FAILUREREASON"));
    }

    public Date getStartTime() throws SkypeException {
        return Utils.parseUnixTime(this.getProperty("TIMESTAMP"));
    }

    public int getDuration() throws SkypeException {
        return Integer.parseInt(this.getProperty("DURATION"));
    }

    public int getAllowedDuration() throws SkypeException {
        return Integer.parseInt(this.getProperty("ALLOWED_DURATION"));
    }

    private String getProperty(String name) throws SkypeException {
        return Utils.getProperty("VOICEMAIL", this.getId(), name);
    }

    public void startPlayback() throws SkypeException {
        Utils.executeWithErrorCheck("ALTER VOICEMAIL " + this.getId() + " " + "STARTPLAYBACK");
    }

    public void stopPlayback() throws SkypeException {
        Utils.executeWithErrorCheck("ALTER VOICEMAIL " + this.getId() + " " + "STOPPLAYBACK");
    }

    public void upload() throws SkypeException {
        Utils.executeWithErrorCheck("ALTER VOICEMAIL " + this.getId() + " " + "UPLOAD");
    }

    public void download() throws SkypeException {
        Utils.executeWithErrorCheck("ALTER VOICEMAIL " + this.getId() + " " + "DOWNLOAD");
    }

    public void startRecording() throws SkypeException {
        Utils.executeWithErrorCheck("ALTER VOICEMAIL " + this.getId() + " " + "STARTRECORDING");
    }

    public void stopRecording() throws SkypeException {
        Utils.executeWithErrorCheck("ALTER VOICEMAIL " + this.getId() + " " + "STOPRECORDING");
    }

    public void dispose() throws SkypeException {
        Utils.executeWithErrorCheck("ALTER VOICEMAIL " + this.getId() + " " + "DELETE");
    }

    public void openAndStartPlayback() throws SkypeException {
        Utils.executeWithErrorCheck("OPEN VOICEMAIL " + this.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForFinishing() throws SkypeException {
        if (this.getType() != Type.OUTGOING) {
            throw new IllegalStateException("The type must be outgoing.");
        }
        final Object wait = new Object();
        VoiceMailStatusChangedListener listener = new VoiceMailStatusChangedListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void statusChanged(Status status) throws SkypeException {
                Object object = wait;
                synchronized (object) {
                    switch (status) {
                        case UPLOADED: 
                        case UNKNOWN: 
                        case FAILED: {
                            wait.notify();
                        }
                    }
                }
            }
        };
        Object object = wait;
        synchronized (object) {
            switch (this.getStatus()) {
                case UPLOADED: 
                case UNKNOWN: 
                case FAILED: {
                    break;
                }
                default: {
                    this.addVoiceMailStatusChangedListener(listener);
                    try {
                        wait.wait();
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    this.removeVoiceMailStatusChangedListener(listener);
                }
            }
        }
    }

    public static enum FailureReason {
        MISC_ERROR,
        CONNECT_ERROR,
        NO_VOICEMAIL_PRIVILEGE,
        NO_SUCH_VOICEMAIL,
        FILE_READ_ERROR,
        FILE_WRITE_ERROR,
        RECORDING_ERROR,
        PLAYBACK_ERROR,
        UNKNOWN;

    }

    public static enum Status {
        NOTDOWNLOADED,
        DOWNLOADING,
        UNPLAYED,
        BUFFERING,
        PLAYING,
        PLAYED,
        BLANK,
        RECORDING,
        RECORDED,
        UPLOADING,
        UPLOADED,
        DELETING,
        FAILED,
        UNKNOWN;

    }

    public static enum Type {
        INCOMING,
        OUTGOING,
        DEFAULT_GREETING,
        CUSTOM_GREETING,
        UNKNOWN;

    }
}

