/*
 * Decompiled with CFR 0.152.
 */
package com.skype;

import com.skype.Application;
import com.skype.Call;
import com.skype.CallListener;
import com.skype.Chat;
import com.skype.ChatListenerMananager;
import com.skype.ChatMessageConnectorListener;
import com.skype.ChatMessageEditConnectorListener;
import com.skype.ChatMessageEditListener;
import com.skype.ChatMessageListener;
import com.skype.ConnectorListenerImpl;
import com.skype.ContactList;
import com.skype.GlobalChatListener;
import com.skype.Profile;
import com.skype.SMS;
import com.skype.SkypeException;
import com.skype.SkypeExceptionHandler;
import com.skype.User;
import com.skype.Utils;
import com.skype.VoiceMail;
import com.skype.VoiceMailConnectorListener;
import com.skype.VoiceMailListener;
import com.skype.connector.Connector;
import com.skype.connector.ConnectorException;
import com.skype.connector.ConnectorListener;
import java.io.File;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public final class Skype {
    public static final String LIBRARY_VERSION = "1.0.0.0";
    private static ContactList contactList;
    private static Profile profile;
    private static Object chatMessageListenerMutex;
    private static Object chatMessageEditListenerMutext;
    private static ChatMessageConnectorListener chatMessageListener;
    static List<ChatMessageListener> chatMessageListeners;
    private static Object callListenerMutex;
    private static ConnectorListener callListener;
    static List<CallListener> callListeners;
    private static Object voiceMailListenerMutex;
    private static ConnectorListener voiceMailListener;
    static List<VoiceMailListener> voiceMailListeners;
    private static Object userThreadFieldMutex;
    private static Thread userThread;
    private static SkypeExceptionHandler defaultExceptionHandler;
    private static SkypeExceptionHandler exceptionHandler;
    private static ChatMessageEditConnectorListener chatMessageEditConnectorListener;
    static Object chatListenerManagerMutex;
    static ChatListenerMananager chatListenerManager;
    static Connector replacementConnectorInstance;
    public static boolean isDebuggingNativeLib;

    @Deprecated
    public static void setDeamon(boolean on) {
        Skype.setDaemon(on);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDaemon(boolean on) {
        Object object = userThreadFieldMutex;
        synchronized (object) {
            if (!on && userThread == null) {
                userThread = new Thread("SkypeUserThread"){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Object wait;
                        Object object = wait = new Object();
                        synchronized (object) {
                            try {
                                wait.wait();
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                    }
                };
                userThread.start();
            } else if (on && userThread != null) {
                userThread.interrupt();
                userThread = null;
            }
        }
    }

    public static void setDebug(boolean on) throws SkypeException {
        try {
            Skype.getConnectorInstance().setDebug(on);
        }
        catch (ConnectorException e) {
            Utils.convertToSkypeException(e);
        }
    }

    public static String getVersion() throws SkypeException {
        return Utils.getProperty("SKYPEVERSION");
    }

    public static boolean isInstalled() {
        String path = Skype.getInstalledPath();
        if (path == null) {
            return false;
        }
        return new File(path).exists();
    }

    public static String getInstalledPath() {
        return Skype.getConnectorInstance().getInstalledPath();
    }

    public static boolean isRunning() throws SkypeException {
        try {
            return Skype.getConnectorInstance().isRunning();
        }
        catch (ConnectorException e) {
            Utils.convertToSkypeException(e);
            return false;
        }
    }

    public static User[] searchUsers(String keyword) throws SkypeException {
        String response;
        String command = "SEARCH USERS " + keyword;
        String responseHeader = "USERS ";
        try {
            response = Skype.getConnectorInstance().executeWithId(command, responseHeader);
        }
        catch (ConnectorException ex) {
            Utils.convertToSkypeException(ex);
            return null;
        }
        Utils.checkError(response);
        String data = response.substring(responseHeader.length());
        String[] ids = Utils.convertToArray(data);
        User[] users = new User[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            users[i] = User.getInstance(ids[i]);
        }
        return users;
    }

    public static ContactList getContactList() throws SkypeException {
        if (contactList == null) {
            contactList = new ContactList();
        }
        return contactList;
    }

    public static Call call(String ... skypeIds) throws SkypeException {
        Utils.checkNotNull("skypeIds", skypeIds);
        return Skype.call(Utils.convertToCommaSeparatedString(skypeIds));
    }

    public static Call call(String skypeId) throws SkypeException {
        Utils.checkNotNull("skypeIds", skypeId);
        try {
            String responseHeader = "CALL ";
            String response = Skype.getConnectorInstance().executeWithId("CALL " + skypeId, responseHeader);
            Utils.checkError(response);
            String id = response.substring(responseHeader.length(), response.indexOf(" STATUS "));
            return Call.getInstance(id);
        }
        catch (ConnectorException e) {
            Utils.convertToSkypeException(e);
            return null;
        }
    }

    public static Chat chat(String[] skypeIds) throws SkypeException {
        Utils.checkNotNull("skypeIds", skypeIds);
        return Skype.chat(Utils.convertToCommaSeparatedString(skypeIds));
    }

    public static Chat chat(String skypeId) throws SkypeException {
        try {
            String responseHeader = "CHAT ";
            String response = Skype.getConnectorInstance().executeWithId("CHAT CREATE " + skypeId, responseHeader);
            Utils.checkError(response);
            String id = response.substring(responseHeader.length(), response.indexOf(" STATUS "));
            return Chat.getInstance(id);
        }
        catch (ConnectorException e) {
            Utils.convertToSkypeException(e);
            return null;
        }
    }

    public static SMS submitConfirmationCode(String[] numbers) throws SkypeException {
        Utils.checkNotNull("numbers", numbers);
        return Skype.submitConfirmationCode(Utils.convertToCommaSeparatedString(numbers));
    }

    public static SMS submitConfirmationCode(String number) throws SkypeException {
        SMS message = Skype.createSMS(number, SMS.Type.CONFIRMATION_CODE_REQUEST);
        message.send();
        return message;
    }

    public static SMS submitConfirmationCode(String[] numbers, String code) throws SkypeException {
        Utils.checkNotNull("numbers", numbers);
        Utils.checkNotNull("code", code);
        return Skype.submitConfirmationCode(Utils.convertToCommaSeparatedString(numbers), code);
    }

    public static SMS submitConfirmationCode(String number, String code) throws SkypeException {
        Utils.checkNotNull("number", number);
        Utils.checkNotNull("code", code);
        SMS message = Skype.createSMS(number, SMS.Type.CONFIRMATION_CODE_REQUEST);
        message.setContent(code);
        message.send();
        return message;
    }

    public static SMS sendSMS(String[] numbers, String content) throws SkypeException {
        Utils.checkNotNull("numbers", numbers);
        return Skype.sendSMS(Utils.convertToCommaSeparatedString(numbers), content);
    }

    public static SMS sendSMS(String number, String content) throws SkypeException {
        Utils.checkNotNull("number", number);
        Utils.checkNotNull("content", content);
        SMS message = Skype.createSMS(number, SMS.Type.OUTGOING);
        message.setContent(content);
        message.send();
        return message;
    }

    private static SMS createSMS(String number, SMS.Type type) throws SkypeException {
        try {
            String responseHeader = "SMS ";
            String response = Skype.getConnectorInstance().executeWithId("CREATE SMS " + (Object)((Object)type) + " " + number, responseHeader);
            Utils.checkError(response);
            String id = response.substring(responseHeader.length(), response.indexOf(" STATUS "));
            return SMS.getInstance(id);
        }
        catch (ConnectorException e) {
            Utils.convertToSkypeException(e);
            return null;
        }
    }

    public SMS[] getAllSMSs() throws SkypeException {
        return this.getAllSMSs("SMSS");
    }

    public SMS[] getAllMissedSMSs() throws SkypeException {
        return this.getAllSMSs("MISSEDSMSS");
    }

    private SMS[] getAllSMSs(String type) throws SkypeException {
        try {
            String command = "SEARCH " + type;
            String responseHeader = "SMSS ";
            String response = Skype.getConnectorInstance().execute(command, responseHeader);
            String data = response.substring(responseHeader.length());
            String[] ids = Utils.convertToArray(data);
            SMS[] smss = new SMS[ids.length];
            for (int i = 0; i < ids.length; ++i) {
                smss[i] = SMS.getInstance(ids[i]);
            }
            return smss;
        }
        catch (ConnectorException e) {
            Utils.convertToSkypeException(e);
            return null;
        }
    }

    public static VoiceMail voiceMail(String skypeId) throws SkypeException {
        try {
            String responseHeader = "VOICEMAIL ";
            String response = Skype.getConnectorInstance().executeWithId("VOICEMAIL " + skypeId, responseHeader);
            Utils.checkError(response);
            String id = response.substring(responseHeader.length(), response.indexOf(32, responseHeader.length()));
            return VoiceMail.getInstance(id);
        }
        catch (ConnectorException e) {
            Utils.convertToSkypeException(e);
            return null;
        }
    }

    public static VoiceMail[] getAllVoiceMails() throws SkypeException {
        try {
            String command = "SEARCH VOICEMAILS";
            String responseHeader = "VOICEMAILS ";
            String response = Skype.getConnectorInstance().execute(command, responseHeader);
            String data = response.substring(responseHeader.length());
            String[] ids = Utils.convertToArray(data);
            VoiceMail[] voiceMails = new VoiceMail[ids.length];
            for (int i = 0; i < ids.length; ++i) {
                voiceMails[i] = VoiceMail.getInstance(ids[i]);
            }
            return voiceMails;
        }
        catch (ConnectorException ex) {
            Utils.convertToSkypeException(ex);
            return null;
        }
    }

    public static Application addApplication(String name) throws SkypeException {
        Utils.checkNotNull("name", name);
        return Application.getInstance(name);
    }

    public static String getAudioInputDevice() throws SkypeException {
        return Skype.convertDefaultDeviceToNull(Utils.getProperty("AUDIO_IN"));
    }

    public static String getAudioOutputDevice() throws SkypeException {
        return Skype.convertDefaultDeviceToNull(Utils.getProperty("AUDIO_OUT"));
    }

    public static String getVideoDevice() throws SkypeException {
        return Skype.convertDefaultDeviceToNull(Utils.getProperty("VIDEO_IN"));
    }

    private static String convertDefaultDeviceToNull(String deviceName) {
        if (Skype.isDefaultDevice(deviceName)) {
            return null;
        }
        return deviceName;
    }

    private static boolean isDefaultDevice(String deviceName) {
        return "".equals(deviceName);
    }

    public static void setAudioInputDevice(String deviceName) throws SkypeException {
        Utils.setProperty("AUDIO_IN", Skype.convertNullToDefaultDevice(deviceName));
    }

    public static void setAudioOutputDevice(String deviceName) throws SkypeException {
        Utils.setProperty("AUDIO_OUT", Skype.convertNullToDefaultDevice(deviceName));
    }

    public static void setVideoDevice(String deviceName) throws SkypeException {
        Utils.setProperty("VIDEO_IN", Skype.convertNullToDefaultDevice(deviceName));
    }

    private static String convertNullToDefaultDevice(String deviceName) {
        if (deviceName == null) {
            return "";
        }
        return deviceName;
    }

    public static synchronized Profile getProfile() {
        if (profile == null) {
            profile = new Profile();
        }
        return profile;
    }

    public static Call[] getAllActiveCalls() throws SkypeException {
        try {
            String command = "SEARCH ACTIVECALLS";
            String responseHeader = "CALLS ";
            String response = Skype.getConnectorInstance().execute(command, responseHeader);
            String data = response.substring(responseHeader.length());
            String[] ids = Utils.convertToArray(data);
            Call[] calls = new Call[ids.length];
            for (int i = 0; i < ids.length; ++i) {
                calls[i] = Call.getInstance(ids[i]);
            }
            return calls;
        }
        catch (ConnectorException ex) {
            Utils.convertToSkypeException(ex);
            return null;
        }
    }

    public static Chat[] getAllChats() throws SkypeException {
        return Skype.getAllChats("CHATS");
    }

    public static Chat[] getAllActiveChats() throws SkypeException {
        return Skype.getAllChats("ACTIVECHATS");
    }

    public static Chat[] getAllMissedChats() throws SkypeException {
        return Skype.getAllChats("MISSEDCHATS");
    }

    public static Chat[] getAllRecentChats() throws SkypeException {
        return Skype.getAllChats("RECENTCHATS");
    }

    public static Chat[] getAllBookmarkedChats() throws SkypeException {
        return Skype.getAllChats("BOOKMARKEDCHATS");
    }

    private static Chat[] getAllChats(String type) throws SkypeException {
        try {
            String command = "SEARCH " + type;
            String responseHeader = "CHATS ";
            String response = Skype.getConnectorInstance().execute(command, responseHeader);
            String data = response.substring(responseHeader.length());
            String[] ids = Utils.convertToArray(data);
            Chat[] chats = new Chat[ids.length];
            for (int i = 0; i < ids.length; ++i) {
                chats[i] = Chat.getInstance(ids[i]);
            }
            return chats;
        }
        catch (ConnectorException ex) {
            Utils.convertToSkypeException(ex);
            return null;
        }
    }

    public static void clearCallHistory() throws SkypeException {
        Utils.executeWithErrorCheck("CLEAR CALLHISTORY ALL");
    }

    public static void clearChatHistory() throws SkypeException {
        Utils.executeWithErrorCheck("CLEAR CHATHISTORY");
    }

    public static void clearVoiceMailHistory() throws SkypeException {
        Utils.executeWithErrorCheck("CLEAR VOICEMAILHISTORY");
    }

    public static User getUser(String id) {
        return User.getInstance(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addChatMessageListener(ChatMessageListener listener) throws SkypeException {
        Utils.checkNotNull("listener", listener);
        Object object = chatMessageListenerMutex;
        synchronized (object) {
            chatMessageListeners.add(listener);
            if (chatMessageListener == null) {
                chatMessageListener = new ChatMessageConnectorListener();
                try {
                    Skype.getConnectorInstance().addConnectorListener(chatMessageListener);
                }
                catch (ConnectorException e) {
                    Utils.convertToSkypeException(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeChatMessageListener(ChatMessageListener listener) {
        Utils.checkNotNull("listener", listener);
        Object object = chatMessageListenerMutex;
        synchronized (object) {
            chatMessageListeners.remove(listener);
            if (chatMessageListeners.isEmpty()) {
                Skype.getConnectorInstance().removeConnectorListener(chatMessageListener);
                chatMessageListener = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addChatMessageEditListener(ChatMessageEditListener listener) throws SkypeException {
        Utils.checkNotNull("listener", listener);
        Object object = chatMessageEditListenerMutext;
        synchronized (object) {
            if (chatMessageEditConnectorListener == null) {
                chatMessageEditConnectorListener = new ChatMessageEditConnectorListener();
                try {
                    Skype.getConnectorInstance().addConnectorListener(chatMessageEditConnectorListener);
                }
                catch (ConnectorException e) {
                    Utils.convertToSkypeException(e);
                }
            }
            chatMessageEditConnectorListener.addListener(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeChatMessageEditListener(ChatMessageEditListener listener) throws SkypeException {
        Utils.checkNotNull("listener", listener);
        Object object = chatMessageEditListenerMutext;
        synchronized (object) {
            if (chatMessageEditConnectorListener != null) {
                chatMessageEditConnectorListener.removeListener(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addCallListener(CallListener listener) throws SkypeException {
        Utils.checkNotNull("listener", listener);
        Object object = callListenerMutex;
        synchronized (object) {
            boolean success = false;
            try {
                callListeners.add(listener);
                if (callListener == null) {
                    callListener = new ConnectorListenerImpl();
                    try {
                        Skype.getConnectorInstance().addConnectorListener(callListener);
                    }
                    catch (ConnectorException e) {
                        Utils.convertToSkypeException(e);
                    }
                }
                success = true;
            }
            finally {
                if (!success) {
                    callListeners.remove(listener);
                }
            }
        }
    }

    public static boolean isCallListenerRegistered(CallListener listener) {
        return callListeners.contains(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeCallListener(CallListener listener) {
        Utils.checkNotNull("listener", listener);
        Object object = callListenerMutex;
        synchronized (object) {
            callListeners.remove(listener);
            if (callListeners.isEmpty()) {
                if (callListener != null) {
                    Skype.getConnectorInstance().removeConnectorListener(callListener);
                }
                callListener = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addVoiceMailListener(VoiceMailListener listener) throws SkypeException {
        Utils.checkNotNull("listener", listener);
        Object object = voiceMailListenerMutex;
        synchronized (object) {
            voiceMailListeners.add(listener);
            if (voiceMailListener == null) {
                voiceMailListener = new VoiceMailConnectorListener();
                try {
                    Skype.getConnectorInstance().addConnectorListener(voiceMailListener);
                }
                catch (ConnectorException e) {
                    Utils.convertToSkypeException(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeVoiceMailListener(VoiceMailListener listener) {
        Utils.checkNotNull("listener", listener);
        Object object = voiceMailListenerMutex;
        synchronized (object) {
            voiceMailListeners.remove(listener);
            if (voiceMailListeners.isEmpty()) {
                Skype.getConnectorInstance().removeConnectorListener(voiceMailListener);
                voiceMailListener = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addGlobalChatListener(GlobalChatListener listener) throws SkypeException {
        Object object = chatListenerManagerMutex;
        synchronized (object) {
            if (chatListenerManager == null) {
                chatListenerManager = new ChatListenerMananager();
                Skype.addChatMessageListener(chatListenerManager);
            }
            chatListenerManager.addGlobalChatListener(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeGlobalChatListener(GlobalChatListener listener) {
        ChatListenerMananager chatListenerMananager = chatListenerManager;
        synchronized (chatListenerMananager) {
            if (chatListenerManager == null) {
                return;
            }
            chatListenerManager.addGlobalChatListener(listener);
        }
    }

    static void addGlobalChatListener(GlobalChatListener listener, Chat chat) throws SkypeException {
        Skype.addGlobalChatListener(listener);
    }

    public static void setSkypeExceptionHandler(SkypeExceptionHandler handler) {
        if (handler == null) {
            handler = defaultExceptionHandler;
        }
        exceptionHandler = handler;
    }

    static void handleUncaughtException(Throwable e) {
        exceptionHandler.uncaughtExceptionHappened(e);
    }

    static void setReplacementConnectorInstance(Connector connector) {
        replacementConnectorInstance = connector;
    }

    private static Connector getConnectorInstance() {
        if (replacementConnectorInstance == null) {
            return Connector.getInstance();
        }
        return replacementConnectorInstance;
    }

    private Skype() {
    }

    public static void setDebugNative(boolean b) {
        isDebuggingNativeLib = b;
    }

    static {
        chatMessageListenerMutex = new Object();
        chatMessageEditListenerMutext = new Object();
        chatMessageListeners = new CopyOnWriteArrayList<ChatMessageListener>();
        callListenerMutex = new Object();
        callListeners = new CopyOnWriteArrayList<CallListener>();
        voiceMailListenerMutex = new Object();
        voiceMailListeners = new CopyOnWriteArrayList<VoiceMailListener>();
        userThreadFieldMutex = new Object();
        exceptionHandler = defaultExceptionHandler = new SkypeExceptionHandler(){

            @Override
            public void uncaughtExceptionHappened(Throwable e) {
                e.printStackTrace();
            }
        };
        chatListenerManagerMutex = new Object();
        chatListenerManager = null;
        replacementConnectorInstance = null;
    }
}

