/*
 * Decompiled with CFR 0.152.
 */
package com.skype;

import com.skype.EventMessage;
import com.skype.MenuItem;
import com.skype.SkypeException;
import com.skype.Utils;
import com.skype.connector.Connector;
import com.skype.connector.ConnectorException;
import java.io.File;

public final class SkypeClient {
    private SkypeClient() {
    }

    public static void showSkypeWindow() throws SkypeException {
        Utils.executeWithErrorCheck("FOCUS");
    }

    public static void hideSkypeWindow() throws SkypeException {
        Utils.executeWithErrorCheck("MINIMIZE");
    }

    public static void showAddFriendWindow() throws SkypeException {
        Utils.executeWithErrorCheck("OPEN ADDAFRIEND");
    }

    public static void showAddFriendWindow(String skypeId) throws SkypeException {
        Utils.checkNotNull("skypeId", skypeId);
        Utils.executeWithErrorCheck("OPEN ADDAFRIEND " + skypeId);
    }

    public static void showChatWindow(String skypeId) throws SkypeException {
        Utils.checkNotNull("skypeId", skypeId);
        Utils.executeWithErrorCheck("OPEN IM " + skypeId);
    }

    public static void showChatWindow(String skypeId, String message) throws SkypeException {
        Utils.checkNotNull("skypeId", skypeId);
        Utils.checkNotNull("message", message);
        Utils.executeWithErrorCheck("OPEN IM " + skypeId + " " + message);
    }

    public static void showFileTransferWindow(String skypeId) throws SkypeException {
        Utils.checkNotNull("skypeId", skypeId);
        Utils.executeWithErrorCheck("OPEN FILETRANSFER " + skypeId);
    }

    public static void showFileTransferWindow(String skypeId, File folder) throws SkypeException {
        Utils.checkNotNull("skypeId", skypeId);
        Utils.checkNotNull("folder", folder);
        Utils.executeWithErrorCheck("OPEN FILETRANSFER " + skypeId + " IN " + folder, "OK");
    }

    public static void showFileTransferWindow(String[] skypeIds) throws SkypeException {
        Utils.checkNotNull("skypeIds", skypeIds);
        Utils.executeWithErrorCheck("OPEN FILETRANSFER " + Utils.convertToCommaSeparatedString(skypeIds));
    }

    public static void showFileTransferWindow(String[] skypeIds, File folder) throws SkypeException {
        Utils.checkNotNull("skypeIds", skypeIds);
        Utils.checkNotNull("folder", folder);
        Utils.executeWithErrorCheck("OPEN FILETRANSFER " + Utils.convertToCommaSeparatedString(skypeIds) + " IN " + folder);
    }

    public static void showProfileWindow() throws SkypeException {
        Utils.executeWithErrorCheck("OPEN PROFILE");
    }

    public static void showUserInformationWindow(String skypeId) throws SkypeException {
        Utils.checkNotNull("skypeId", skypeId);
        Utils.executeWithErrorCheck("OPEN USERINFO " + skypeId);
    }

    public static void showConferenceWindow() throws SkypeException {
        Utils.executeWithErrorCheck("OPEN CONFERENCE");
    }

    public static void showSearchWindow() throws SkypeException {
        Utils.executeWithErrorCheck("OPEN SEARCH");
    }

    public static void showOptionsWindow(OptionsPage page) throws SkypeException {
        Utils.executeWithErrorCheck("OPEN OPTIONS " + page.toString().toLowerCase());
    }

    public static void showCallHistoryTab() throws SkypeException {
        Utils.executeWithErrorCheck("OPEN CALLHISTORY");
    }

    public static void showContactsTab() throws SkypeException {
        Utils.executeWithErrorCheck("OPEN CONTACTS");
    }

    public static void showDialPadTab() throws SkypeException {
        Utils.executeWithErrorCheck("OPEN DIALPAD");
    }

    public static void showSendContactsWindow() throws SkypeException {
        Utils.executeWithErrorCheck("OPEN SENDCONTACTS");
    }

    public static void showBlockedUsersWindow() throws SkypeException {
        Utils.executeWithErrorCheck("OPEN BLOCKEDUSERS");
    }

    public static void showImportContactsWindow() throws SkypeException {
        Utils.executeWithErrorCheck("OPEN IMPORTCONTACTS");
    }

    public static void showGettingStartedWindow() throws SkypeException {
        Utils.executeWithErrorCheck("OPEN GETTINGSTARTED");
    }

    public static void showRequestAuthorizationWindow(String skypeId) throws SkypeException {
        Utils.executeWithErrorCheck("OPEN AUTHORIZATION " + skypeId);
    }

    public static void pressButton(Button button) throws SkypeException {
        Utils.executeWithErrorCheck("BTN_PRESSED " + button.getKey());
    }

    public static void releaseButton(Button button) throws SkypeException {
        Utils.executeWithErrorCheck("BTN_RELEASED " + button.getKey());
    }

    public static void openVideoTestWindow() throws SkypeException {
        Utils.executeWithErrorCheck("OPEN VIDEOTEST");
    }

    public static void openVideoOptionsWindow() throws SkypeException {
        Utils.executeWithErrorCheck("OPEN OPTIONS VIDEO");
    }

    public static String getUILanguageByISOCode() throws SkypeException {
        return Utils.getProperty("UI_LANGUAGE");
    }

    public static void setUILanguageByISOCode(String newValue) throws SkypeException {
        Utils.setProperty("UI_LANGUAGE", newValue);
    }

    public static File getWallPaper() throws SkypeException {
        return new File(Utils.getProperty("WALLPAPER"));
    }

    public static void setWallPaper(File newValue) throws SkypeException {
        if (newValue != null) {
            Utils.setProperty("WALLPAPER", newValue.getAbsolutePath());
        } else {
            Utils.setProperty("WALLPAPER", "");
        }
    }

    public static boolean setSilentMode(boolean on) throws SkypeException {
        try {
            String command = "SET SILENT_MODE " + (on ? "ON" : "OFF");
            String responseHeader = "SILENT_MODE ";
            String response = Connector.getInstance().execute(command, responseHeader);
            Utils.checkError(response);
            String responseValue = response.substring(responseHeader.length());
            return "ON".equals(responseValue);
        }
        catch (ConnectorException e) {
            Utils.convertToSkypeException(e);
            return false;
        }
    }

    public static EventMessage addEventMessage(String caption) throws SkypeException {
        return SkypeClient.addEventMessage(caption, caption);
    }

    public static EventMessage addEventMessage(String caption, String hint) throws SkypeException {
        Utils.checkNotNull("caption", caption);
        Utils.checkNotNull("hint", hint);
        try {
            EventMessage eventMessage = EventMessage.addEventMessage(caption, hint);
            String command = "CREATE EVENT " + eventMessage.getId() + " CAPTION \"" + caption + "\" HINT \"" + hint + "\"";
            String responseHeader = "EVENT " + eventMessage.getId() + " CREATED";
            String response = Connector.getInstance().execute(command, responseHeader);
            Utils.checkError(response);
            return eventMessage;
        }
        catch (ConnectorException e) {
            Utils.convertToSkypeException(e);
            return null;
        }
    }

    public static void removeEventMessage(EventMessage eventMessage) throws SkypeException {
        eventMessage.dispose();
    }

    public static MenuItem addMenuItem(MenuItem.Context context, String caption, String hint, File iconFile, boolean enabled, String targetSkypeId, boolean multipleContactsEnabled) throws SkypeException {
        try {
            MenuItem menuItem = MenuItem.addMenuItem(context, caption, hint, iconFile, enabled, targetSkypeId, multipleContactsEnabled);
            String command = "CREATE MENU_ITEM " + menuItem.getId() + " CONTEXT " + context.name().toLowerCase() + " CAPTION \"" + caption + "\"";
            if (hint != null) {
                command = command + " HINT \"" + hint + "\"";
            }
            if (iconFile != null) {
                command = command + " ICON \"" + iconFile.getAbsolutePath() + "\"";
            }
            if (!enabled) {
                command = command + " ENABLED false";
            }
            if (targetSkypeId != null) {
                command = command + " CONTACT_TYPE_FILTER \"" + targetSkypeId + "\"";
            }
            if (!multipleContactsEnabled) {
                command = command + " ENABLE_MULTIPLE_CONTACTS false";
            }
            String responseHeader = "MENU_ITEM " + menuItem.getId() + " CREATED";
            String response = Connector.getInstance().execute(command, responseHeader);
            Utils.checkError(response);
            return menuItem;
        }
        catch (ConnectorException e) {
            Utils.convertToSkypeException(e);
            return null;
        }
    }

    public static void removeMenuItem(MenuItem menuItem) throws SkypeException {
        menuItem.dispose();
    }

    public static void setMainWindowState(WindowState newValue) throws SkypeException {
        Utils.setProperty("WINDOWSTATE", newValue.name());
    }

    public static WindowState getMainWindowState() throws SkypeException {
        return WindowState.valueOf(Utils.getProperty("WINDOWSTATE"));
    }

    public static enum WindowState {
        NORMAL,
        MINIMIZED,
        MAXIMIZED,
        HIDDEN;

    }

    public static enum Button {
        KEY_0,
        KEY_1,
        KEY_2,
        KEY_3,
        KEY_4,
        KEY_5,
        KEY_6,
        KEY_7,
        KEY_8,
        KEY_9,
        KEY_A,
        KEY_B,
        KEY_C,
        KEY_D,
        KEY_E,
        KEY_F,
        KEY_G,
        KEY_H,
        KEY_I,
        KEY_J,
        KEY_K,
        KEY_L,
        KEY_M,
        KEY_N,
        KEY_O,
        KEY_P,
        KEY_Q,
        KEY_R,
        KEY_S,
        KEY_T,
        KEY_U,
        KEY_V,
        KEY_W,
        KEY_X,
        KEY_Y,
        KEY_Z,
        KEY_SHARP("#"),
        KEY_ASTERISK("*"),
        KEY_PLUS("+"),
        KEY_UP,
        KEY_DOWN,
        KEY_YES,
        KEY_NO,
        KEY_PAGEUP,
        KEY_PAGEDOWN,
        KEY_SKYPE;

        private String key;

        private Button() {
        }

        private Button(String newKey) {
            this.key = newKey;
        }

        private String getKey() {
            if (this.key != null) {
                return this.key;
            }
            return this.name().substring(this.name().indexOf(95) + 1);
        }
    }

    public static enum OptionsPage {
        GENERAL,
        PRIVACY,
        NOTIFICATIONS,
        SOUNDALERTS,
        SOUNDDEVICES,
        HOTKEYS,
        CONNECTION,
        VOICEMAIL,
        CALLFORWARD,
        VIDEO,
        ADVANCED;

    }
}

