/*
 * Decompiled with CFR 0.152.
 */
package com.skype;

import com.skype.Skype;
import com.skype.VoiceMail;
import com.skype.VoiceMailListener;
import com.skype.connector.AbstractConnectorListener;
import com.skype.connector.ConnectorMessageEvent;

final class VoiceMailConnectorListener
extends AbstractConnectorListener {
    VoiceMailConnectorListener() {
    }

    @Override
    public void messageReceived(ConnectorMessageEvent event) {
        String message = event.getMessage();
        if (message.startsWith("VOICEMAIL ")) {
            String data = message.substring("VOICEMAIL ".length());
            String id = data.substring(0, data.indexOf(32));
            String propertyNameAndValue = data.substring(data.indexOf(32) + 1);
            String propertyName = propertyNameAndValue.substring(0, propertyNameAndValue.indexOf(32));
            if ("TYPE".equals(propertyName)) {
                String propertyValue = propertyNameAndValue.substring(propertyNameAndValue.indexOf(32) + 1);
                VoiceMail.Type type = VoiceMail.Type.valueOf(propertyValue);
                VoiceMail voiceMail = VoiceMail.getInstance(id);
                VoiceMailListener[] listeners = Skype.voiceMailListeners.toArray(new VoiceMailListener[0]);
                switch (type) {
                    case OUTGOING: {
                        for (VoiceMailListener listener : listeners) {
                            try {
                                listener.voiceMailMade(voiceMail);
                            }
                            catch (Throwable e) {
                                Skype.handleUncaughtException(e);
                            }
                        }
                        break;
                    }
                    case INCOMING: {
                        for (VoiceMailListener listener : listeners) {
                            try {
                                listener.voiceMailReceived(voiceMail);
                            }
                            catch (Throwable e) {
                                Skype.handleUncaughtException(e);
                            }
                        }
                        break;
                    }
                }
            }
        }
    }
}

