/*
 * Decompiled with CFR 0.152.
 */
package com.skype.connector.osx;

import com.skype.connector.Connector;
import com.skype.connector.ConnectorException;
import com.skype.connector.UnsupportedArchitectureException;
import com.skype.connector.osx.AbstractSkypeFrameworkListener;
import com.skype.connector.osx.SkypeFramework;
import com.skype.connector.osx.SkypeFrameworkListener;
import java.io.File;
import java.util.concurrent.CountDownLatch;

public final class OSXConnector
extends Connector {
    private static OSXConnector _instance = null;
    private static boolean _skypeEventLoopEnabled = true;
    private SkypeFrameworkListener listener = new AbstractSkypeFrameworkListener(){

        @Override
        public void notificationReceived(String notificationString) {
            OSXConnector.this.fireMessageReceived(OSXConnector.fixLegacyMessage(notificationString));
        }

        @Override
        public void becameUnavailable() {
            OSXConnector.this.setStatus(Connector.Status.NOT_AVAILABLE);
        }

        @Override
        public void becameAvailable() {
        }
    };

    public static synchronized Connector getInstance() {
        String osArch = System.getProperty("os.arch");
        if (osArch.contains("64")) {
            throw new UnsupportedArchitectureException("Skype Java Api doesn't support running under 64bit architectures under Mac OSX. You may try running with 'java -d32' if your system has java 32bit installed.");
        }
        if (_instance == null) {
            _instance = new OSXConnector();
            try {
                _instance.initialize();
            }
            catch (ConnectorException e) {
                throw new IllegalStateException(e);
            }
        }
        return _instance;
    }

    public static void disableSkypeEventLoop() {
        _skypeEventLoopEnabled = false;
    }

    static String fixLegacyMessage(String message) {
        if (message.matches(".*\\bMESSAGE\\b.*")) {
            return message.replaceFirst("\\bMESSAGE\\b", "CHATMESSAGE");
        }
        return message;
    }

    private OSXConnector() {
    }

    @Override
    public boolean isRunning() throws ConnectorException {
        return SkypeFramework.isRunning();
    }

    @Override
    public String getInstalledPath() {
        File application = new File("/Applications/Skype.app/Contents/MacOS/Skype");
        if (application.exists()) {
            return application.getAbsolutePath();
        }
        return null;
    }

    @Override
    protected void initializeImpl() throws ConnectorException {
        SkypeFramework.init(this.getApplicationName());
        SkypeFramework.addSkypeFrameworkListener(this.listener);
        if (_skypeEventLoopEnabled) {
            final CountDownLatch latch = new CountDownLatch(1);
            Thread eventLoop = new Thread("SkypeEventLoop"){

                @Override
                public void run() {
                    latch.countDown();
                    SkypeFramework.runApplicationEventLoop();
                }
            };
            eventLoop.setDaemon(true);
            eventLoop.start();
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                SkypeFramework.quitApplicationEventLoop();
                throw new ConnectorException("The connector initialization was interrupted.", e);
            }
        }
    }

    @Override
    protected Connector.Status connect(int timeout) throws ConnectorException {
        if (!SkypeFramework.isRunning()) {
            this.setStatus(Connector.Status.NOT_RUNNING);
            return this.getStatus();
        }
        try {
            final CountDownLatch latch = new CountDownLatch(1);
            AbstractSkypeFrameworkListener listener = new AbstractSkypeFrameworkListener(){

                @Override
                public void attachResponse(int attachResponseCode) {
                    SkypeFramework.removeSkypeFrameworkListener(this);
                    switch (attachResponseCode) {
                        case 0: {
                            OSXConnector.this.setStatus(Connector.Status.REFUSED);
                            latch.countDown();
                            break;
                        }
                        case 1: {
                            OSXConnector.this.setStatus(Connector.Status.ATTACHED);
                            latch.countDown();
                            break;
                        }
                        default: {
                            throw new IllegalStateException("not supported attachResponseCode");
                        }
                    }
                }
            };
            this.setStatus(Connector.Status.PENDING_AUTHORIZATION);
            SkypeFramework.addSkypeFrameworkListener(listener);
            SkypeFramework.connect();
            latch.await();
            return this.getStatus();
        }
        catch (InterruptedException e) {
            throw new ConnectorException("Trying to connect was interrupted.", e);
        }
    }

    @Override
    protected void sendProtocol() throws ConnectorException {
    }

    @Override
    protected void sendCommand(String command) {
        String result = SkypeFramework.sendCommand(command);
        if (result != null) {
            this.fireMessageReceived(result);
        }
    }

    @Override
    protected void disposeImpl() {
        SkypeFramework.removeSkypeFrameworkListener(this.listener);
        SkypeFramework.dispose();
        if (_skypeEventLoopEnabled) {
            SkypeFramework.quitApplicationEventLoop();
        }
    }
}

